/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.storm;

import backtype.storm.task.IOutputCollector;
import backtype.storm.tuple.Tuple;
import java.util.Collection;
import java.util.List;

public class MockOutputCollector
implements IOutputCollector {
    private boolean acked = false;
    private boolean failed = false;
    private Throwable lastError = null;
    private Tuple ackedTuple = null;
    private int numTuplesAcked = 0;

    public void reportError(Throwable error) {
        this.lastError = error;
    }

    public List<Integer> emit(String streamId, Collection<Tuple> anchors, List<Object> tuple) {
        return null;
    }

    public void emitDirect(int taskId, String streamId, Collection<Tuple> anchors, List<Object> tuple) {
    }

    public void ack(Tuple input) {
        this.acked = true;
        this.failed = false;
        this.ackedTuple = input;
        ++this.numTuplesAcked;
    }

    public void fail(Tuple input) {
        this.failed = true;
        this.acked = false;
    }

    public boolean acked() {
        return this.acked;
    }

    public boolean failed() {
        return this.failed;
    }

    public Throwable getLastError() {
        return this.lastError;
    }

    public Tuple getAckedTuple() {
        return this.ackedTuple;
    }

    public int getNumTuplesAcked() {
        return this.numTuplesAcked;
    }

    public void reset() {
        this.acked = false;
        this.failed = false;
        this.lastError = null;
        this.ackedTuple = null;
        this.numTuplesAcked = 0;
    }
}

