/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.topics;

import org.apache.pulsar.client.api.Schema;

public interface TopicCompactionStrategy<T> {
    public Schema<T> getSchema();

    public boolean shouldKeepLeft(T var1, T var2);

    public static TopicCompactionStrategy load(String topicCompactionStrategyClassName) {
        if (topicCompactionStrategyClassName == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(topicCompactionStrategyClassName);
            Object instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return (TopicCompactionStrategy)instance;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error when loading topic compaction strategy: " + topicCompactionStrategyClassName, e);
        }
    }
}

