/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.redis.sink;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.pulsar.io.core.annotations.FieldDoc;
import org.apache.pulsar.io.redis.RedisAbstractConfig;

public class RedisSinkConfig
extends RedisAbstractConfig
implements Serializable {
    private static final long serialVersionUID = 4686456460365805717L;
    @FieldDoc(required=false, defaultValue="10000L", help="The amount of time in milliseconds before an operation is marked as timed out")
    private long operationTimeout = 10000L;
    @FieldDoc(required=false, defaultValue="1000L", help="The Redis operation time in milliseconds")
    private long batchTimeMs = 1000L;
    @FieldDoc(required=false, defaultValue="200", help="The batch size of write to Redis database")
    private int batchSize = 200;

    public static RedisSinkConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (RedisSinkConfig)mapper.readValue(new File(yamlFile), RedisSinkConfig.class);
    }

    public static RedisSinkConfig load(Map<String, Object> map) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (RedisSinkConfig)mapper.readValue(mapper.writeValueAsString(map), RedisSinkConfig.class);
    }

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkArgument((this.operationTimeout > 0L ? 1 : 0) != 0, (Object)"operationTimeout must be a positive long.");
        Preconditions.checkArgument((this.batchTimeMs > 0L ? 1 : 0) != 0, (Object)"batchTimeMs must be a positive long.");
        Preconditions.checkArgument((this.batchSize > 0 ? 1 : 0) != 0, (Object)"batchSize must be a positive integer.");
    }

    public long getOperationTimeout() {
        return this.operationTimeout;
    }

    public long getBatchTimeMs() {
        return this.batchTimeMs;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public RedisSinkConfig setOperationTimeout(long operationTimeout) {
        this.operationTimeout = operationTimeout;
        return this;
    }

    public RedisSinkConfig setBatchTimeMs(long batchTimeMs) {
        this.batchTimeMs = batchTimeMs;
        return this;
    }

    public RedisSinkConfig setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Override
    public String toString() {
        return "RedisSinkConfig(operationTimeout=" + this.getOperationTimeout() + ", batchTimeMs=" + this.getBatchTimeMs() + ", batchSize=" + this.getBatchSize() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisSinkConfig)) {
            return false;
        }
        RedisSinkConfig other = (RedisSinkConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOperationTimeout() != other.getOperationTimeout()) {
            return false;
        }
        if (this.getBatchTimeMs() != other.getBatchTimeMs()) {
            return false;
        }
        return this.getBatchSize() == other.getBatchSize();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RedisSinkConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $operationTimeout = this.getOperationTimeout();
        result = result * 59 + (int)($operationTimeout >>> 32 ^ $operationTimeout);
        long $batchTimeMs = this.getBatchTimeMs();
        result = result * 59 + (int)($batchTimeMs >>> 32 ^ $batchTimeMs);
        result = result * 59 + this.getBatchSize();
        return result;
    }
}

