/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.rabbitmq;

import com.google.common.base.Preconditions;
import com.rabbitmq.client.ConnectionFactory;
import java.io.Serializable;
import lombok.Generated;
import org.apache.pulsar.io.core.annotations.FieldDoc;

public class RabbitMQAbstractConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @FieldDoc(required=true, defaultValue="", help="The connection name used for connecting to RabbitMQ")
    private String connectionName;
    @FieldDoc(required=true, defaultValue="", help="The RabbitMQ host to connect to")
    private String host;
    @FieldDoc(required=true, defaultValue="5672", help="The RabbitMQ port to connect to")
    private int port = 5672;
    @FieldDoc(required=true, defaultValue="/", help="The virtual host used for connecting to RabbitMQ")
    private String virtualHost = "/";
    @FieldDoc(required=false, defaultValue="guest", sensitive=true, help="The username used to authenticate to RabbitMQ")
    private String username = "guest";
    @FieldDoc(required=false, defaultValue="guest", sensitive=true, help="The password used to authenticate to RabbitMQ")
    private String password = "guest";
    @FieldDoc(required=false, defaultValue="", help="The RabbitMQ queue name from which messages should be read from or written to")
    private String queueName;
    @FieldDoc(required=false, defaultValue="0", help="Initially requested maximum channel number. 0 for unlimited")
    private int requestedChannelMax = 0;
    @FieldDoc(required=false, defaultValue="0", help="Initially requested maximum frame size, in octets. 0 for unlimited")
    private int requestedFrameMax = 0;
    @FieldDoc(required=false, defaultValue="60000", help="Connection TCP establishment timeout in milliseconds. 0 for infinite")
    private int connectionTimeout = 60000;
    @FieldDoc(required=false, defaultValue="10000", help="The AMQP0-9-1 protocol handshake timeout in milliseconds")
    private int handshakeTimeout = 10000;
    @FieldDoc(required=false, defaultValue="60", help="The requested heartbeat timeout in seconds")
    private int requestedHeartbeat = 60;

    public void validate() {
        Preconditions.checkNotNull((Object)this.host, (Object)"host property not set.");
        Preconditions.checkNotNull((Object)this.port, (Object)"port property not set.");
        Preconditions.checkNotNull((Object)this.virtualHost, (Object)"virtualHost property not set.");
        Preconditions.checkNotNull((Object)this.connectionName, (Object)"connectionName property not set.");
    }

    public ConnectionFactory createConnectionFactory() {
        ConnectionFactory connectionFactory = new ConnectionFactory();
        connectionFactory.setHost(this.host);
        connectionFactory.setUsername(this.username);
        connectionFactory.setPassword(this.password);
        connectionFactory.setVirtualHost(this.virtualHost);
        connectionFactory.setRequestedChannelMax(this.requestedChannelMax);
        connectionFactory.setRequestedFrameMax(this.requestedFrameMax);
        connectionFactory.setConnectionTimeout(this.connectionTimeout);
        connectionFactory.setHandshakeTimeout(this.handshakeTimeout);
        connectionFactory.setRequestedHeartbeat(this.requestedHeartbeat);
        connectionFactory.setPort(this.port);
        return connectionFactory;
    }

    @Generated
    public RabbitMQAbstractConfig() {
    }

    @Generated
    public String getConnectionName() {
        return this.connectionName;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public String getVirtualHost() {
        return this.virtualHost;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getQueueName() {
        return this.queueName;
    }

    @Generated
    public int getRequestedChannelMax() {
        return this.requestedChannelMax;
    }

    @Generated
    public int getRequestedFrameMax() {
        return this.requestedFrameMax;
    }

    @Generated
    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Generated
    public int getHandshakeTimeout() {
        return this.handshakeTimeout;
    }

    @Generated
    public int getRequestedHeartbeat() {
        return this.requestedHeartbeat;
    }

    @Generated
    public RabbitMQAbstractConfig setConnectionName(String connectionName) {
        this.connectionName = connectionName;
        return this;
    }

    @Generated
    public RabbitMQAbstractConfig setHost(String host) {
        this.host = host;
        return this;
    }

    @Generated
    public RabbitMQAbstractConfig setPort(int port) {
        this.port = port;
        return this;
    }

    @Generated
    public RabbitMQAbstractConfig setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
        return this;
    }

    @Generated
    public RabbitMQAbstractConfig setUsername(String username) {
        this.username = username;
        return this;
    }

    @Generated
    public RabbitMQAbstractConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    @Generated
    public RabbitMQAbstractConfig setQueueName(String queueName) {
        this.queueName = queueName;
        return this;
    }

    @Generated
    public RabbitMQAbstractConfig setRequestedChannelMax(int requestedChannelMax) {
        this.requestedChannelMax = requestedChannelMax;
        return this;
    }

    @Generated
    public RabbitMQAbstractConfig setRequestedFrameMax(int requestedFrameMax) {
        this.requestedFrameMax = requestedFrameMax;
        return this;
    }

    @Generated
    public RabbitMQAbstractConfig setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    @Generated
    public RabbitMQAbstractConfig setHandshakeTimeout(int handshakeTimeout) {
        this.handshakeTimeout = handshakeTimeout;
        return this;
    }

    @Generated
    public RabbitMQAbstractConfig setRequestedHeartbeat(int requestedHeartbeat) {
        this.requestedHeartbeat = requestedHeartbeat;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RabbitMQAbstractConfig)) {
            return false;
        }
        RabbitMQAbstractConfig other = (RabbitMQAbstractConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.getRequestedChannelMax() != other.getRequestedChannelMax()) {
            return false;
        }
        if (this.getRequestedFrameMax() != other.getRequestedFrameMax()) {
            return false;
        }
        if (this.getConnectionTimeout() != other.getConnectionTimeout()) {
            return false;
        }
        if (this.getHandshakeTimeout() != other.getHandshakeTimeout()) {
            return false;
        }
        if (this.getRequestedHeartbeat() != other.getRequestedHeartbeat()) {
            return false;
        }
        String this$connectionName = this.getConnectionName();
        String other$connectionName = other.getConnectionName();
        if (this$connectionName == null ? other$connectionName != null : !this$connectionName.equals(other$connectionName)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$virtualHost = this.getVirtualHost();
        String other$virtualHost = other.getVirtualHost();
        if (this$virtualHost == null ? other$virtualHost != null : !this$virtualHost.equals(other$virtualHost)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$queueName = this.getQueueName();
        String other$queueName = other.getQueueName();
        return !(this$queueName == null ? other$queueName != null : !this$queueName.equals(other$queueName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RabbitMQAbstractConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        result = result * 59 + this.getRequestedChannelMax();
        result = result * 59 + this.getRequestedFrameMax();
        result = result * 59 + this.getConnectionTimeout();
        result = result * 59 + this.getHandshakeTimeout();
        result = result * 59 + this.getRequestedHeartbeat();
        String $connectionName = this.getConnectionName();
        result = result * 59 + ($connectionName == null ? 43 : $connectionName.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $virtualHost = this.getVirtualHost();
        result = result * 59 + ($virtualHost == null ? 43 : $virtualHost.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $queueName = this.getQueueName();
        result = result * 59 + ($queueName == null ? 43 : $queueName.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RabbitMQAbstractConfig(connectionName=" + this.getConnectionName() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", virtualHost=" + this.getVirtualHost() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", queueName=" + this.getQueueName() + ", requestedChannelMax=" + this.getRequestedChannelMax() + ", requestedFrameMax=" + this.getRequestedFrameMax() + ", connectionTimeout=" + this.getConnectionTimeout() + ", handshakeTimeout=" + this.getHandshakeTimeout() + ", requestedHeartbeat=" + this.getRequestedHeartbeat() + ")";
    }
}

