/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.netty.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Optional;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.io.netty.NettySource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class NettyHttpServerHandler
extends SimpleChannelInboundHandler<Object> {
    private static final Logger logger = LoggerFactory.getLogger(NettyHttpServerHandler.class);
    private NettySource nettySource;
    private HttpRequest request;

    public NettyHttpServerHandler(NettySource nettySource) {
        this.nettySource = nettySource;
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
        HttpRequest request;
        if (msg instanceof HttpRequest && HttpUtil.is100ContinueExpected((HttpMessage)(request = (this.request = (HttpRequest)msg)))) {
            NettyHttpServerHandler.send100Continue(ctx);
        }
        if (msg instanceof HttpContent) {
            LastHttpContent trailer;
            HttpContent httpContent = (HttpContent)msg;
            ByteBuf content = httpContent.content();
            if (content.isReadable()) {
                this.nettySource.consume(new NettyHttpRecord(Optional.ofNullable(""), content.toString(CharsetUtil.UTF_8).getBytes()));
            }
            if (msg instanceof LastHttpContent && !this.writeResponse((HttpObject)(trailer = (LastHttpContent)msg), ctx)) {
                ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
    }

    private boolean writeResponse(HttpObject currentObj, ChannelHandlerContext ctx) {
        boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)this.request);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, currentObj.decoderResult().isSuccess() ? HttpResponseStatus.OK : HttpResponseStatus.BAD_REQUEST, Unpooled.EMPTY_BUFFER);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain; charset=UTF-8");
        if (keepAlive) {
            response.headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, response.content().readableBytes());
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
        ctx.write((Object)response);
        return keepAlive;
    }

    private static void send100Continue(ChannelHandlerContext ctx) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE);
        ctx.write((Object)response);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.error("Error when processing incoming data", cause);
        ctx.close();
    }

    private static class NettyHttpRecord
    implements Record<byte[]>,
    Serializable {
        private final Optional<String> key;
        private final byte[] value;

        public NettyHttpRecord(Optional<String> key, byte[] value) {
            this.key = key;
            this.value = value;
        }

        public Optional<String> getKey() {
            return this.key;
        }

        public byte[] getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NettyHttpRecord)) {
                return false;
            }
            NettyHttpRecord other = (NettyHttpRecord)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Optional<String> this$key = this.getKey();
            Optional<String> other$key = other.getKey();
            if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
                return false;
            }
            return Arrays.equals(this.getValue(), other.getValue());
        }

        protected boolean canEqual(Object other) {
            return other instanceof NettyHttpRecord;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<String> $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
            result = result * 59 + Arrays.hashCode(this.getValue());
            return result;
        }

        public String toString() {
            return "NettyHttpServerHandler.NettyHttpRecord(key=" + this.getKey() + ", value=" + Arrays.toString(this.getValue()) + ")";
        }
    }
}

