/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.hdfs3.sink.seq;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.io.core.KeyValue;
import org.apache.pulsar.io.hdfs3.sink.seq.HdfsAbstractSequenceFileSink;

public class HdfsTextSink
extends HdfsAbstractSequenceFileSink<String, String, Text, Text> {
    @Override
    protected List<SequenceFile.Writer.Option> getOptions() throws IllegalArgumentException, IOException {
        List<SequenceFile.Writer.Option> opts = super.getOptions();
        opts.add(SequenceFile.Writer.keyClass(Text.class));
        opts.add(SequenceFile.Writer.valueClass(Text.class));
        return opts;
    }

    @Override
    public KeyValue<String, String> extractKeyValue(Record<String> record) {
        String key = record.getKey().orElseGet(() -> (String)record.getValue());
        return new KeyValue((Object)key, (Object)((String)record.getValue()));
    }

    @Override
    public KeyValue<Text, Text> convert(KeyValue<String, String> kv) {
        return new KeyValue((Object)new Text((String)kv.getKey()), (Object)new Text((String)kv.getValue()));
    }
}

