/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.batchdatagenerator;

import io.codearte.jfairy.Fairy;
import io.codearte.jfairy.producer.person.PersonProperties;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.io.batchdatagenerator.Person;
import org.apache.pulsar.io.core.BatchPushSource;
import org.apache.pulsar.io.core.SourceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchDataGeneratorPushSource
extends BatchPushSource<Person>
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(BatchDataGeneratorPushSource.class);
    private Fairy fairy;
    private SourceContext sourceContext;
    private int maxRecordsPerCycle = 10;
    private ExecutorService executor = Executors.newSingleThreadExecutor();

    public void close() {
        this.executor.shutdownNow();
    }

    public void open(Map config, SourceContext context) throws Exception {
        this.fairy = Fairy.create();
        this.sourceContext = context;
    }

    public void discover(Consumer taskEater) throws Exception {
        log.info("Generating one task for each instance");
        for (int i = 0; i < this.sourceContext.getNumInstances(); ++i) {
            taskEater.accept(String.format("something-%d", System.currentTimeMillis()).getBytes());
        }
    }

    public void prepare(byte[] instanceSplit) throws Exception {
        log.info("Instance " + this.sourceContext.getInstanceId() + " got a new discovered task {}", (Object)new String(instanceSplit));
        this.executor.submit(this);
    }

    @Override
    public void run() {
        try {
            for (int i = 0; i < this.maxRecordsPerCycle; ++i) {
                Thread.sleep(50L);
                Record record = () -> new Person(this.fairy.person(new PersonProperties.PersonProperty[0]));
                this.consume(record);
            }
            this.consume(null);
        }
        catch (Exception e) {
            this.notifyError(e);
        }
    }
}

