/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker.request;

import java.util.UUID;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.proto.Request;

public class ServiceRequestUtils {
    public static Request.ServiceRequest getServiceRequest(String requestId, String workerId, Request.ServiceRequest.ServiceRequestType serviceRequestType, Function.FunctionMetaData functionMetaData) {
        Request.ServiceRequest.Builder serviceRequestBuilder = Request.ServiceRequest.newBuilder().setRequestId(requestId).setWorkerId(workerId).setServiceRequestType(serviceRequestType);
        if (functionMetaData != null) {
            serviceRequestBuilder.setFunctionMetaData(functionMetaData);
        }
        return serviceRequestBuilder.build();
    }

    public static Request.ServiceRequest getUpdateRequest(String workerId, Function.FunctionMetaData functionMetaData) {
        return ServiceRequestUtils.getServiceRequest(UUID.randomUUID().toString(), workerId, Request.ServiceRequest.ServiceRequestType.UPDATE, functionMetaData);
    }

    public static Request.ServiceRequest getDeregisterRequest(String workerId, Function.FunctionMetaData functionMetaData) {
        return ServiceRequestUtils.getServiceRequest(UUID.randomUUID().toString(), workerId, Request.ServiceRequest.ServiceRequestType.DELETE, functionMetaData);
    }

    public static Request.ServiceRequest getIntializationRequest(String requestId, String workerId) {
        return ServiceRequestUtils.getServiceRequest(requestId, workerId, Request.ServiceRequest.ServiceRequestType.INITIALIZE, null);
    }
}

