/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.pulsar.common.util.SimpleTextOutputStream;
import org.apache.pulsar.functions.proto.InstanceCommunication;
import org.apache.pulsar.functions.runtime.Runtime;
import org.apache.pulsar.functions.runtime.RuntimeSpawner;
import org.apache.pulsar.functions.worker.FunctionRuntimeInfo;
import org.apache.pulsar.functions.worker.WorkerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionsStatsGenerator {
    private static final Logger log = LoggerFactory.getLogger(FunctionsStatsGenerator.class);

    public static void generate(WorkerService workerService, String cluster, SimpleTextOutputStream out) {
        if (workerService != null) {
            Map<String, FunctionRuntimeInfo> functionRuntimes = workerService.getFunctionRuntimeManager().getFunctionRuntimeInfos();
            for (Map.Entry<String, FunctionRuntimeInfo> entry : functionRuntimes.entrySet()) {
                Runtime functionRuntime;
                String fullyQualifiedInstanceName = entry.getKey();
                FunctionRuntimeInfo functionRuntimeInfo = entry.getValue();
                RuntimeSpawner functionRuntimeSpawner = functionRuntimeInfo.getRuntimeSpawner();
                if (functionRuntimeSpawner == null || (functionRuntime = functionRuntimeSpawner.getRuntime()) == null) continue;
                try {
                    InstanceCommunication.MetricsData metrics = (InstanceCommunication.MetricsData)functionRuntime.getAndResetMetrics().get();
                    for (Map.Entry metricsEntry : metrics.getMetricsMap().entrySet()) {
                        String metricName = (String)metricsEntry.getKey();
                        InstanceCommunication.MetricsData.DataDigest dataDigest = (InstanceCommunication.MetricsData.DataDigest)metricsEntry.getValue();
                        String tenant = functionRuntimeInfo.getFunctionInstance().getFunctionMetaData().getFunctionDetails().getTenant();
                        String namespace = functionRuntimeInfo.getFunctionInstance().getFunctionMetaData().getFunctionDetails().getNamespace();
                        String name = functionRuntimeInfo.getFunctionInstance().getFunctionMetaData().getFunctionDetails().getName();
                        int instanceId = functionRuntimeInfo.getFunctionInstance().getInstanceId();
                        String qualifiedNamespace = String.format("%s/%s", tenant, namespace);
                        FunctionsStatsGenerator.metric(out, cluster, qualifiedNamespace, name, String.format("pulsar_function%scount", metricName), instanceId, dataDigest.getCount());
                        FunctionsStatsGenerator.metric(out, cluster, qualifiedNamespace, name, String.format("pulsar_function%smax", metricName), instanceId, dataDigest.getMax());
                        FunctionsStatsGenerator.metric(out, cluster, qualifiedNamespace, name, String.format("pulsar_function%smin", metricName), instanceId, dataDigest.getMin());
                        FunctionsStatsGenerator.metric(out, cluster, qualifiedNamespace, name, String.format("pulsar_function%ssum", metricName), instanceId, dataDigest.getSum());
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    log.warn("Failed to collect metrics for function instance {}", (Object)fullyQualifiedInstanceName, (Object)e);
                }
            }
        }
    }

    private static void metric(SimpleTextOutputStream stream, String cluster, String namespace, String functionName, String metricName, int instanceId, double value) {
        stream.write(metricName).write("{cluster=\"").write(cluster).write("\", namespace=\"").write(namespace).write("\", name=\"").write(functionName).write("\", instanceId=\"").write((long)instanceId).write("\"} ");
        stream.write(value).write(' ').write(System.currentTimeMillis()).write('\n');
    }
}

