/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Reader;
import org.apache.pulsar.functions.proto.Request;
import org.apache.pulsar.functions.worker.FunctionRuntimeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionAssignmentTailer
implements Consumer<Message<byte[]>>,
Function<Throwable, Void>,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(FunctionAssignmentTailer.class);
    private final FunctionRuntimeManager functionRuntimeManager;
    private final Reader<byte[]> reader;

    public FunctionAssignmentTailer(FunctionRuntimeManager functionRuntimeManager, Reader<byte[]> reader) throws PulsarClientException {
        this.functionRuntimeManager = functionRuntimeManager;
        this.reader = reader;
    }

    public void start() {
        this.receiveOne();
    }

    private void receiveOne() {
        ((CompletableFuture)this.reader.readNextAsync().thenAccept((Consumer)this)).exceptionally((Function)this);
    }

    @Override
    public void close() {
        log.info("Stopping function state consumer");
        try {
            this.reader.close();
        }
        catch (IOException e) {
            log.error("Failed to stop function state consumer", (Throwable)e);
        }
        log.info("Stopped function state consumer");
    }

    @Override
    public void accept(Message<byte[]> msg) {
        boolean hasMessageAvailable;
        try {
            hasMessageAvailable = this.reader.hasMessageAvailable();
        }
        catch (PulsarClientException e) {
            throw new RuntimeException(e);
        }
        if (!hasMessageAvailable) {
            Request.AssignmentsUpdate assignmentsUpdate;
            try {
                assignmentsUpdate = Request.AssignmentsUpdate.parseFrom((byte[])msg.getData());
            }
            catch (IOException e) {
                log.error("Received bad assignment update at message {}", (Object)msg.getMessageId(), (Object)e);
                throw new RuntimeException(e);
            }
            if (log.isDebugEnabled()) {
                log.debug("Received assignment update: {}", (Object)assignmentsUpdate);
            }
            this.functionRuntimeManager.processAssignmentUpdate(msg.getMessageId(), assignmentsUpdate);
        }
        this.receiveOne();
    }

    @Override
    public Void apply(Throwable cause) {
        log.error("Failed to retrieve messages from assignment update topic", cause);
        throw new RuntimeException(cause);
    }
}

