/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.common.functions.ConsumerConfig;
import org.apache.pulsar.common.functions.FunctionConfig;
import org.apache.pulsar.common.functions.ProducerConfig;
import org.apache.pulsar.common.functions.Resources;
import org.apache.pulsar.common.functions.Utils;
import org.apache.pulsar.common.functions.WindowConfig;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.util.ClassLoaderUtils;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.functions.api.WindowFunction;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.utils.CryptoUtils;
import org.apache.pulsar.functions.utils.FunctionCommon;
import org.apache.pulsar.functions.utils.ResourceConfigUtils;
import org.apache.pulsar.functions.utils.ValidatorUtils;
import org.apache.pulsar.functions.utils.WindowConfigUtils;
import org.apache.pulsar.functions.utils.functions.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionConfigUtils {
    private static final Logger log = LoggerFactory.getLogger(FunctionConfigUtils.class);
    static final Integer MAX_PENDING_ASYNC_REQUESTS_DEFAULT = 1000;
    static final Boolean FORWARD_SOURCE_MESSAGE_PROPERTY_DEFAULT = Boolean.TRUE;
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.create();

    public static Function.FunctionDetails convert(FunctionConfig functionConfig, ClassLoader classLoader) throws IllegalArgumentException {
        if (functionConfig.getRuntime() == FunctionConfig.Runtime.JAVA && classLoader != null) {
            try {
                Class<?>[] typeArgs = FunctionCommon.getFunctionTypes(functionConfig, classLoader);
                return FunctionConfigUtils.convert(functionConfig, new ExtractedFunctionDetails(functionConfig.getClassName(), typeArgs[0].getName(), typeArgs[1].getName()));
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                throw new IllegalArgumentException(String.format("Function class %s must be in class path", functionConfig.getClassName()), e);
            }
        }
        return FunctionConfigUtils.convert(functionConfig, new ExtractedFunctionDetails(functionConfig.getClassName(), null, null));
    }

    public static Function.FunctionDetails convert(FunctionConfig functionConfig, ExtractedFunctionDetails extractedDetails) throws IllegalArgumentException {
        WindowConfig windowConfig;
        boolean isBuiltin = !StringUtils.isEmpty((String)functionConfig.getJar()) && functionConfig.getJar().startsWith("builtin");
        Function.FunctionDetails.Builder functionDetailsBuilder = Function.FunctionDetails.newBuilder();
        Function.SourceSpec.Builder sourceSpecBuilder = Function.SourceSpec.newBuilder();
        if (functionConfig.getInputs() != null) {
            functionConfig.getInputs().forEach(topicName -> sourceSpecBuilder.putInputSpecs(topicName, Function.ConsumerSpec.newBuilder().setIsRegexPattern(false).build()));
        }
        if (functionConfig.getTopicsPattern() != null && !functionConfig.getTopicsPattern().isEmpty()) {
            sourceSpecBuilder.putInputSpecs(functionConfig.getTopicsPattern(), Function.ConsumerSpec.newBuilder().setIsRegexPattern(true).build());
        }
        if (functionConfig.getCustomSerdeInputs() != null) {
            functionConfig.getCustomSerdeInputs().forEach((topicName, serdeClassName) -> sourceSpecBuilder.putInputSpecs(topicName, Function.ConsumerSpec.newBuilder().setSerdeClassName(serdeClassName).setIsRegexPattern(false).build()));
        }
        if (functionConfig.getCustomSchemaInputs() != null) {
            functionConfig.getCustomSchemaInputs().forEach((topicName, conf) -> {
                try {
                    ConsumerConfig consumerConfig = (ConsumerConfig)OBJECT_MAPPER.readValue(conf, ConsumerConfig.class);
                    sourceSpecBuilder.putInputSpecs(topicName, Function.ConsumerSpec.newBuilder().setSchemaType(consumerConfig.getSchemaType()).putAllSchemaProperties(consumerConfig.getSchemaProperties()).putAllConsumerProperties(consumerConfig.getConsumerProperties()).setIsRegexPattern(false).build());
                }
                catch (JsonProcessingException e) {
                    throw new IllegalArgumentException(String.format("Incorrect custom schema inputs,Topic %s ", topicName));
                }
            });
        }
        if (functionConfig.getInputSpecs() != null) {
            functionConfig.getInputSpecs().forEach((topicName, consumerConf) -> {
                Function.ConsumerSpec.Builder bldr = Function.ConsumerSpec.newBuilder().setIsRegexPattern(consumerConf.isRegexPattern());
                if (StringUtils.isNotBlank((String)consumerConf.getSchemaType())) {
                    bldr.setSchemaType(consumerConf.getSchemaType());
                } else if (StringUtils.isNotBlank((String)consumerConf.getSerdeClassName())) {
                    bldr.setSerdeClassName(consumerConf.getSerdeClassName());
                }
                if (consumerConf.getReceiverQueueSize() != null) {
                    bldr.setReceiverQueueSize(Function.ConsumerSpec.ReceiverQueueSize.newBuilder().setValue(consumerConf.getReceiverQueueSize().intValue()).build());
                }
                if (consumerConf.getSchemaProperties() != null) {
                    bldr.putAllSchemaProperties(consumerConf.getSchemaProperties());
                }
                if (consumerConf.getCryptoConfig() != null) {
                    bldr.setCryptoSpec(CryptoUtils.convert(consumerConf.getCryptoConfig()));
                }
                bldr.putAllConsumerProperties(consumerConf.getConsumerProperties());
                bldr.setPoolMessages(consumerConf.isPoolMessages());
                sourceSpecBuilder.putInputSpecs(topicName, bldr.build());
            });
        }
        Function.SubscriptionType subType = functionConfig.getRetainOrdering() != null && functionConfig.getRetainOrdering() != false || FunctionConfig.ProcessingGuarantees.EFFECTIVELY_ONCE.equals((Object)functionConfig.getProcessingGuarantees()) ? Function.SubscriptionType.FAILOVER : (functionConfig.getRetainKeyOrdering() != null && functionConfig.getRetainKeyOrdering() != false ? Function.SubscriptionType.KEY_SHARED : Function.SubscriptionType.SHARED);
        sourceSpecBuilder.setSubscriptionType(subType);
        if (StringUtils.isNotBlank((String)functionConfig.getSubName())) {
            sourceSpecBuilder.setSubscriptionName(functionConfig.getSubName());
        }
        if (functionConfig.getSubscriptionPosition() != null) {
            Function.SubscriptionPosition subPosition = SubscriptionInitialPosition.Earliest == functionConfig.getSubscriptionPosition() ? Function.SubscriptionPosition.EARLIEST : Function.SubscriptionPosition.LATEST;
            sourceSpecBuilder.setSubscriptionPosition(subPosition);
        }
        if (functionConfig.getSkipToLatest() != null) {
            sourceSpecBuilder.setSkipToLatest(functionConfig.getSkipToLatest().booleanValue());
        } else {
            sourceSpecBuilder.setSkipToLatest(false);
        }
        if (extractedDetails.getTypeArg0() != null) {
            sourceSpecBuilder.setTypeClassName(extractedDetails.getTypeArg0());
        } else if (StringUtils.isNotEmpty((String)functionConfig.getInputTypeClassName())) {
            sourceSpecBuilder.setTypeClassName(functionConfig.getInputTypeClassName());
        }
        if (functionConfig.getTimeoutMs() != null) {
            sourceSpecBuilder.setTimeoutMs(functionConfig.getTimeoutMs().longValue());
            sourceSpecBuilder.setNegativeAckRedeliveryDelayMs(functionConfig.getTimeoutMs().longValue());
        }
        if (functionConfig.getCleanupSubscription() != null) {
            sourceSpecBuilder.setCleanupSubscription(functionConfig.getCleanupSubscription().booleanValue());
        } else {
            sourceSpecBuilder.setCleanupSubscription(true);
        }
        functionDetailsBuilder.setSource(sourceSpecBuilder);
        Function.SinkSpec.Builder sinkSpecBuilder = Function.SinkSpec.newBuilder();
        if (functionConfig.getOutput() != null) {
            sinkSpecBuilder.setTopic(functionConfig.getOutput());
        }
        if (!StringUtils.isBlank((String)functionConfig.getOutputSerdeClassName())) {
            sinkSpecBuilder.setSerDeClassName(functionConfig.getOutputSerdeClassName());
        }
        if (!StringUtils.isBlank((String)functionConfig.getOutputSchemaType())) {
            sinkSpecBuilder.setSchemaType(functionConfig.getOutputSchemaType());
        }
        if (functionConfig.getForwardSourceMessageProperty() == Boolean.TRUE) {
            sinkSpecBuilder.setForwardSourceMessageProperty(functionConfig.getForwardSourceMessageProperty().booleanValue());
        }
        if (functionConfig.getCustomSchemaOutputs() != null && functionConfig.getOutput() != null) {
            String conf2 = (String)functionConfig.getCustomSchemaOutputs().get(functionConfig.getOutput());
            try {
                if (StringUtils.isNotEmpty((String)conf2)) {
                    ConsumerConfig consumerConfig = (ConsumerConfig)OBJECT_MAPPER.readValue(conf2, ConsumerConfig.class);
                    sinkSpecBuilder.putAllSchemaProperties(consumerConfig.getSchemaProperties());
                    sinkSpecBuilder.putAllConsumerProperties(consumerConfig.getConsumerProperties());
                }
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException(String.format("Incorrect custom schema outputs,Topic %s ", functionConfig.getOutput()));
            }
        }
        if (extractedDetails.getTypeArg1() != null) {
            sinkSpecBuilder.setTypeClassName(extractedDetails.getTypeArg1());
        } else if (StringUtils.isNotEmpty((String)functionConfig.getOutputTypeClassName())) {
            sinkSpecBuilder.setTypeClassName(functionConfig.getOutputTypeClassName());
        }
        if (functionConfig.getProducerConfig() != null) {
            ProducerConfig producerConf = functionConfig.getProducerConfig();
            Function.ProducerSpec.Builder pbldr = Function.ProducerSpec.newBuilder();
            if (producerConf.getMaxPendingMessages() != null) {
                pbldr.setMaxPendingMessages(producerConf.getMaxPendingMessages().intValue());
            }
            if (producerConf.getMaxPendingMessagesAcrossPartitions() != null) {
                pbldr.setMaxPendingMessagesAcrossPartitions(producerConf.getMaxPendingMessagesAcrossPartitions().intValue());
            }
            if (producerConf.getUseThreadLocalProducers() != null) {
                pbldr.setUseThreadLocalProducers(producerConf.getUseThreadLocalProducers().booleanValue());
            }
            if (producerConf.getCryptoConfig() != null) {
                pbldr.setCryptoSpec(CryptoUtils.convert(producerConf.getCryptoConfig()));
            }
            if (producerConf.getBatchBuilder() != null) {
                pbldr.setBatchBuilder(producerConf.getBatchBuilder());
            }
            if (producerConf.getCompressionType() != null) {
                pbldr.setCompressionType(FunctionCommon.convertFromCompressionType(producerConf.getCompressionType()));
            } else {
                pbldr.setCompressionType(Function.CompressionType.LZ4);
            }
            sinkSpecBuilder.setProducerSpec(pbldr.build());
        }
        if (functionConfig.getBatchBuilder() != null) {
            Function.ProducerSpec.Builder builder = sinkSpecBuilder.getProducerSpec() != null ? sinkSpecBuilder.getProducerSpec().toBuilder() : Function.ProducerSpec.newBuilder();
            sinkSpecBuilder.setProducerSpec(builder.setBatchBuilder(functionConfig.getBatchBuilder()).build());
        }
        functionDetailsBuilder.setSink(sinkSpecBuilder);
        if (functionConfig.getTenant() != null) {
            functionDetailsBuilder.setTenant(functionConfig.getTenant());
        }
        if (functionConfig.getNamespace() != null) {
            functionDetailsBuilder.setNamespace(functionConfig.getNamespace());
        }
        if (functionConfig.getName() != null) {
            functionDetailsBuilder.setName(functionConfig.getName());
        }
        if (functionConfig.getLogTopic() != null) {
            functionDetailsBuilder.setLogTopic(functionConfig.getLogTopic());
        }
        if (functionConfig.getRuntime() != null) {
            functionDetailsBuilder.setRuntime(FunctionCommon.convertRuntime(functionConfig.getRuntime()));
        }
        if (functionConfig.getProcessingGuarantees() != null) {
            functionDetailsBuilder.setProcessingGuarantees(FunctionCommon.convertProcessingGuarantee(functionConfig.getProcessingGuarantees()));
        }
        if (functionConfig.getRetainKeyOrdering() != null) {
            functionDetailsBuilder.setRetainKeyOrdering(functionConfig.getRetainKeyOrdering().booleanValue());
        }
        if (functionConfig.getRetainOrdering() != null) {
            functionDetailsBuilder.setRetainOrdering(functionConfig.getRetainOrdering().booleanValue());
        }
        if (functionConfig.getMaxMessageRetries() != null && functionConfig.getMaxMessageRetries() >= 0) {
            Function.RetryDetails.Builder retryBuilder = Function.RetryDetails.newBuilder();
            retryBuilder.setMaxMessageRetries(functionConfig.getMaxMessageRetries().intValue());
            if (StringUtils.isNotEmpty((String)functionConfig.getDeadLetterTopic())) {
                retryBuilder.setDeadLetterTopic(functionConfig.getDeadLetterTopic());
            }
            functionDetailsBuilder.setRetryDetails(retryBuilder);
        }
        HashMap<String, WindowConfig> configs = new HashMap<String, WindowConfig>();
        if (functionConfig.getUserConfig() != null) {
            configs.putAll(functionConfig.getUserConfig());
        }
        if ((windowConfig = functionConfig.getWindowConfig()) != null) {
            if (functionConfig.getProcessingGuarantees() == FunctionConfig.ProcessingGuarantees.EFFECTIVELY_ONCE || functionConfig.getProcessingGuarantees() == FunctionConfig.ProcessingGuarantees.MANUAL) {
                throw new IllegalArgumentException("Windows Function not support " + functionConfig.getProcessingGuarantees() + " delivery semantics.");
            }
            windowConfig.setProcessingGuarantees(WindowConfig.ProcessingGuarantees.valueOf((String)functionDetailsBuilder.getProcessingGuarantees().name()));
            functionDetailsBuilder.setProcessingGuarantees(Function.ProcessingGuarantees.MANUAL);
            windowConfig.setActualWindowFunctionClassName(extractedDetails.getFunctionClassName());
            configs.put("__WINDOWCONFIGS__", windowConfig);
            functionDetailsBuilder.setClassName("org.apache.pulsar.functions.windowing.WindowFunctionExecutor");
        } else if (extractedDetails.getFunctionClassName() != null) {
            functionDetailsBuilder.setClassName(extractedDetails.getFunctionClassName());
        }
        if (!configs.isEmpty()) {
            functionDetailsBuilder.setUserConfig(new Gson().toJson(configs));
        }
        if (functionConfig.getSecrets() != null && !functionConfig.getSecrets().isEmpty()) {
            functionDetailsBuilder.setSecretsMap(new Gson().toJson((Object)functionConfig.getSecrets()));
        }
        if (functionConfig.getAutoAck() != null) {
            functionDetailsBuilder.setAutoAck(functionConfig.getAutoAck().booleanValue());
        } else {
            functionDetailsBuilder.setAutoAck(true);
        }
        if (functionConfig.getParallelism() != null) {
            functionDetailsBuilder.setParallelism(functionConfig.getParallelism().intValue());
        } else {
            functionDetailsBuilder.setParallelism(1);
        }
        Resources resources = Resources.mergeWithDefault((Resources)functionConfig.getResources());
        Function.Resources.Builder bldr = Function.Resources.newBuilder();
        bldr.setCpu(resources.getCpu().doubleValue());
        bldr.setRam(resources.getRam().longValue());
        bldr.setDisk(resources.getDisk().longValue());
        functionDetailsBuilder.setResources(bldr);
        if (!StringUtils.isEmpty((String)functionConfig.getRuntimeFlags())) {
            functionDetailsBuilder.setRuntimeFlags(functionConfig.getRuntimeFlags());
        }
        functionDetailsBuilder.setComponentType(Function.FunctionDetails.ComponentType.FUNCTION);
        if (!StringUtils.isEmpty((String)functionConfig.getCustomRuntimeOptions())) {
            functionDetailsBuilder.setCustomRuntimeOptions(functionConfig.getCustomRuntimeOptions());
        }
        if (isBuiltin) {
            String builtin = functionConfig.getJar().replaceFirst("^builtin://", "");
            functionDetailsBuilder.setBuiltin(builtin);
        }
        return FunctionConfigUtils.validateFunctionDetails(functionDetailsBuilder.build());
    }

    public static Function.FunctionDetails validateFunctionDetails(Function.FunctionDetails functionDetails) throws IllegalArgumentException {
        if (!functionDetails.getAutoAck() && functionDetails.getProcessingGuarantees() == Function.ProcessingGuarantees.ATMOST_ONCE) {
            throw new IllegalArgumentException("When Guarantees == ATMOST_ONCE, autoAck must be equal to true. This is a contradictory configuration, autoAck will be removed later. Please refer to PIP: https://github.com/apache/pulsar/issues/15560");
        }
        if (!functionDetails.getAutoAck()) {
            log.warn("The autoAck configuration will be deprecated in the future. If you want not to automatically ack, please configure the processing guarantees as MANUAL.");
        }
        return functionDetails;
    }

    public static FunctionConfig convertFromDetails(Function.FunctionDetails functionDetails) {
        Map userConfig;
        Type type;
        functionDetails = FunctionConfigUtils.validateFunctionDetails(functionDetails);
        FunctionConfig functionConfig = new FunctionConfig();
        functionConfig.setTenant(functionDetails.getTenant());
        functionConfig.setNamespace(functionDetails.getNamespace());
        functionConfig.setName(functionDetails.getName());
        functionConfig.setParallelism(Integer.valueOf(functionDetails.getParallelism()));
        functionConfig.setProcessingGuarantees(FunctionCommon.convertProcessingGuarantee(functionDetails.getProcessingGuarantees()));
        HashMap<String, ConsumerConfig> consumerConfigMap = new HashMap<String, ConsumerConfig>();
        for (Map.Entry input : functionDetails.getSource().getInputSpecsMap().entrySet()) {
            ConsumerConfig consumerConfig = new ConsumerConfig();
            if (StringUtils.isNotEmpty((String)((Function.ConsumerSpec)input.getValue()).getSerdeClassName())) {
                consumerConfig.setSerdeClassName(((Function.ConsumerSpec)input.getValue()).getSerdeClassName());
            }
            if (StringUtils.isNotEmpty((String)((Function.ConsumerSpec)input.getValue()).getSchemaType())) {
                consumerConfig.setSchemaType(((Function.ConsumerSpec)input.getValue()).getSchemaType());
            }
            if (((Function.ConsumerSpec)input.getValue()).hasReceiverQueueSize()) {
                consumerConfig.setReceiverQueueSize(Integer.valueOf(((Function.ConsumerSpec)input.getValue()).getReceiverQueueSize().getValue()));
            }
            if (((Function.ConsumerSpec)input.getValue()).hasCryptoSpec()) {
                consumerConfig.setCryptoConfig(CryptoUtils.convertFromSpec(((Function.ConsumerSpec)input.getValue()).getCryptoSpec()));
            }
            consumerConfig.setRegexPattern(((Function.ConsumerSpec)input.getValue()).getIsRegexPattern());
            consumerConfig.setSchemaProperties(((Function.ConsumerSpec)input.getValue()).getSchemaPropertiesMap());
            consumerConfig.setPoolMessages(((Function.ConsumerSpec)input.getValue()).getPoolMessages());
            consumerConfigMap.put((String)input.getKey(), consumerConfig);
        }
        functionConfig.setInputSpecs(consumerConfigMap);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)functionDetails.getSource().getSubscriptionName())) {
            functionConfig.setSubName(functionDetails.getSource().getSubscriptionName());
        }
        functionConfig.setRetainOrdering(Boolean.valueOf(functionDetails.getRetainOrdering()));
        functionConfig.setRetainKeyOrdering(Boolean.valueOf(functionDetails.getRetainKeyOrdering()));
        functionConfig.setCleanupSubscription(Boolean.valueOf(functionDetails.getSource().getCleanupSubscription()));
        functionConfig.setAutoAck(Boolean.valueOf(functionDetails.getAutoAck()));
        functionConfig.setSubscriptionPosition(FunctionCommon.convertFromFunctionDetailsSubscriptionPosition(functionDetails.getSource().getSubscriptionPosition()));
        if (functionDetails.getSource().getTimeoutMs() != 0L) {
            functionConfig.setTimeoutMs(Long.valueOf(functionDetails.getSource().getTimeoutMs()));
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)functionDetails.getSink().getTopic())) {
            functionConfig.setOutput(functionDetails.getSink().getTopic());
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)functionDetails.getSink().getSerDeClassName())) {
            functionConfig.setOutputSerdeClassName(functionDetails.getSink().getSerDeClassName());
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)functionDetails.getSink().getSchemaType())) {
            functionConfig.setOutputSchemaType(functionDetails.getSink().getSchemaType());
        }
        if (functionDetails.getSink().getProducerSpec() != null) {
            Function.ProducerSpec spec = functionDetails.getSink().getProducerSpec();
            ProducerConfig producerConfig = new ProducerConfig();
            if (spec.getMaxPendingMessages() != 0) {
                producerConfig.setMaxPendingMessages(Integer.valueOf(spec.getMaxPendingMessages()));
            }
            if (spec.getMaxPendingMessagesAcrossPartitions() != 0) {
                producerConfig.setMaxPendingMessagesAcrossPartitions(Integer.valueOf(spec.getMaxPendingMessagesAcrossPartitions()));
            }
            if (spec.hasCryptoSpec()) {
                producerConfig.setCryptoConfig(CryptoUtils.convertFromSpec(spec.getCryptoSpec()));
            }
            if (spec.getBatchBuilder() != null) {
                producerConfig.setBatchBuilder(spec.getBatchBuilder());
            }
            producerConfig.setUseThreadLocalProducers(Boolean.valueOf(spec.getUseThreadLocalProducers()));
            producerConfig.setCompressionType(FunctionCommon.convertFromFunctionDetailsCompressionType(spec.getCompressionType()));
            functionConfig.setProducerConfig(producerConfig);
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)functionDetails.getLogTopic())) {
            functionConfig.setLogTopic(functionDetails.getLogTopic());
        }
        if (functionDetails.getSink().getForwardSourceMessageProperty()) {
            functionConfig.setForwardSourceMessageProperty(Boolean.valueOf(functionDetails.getSink().getForwardSourceMessageProperty()));
        }
        functionConfig.setRuntime(FunctionCommon.convertRuntime(functionDetails.getRuntime()));
        if (functionDetails.hasRetryDetails()) {
            functionConfig.setMaxMessageRetries(Integer.valueOf(functionDetails.getRetryDetails().getMaxMessageRetries()));
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)functionDetails.getRetryDetails().getDeadLetterTopic())) {
                functionConfig.setDeadLetterTopic(functionDetails.getRetryDetails().getDeadLetterTopic());
            }
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)functionDetails.getUserConfig())) {
            type = new TypeToken<Map<String, Object>>(){}.getType();
            userConfig = (Map)new Gson().fromJson(functionDetails.getUserConfig(), type);
        } else {
            userConfig = new HashMap();
        }
        if (userConfig.containsKey("__WINDOWCONFIGS__")) {
            WindowConfig windowConfig = (WindowConfig)new Gson().fromJson(new Gson().toJson(userConfig.get("__WINDOWCONFIGS__")), WindowConfig.class);
            userConfig.remove("__WINDOWCONFIGS__");
            if (windowConfig.getProcessingGuarantees() != null) {
                functionConfig.setProcessingGuarantees(FunctionConfig.ProcessingGuarantees.valueOf((String)windowConfig.getProcessingGuarantees().name()));
            }
            functionConfig.setClassName(windowConfig.getActualWindowFunctionClassName());
            functionConfig.setWindowConfig(windowConfig);
        } else {
            functionConfig.setClassName(functionDetails.getClassName());
        }
        functionConfig.setUserConfig(userConfig);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)functionDetails.getSecretsMap())) {
            type = new TypeToken<Map<String, Object>>(){}.getType();
            Map secretsMap = (Map)new Gson().fromJson(functionDetails.getSecretsMap(), type);
            functionConfig.setSecrets(secretsMap);
        }
        if (functionDetails.hasResources()) {
            Resources resources = new Resources();
            resources.setCpu(Double.valueOf(functionDetails.getResources().getCpu()));
            resources.setRam(Long.valueOf(functionDetails.getResources().getRam()));
            resources.setDisk(Long.valueOf(functionDetails.getResources().getDisk()));
            functionConfig.setResources(resources);
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)functionDetails.getRuntimeFlags())) {
            functionConfig.setRuntimeFlags(functionDetails.getRuntimeFlags());
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)functionDetails.getCustomRuntimeOptions())) {
            functionConfig.setCustomRuntimeOptions(functionDetails.getCustomRuntimeOptions());
        }
        return functionConfig;
    }

    public static void inferMissingArguments(FunctionConfig functionConfig, boolean forwardSourceMessagePropertyEnabled) {
        if (StringUtils.isEmpty((String)functionConfig.getName())) {
            Utils.inferMissingFunctionName((FunctionConfig)functionConfig);
        }
        if (StringUtils.isEmpty((String)functionConfig.getTenant())) {
            Utils.inferMissingTenant((FunctionConfig)functionConfig);
        }
        if (StringUtils.isEmpty((String)functionConfig.getNamespace())) {
            Utils.inferMissingNamespace((FunctionConfig)functionConfig);
        }
        if (functionConfig.getParallelism() == null) {
            functionConfig.setParallelism(Integer.valueOf(1));
        }
        if (functionConfig.getMaxPendingAsyncRequests() == null) {
            functionConfig.setMaxPendingAsyncRequests(MAX_PENDING_ASYNC_REQUESTS_DEFAULT);
        }
        if (forwardSourceMessagePropertyEnabled) {
            if (functionConfig.getForwardSourceMessageProperty() == null) {
                functionConfig.setForwardSourceMessageProperty(FORWARD_SOURCE_MESSAGE_PROPERTY_DEFAULT);
            }
        } else {
            functionConfig.setForwardSourceMessageProperty(null);
        }
        if (functionConfig.getJar() != null) {
            functionConfig.setRuntime(FunctionConfig.Runtime.JAVA);
        } else if (functionConfig.getPy() != null) {
            functionConfig.setRuntime(FunctionConfig.Runtime.PYTHON);
        } else if (functionConfig.getGo() != null) {
            functionConfig.setRuntime(FunctionConfig.Runtime.GO);
        }
        WindowConfig windowConfig = functionConfig.getWindowConfig();
        if (windowConfig != null) {
            WindowConfigUtils.inferMissingArguments(windowConfig);
            functionConfig.setAutoAck(Boolean.valueOf(false));
        }
    }

    public static ExtractedFunctionDetails doJavaChecks(FunctionConfig functionConfig, ClassLoader clsLoader) {
        Class[] typeArgs;
        Class<?> functionClass;
        String functionClassName = functionConfig.getClassName();
        try {
            if (functionClassName == null) {
                try {
                    functionClassName = FunctionUtils.getFunctionClass(clsLoader);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Failed to extract source class from archive", e);
                }
            }
            if (!(org.apache.pulsar.functions.api.Function.class.isAssignableFrom(functionClass = clsLoader.loadClass(functionClassName)) || Function.class.isAssignableFrom(functionClass) || WindowFunction.class.isAssignableFrom(functionClass))) {
                throw new IllegalArgumentException(String.format("Function class %s does not implement the correct interface", functionClass.getName()));
            }
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new IllegalArgumentException(String.format("Function class %s must be in class path", functionConfig.getClassName()), e);
        }
        try {
            typeArgs = FunctionCommon.getFunctionTypes(functionConfig, functionClass);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new IllegalArgumentException(String.format("Function class %s must be in class path", functionConfig.getClassName()), e);
        }
        if (functionConfig.getCustomSerdeInputs() != null) {
            functionConfig.getCustomSerdeInputs().forEach((topicName, inputSerializer) -> ValidatorUtils.validateSerde(inputSerializer, typeArgs[0], clsLoader, true));
        }
        if (functionConfig.getCustomSchemaInputs() != null) {
            functionConfig.getCustomSchemaInputs().forEach((topicName, conf) -> {
                ConsumerConfig consumerConfig;
                try {
                    consumerConfig = (ConsumerConfig)OBJECT_MAPPER.readValue(conf, ConsumerConfig.class);
                }
                catch (JsonProcessingException e) {
                    throw new IllegalArgumentException(String.format("Topic %s has an incorrect schema Info", topicName));
                }
                ValidatorUtils.validateSchema(consumerConfig.getSchemaType(), typeArgs[0], clsLoader, true);
            });
        }
        if (functionConfig.getInputSpecs() != null) {
            functionConfig.getInputSpecs().forEach((topicName, conf) -> {
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)conf.getSchemaType()) && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)conf.getSerdeClassName())) {
                    throw new IllegalArgumentException("Only one of schemaType or serdeClassName should be set in inputSpec");
                }
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)conf.getSerdeClassName())) {
                    ValidatorUtils.validateSerde(conf.getSerdeClassName(), typeArgs[0], clsLoader, true);
                }
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)conf.getSchemaType())) {
                    ValidatorUtils.validateSchema(conf.getSchemaType(), typeArgs[0], clsLoader, true);
                }
                if (conf.getCryptoConfig() != null) {
                    ValidatorUtils.validateCryptoKeyReader(conf.getCryptoConfig(), clsLoader, false);
                }
            });
        }
        if (Void.class.equals((Object)typeArgs[1])) {
            return new ExtractedFunctionDetails(functionClassName, typeArgs[0].getName(), typeArgs[1].getName());
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)functionConfig.getOutputSerdeClassName()) && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)functionConfig.getOutputSchemaType())) {
            throw new IllegalArgumentException("Only one of outputSchemaType or outputSerdeClassName should be set");
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)functionConfig.getOutputSchemaType())) {
            ValidatorUtils.validateSchema(functionConfig.getOutputSchemaType(), typeArgs[1], clsLoader, false);
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)functionConfig.getOutputSerdeClassName())) {
            ValidatorUtils.validateSerde(functionConfig.getOutputSerdeClassName(), typeArgs[1], clsLoader, false);
        }
        if (functionConfig.getProducerConfig() != null && functionConfig.getProducerConfig().getCryptoConfig() != null) {
            ValidatorUtils.validateCryptoKeyReader(functionConfig.getProducerConfig().getCryptoConfig(), clsLoader, true);
        }
        return new ExtractedFunctionDetails(functionClassName, typeArgs[0].getName(), typeArgs[1].getName());
    }

    private static void doPythonChecks(FunctionConfig functionConfig) {
        if (functionConfig.getProcessingGuarantees() == FunctionConfig.ProcessingGuarantees.EFFECTIVELY_ONCE) {
            throw new RuntimeException("Effectively-once processing guarantees not yet supported in Python");
        }
        if (functionConfig.getWindowConfig() != null) {
            throw new IllegalArgumentException("There is currently no support windowing in python");
        }
        if (functionConfig.getMaxMessageRetries() != null && functionConfig.getMaxMessageRetries() >= 0) {
            throw new IllegalArgumentException("Message retries not yet supported in python");
        }
        if (functionConfig.getRetainKeyOrdering() != null && functionConfig.getRetainKeyOrdering().booleanValue()) {
            throw new IllegalArgumentException("Retain Key Orderering not yet supported in python");
        }
    }

    private static void doGolangChecks(FunctionConfig functionConfig) {
        if (functionConfig.getProcessingGuarantees() == FunctionConfig.ProcessingGuarantees.EFFECTIVELY_ONCE) {
            throw new RuntimeException("Effectively-once processing guarantees not yet supported in Go function");
        }
        if (functionConfig.getWindowConfig() != null) {
            throw new IllegalArgumentException("Windowing is not supported in Go function yet");
        }
        if (functionConfig.getMaxMessageRetries() != null && functionConfig.getMaxMessageRetries() >= 0) {
            throw new IllegalArgumentException("Message retries not yet supported in Go function");
        }
        if (functionConfig.getRetainKeyOrdering() != null && functionConfig.getRetainKeyOrdering().booleanValue()) {
            throw new IllegalArgumentException("Retain Key Orderering not yet supported in Go function");
        }
    }

    private static void verifyNoTopicClash(Collection<String> inputTopics, String outputTopic) throws IllegalArgumentException {
        if (inputTopics.contains(outputTopic)) {
            throw new IllegalArgumentException(String.format("Output topic %s is also being used as an input topic (topics must be one or the other)", outputTopic));
        }
    }

    private static void doCommonChecks(FunctionConfig functionConfig) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)functionConfig.getTenant())) {
            throw new IllegalArgumentException("Function tenant cannot be null");
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)functionConfig.getNamespace())) {
            throw new IllegalArgumentException("Function namespace cannot be null");
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)functionConfig.getName())) {
            throw new IllegalArgumentException("Function name cannot be null");
        }
        if (functionConfig.getRuntime() == FunctionConfig.Runtime.PYTHON && org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)functionConfig.getClassName())) {
            throw new IllegalArgumentException("Function classname cannot be null");
        }
        Collection<String> allInputTopics = FunctionConfigUtils.collectAllInputTopics(functionConfig);
        if (allInputTopics.isEmpty()) {
            throw new IllegalArgumentException("No input topic(s) specified for the function");
        }
        for (String topic : allInputTopics) {
            if (TopicName.isValid((String)topic)) continue;
            throw new IllegalArgumentException(String.format("Input topic %s is invalid", topic));
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)functionConfig.getOutput()) && !TopicName.isValid((String)functionConfig.getOutput())) {
            throw new IllegalArgumentException(String.format("Output topic %s is invalid", functionConfig.getOutput()));
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)functionConfig.getLogTopic()) && !TopicName.isValid((String)functionConfig.getLogTopic())) {
            throw new IllegalArgumentException(String.format("LogTopic topic %s is invalid", functionConfig.getLogTopic()));
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)functionConfig.getDeadLetterTopic()) && !TopicName.isValid((String)functionConfig.getDeadLetterTopic())) {
            throw new IllegalArgumentException(String.format("DeadLetter topic %s is invalid", functionConfig.getDeadLetterTopic()));
        }
        if (functionConfig.getParallelism() != null && functionConfig.getParallelism() <= 0) {
            throw new IllegalArgumentException("Function parallelism must be a positive number");
        }
        FunctionConfigUtils.verifyNoTopicClash(allInputTopics, functionConfig.getOutput());
        WindowConfig windowConfig = functionConfig.getWindowConfig();
        if (windowConfig != null) {
            if (functionConfig.getAutoAck() != null && functionConfig.getAutoAck().booleanValue()) {
                throw new IllegalArgumentException("Cannot enable auto ack when using windowing functionality");
            }
            WindowConfigUtils.validate(windowConfig);
        }
        if (functionConfig.getResources() != null) {
            ResourceConfigUtils.validate(functionConfig.getResources());
        }
        if (functionConfig.getTimeoutMs() != null && functionConfig.getTimeoutMs() <= 0L) {
            throw new IllegalArgumentException("Function timeout must be a positive number");
        }
        if (functionConfig.getTimeoutMs() != null && functionConfig.getProcessingGuarantees() != null && functionConfig.getProcessingGuarantees() != FunctionConfig.ProcessingGuarantees.ATLEAST_ONCE) {
            throw new IllegalArgumentException("Message timeout can only be specified with processing guarantee is " + FunctionConfig.ProcessingGuarantees.ATLEAST_ONCE.name());
        }
        if (functionConfig.getMaxMessageRetries() != null && functionConfig.getMaxMessageRetries() >= 0 && functionConfig.getProcessingGuarantees() == FunctionConfig.ProcessingGuarantees.EFFECTIVELY_ONCE) {
            throw new IllegalArgumentException("MaxMessageRetries and Effectively once don't gel well");
        }
        if (!(functionConfig.getMaxMessageRetries() != null && functionConfig.getMaxMessageRetries() >= 0 || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)functionConfig.getDeadLetterTopic()))) {
            throw new IllegalArgumentException("Dead Letter Topic specified, however max retries is set to infinity");
        }
        if (functionConfig.getRetainKeyOrdering() != null && functionConfig.getRetainKeyOrdering().booleanValue() && functionConfig.getProcessingGuarantees() != null && functionConfig.getProcessingGuarantees() == FunctionConfig.ProcessingGuarantees.EFFECTIVELY_ONCE) {
            throw new IllegalArgumentException("When effectively once processing guarantee is specified, retain Key ordering cannot be set");
        }
        if (functionConfig.getRetainKeyOrdering() != null && functionConfig.getRetainKeyOrdering().booleanValue() && functionConfig.getRetainOrdering() != null && functionConfig.getRetainOrdering().booleanValue()) {
            throw new IllegalArgumentException("Only one of retain ordering or retain key ordering can be set");
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)functionConfig.getPy()) && !Utils.isFunctionPackageUrlSupported((String)functionConfig.getPy()) && functionConfig.getPy().startsWith("builtin") && !new File(functionConfig.getPy()).exists()) {
            throw new IllegalArgumentException("The supplied python file does not exist");
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)functionConfig.getGo()) && !Utils.isFunctionPackageUrlSupported((String)functionConfig.getGo()) && functionConfig.getGo().startsWith("builtin") && !new File(functionConfig.getGo()).exists()) {
            throw new IllegalArgumentException("The supplied go file does not exist");
        }
        if (functionConfig.getInputSpecs() != null) {
            functionConfig.getInputSpecs().forEach((topicName, conf) -> {
                if (conf.getReceiverQueueSize() != null && conf.getReceiverQueueSize() < 0) {
                    throw new IllegalArgumentException("Receiver queue size should be >= zero");
                }
                if (conf.getCryptoConfig() != null && StringUtils.isBlank((String)conf.getCryptoConfig().getCryptoKeyReaderClassName())) {
                    throw new IllegalArgumentException("CryptoKeyReader class name required");
                }
            });
        }
        if (functionConfig.getProducerConfig() != null && functionConfig.getProducerConfig().getCryptoConfig() != null) {
            if (StringUtils.isBlank((String)functionConfig.getProducerConfig().getCryptoConfig().getCryptoKeyReaderClassName())) {
                throw new IllegalArgumentException("CryptoKeyReader class name required");
            }
            if (functionConfig.getProducerConfig().getCryptoConfig().getEncryptionKeys() == null || functionConfig.getProducerConfig().getCryptoConfig().getEncryptionKeys().length == 0) {
                throw new IllegalArgumentException("Must provide encryption key name for crypto key reader");
            }
        }
    }

    private static Collection<String> collectAllInputTopics(FunctionConfig functionConfig) {
        LinkedList<String> retval = new LinkedList<String>();
        if (functionConfig.getInputs() != null) {
            retval.addAll(functionConfig.getInputs());
        }
        if (functionConfig.getTopicsPattern() != null) {
            retval.add(functionConfig.getTopicsPattern());
        }
        if (functionConfig.getCustomSerdeInputs() != null) {
            retval.addAll(functionConfig.getCustomSerdeInputs().keySet());
        }
        if (functionConfig.getCustomSchemaInputs() != null) {
            retval.addAll(functionConfig.getCustomSchemaInputs().keySet());
        }
        if (functionConfig.getInputSpecs() != null) {
            retval.addAll(functionConfig.getInputSpecs().keySet());
        }
        return retval;
    }

    public static ClassLoader validate(FunctionConfig functionConfig, File functionPackageFile) {
        FunctionConfigUtils.doCommonChecks(functionConfig);
        if (functionConfig.getRuntime() == FunctionConfig.Runtime.JAVA) {
            ClassLoader classLoader;
            if (functionPackageFile != null) {
                try {
                    classLoader = ClassLoaderUtils.loadJar((File)functionPackageFile);
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("Corrupted Jar File", e);
                }
            } else if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)functionConfig.getJar())) {
                File jarFile = new File(functionConfig.getJar());
                if (!jarFile.exists()) {
                    throw new IllegalArgumentException("Jar file does not exist");
                }
                try {
                    classLoader = ClassLoaderUtils.loadJar((File)jarFile);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Corrupted Jar File", e);
                }
            } else {
                throw new IllegalArgumentException("Function Package is not provided");
            }
            FunctionConfigUtils.doJavaChecks(functionConfig, classLoader);
            return classLoader;
        }
        if (functionConfig.getRuntime() == FunctionConfig.Runtime.GO) {
            FunctionConfigUtils.doGolangChecks(functionConfig);
            return null;
        }
        if (functionConfig.getRuntime() == FunctionConfig.Runtime.PYTHON) {
            FunctionConfigUtils.doPythonChecks(functionConfig);
            return null;
        }
        throw new IllegalArgumentException("Function language runtime is either not set or cannot be determined");
    }

    public static ExtractedFunctionDetails validateJavaFunction(FunctionConfig functionConfig, ClassLoader classLoader) {
        FunctionConfigUtils.doCommonChecks(functionConfig);
        return FunctionConfigUtils.doJavaChecks(functionConfig, classLoader);
    }

    public static FunctionConfig validateUpdate(FunctionConfig existingConfig, FunctionConfig newConfig) {
        FunctionConfig mergedConfig = existingConfig.toBuilder().build();
        if (!existingConfig.getTenant().equals(newConfig.getTenant())) {
            throw new IllegalArgumentException("Tenants differ");
        }
        if (!existingConfig.getNamespace().equals(newConfig.getNamespace())) {
            throw new IllegalArgumentException("Namespaces differ");
        }
        if (!existingConfig.getName().equals(newConfig.getName())) {
            throw new IllegalArgumentException("Function Names differ");
        }
        if (!StringUtils.isEmpty((String)newConfig.getClassName())) {
            mergedConfig.setClassName(newConfig.getClassName());
        }
        if (!StringUtils.isEmpty((String)newConfig.getJar())) {
            mergedConfig.setJar(newConfig.getJar());
        }
        if (newConfig.getInputSpecs() == null) {
            newConfig.setInputSpecs(new HashMap());
        }
        if (mergedConfig.getInputSpecs() == null) {
            mergedConfig.setInputSpecs(new HashMap());
        }
        if (newConfig.getInputs() != null) {
            newConfig.getInputs().forEach(topicName -> newConfig.getInputSpecs().put(topicName, ConsumerConfig.builder().isRegexPattern(false).build()));
        }
        if (newConfig.getTopicsPattern() != null && !newConfig.getTopicsPattern().isEmpty()) {
            newConfig.getInputSpecs().put(newConfig.getTopicsPattern(), ConsumerConfig.builder().isRegexPattern(true).build());
        }
        if (newConfig.getCustomSerdeInputs() != null) {
            newConfig.getCustomSerdeInputs().forEach((topicName, serdeClassName) -> newConfig.getInputSpecs().put(topicName, ConsumerConfig.builder().serdeClassName(serdeClassName).isRegexPattern(false).build()));
        }
        if (newConfig.getCustomSchemaInputs() != null) {
            newConfig.getCustomSchemaInputs().forEach((topicName, schemaClassname) -> newConfig.getInputSpecs().put(topicName, ConsumerConfig.builder().schemaType(schemaClassname).isRegexPattern(false).build()));
        }
        if (!newConfig.getInputSpecs().isEmpty()) {
            newConfig.getInputSpecs().forEach((topicName, consumerConfig) -> {
                if (!existingConfig.getInputSpecs().containsKey(topicName)) {
                    throw new IllegalArgumentException("Input Topics cannot be altered");
                }
                if (consumerConfig.isRegexPattern() != ((ConsumerConfig)existingConfig.getInputSpecs().get(topicName)).isRegexPattern()) {
                    throw new IllegalArgumentException("isRegexPattern for input topic " + topicName + " cannot be altered");
                }
                mergedConfig.getInputSpecs().put(topicName, consumerConfig);
            });
        }
        if (!StringUtils.isEmpty((String)newConfig.getOutputSerdeClassName()) && !newConfig.getOutputSerdeClassName().equals(existingConfig.getOutputSerdeClassName())) {
            throw new IllegalArgumentException("Output Serde mismatch");
        }
        if (!StringUtils.isEmpty((String)newConfig.getOutputSchemaType()) && !newConfig.getOutputSchemaType().equals(existingConfig.getOutputSchemaType())) {
            throw new IllegalArgumentException("Output Schema mismatch");
        }
        if (!StringUtils.isEmpty((String)newConfig.getLogTopic())) {
            mergedConfig.setLogTopic(newConfig.getLogTopic());
        }
        if (newConfig.getProcessingGuarantees() != null && !newConfig.getProcessingGuarantees().equals((Object)existingConfig.getProcessingGuarantees())) {
            throw new IllegalArgumentException("Processing Guarantees cannot be altered");
        }
        if (newConfig.getRetainOrdering() != null && !newConfig.getRetainOrdering().equals(existingConfig.getRetainOrdering())) {
            throw new IllegalArgumentException("Retain Ordering cannot be altered");
        }
        if (newConfig.getRetainKeyOrdering() != null && !newConfig.getRetainKeyOrdering().equals(existingConfig.getRetainKeyOrdering())) {
            throw new IllegalArgumentException("Retain Key Ordering cannot be altered");
        }
        if (!StringUtils.isEmpty((String)newConfig.getOutput())) {
            mergedConfig.setOutput(newConfig.getOutput());
        }
        if (newConfig.getUserConfig() != null) {
            mergedConfig.setUserConfig(newConfig.getUserConfig());
        }
        if (newConfig.getSecrets() != null) {
            mergedConfig.setSecrets(newConfig.getSecrets());
        }
        if (newConfig.getRuntime() != null && !newConfig.getRuntime().equals((Object)existingConfig.getRuntime())) {
            throw new IllegalArgumentException("Runtime cannot be altered");
        }
        if (newConfig.getAutoAck() != null && !newConfig.getAutoAck().equals(existingConfig.getAutoAck())) {
            throw new IllegalArgumentException("AutoAck cannot be altered");
        }
        if (newConfig.getMaxMessageRetries() != null) {
            mergedConfig.setMaxMessageRetries(newConfig.getMaxMessageRetries());
        }
        if (!StringUtils.isEmpty((String)newConfig.getDeadLetterTopic())) {
            mergedConfig.setDeadLetterTopic(newConfig.getDeadLetterTopic());
        }
        if (!StringUtils.isEmpty((String)newConfig.getSubName()) && !newConfig.getSubName().equals(existingConfig.getSubName())) {
            throw new IllegalArgumentException("Subscription Name cannot be altered");
        }
        if (newConfig.getParallelism() != null) {
            mergedConfig.setParallelism(newConfig.getParallelism());
        }
        if (newConfig.getResources() != null) {
            mergedConfig.setResources(ResourceConfigUtils.merge(existingConfig.getResources(), newConfig.getResources()));
        }
        if (newConfig.getWindowConfig() != null) {
            mergedConfig.setWindowConfig(newConfig.getWindowConfig());
        }
        if (newConfig.getTimeoutMs() != null) {
            mergedConfig.setTimeoutMs(newConfig.getTimeoutMs());
        }
        if (newConfig.getCleanupSubscription() != null) {
            mergedConfig.setCleanupSubscription(newConfig.getCleanupSubscription());
        }
        if (!StringUtils.isEmpty((String)newConfig.getRuntimeFlags())) {
            mergedConfig.setRuntimeFlags(newConfig.getRuntimeFlags());
        }
        if (!StringUtils.isEmpty((String)newConfig.getCustomRuntimeOptions())) {
            mergedConfig.setCustomRuntimeOptions(newConfig.getCustomRuntimeOptions());
        }
        if (newConfig.getProducerConfig() != null) {
            mergedConfig.setProducerConfig(newConfig.getProducerConfig());
        }
        return mergedConfig;
    }

    public static class ExtractedFunctionDetails {
        private String functionClassName;
        private String typeArg0;
        private String typeArg1;

        public String getFunctionClassName() {
            return this.functionClassName;
        }

        public String getTypeArg0() {
            return this.typeArg0;
        }

        public String getTypeArg1() {
            return this.typeArg1;
        }

        public void setFunctionClassName(String functionClassName) {
            this.functionClassName = functionClassName;
        }

        public void setTypeArg0(String typeArg0) {
            this.typeArg0 = typeArg0;
        }

        public void setTypeArg1(String typeArg1) {
            this.typeArg1 = typeArg1;
        }

        public ExtractedFunctionDetails(String functionClassName, String typeArg0, String typeArg1) {
            this.functionClassName = functionClassName;
            this.typeArg0 = typeArg0;
            this.typeArg1 = typeArg1;
        }
    }
}

