/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.utils.functions;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.common.functions.FunctionDefinition;
import org.apache.pulsar.common.nar.NarClassLoader;
import org.apache.pulsar.common.nar.NarClassLoaderBuilder;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.functions.api.Function;
import org.apache.pulsar.functions.utils.Exceptions;
import org.apache.pulsar.functions.utils.functions.FunctionArchive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FunctionUtils {
    private static final Logger log = LoggerFactory.getLogger(FunctionUtils.class);
    private static final String PULSAR_IO_SERVICE_NAME = "pulsar-io.yaml";

    public static String getFunctionClass(ClassLoader classLoader) throws IOException {
        NarClassLoader ncl = (NarClassLoader)classLoader;
        String configStr = ncl.getServiceDefinition(PULSAR_IO_SERVICE_NAME);
        FunctionDefinition conf = (FunctionDefinition)ObjectMapperFactory.getYamlMapper().reader().readValue(configStr, FunctionDefinition.class);
        if (StringUtils.isEmpty((CharSequence)conf.getFunctionClass())) {
            throw new IOException(String.format("The '%s' functionctor does not provide a function implementation", conf.getName()));
        }
        try {
            Class functionClass = ncl.loadClass(conf.getFunctionClass());
            if (!Function.class.isAssignableFrom(functionClass)) {
                throw new IOException("Class " + conf.getFunctionClass() + " does not implement interface " + Function.class.getName());
            }
        }
        catch (Throwable t) {
            Exceptions.rethrowIOException(t);
        }
        return conf.getFunctionClass();
    }

    public static FunctionDefinition getFunctionDefinition(NarClassLoader narClassLoader) throws IOException {
        String configStr = narClassLoader.getServiceDefinition(PULSAR_IO_SERVICE_NAME);
        return (FunctionDefinition)ObjectMapperFactory.getYamlMapper().reader().readValue(configStr, FunctionDefinition.class);
    }

    public static TreeMap<String, FunctionArchive> searchForFunctions(String functionsDirectory) throws IOException {
        return FunctionUtils.searchForFunctions(functionsDirectory, false);
    }

    public static TreeMap<String, FunctionArchive> searchForFunctions(String functionsDirectory, boolean alwaysPopulatePath) throws IOException {
        Path path = Paths.get(functionsDirectory, new String[0]).toAbsolutePath();
        log.info("Searching for functions in {}", (Object)path);
        TreeMap<String, FunctionArchive> functions = new TreeMap<String, FunctionArchive>();
        if (!path.toFile().exists()) {
            log.warn("Functions archive directory not found");
            return functions;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path, "*.nar");){
            for (Path archive : stream) {
                try {
                    NarClassLoader ncl = NarClassLoaderBuilder.builder().narFile(new File(archive.toString())).build();
                    FunctionArchive.FunctionArchiveBuilder functionArchiveBuilder = FunctionArchive.builder();
                    FunctionDefinition cntDef = FunctionUtils.getFunctionDefinition(ncl);
                    log.info("Found function {} from {}", (Object)cntDef, (Object)archive);
                    functionArchiveBuilder.archivePath(archive);
                    functionArchiveBuilder.classLoader((ClassLoader)ncl);
                    functionArchiveBuilder.functionDefinition(cntDef);
                    if (!alwaysPopulatePath && StringUtils.isEmpty((CharSequence)cntDef.getFunctionClass())) continue;
                    functions.put(cntDef.getName(), functionArchiveBuilder.build());
                }
                catch (Throwable t) {
                    log.warn("Failed to load function from {}", (Object)archive, (Object)t);
                }
            }
        }
        return functions;
    }

    private FunctionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

