/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.common.functions.ConsumerConfig;
import org.apache.pulsar.common.functions.FunctionConfig;
import org.apache.pulsar.common.functions.Resources;
import org.apache.pulsar.common.io.ConnectorDefinition;
import org.apache.pulsar.common.io.SinkConfig;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.nar.NarClassLoader;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.config.validation.ConfigValidation;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.functions.api.utils.IdentityFunction;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.utils.CryptoUtils;
import org.apache.pulsar.functions.utils.FunctionCommon;
import org.apache.pulsar.functions.utils.FunctionConfigUtils;
import org.apache.pulsar.functions.utils.ResourceConfigUtils;
import org.apache.pulsar.functions.utils.ValidatorUtils;
import org.apache.pulsar.functions.utils.functions.FunctionUtils;
import org.apache.pulsar.functions.utils.io.ConnectorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinkConfigUtils {
    private static final Logger log = LoggerFactory.getLogger(SinkConfigUtils.class);

    public static Function.FunctionDetails convert(SinkConfig sinkConfig, ExtractedSinkDetails sinkDetails) throws IOException {
        boolean isBuiltin;
        Function.FunctionDetails.Builder functionDetailsBuilder = Function.FunctionDetails.newBuilder();
        boolean bl = isBuiltin = !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)sinkConfig.getArchive()) && sinkConfig.getArchive().startsWith("builtin");
        if (sinkConfig.getTenant() != null) {
            functionDetailsBuilder.setTenant(sinkConfig.getTenant());
        }
        if (sinkConfig.getNamespace() != null) {
            functionDetailsBuilder.setNamespace(sinkConfig.getNamespace());
        }
        if (sinkConfig.getName() != null) {
            functionDetailsBuilder.setName(sinkConfig.getName());
        }
        functionDetailsBuilder.setRuntime(Function.FunctionDetails.Runtime.JAVA);
        if (sinkConfig.getParallelism() != null) {
            functionDetailsBuilder.setParallelism(sinkConfig.getParallelism().intValue());
        } else {
            functionDetailsBuilder.setParallelism(1);
        }
        if (sinkDetails.getFunctionClassName() != null) {
            functionDetailsBuilder.setClassName(sinkDetails.getFunctionClassName());
        } else {
            functionDetailsBuilder.setClassName(IdentityFunction.class.getName());
        }
        if (sinkConfig.getTransformFunctionConfig() != null) {
            functionDetailsBuilder.setUserConfig(sinkConfig.getTransformFunctionConfig());
        }
        if (sinkConfig.getProcessingGuarantees() != null) {
            functionDetailsBuilder.setProcessingGuarantees(FunctionCommon.convertProcessingGuarantee(sinkConfig.getProcessingGuarantees()));
        } else {
            functionDetailsBuilder.setProcessingGuarantees(Function.ProcessingGuarantees.ATLEAST_ONCE);
        }
        Function.SourceSpec.Builder sourceSpecBuilder = Function.SourceSpec.newBuilder();
        sourceSpecBuilder.setSubscriptionType(Function.SubscriptionType.SHARED);
        if (sinkConfig.getInputs() != null) {
            sinkConfig.getInputs().forEach(topicName -> sourceSpecBuilder.putInputSpecs(topicName, Function.ConsumerSpec.newBuilder().setIsRegexPattern(false).build()));
        }
        if (!StringUtils.isEmpty((String)sinkConfig.getTopicsPattern())) {
            sourceSpecBuilder.putInputSpecs(sinkConfig.getTopicsPattern(), Function.ConsumerSpec.newBuilder().setIsRegexPattern(true).build());
        }
        if (sinkConfig.getTopicToSerdeClassName() != null) {
            sinkConfig.getTopicToSerdeClassName().forEach((topicName, serde) -> sourceSpecBuilder.putInputSpecs(topicName, Function.ConsumerSpec.newBuilder().setSerdeClassName(serde == null ? "" : serde).setIsRegexPattern(false).build()));
        }
        if (sinkConfig.getTopicToSchemaType() != null) {
            sinkConfig.getTopicToSchemaType().forEach((topicName, schemaType) -> sourceSpecBuilder.putInputSpecs(topicName, Function.ConsumerSpec.newBuilder().setSchemaType(schemaType == null ? "" : schemaType).setIsRegexPattern(false).build()));
        }
        if (sinkConfig.getInputSpecs() != null) {
            sinkConfig.getInputSpecs().forEach((topic, spec) -> {
                Function.ConsumerSpec.Builder bldr = Function.ConsumerSpec.newBuilder().setIsRegexPattern(spec.isRegexPattern());
                if (StringUtils.isNotBlank((String)spec.getSchemaType())) {
                    bldr.setSchemaType(spec.getSchemaType());
                } else if (StringUtils.isNotBlank((String)spec.getSerdeClassName())) {
                    bldr.setSerdeClassName(spec.getSerdeClassName());
                }
                if (spec.getReceiverQueueSize() != null) {
                    bldr.setReceiverQueueSize(Function.ConsumerSpec.ReceiverQueueSize.newBuilder().setValue(spec.getReceiverQueueSize().intValue()).build());
                }
                if (spec.getCryptoConfig() != null) {
                    bldr.setCryptoSpec(CryptoUtils.convert(spec.getCryptoConfig()));
                }
                bldr.putAllConsumerProperties(spec.getConsumerProperties());
                bldr.setPoolMessages(spec.isPoolMessages());
                sourceSpecBuilder.putInputSpecs(topic, bldr.build());
            });
        }
        if (sinkDetails.getTypeArg() != null) {
            sourceSpecBuilder.setTypeClassName(sinkDetails.getTypeArg());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)sinkConfig.getSourceSubscriptionName())) {
            sourceSpecBuilder.setSubscriptionName(sinkConfig.getSourceSubscriptionName());
        }
        Function.SubscriptionType subType = sinkConfig.getRetainOrdering() != null && sinkConfig.getRetainOrdering() != false || FunctionConfig.ProcessingGuarantees.EFFECTIVELY_ONCE.equals((Object)sinkConfig.getProcessingGuarantees()) ? Function.SubscriptionType.FAILOVER : (sinkConfig.getRetainKeyOrdering() != null && sinkConfig.getRetainKeyOrdering() != false ? Function.SubscriptionType.KEY_SHARED : Function.SubscriptionType.SHARED);
        sourceSpecBuilder.setSubscriptionType(subType);
        if (sinkConfig.getAutoAck() != null) {
            functionDetailsBuilder.setAutoAck(sinkConfig.getAutoAck().booleanValue());
        } else {
            functionDetailsBuilder.setAutoAck(true);
        }
        if (sinkConfig.getTimeoutMs() != null) {
            sourceSpecBuilder.setTimeoutMs(sinkConfig.getTimeoutMs().longValue());
        }
        if (sinkConfig.getCleanupSubscription() != null) {
            sourceSpecBuilder.setCleanupSubscription(sinkConfig.getCleanupSubscription().booleanValue());
        } else {
            sourceSpecBuilder.setCleanupSubscription(true);
        }
        if (sinkConfig.getNegativeAckRedeliveryDelayMs() != null && sinkConfig.getNegativeAckRedeliveryDelayMs() > 0L) {
            sourceSpecBuilder.setNegativeAckRedeliveryDelayMs(sinkConfig.getNegativeAckRedeliveryDelayMs().longValue());
        }
        if (sinkConfig.getCleanupSubscription() != null) {
            sourceSpecBuilder.setCleanupSubscription(sinkConfig.getCleanupSubscription().booleanValue());
        } else {
            sourceSpecBuilder.setCleanupSubscription(true);
        }
        if (sinkConfig.getSourceSubscriptionPosition() == SubscriptionInitialPosition.Earliest) {
            sourceSpecBuilder.setSubscriptionPosition(Function.SubscriptionPosition.EARLIEST);
        } else {
            sourceSpecBuilder.setSubscriptionPosition(Function.SubscriptionPosition.LATEST);
        }
        functionDetailsBuilder.setSource(sourceSpecBuilder);
        if (sinkConfig.getMaxMessageRetries() != null && sinkConfig.getMaxMessageRetries() > 0) {
            Function.RetryDetails.Builder retryDetails = Function.RetryDetails.newBuilder();
            retryDetails.setMaxMessageRetries(sinkConfig.getMaxMessageRetries().intValue());
            if (StringUtils.isNotBlank((String)sinkConfig.getDeadLetterTopic())) {
                retryDetails.setDeadLetterTopic(sinkConfig.getDeadLetterTopic());
            }
            functionDetailsBuilder.setRetryDetails(retryDetails);
        }
        Function.SinkSpec.Builder sinkSpecBuilder = Function.SinkSpec.newBuilder();
        if (sinkDetails.getSinkClassName() != null) {
            sinkSpecBuilder.setClassName(sinkDetails.getSinkClassName());
        }
        if (isBuiltin) {
            String builtin = sinkConfig.getArchive().replaceFirst("^builtin://", "");
            sinkSpecBuilder.setBuiltin(builtin);
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)sinkConfig.getTransformFunction()) && sinkConfig.getTransformFunction().startsWith("builtin")) {
            functionDetailsBuilder.setBuiltin(sinkConfig.getTransformFunction().replaceFirst("^builtin://", ""));
        }
        if (sinkConfig.getConfigs() != null) {
            sinkSpecBuilder.setConfigs(new Gson().toJson((Object)sinkConfig.getConfigs()));
        }
        if (sinkConfig.getSecrets() != null && !sinkConfig.getSecrets().isEmpty()) {
            functionDetailsBuilder.setSecretsMap(new Gson().toJson((Object)sinkConfig.getSecrets()));
        }
        if (sinkDetails.getTypeArg() != null) {
            sinkSpecBuilder.setTypeClassName(sinkDetails.getTypeArg());
        }
        functionDetailsBuilder.setSink(sinkSpecBuilder);
        Resources resources = Resources.mergeWithDefault((Resources)sinkConfig.getResources());
        Function.Resources.Builder bldr = Function.Resources.newBuilder();
        bldr.setCpu(resources.getCpu().doubleValue());
        bldr.setRam(resources.getRam().longValue());
        bldr.setDisk(resources.getDisk().longValue());
        functionDetailsBuilder.setResources(bldr);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)sinkConfig.getRuntimeFlags())) {
            functionDetailsBuilder.setRuntimeFlags(sinkConfig.getRuntimeFlags());
        }
        functionDetailsBuilder.setComponentType(Function.FunctionDetails.ComponentType.SINK);
        if (!StringUtils.isEmpty((String)sinkConfig.getCustomRuntimeOptions())) {
            functionDetailsBuilder.setCustomRuntimeOptions(sinkConfig.getCustomRuntimeOptions());
        }
        return FunctionConfigUtils.validateFunctionDetails(functionDetailsBuilder.build());
    }

    public static SinkConfig convertFromDetails(Function.FunctionDetails functionDetails) {
        SinkConfig sinkConfig = new SinkConfig();
        sinkConfig.setTenant(functionDetails.getTenant());
        sinkConfig.setNamespace(functionDetails.getNamespace());
        sinkConfig.setName(functionDetails.getName());
        sinkConfig.setParallelism(Integer.valueOf(functionDetails.getParallelism()));
        sinkConfig.setProcessingGuarantees(FunctionCommon.convertProcessingGuarantee(functionDetails.getProcessingGuarantees()));
        HashMap<String, ConsumerConfig> consumerConfigMap = new HashMap<String, ConsumerConfig>();
        ArrayList<String> inputs = new ArrayList<String>();
        for (Map.Entry input : functionDetails.getSource().getInputSpecsMap().entrySet()) {
            ConsumerConfig consumerConfig = new ConsumerConfig();
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)((Function.ConsumerSpec)input.getValue()).getSerdeClassName())) {
                consumerConfig.setSerdeClassName(((Function.ConsumerSpec)input.getValue()).getSerdeClassName());
            }
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)((Function.ConsumerSpec)input.getValue()).getSchemaType())) {
                consumerConfig.setSchemaType(((Function.ConsumerSpec)input.getValue()).getSchemaType());
            }
            if (((Function.ConsumerSpec)input.getValue()).hasReceiverQueueSize()) {
                consumerConfig.setReceiverQueueSize(Integer.valueOf(((Function.ConsumerSpec)input.getValue()).getReceiverQueueSize().getValue()));
            }
            if (((Function.ConsumerSpec)input.getValue()).hasCryptoSpec()) {
                consumerConfig.setCryptoConfig(CryptoUtils.convertFromSpec(((Function.ConsumerSpec)input.getValue()).getCryptoSpec()));
            }
            consumerConfig.setRegexPattern(((Function.ConsumerSpec)input.getValue()).getIsRegexPattern());
            consumerConfig.setConsumerProperties(((Function.ConsumerSpec)input.getValue()).getConsumerPropertiesMap());
            consumerConfig.setPoolMessages(((Function.ConsumerSpec)input.getValue()).getPoolMessages());
            consumerConfigMap.put((String)input.getKey(), consumerConfig);
            inputs.add((String)input.getKey());
        }
        sinkConfig.setInputs(inputs);
        sinkConfig.setInputSpecs(consumerConfigMap);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)functionDetails.getSource().getSubscriptionName())) {
            sinkConfig.setSourceSubscriptionName(functionDetails.getSource().getSubscriptionName());
        }
        if (functionDetails.getSource().getSubscriptionType() == Function.SubscriptionType.FAILOVER) {
            sinkConfig.setRetainOrdering(Boolean.valueOf(true));
            sinkConfig.setRetainKeyOrdering(Boolean.valueOf(false));
        } else if (functionDetails.getSource().getSubscriptionType() == Function.SubscriptionType.KEY_SHARED) {
            sinkConfig.setRetainOrdering(Boolean.valueOf(false));
            sinkConfig.setRetainKeyOrdering(Boolean.valueOf(true));
        } else {
            sinkConfig.setRetainOrdering(Boolean.valueOf(false));
            sinkConfig.setRetainKeyOrdering(Boolean.valueOf(false));
        }
        sinkConfig.setProcessingGuarantees(FunctionCommon.convertProcessingGuarantee(functionDetails.getProcessingGuarantees()));
        sinkConfig.setAutoAck(Boolean.valueOf(functionDetails.getAutoAck()));
        sinkConfig.setCleanupSubscription(Boolean.valueOf(functionDetails.getSource().getCleanupSubscription()));
        sinkConfig.setSourceSubscriptionPosition(FunctionCommon.convertFromFunctionDetailsSubscriptionPosition(functionDetails.getSource().getSubscriptionPosition()));
        sinkConfig.setCleanupSubscription(Boolean.valueOf(functionDetails.getSource().getCleanupSubscription()));
        if (functionDetails.getSource().getTimeoutMs() != 0L) {
            sinkConfig.setTimeoutMs(Long.valueOf(functionDetails.getSource().getTimeoutMs()));
        }
        if (functionDetails.getSource().getNegativeAckRedeliveryDelayMs() > 0L) {
            sinkConfig.setNegativeAckRedeliveryDelayMs(Long.valueOf(functionDetails.getSource().getNegativeAckRedeliveryDelayMs()));
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)functionDetails.getSink().getClassName())) {
            sinkConfig.setClassName(functionDetails.getSink().getClassName());
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)functionDetails.getSink().getBuiltin())) {
            sinkConfig.setArchive("builtin://" + functionDetails.getSink().getBuiltin());
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)functionDetails.getSink().getConfigs())) {
            Map configMap;
            TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
            try {
                configMap = (Map)ObjectMapperFactory.getMapper().getObjectMapper().readValue(functionDetails.getSink().getConfigs(), (TypeReference)typeRef);
            }
            catch (IOException e) {
                log.error("Failed to read configs for sink {}", (Object)FunctionCommon.getFullyQualifiedName(functionDetails), (Object)e);
                throw new RuntimeException(e);
            }
            sinkConfig.setConfigs(configMap);
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)functionDetails.getSecretsMap())) {
            Type type = new TypeToken<Map<String, Object>>(){}.getType();
            Map secretsMap = (Map)new Gson().fromJson(functionDetails.getSecretsMap(), type);
            sinkConfig.setSecrets(secretsMap);
        }
        if (functionDetails.hasResources()) {
            Resources resources = new Resources();
            resources.setCpu(Double.valueOf(functionDetails.getResources().getCpu()));
            resources.setRam(Long.valueOf(functionDetails.getResources().getRam()));
            resources.setDisk(Long.valueOf(functionDetails.getResources().getDisk()));
            sinkConfig.setResources(resources);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)functionDetails.getRuntimeFlags())) {
            sinkConfig.setRuntimeFlags(functionDetails.getRuntimeFlags());
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)functionDetails.getCustomRuntimeOptions())) {
            sinkConfig.setCustomRuntimeOptions(functionDetails.getCustomRuntimeOptions());
        }
        if (functionDetails.hasRetryDetails()) {
            sinkConfig.setMaxMessageRetries(Integer.valueOf(functionDetails.getRetryDetails().getMaxMessageRetries()));
            if (StringUtils.isNotBlank((String)functionDetails.getRetryDetails().getDeadLetterTopic())) {
                sinkConfig.setDeadLetterTopic(functionDetails.getRetryDetails().getDeadLetterTopic());
            }
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)functionDetails.getBuiltin())) {
            sinkConfig.setTransformFunction("builtin://" + functionDetails.getBuiltin());
        }
        if (!functionDetails.getClassName().equals(IdentityFunction.class.getName())) {
            sinkConfig.setTransformFunctionClassName(functionDetails.getClassName());
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)functionDetails.getUserConfig())) {
            sinkConfig.setTransformFunctionConfig(functionDetails.getUserConfig());
        }
        return sinkConfig;
    }

    public static ExtractedSinkDetails validateAndExtractDetails(SinkConfig sinkConfig, ClassLoader sinkClassLoader, ClassLoader functionClassLoader, boolean validateConnectorConfig) {
        ClassLoader inputClassLoader;
        Class<?> typeArg;
        Class<?> sinkClass;
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)sinkConfig.getTenant())) {
            throw new IllegalArgumentException("Sink tenant cannot be null");
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)sinkConfig.getNamespace())) {
            throw new IllegalArgumentException("Sink namespace cannot be null");
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)sinkConfig.getName())) {
            throw new IllegalArgumentException("Sink name cannot be null");
        }
        Collection<String> allInputs = SinkConfigUtils.collectAllInputTopics(sinkConfig);
        if (allInputs.isEmpty()) {
            throw new IllegalArgumentException("Must specify at least one topic of input via topicToSerdeClassName, topicsPattern, topicToSchemaType or inputSpecs");
        }
        for (String topic : allInputs) {
            if (TopicName.isValid((String)topic)) continue;
            throw new IllegalArgumentException(String.format("Input topic %s is invalid", topic));
        }
        if (sinkConfig.getParallelism() != null && sinkConfig.getParallelism() <= 0) {
            throw new IllegalArgumentException("Sink parallelism must be a positive number");
        }
        if (sinkConfig.getResources() != null) {
            ResourceConfigUtils.validate(sinkConfig.getResources());
        }
        if (sinkConfig.getTimeoutMs() != null && sinkConfig.getTimeoutMs() < 0L) {
            throw new IllegalArgumentException("Sink timeout must be a positive number");
        }
        String sinkClassName = sinkConfig.getClassName();
        if (sinkClassName == null) {
            try {
                sinkClassName = ConnectorUtils.getIOSinkClass((NarClassLoader)sinkClassLoader);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to extract sink class from archive", e);
            }
        }
        try {
            sinkClass = sinkClassLoader.loadClass(sinkClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(String.format("Sink class %s not found in class loader", sinkClassName), e);
        }
        String functionClassName = sinkConfig.getTransformFunctionClassName();
        if (functionClassLoader != null) {
            Class<?> functionClass;
            if (functionClassName == null) {
                try {
                    functionClassName = FunctionUtils.getFunctionClass(functionClassLoader);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Failed to extract function class from archive", e);
                }
            }
            try {
                functionClass = functionClassLoader.loadClass(functionClassName);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(String.format("Function class %s not found in class loader", functionClassName), e);
            }
            if (!FunctionCommon.getRawFunctionTypes(functionClass, false)[1].equals(Record.class)) {
                throw new IllegalArgumentException("Sink transform function output must be of type Record");
            }
            typeArg = FunctionCommon.getFunctionTypes(functionClass, false)[0];
            inputClassLoader = functionClassLoader;
        } else {
            typeArg = FunctionCommon.getSinkType(sinkClass);
            inputClassLoader = sinkClassLoader;
        }
        if (sinkConfig.getTopicToSerdeClassName() != null) {
            for (String serdeClassName : sinkConfig.getTopicToSerdeClassName().values()) {
                ValidatorUtils.validateSerde(serdeClassName, typeArg, inputClassLoader, true);
            }
        }
        if (sinkConfig.getTopicToSchemaType() != null) {
            for (String schemaType : sinkConfig.getTopicToSchemaType().values()) {
                ValidatorUtils.validateSchema(schemaType, typeArg, inputClassLoader, true);
            }
        }
        if (sinkConfig.getInputSpecs() != null) {
            for (ConsumerConfig consumerSpec : sinkConfig.getInputSpecs().values()) {
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)consumerSpec.getSerdeClassName()) && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)consumerSpec.getSchemaType())) {
                    throw new IllegalArgumentException("Only one of serdeClassName or schemaType should be set");
                }
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)consumerSpec.getSerdeClassName())) {
                    ValidatorUtils.validateSerde(consumerSpec.getSerdeClassName(), typeArg, inputClassLoader, true);
                }
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)consumerSpec.getSchemaType())) {
                    ValidatorUtils.validateSchema(consumerSpec.getSchemaType(), typeArg, inputClassLoader, true);
                }
                if (consumerSpec.getCryptoConfig() == null) continue;
                ValidatorUtils.validateCryptoKeyReader(consumerSpec.getCryptoConfig(), inputClassLoader, false);
            }
        }
        if (validateConnectorConfig && sinkClassLoader instanceof NarClassLoader) {
            SinkConfigUtils.validateSinkConfig(sinkConfig, (NarClassLoader)sinkClassLoader);
        }
        return new ExtractedSinkDetails(sinkClassName, typeArg.getName(), functionClassName);
    }

    private static Collection<String> collectAllInputTopics(SinkConfig sinkConfig) {
        LinkedList<String> retval = new LinkedList<String>();
        if (sinkConfig.getInputs() != null) {
            retval.addAll(sinkConfig.getInputs());
        }
        if (sinkConfig.getTopicToSerdeClassName() != null) {
            retval.addAll(sinkConfig.getTopicToSerdeClassName().keySet());
        }
        if (sinkConfig.getTopicsPattern() != null) {
            retval.add(sinkConfig.getTopicsPattern());
        }
        if (sinkConfig.getTopicToSchemaType() != null) {
            retval.addAll(sinkConfig.getTopicToSchemaType().keySet());
        }
        if (sinkConfig.getInputSpecs() != null) {
            retval.addAll(sinkConfig.getInputSpecs().keySet());
        }
        return retval;
    }

    public static SinkConfig clone(SinkConfig sinkConfig) {
        return (SinkConfig)ObjectMapperFactory.getMapper().reader().readValue(ObjectMapperFactory.getMapper().writer().writeValueAsBytes((Object)sinkConfig), SinkConfig.class);
    }

    public static SinkConfig validateUpdate(SinkConfig existingConfig, SinkConfig newConfig) {
        SinkConfig mergedConfig = SinkConfigUtils.clone(existingConfig);
        if (!existingConfig.getTenant().equals(newConfig.getTenant())) {
            throw new IllegalArgumentException("Tenants differ");
        }
        if (!existingConfig.getNamespace().equals(newConfig.getNamespace())) {
            throw new IllegalArgumentException("Namespaces differ");
        }
        if (!existingConfig.getName().equals(newConfig.getName())) {
            throw new IllegalArgumentException("Sink Names differ");
        }
        if (!StringUtils.isEmpty((String)newConfig.getClassName())) {
            mergedConfig.setClassName(newConfig.getClassName());
        }
        if (!StringUtils.isEmpty((String)newConfig.getSourceSubscriptionName()) && !newConfig.getSourceSubscriptionName().equals(existingConfig.getSourceSubscriptionName())) {
            throw new IllegalArgumentException("Subscription Name cannot be altered");
        }
        if (newConfig.getInputSpecs() == null) {
            newConfig.setInputSpecs(new HashMap());
        }
        if (mergedConfig.getInputSpecs() == null) {
            mergedConfig.setInputSpecs(new HashMap());
        }
        if (newConfig.getInputs() != null) {
            newConfig.getInputs().forEach(topicName -> newConfig.getInputSpecs().putIfAbsent(topicName, ConsumerConfig.builder().isRegexPattern(false).build()));
        }
        if (newConfig.getTopicsPattern() != null && !newConfig.getTopicsPattern().isEmpty()) {
            newConfig.getInputSpecs().put(newConfig.getTopicsPattern(), ConsumerConfig.builder().isRegexPattern(true).build());
        }
        if (newConfig.getTopicToSerdeClassName() != null) {
            newConfig.getTopicToSerdeClassName().forEach((topicName, serdeClassName) -> newConfig.getInputSpecs().put(topicName, ConsumerConfig.builder().serdeClassName(serdeClassName).isRegexPattern(false).build()));
        }
        if (newConfig.getTopicToSchemaType() != null) {
            newConfig.getTopicToSchemaType().forEach((topicName, schemaClassname) -> newConfig.getInputSpecs().put(topicName, ConsumerConfig.builder().schemaType(schemaClassname).isRegexPattern(false).build()));
        }
        if (!newConfig.getInputSpecs().isEmpty()) {
            SinkConfig finalMergedConfig = mergedConfig;
            newConfig.getInputSpecs().forEach((topicName, consumerConfig) -> {
                if (!existingConfig.getInputSpecs().containsKey(topicName)) {
                    throw new IllegalArgumentException("Input Topics cannot be altered");
                }
                if (consumerConfig.isRegexPattern() != ((ConsumerConfig)existingConfig.getInputSpecs().get(topicName)).isRegexPattern()) {
                    throw new IllegalArgumentException("isRegexPattern for input topic " + topicName + " cannot be altered");
                }
                finalMergedConfig.getInputSpecs().put(topicName, consumerConfig);
            });
        }
        if (newConfig.getProcessingGuarantees() != null && !newConfig.getProcessingGuarantees().equals((Object)existingConfig.getProcessingGuarantees())) {
            throw new IllegalArgumentException("Processing Guarantees cannot be altered");
        }
        if (newConfig.getConfigs() != null) {
            mergedConfig.setConfigs(newConfig.getConfigs());
        }
        if (newConfig.getSecrets() != null) {
            mergedConfig.setSecrets(newConfig.getSecrets());
        }
        if (newConfig.getParallelism() != null) {
            mergedConfig.setParallelism(newConfig.getParallelism());
        }
        if (newConfig.getRetainOrdering() != null && !newConfig.getRetainOrdering().equals(existingConfig.getRetainOrdering())) {
            throw new IllegalArgumentException("Retain Ordering cannot be altered");
        }
        if (newConfig.getRetainKeyOrdering() != null && !newConfig.getRetainKeyOrdering().equals(existingConfig.getRetainKeyOrdering())) {
            throw new IllegalArgumentException("Retain Key Ordering cannot be altered");
        }
        if (newConfig.getAutoAck() != null && !newConfig.getAutoAck().equals(existingConfig.getAutoAck())) {
            throw new IllegalArgumentException("AutoAck cannot be altered");
        }
        if (newConfig.getResources() != null) {
            mergedConfig.setResources(ResourceConfigUtils.merge(existingConfig.getResources(), newConfig.getResources()));
        }
        if (newConfig.getTimeoutMs() != null) {
            mergedConfig.setTimeoutMs(newConfig.getTimeoutMs());
        }
        if (newConfig.getCleanupSubscription() != null) {
            mergedConfig.setCleanupSubscription(newConfig.getCleanupSubscription());
        }
        if (!StringUtils.isEmpty((String)newConfig.getArchive())) {
            mergedConfig.setArchive(newConfig.getArchive());
        }
        if (!StringUtils.isEmpty((String)newConfig.getRuntimeFlags())) {
            mergedConfig.setRuntimeFlags(newConfig.getRuntimeFlags());
        }
        if (!StringUtils.isEmpty((String)newConfig.getCustomRuntimeOptions())) {
            mergedConfig.setCustomRuntimeOptions(newConfig.getCustomRuntimeOptions());
        }
        if (newConfig.getCleanupSubscription() != null) {
            mergedConfig.setCleanupSubscription(newConfig.getCleanupSubscription());
        }
        if (newConfig.getTransformFunction() != null) {
            mergedConfig.setTransformFunction(newConfig.getTransformFunction());
        }
        if (newConfig.getTransformFunctionClassName() != null) {
            mergedConfig.setTransformFunctionClassName(newConfig.getTransformFunctionClassName());
        }
        if (newConfig.getTransformFunctionConfig() != null) {
            mergedConfig.setTransformFunctionConfig(newConfig.getTransformFunctionConfig());
        }
        return mergedConfig;
    }

    public static void validateSinkConfig(SinkConfig sinkConfig, NarClassLoader narClassLoader) {
        if (sinkConfig.getRetainKeyOrdering() != null && sinkConfig.getRetainKeyOrdering().booleanValue() && sinkConfig.getProcessingGuarantees() != null && sinkConfig.getProcessingGuarantees() == FunctionConfig.ProcessingGuarantees.EFFECTIVELY_ONCE) {
            throw new IllegalArgumentException("When effectively once processing guarantee is specified, retain Key ordering cannot be set");
        }
        if (sinkConfig.getRetainKeyOrdering() != null && sinkConfig.getRetainKeyOrdering().booleanValue() && sinkConfig.getRetainOrdering() != null && sinkConfig.getRetainOrdering().booleanValue()) {
            throw new IllegalArgumentException("Only one of retain ordering or retain key ordering can be set");
        }
        try {
            ConnectorDefinition defn = ConnectorUtils.getConnectorDefinition(narClassLoader);
            if (defn.getSinkConfigClass() != null) {
                Class<?> configClass = Class.forName(defn.getSinkConfigClass(), true, (ClassLoader)narClassLoader);
                SinkConfigUtils.validateSinkConfig(sinkConfig, configClass);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error validating sink config", e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find sink config class", e);
        }
    }

    public static void validateSinkConfig(SinkConfig sinkConfig, Class configClass) {
        try {
            Object configObject = ObjectMapperFactory.getMapper().getObjectMapper().convertValue((Object)sinkConfig.getConfigs(), configClass);
            if (configObject != null) {
                ConfigValidation.validateConfig((Object)configObject);
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Could not validate sink config: " + e.getMessage());
        }
    }

    public static class ExtractedSinkDetails {
        private String sinkClassName;
        private String typeArg;
        private String functionClassName;

        public String getSinkClassName() {
            return this.sinkClassName;
        }

        public String getTypeArg() {
            return this.typeArg;
        }

        public String getFunctionClassName() {
            return this.functionClassName;
        }

        public void setSinkClassName(String sinkClassName) {
            this.sinkClassName = sinkClassName;
        }

        public void setTypeArg(String typeArg) {
            this.typeArg = typeArg;
        }

        public void setFunctionClassName(String functionClassName) {
            this.functionClassName = functionClassName;
        }

        public ExtractedSinkDetails(String sinkClassName, String typeArg, String functionClassName) {
            this.sinkClassName = sinkClassName;
            this.typeArg = typeArg;
            this.functionClassName = functionClassName;
        }
    }
}

