/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.kubernetes;

import java.util.Map;
import org.apache.pulsar.common.configuration.FieldContext;

public class KubernetesRuntimeFactoryConfig {
    @FieldContext(doc="Uri to kubernetes cluster, leave it to empty and it will use the kubernetes settings in function worker machine")
    protected String k8Uri;
    @FieldContext(doc="The Kubernetes namespace to run the function instances. It is `default`, if this setting is left to be empty")
    protected String jobNamespace;
    @FieldContext(doc="The docker image used to run function instance. By default it is `apachepulsar/pulsar`")
    protected String pulsarDockerImageName;
    @FieldContext(doc="The image pull policy for image used to run function instance. By default it is `IfNotPresent`")
    protected String imagePullPolicy;
    @FieldContext(doc="The root directory of pulsar home directory in the pulsar docker image specified `pulsarDockerImageName`. By default it is under `/pulsar`. If you are using your own customized image in `pulsarDockerImageName`, you need to set this setting accordingly")
    protected String pulsarRootDir;
    @FieldContext(doc="This setting only takes effects if `k8Uri` is set to null. If your function worker is also running as a k8s pod, set this to `true` is let function worker to submit functions to the same k8s cluster as function worker is running. Set this to `false` if your function worker is not running as a k8s pod")
    protected Boolean submittingInsidePod;
    @FieldContext(doc="The pulsar service url that pulsar functions should use to connect to pulsar. If it is not set, it will use the pulsar service url configured in function worker.")
    protected String pulsarServiceUrl;
    @FieldContext(doc="The pulsar admin url that pulsar functions should use to connect to pulsar. If it is not set, it will use the pulsar admin url configured in function worker.")
    protected String pulsarAdminUrl;
    @FieldContext(doc="The flag indicates to install user code dependencies. (applied to python package)")
    protected Boolean installUserCodeDependencies;
    @FieldContext(doc="The repository that pulsar functions use to download python dependencies")
    protected String pythonDependencyRepository;
    @FieldContext(doc="The repository that pulsar functions use to download extra python dependencies")
    protected String pythonExtraDependencyRepository;
    @FieldContext(doc="the directory for dropping extra function dependencies. If it is not absolute path, it is relative to `pulsarRootDir`")
    protected String extraFunctionDependenciesDir;
    @FieldContext(doc="The custom labels that function worker uses to select the nodes for pods")
    protected Map<String, String> customLabels;
    @FieldContext(doc="The expected metrics collection interval, in seconds")
    protected Integer expectedMetricsCollectionInterval = 30;
    @FieldContext(doc="Kubernetes Runtime will periodically checkback on this configMap if defined and if there are any changes to the kubernetes specific stuff, we apply those changes")
    protected String changeConfigMap;
    @FieldContext(doc="The namespace for storing change config map")
    protected String changeConfigMapNamespace;
    @FieldContext(doc="Additional memory padding added on top of the memory requested by the function per on a per instance basis")
    protected int percentMemoryPadding;
    @FieldContext(doc="The ratio cpu request and cpu limit to be set for a function/source/sink.  The formula for cpu request is cpuRequest = userRequestCpu / cpuOverCommitRatio")
    protected double cpuOverCommitRatio = 1.0;
    @FieldContext(doc="The ratio memory request and memory limit to be set for a function/source/sink.  The formula for memory request is memoryRequest = userRequestMemory / memoryOverCommitRatio")
    protected double memoryOverCommitRatio = 1.0;
    @FieldContext(doc="The port inside the function pod which is used by the worker to communicate with the pod")
    private Integer grpcPort = 9093;
    @FieldContext(doc="The port inside the function pod on which prometheus metrics are exposed")
    private Integer metricsPort = 9094;

    public String getK8Uri() {
        return this.k8Uri;
    }

    public String getJobNamespace() {
        return this.jobNamespace;
    }

    public String getPulsarDockerImageName() {
        return this.pulsarDockerImageName;
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public String getPulsarRootDir() {
        return this.pulsarRootDir;
    }

    public Boolean getSubmittingInsidePod() {
        return this.submittingInsidePod;
    }

    public String getPulsarServiceUrl() {
        return this.pulsarServiceUrl;
    }

    public String getPulsarAdminUrl() {
        return this.pulsarAdminUrl;
    }

    public Boolean getInstallUserCodeDependencies() {
        return this.installUserCodeDependencies;
    }

    public String getPythonDependencyRepository() {
        return this.pythonDependencyRepository;
    }

    public String getPythonExtraDependencyRepository() {
        return this.pythonExtraDependencyRepository;
    }

    public String getExtraFunctionDependenciesDir() {
        return this.extraFunctionDependenciesDir;
    }

    public Map<String, String> getCustomLabels() {
        return this.customLabels;
    }

    public Integer getExpectedMetricsCollectionInterval() {
        return this.expectedMetricsCollectionInterval;
    }

    public String getChangeConfigMap() {
        return this.changeConfigMap;
    }

    public String getChangeConfigMapNamespace() {
        return this.changeConfigMapNamespace;
    }

    public int getPercentMemoryPadding() {
        return this.percentMemoryPadding;
    }

    public double getCpuOverCommitRatio() {
        return this.cpuOverCommitRatio;
    }

    public double getMemoryOverCommitRatio() {
        return this.memoryOverCommitRatio;
    }

    public Integer getGrpcPort() {
        return this.grpcPort;
    }

    public Integer getMetricsPort() {
        return this.metricsPort;
    }

    public KubernetesRuntimeFactoryConfig setK8Uri(String k8Uri) {
        this.k8Uri = k8Uri;
        return this;
    }

    public KubernetesRuntimeFactoryConfig setJobNamespace(String jobNamespace) {
        this.jobNamespace = jobNamespace;
        return this;
    }

    public KubernetesRuntimeFactoryConfig setPulsarDockerImageName(String pulsarDockerImageName) {
        this.pulsarDockerImageName = pulsarDockerImageName;
        return this;
    }

    public KubernetesRuntimeFactoryConfig setImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
        return this;
    }

    public KubernetesRuntimeFactoryConfig setPulsarRootDir(String pulsarRootDir) {
        this.pulsarRootDir = pulsarRootDir;
        return this;
    }

    public KubernetesRuntimeFactoryConfig setSubmittingInsidePod(Boolean submittingInsidePod) {
        this.submittingInsidePod = submittingInsidePod;
        return this;
    }

    public KubernetesRuntimeFactoryConfig setPulsarServiceUrl(String pulsarServiceUrl) {
        this.pulsarServiceUrl = pulsarServiceUrl;
        return this;
    }

    public KubernetesRuntimeFactoryConfig setPulsarAdminUrl(String pulsarAdminUrl) {
        this.pulsarAdminUrl = pulsarAdminUrl;
        return this;
    }

    public KubernetesRuntimeFactoryConfig setInstallUserCodeDependencies(Boolean installUserCodeDependencies) {
        this.installUserCodeDependencies = installUserCodeDependencies;
        return this;
    }

    public KubernetesRuntimeFactoryConfig setPythonDependencyRepository(String pythonDependencyRepository) {
        this.pythonDependencyRepository = pythonDependencyRepository;
        return this;
    }

    public KubernetesRuntimeFactoryConfig setPythonExtraDependencyRepository(String pythonExtraDependencyRepository) {
        this.pythonExtraDependencyRepository = pythonExtraDependencyRepository;
        return this;
    }

    public KubernetesRuntimeFactoryConfig setExtraFunctionDependenciesDir(String extraFunctionDependenciesDir) {
        this.extraFunctionDependenciesDir = extraFunctionDependenciesDir;
        return this;
    }

    public KubernetesRuntimeFactoryConfig setCustomLabels(Map<String, String> customLabels) {
        this.customLabels = customLabels;
        return this;
    }

    public KubernetesRuntimeFactoryConfig setExpectedMetricsCollectionInterval(Integer expectedMetricsCollectionInterval) {
        this.expectedMetricsCollectionInterval = expectedMetricsCollectionInterval;
        return this;
    }

    public KubernetesRuntimeFactoryConfig setChangeConfigMap(String changeConfigMap) {
        this.changeConfigMap = changeConfigMap;
        return this;
    }

    public KubernetesRuntimeFactoryConfig setChangeConfigMapNamespace(String changeConfigMapNamespace) {
        this.changeConfigMapNamespace = changeConfigMapNamespace;
        return this;
    }

    public KubernetesRuntimeFactoryConfig setPercentMemoryPadding(int percentMemoryPadding) {
        this.percentMemoryPadding = percentMemoryPadding;
        return this;
    }

    public KubernetesRuntimeFactoryConfig setCpuOverCommitRatio(double cpuOverCommitRatio) {
        this.cpuOverCommitRatio = cpuOverCommitRatio;
        return this;
    }

    public KubernetesRuntimeFactoryConfig setMemoryOverCommitRatio(double memoryOverCommitRatio) {
        this.memoryOverCommitRatio = memoryOverCommitRatio;
        return this;
    }

    public KubernetesRuntimeFactoryConfig setGrpcPort(Integer grpcPort) {
        this.grpcPort = grpcPort;
        return this;
    }

    public KubernetesRuntimeFactoryConfig setMetricsPort(Integer metricsPort) {
        this.metricsPort = metricsPort;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesRuntimeFactoryConfig)) {
            return false;
        }
        KubernetesRuntimeFactoryConfig other = (KubernetesRuntimeFactoryConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$k8Uri = this.getK8Uri();
        String other$k8Uri = other.getK8Uri();
        if (this$k8Uri == null ? other$k8Uri != null : !this$k8Uri.equals(other$k8Uri)) {
            return false;
        }
        String this$jobNamespace = this.getJobNamespace();
        String other$jobNamespace = other.getJobNamespace();
        if (this$jobNamespace == null ? other$jobNamespace != null : !this$jobNamespace.equals(other$jobNamespace)) {
            return false;
        }
        String this$pulsarDockerImageName = this.getPulsarDockerImageName();
        String other$pulsarDockerImageName = other.getPulsarDockerImageName();
        if (this$pulsarDockerImageName == null ? other$pulsarDockerImageName != null : !this$pulsarDockerImageName.equals(other$pulsarDockerImageName)) {
            return false;
        }
        String this$imagePullPolicy = this.getImagePullPolicy();
        String other$imagePullPolicy = other.getImagePullPolicy();
        if (this$imagePullPolicy == null ? other$imagePullPolicy != null : !this$imagePullPolicy.equals(other$imagePullPolicy)) {
            return false;
        }
        String this$pulsarRootDir = this.getPulsarRootDir();
        String other$pulsarRootDir = other.getPulsarRootDir();
        if (this$pulsarRootDir == null ? other$pulsarRootDir != null : !this$pulsarRootDir.equals(other$pulsarRootDir)) {
            return false;
        }
        Boolean this$submittingInsidePod = this.getSubmittingInsidePod();
        Boolean other$submittingInsidePod = other.getSubmittingInsidePod();
        if (this$submittingInsidePod == null ? other$submittingInsidePod != null : !((Object)this$submittingInsidePod).equals(other$submittingInsidePod)) {
            return false;
        }
        String this$pulsarServiceUrl = this.getPulsarServiceUrl();
        String other$pulsarServiceUrl = other.getPulsarServiceUrl();
        if (this$pulsarServiceUrl == null ? other$pulsarServiceUrl != null : !this$pulsarServiceUrl.equals(other$pulsarServiceUrl)) {
            return false;
        }
        String this$pulsarAdminUrl = this.getPulsarAdminUrl();
        String other$pulsarAdminUrl = other.getPulsarAdminUrl();
        if (this$pulsarAdminUrl == null ? other$pulsarAdminUrl != null : !this$pulsarAdminUrl.equals(other$pulsarAdminUrl)) {
            return false;
        }
        Boolean this$installUserCodeDependencies = this.getInstallUserCodeDependencies();
        Boolean other$installUserCodeDependencies = other.getInstallUserCodeDependencies();
        if (this$installUserCodeDependencies == null ? other$installUserCodeDependencies != null : !((Object)this$installUserCodeDependencies).equals(other$installUserCodeDependencies)) {
            return false;
        }
        String this$pythonDependencyRepository = this.getPythonDependencyRepository();
        String other$pythonDependencyRepository = other.getPythonDependencyRepository();
        if (this$pythonDependencyRepository == null ? other$pythonDependencyRepository != null : !this$pythonDependencyRepository.equals(other$pythonDependencyRepository)) {
            return false;
        }
        String this$pythonExtraDependencyRepository = this.getPythonExtraDependencyRepository();
        String other$pythonExtraDependencyRepository = other.getPythonExtraDependencyRepository();
        if (this$pythonExtraDependencyRepository == null ? other$pythonExtraDependencyRepository != null : !this$pythonExtraDependencyRepository.equals(other$pythonExtraDependencyRepository)) {
            return false;
        }
        String this$extraFunctionDependenciesDir = this.getExtraFunctionDependenciesDir();
        String other$extraFunctionDependenciesDir = other.getExtraFunctionDependenciesDir();
        if (this$extraFunctionDependenciesDir == null ? other$extraFunctionDependenciesDir != null : !this$extraFunctionDependenciesDir.equals(other$extraFunctionDependenciesDir)) {
            return false;
        }
        Map<String, String> this$customLabels = this.getCustomLabels();
        Map<String, String> other$customLabels = other.getCustomLabels();
        if (this$customLabels == null ? other$customLabels != null : !((Object)this$customLabels).equals(other$customLabels)) {
            return false;
        }
        Integer this$expectedMetricsCollectionInterval = this.getExpectedMetricsCollectionInterval();
        Integer other$expectedMetricsCollectionInterval = other.getExpectedMetricsCollectionInterval();
        if (this$expectedMetricsCollectionInterval == null ? other$expectedMetricsCollectionInterval != null : !((Object)this$expectedMetricsCollectionInterval).equals(other$expectedMetricsCollectionInterval)) {
            return false;
        }
        String this$changeConfigMap = this.getChangeConfigMap();
        String other$changeConfigMap = other.getChangeConfigMap();
        if (this$changeConfigMap == null ? other$changeConfigMap != null : !this$changeConfigMap.equals(other$changeConfigMap)) {
            return false;
        }
        String this$changeConfigMapNamespace = this.getChangeConfigMapNamespace();
        String other$changeConfigMapNamespace = other.getChangeConfigMapNamespace();
        if (this$changeConfigMapNamespace == null ? other$changeConfigMapNamespace != null : !this$changeConfigMapNamespace.equals(other$changeConfigMapNamespace)) {
            return false;
        }
        if (this.getPercentMemoryPadding() != other.getPercentMemoryPadding()) {
            return false;
        }
        if (Double.compare(this.getCpuOverCommitRatio(), other.getCpuOverCommitRatio()) != 0) {
            return false;
        }
        if (Double.compare(this.getMemoryOverCommitRatio(), other.getMemoryOverCommitRatio()) != 0) {
            return false;
        }
        Integer this$grpcPort = this.getGrpcPort();
        Integer other$grpcPort = other.getGrpcPort();
        if (this$grpcPort == null ? other$grpcPort != null : !((Object)this$grpcPort).equals(other$grpcPort)) {
            return false;
        }
        Integer this$metricsPort = this.getMetricsPort();
        Integer other$metricsPort = other.getMetricsPort();
        return !(this$metricsPort == null ? other$metricsPort != null : !((Object)this$metricsPort).equals(other$metricsPort));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KubernetesRuntimeFactoryConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $k8Uri = this.getK8Uri();
        result = result * 59 + ($k8Uri == null ? 43 : $k8Uri.hashCode());
        String $jobNamespace = this.getJobNamespace();
        result = result * 59 + ($jobNamespace == null ? 43 : $jobNamespace.hashCode());
        String $pulsarDockerImageName = this.getPulsarDockerImageName();
        result = result * 59 + ($pulsarDockerImageName == null ? 43 : $pulsarDockerImageName.hashCode());
        String $imagePullPolicy = this.getImagePullPolicy();
        result = result * 59 + ($imagePullPolicy == null ? 43 : $imagePullPolicy.hashCode());
        String $pulsarRootDir = this.getPulsarRootDir();
        result = result * 59 + ($pulsarRootDir == null ? 43 : $pulsarRootDir.hashCode());
        Boolean $submittingInsidePod = this.getSubmittingInsidePod();
        result = result * 59 + ($submittingInsidePod == null ? 43 : ((Object)$submittingInsidePod).hashCode());
        String $pulsarServiceUrl = this.getPulsarServiceUrl();
        result = result * 59 + ($pulsarServiceUrl == null ? 43 : $pulsarServiceUrl.hashCode());
        String $pulsarAdminUrl = this.getPulsarAdminUrl();
        result = result * 59 + ($pulsarAdminUrl == null ? 43 : $pulsarAdminUrl.hashCode());
        Boolean $installUserCodeDependencies = this.getInstallUserCodeDependencies();
        result = result * 59 + ($installUserCodeDependencies == null ? 43 : ((Object)$installUserCodeDependencies).hashCode());
        String $pythonDependencyRepository = this.getPythonDependencyRepository();
        result = result * 59 + ($pythonDependencyRepository == null ? 43 : $pythonDependencyRepository.hashCode());
        String $pythonExtraDependencyRepository = this.getPythonExtraDependencyRepository();
        result = result * 59 + ($pythonExtraDependencyRepository == null ? 43 : $pythonExtraDependencyRepository.hashCode());
        String $extraFunctionDependenciesDir = this.getExtraFunctionDependenciesDir();
        result = result * 59 + ($extraFunctionDependenciesDir == null ? 43 : $extraFunctionDependenciesDir.hashCode());
        Map<String, String> $customLabels = this.getCustomLabels();
        result = result * 59 + ($customLabels == null ? 43 : ((Object)$customLabels).hashCode());
        Integer $expectedMetricsCollectionInterval = this.getExpectedMetricsCollectionInterval();
        result = result * 59 + ($expectedMetricsCollectionInterval == null ? 43 : ((Object)$expectedMetricsCollectionInterval).hashCode());
        String $changeConfigMap = this.getChangeConfigMap();
        result = result * 59 + ($changeConfigMap == null ? 43 : $changeConfigMap.hashCode());
        String $changeConfigMapNamespace = this.getChangeConfigMapNamespace();
        result = result * 59 + ($changeConfigMapNamespace == null ? 43 : $changeConfigMapNamespace.hashCode());
        result = result * 59 + this.getPercentMemoryPadding();
        long $cpuOverCommitRatio = Double.doubleToLongBits(this.getCpuOverCommitRatio());
        result = result * 59 + (int)($cpuOverCommitRatio >>> 32 ^ $cpuOverCommitRatio);
        long $memoryOverCommitRatio = Double.doubleToLongBits(this.getMemoryOverCommitRatio());
        result = result * 59 + (int)($memoryOverCommitRatio >>> 32 ^ $memoryOverCommitRatio);
        Integer $grpcPort = this.getGrpcPort();
        result = result * 59 + ($grpcPort == null ? 43 : ((Object)$grpcPort).hashCode());
        Integer $metricsPort = this.getMetricsPort();
        result = result * 59 + ($metricsPort == null ? 43 : ((Object)$metricsPort).hashCode());
        return result;
    }

    public String toString() {
        return "KubernetesRuntimeFactoryConfig(k8Uri=" + this.getK8Uri() + ", jobNamespace=" + this.getJobNamespace() + ", pulsarDockerImageName=" + this.getPulsarDockerImageName() + ", imagePullPolicy=" + this.getImagePullPolicy() + ", pulsarRootDir=" + this.getPulsarRootDir() + ", submittingInsidePod=" + this.getSubmittingInsidePod() + ", pulsarServiceUrl=" + this.getPulsarServiceUrl() + ", pulsarAdminUrl=" + this.getPulsarAdminUrl() + ", installUserCodeDependencies=" + this.getInstallUserCodeDependencies() + ", pythonDependencyRepository=" + this.getPythonDependencyRepository() + ", pythonExtraDependencyRepository=" + this.getPythonExtraDependencyRepository() + ", extraFunctionDependenciesDir=" + this.getExtraFunctionDependenciesDir() + ", customLabels=" + this.getCustomLabels() + ", expectedMetricsCollectionInterval=" + this.getExpectedMetricsCollectionInterval() + ", changeConfigMap=" + this.getChangeConfigMap() + ", changeConfigMapNamespace=" + this.getChangeConfigMapNamespace() + ", percentMemoryPadding=" + this.getPercentMemoryPadding() + ", cpuOverCommitRatio=" + this.getCpuOverCommitRatio() + ", memoryOverCommitRatio=" + this.getMemoryOverCommitRatio() + ", grpcPort=" + this.getGrpcPort() + ", metricsPort=" + this.getMetricsPort() + ")";
    }
}

