/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.kubernetes;

import com.google.common.annotations.VisibleForTesting;
import io.kubernetes.client.ApiClient;
import io.kubernetes.client.Configuration;
import io.kubernetes.client.apis.AppsV1Api;
import io.kubernetes.client.apis.CoreV1Api;
import io.kubernetes.client.models.V1ConfigMap;
import io.kubernetes.client.util.Config;
import java.lang.reflect.Field;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.common.functions.Resources;
import org.apache.pulsar.functions.auth.FunctionAuthProvider;
import org.apache.pulsar.functions.auth.FunctionAuthUtils;
import org.apache.pulsar.functions.auth.KubernetesFunctionAuthProvider;
import org.apache.pulsar.functions.instance.AuthenticationConfig;
import org.apache.pulsar.functions.instance.InstanceConfig;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.runtime.RuntimeCustomizer;
import org.apache.pulsar.functions.runtime.RuntimeFactory;
import org.apache.pulsar.functions.runtime.RuntimeUtils;
import org.apache.pulsar.functions.runtime.kubernetes.KubernetesManifestCustomizer;
import org.apache.pulsar.functions.runtime.kubernetes.KubernetesRuntime;
import org.apache.pulsar.functions.runtime.kubernetes.KubernetesRuntimeFactoryConfig;
import org.apache.pulsar.functions.secretsproviderconfigurator.SecretsProviderConfigurator;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesRuntimeFactory
implements RuntimeFactory {
    private static final Logger log = LoggerFactory.getLogger(KubernetesRuntimeFactory.class);
    static int NUM_RETRIES = 5;
    static long SLEEP_BETWEEN_RETRIES_MS = 500L;
    private String k8Uri;
    private String jobNamespace;
    private String pulsarDockerImageName;
    private String imagePullPolicy;
    private String pulsarRootDir;
    private String pulsarAdminUrl;
    private String pulsarServiceUrl;
    private String pythonDependencyRepository;
    private String pythonExtraDependencyRepository;
    private String extraDependenciesDir;
    private String changeConfigMap;
    private String changeConfigMapNamespace;
    private int percentMemoryPadding;
    private double cpuOverCommitRatio;
    private double memoryOverCommitRatio;
    private Boolean submittingInsidePod;
    private Boolean installUserCodeDependencies;
    private Map<String, String> customLabels;
    private Integer expectedMetricsCollectionInterval;
    private String stateStorageServiceUri;
    private AuthenticationConfig authConfig;
    private String javaInstanceJarFile;
    private String pythonInstanceFile;
    private final String logDirectory = "logs/functions";
    private Resources functionInstanceMinResources;
    private boolean authenticationEnabled;
    private Integer grpcPort;
    private Integer metricsPort;
    private Timer changeConfigMapTimer;
    private AppsV1Api appsClient;
    private CoreV1Api coreClient;
    private SecretsProviderConfigurator secretsProviderConfigurator;
    private Optional<KubernetesFunctionAuthProvider> authProvider;
    private Optional<KubernetesManifestCustomizer> manifestCustomizer;
    private byte[] serverCaBytes;

    @Override
    public boolean externallyManaged() {
        return true;
    }

    @Override
    public void initialize(WorkerConfig workerConfig, AuthenticationConfig authenticationConfig, SecretsProviderConfigurator secretsProviderConfigurator, Optional<FunctionAuthProvider> functionAuthProvider, Optional<RuntimeCustomizer> runtimeCustomizer) {
        KubernetesRuntimeFactoryConfig factoryConfig = RuntimeUtils.getRuntimeFunctionConfig(workerConfig.getFunctionRuntimeFactoryConfigs(), KubernetesRuntimeFactoryConfig.class);
        this.k8Uri = factoryConfig.getK8Uri();
        this.jobNamespace = !StringUtils.isEmpty((CharSequence)factoryConfig.getJobNamespace()) ? factoryConfig.getJobNamespace() : "default";
        this.pulsarDockerImageName = !StringUtils.isEmpty((CharSequence)factoryConfig.getPulsarDockerImageName()) ? factoryConfig.getPulsarDockerImageName() : "apachepulsar/pulsar";
        this.imagePullPolicy = !StringUtils.isEmpty((CharSequence)factoryConfig.getImagePullPolicy()) ? factoryConfig.getImagePullPolicy() : "IfNotPresent";
        this.pulsarRootDir = !StringUtils.isEmpty((CharSequence)factoryConfig.getPulsarRootDir()) ? factoryConfig.getPulsarRootDir() : "/pulsar";
        this.submittingInsidePod = factoryConfig.getSubmittingInsidePod();
        this.installUserCodeDependencies = factoryConfig.getInstallUserCodeDependencies();
        this.pythonDependencyRepository = factoryConfig.getPythonDependencyRepository();
        this.pythonExtraDependencyRepository = factoryConfig.getPythonExtraDependencyRepository();
        this.extraDependenciesDir = StringUtils.isNotEmpty((CharSequence)factoryConfig.getExtraFunctionDependenciesDir()) ? (Paths.get(factoryConfig.getExtraFunctionDependenciesDir(), new String[0]).isAbsolute() ? factoryConfig.getExtraFunctionDependenciesDir() : this.pulsarRootDir + "/" + factoryConfig.getExtraFunctionDependenciesDir()) : this.pulsarRootDir + "/instances/deps";
        this.customLabels = factoryConfig.getCustomLabels();
        this.percentMemoryPadding = factoryConfig.getPercentMemoryPadding();
        this.cpuOverCommitRatio = factoryConfig.getCpuOverCommitRatio();
        this.memoryOverCommitRatio = factoryConfig.getMemoryOverCommitRatio();
        this.pulsarServiceUrl = StringUtils.isEmpty((CharSequence)factoryConfig.getPulsarServiceUrl()) ? workerConfig.getPulsarServiceUrl() : factoryConfig.getPulsarServiceUrl();
        this.pulsarAdminUrl = StringUtils.isEmpty((CharSequence)factoryConfig.getPulsarAdminUrl()) ? workerConfig.getPulsarWebServiceUrl() : factoryConfig.getPulsarAdminUrl();
        this.stateStorageServiceUri = workerConfig.getStateStorageServiceUrl();
        this.authConfig = authenticationConfig;
        this.expectedMetricsCollectionInterval = factoryConfig.getExpectedMetricsCollectionInterval() == null ? -1 : factoryConfig.getExpectedMetricsCollectionInterval();
        this.changeConfigMap = factoryConfig.getChangeConfigMap();
        this.changeConfigMapNamespace = factoryConfig.getChangeConfigMapNamespace();
        this.functionInstanceMinResources = workerConfig.getFunctionInstanceMinResources();
        this.secretsProviderConfigurator = secretsProviderConfigurator;
        this.authenticationEnabled = workerConfig.isAuthenticationEnabled();
        this.javaInstanceJarFile = this.pulsarRootDir + "/instances/java-instance.jar";
        this.pythonInstanceFile = this.pulsarRootDir + "/instances/python-instance/python_instance_main.py";
        this.serverCaBytes = workerConfig.getTlsTrustChainBytes();
        try {
            this.setupClient();
        }
        catch (Exception e) {
            log.error("Failed to setup client", (Throwable)e);
            throw new RuntimeException(e);
        }
        if (runtimeCustomizer.isPresent()) {
            if (!(runtimeCustomizer.get() instanceof KubernetesManifestCustomizer)) {
                throw new IllegalArgumentException("Function runtime customizer " + runtimeCustomizer.get().getClass().getName() + " must implement KubernetesManifestCustomizer");
            }
            KubernetesManifestCustomizer manifestCustomizer = (KubernetesManifestCustomizer)runtimeCustomizer.get();
            this.manifestCustomizer = Optional.of(manifestCustomizer);
        } else {
            this.manifestCustomizer = Optional.empty();
        }
        if (functionAuthProvider.isPresent()) {
            if (!(functionAuthProvider.get() instanceof KubernetesFunctionAuthProvider)) {
                throw new IllegalArgumentException("Function authentication provider " + functionAuthProvider.get().getClass().getName() + " must implement KubernetesFunctionAuthProvider");
            }
            KubernetesFunctionAuthProvider kubernetesFunctionAuthProvider = (KubernetesFunctionAuthProvider)functionAuthProvider.get();
            kubernetesFunctionAuthProvider.initialize(this.coreClient, this.serverCaBytes, funcDetails -> this.getRuntimeCustomizer().map(customizer -> customizer.customizeNamespace((Function.FunctionDetails)funcDetails, this.jobNamespace)).orElse(this.jobNamespace));
            this.authProvider = Optional.of(kubernetesFunctionAuthProvider);
        } else {
            this.authProvider = Optional.empty();
        }
        this.grpcPort = factoryConfig.getGrpcPort();
        this.metricsPort = factoryConfig.getMetricsPort();
    }

    @Override
    public KubernetesRuntime createContainer(InstanceConfig instanceConfig, String codePkgUrl, String originalCodeFileName, Long expectedHealthCheckInterval) throws Exception {
        String instanceFile = null;
        switch (instanceConfig.getFunctionDetails().getRuntime()) {
            case JAVA: {
                instanceFile = this.javaInstanceJarFile;
                break;
            }
            case PYTHON: {
                instanceFile = this.pythonInstanceFile;
                break;
            }
            case GO: {
                throw new UnsupportedOperationException();
            }
            default: {
                throw new RuntimeException("Unsupported Runtime " + instanceConfig.getFunctionDetails().getRuntime());
            }
        }
        if (this.authenticationEnabled) {
            this.authProvider.ifPresent(kubernetesFunctionAuthProvider -> kubernetesFunctionAuthProvider.configureAuthenticationConfig(this.authConfig, Optional.ofNullable(FunctionAuthUtils.getFunctionAuthData(Optional.ofNullable(instanceConfig.getFunctionAuthenticationSpec())))));
        }
        Optional<KubernetesManifestCustomizer> manifestCustomizer = this.getRuntimeCustomizer();
        String overriddenNamespace = manifestCustomizer.map(customizer -> customizer.customizeNamespace(instanceConfig.getFunctionDetails(), this.jobNamespace)).orElse(this.jobNamespace);
        return new KubernetesRuntime(this.appsClient, this.coreClient, overriddenNamespace, this.customLabels, this.installUserCodeDependencies, this.pythonDependencyRepository, this.pythonExtraDependencyRepository, this.pulsarDockerImageName, this.imagePullPolicy, this.pulsarRootDir, instanceConfig, instanceFile, this.extraDependenciesDir, "logs/functions", codePkgUrl, originalCodeFileName, this.pulsarServiceUrl, this.pulsarAdminUrl, this.stateStorageServiceUri, this.authConfig, this.secretsProviderConfigurator, this.expectedMetricsCollectionInterval, this.percentMemoryPadding, this.cpuOverCommitRatio, this.memoryOverCommitRatio, this.authProvider, this.authenticationEnabled, this.grpcPort, this.metricsPort, manifestCustomizer);
    }

    @Override
    public void close() {
    }

    @Override
    public void doAdmissionChecks(Function.FunctionDetails functionDetails) {
        KubernetesRuntime.doChecks(functionDetails);
        this.validateMinResourcesRequired(functionDetails);
        this.secretsProviderConfigurator.doAdmissionChecks(this.appsClient, this.coreClient, this.getOverriddenNamespace(functionDetails), functionDetails);
    }

    @VisibleForTesting
    public void setupClient() throws Exception {
        if (this.appsClient == null) {
            if (this.k8Uri == null) {
                ApiClient cli;
                log.info("k8Uri is null thus going by defaults");
                if (this.submittingInsidePod.booleanValue()) {
                    log.info("Looks like we are inside a k8 pod ourselves. Initializing as cluster");
                    cli = Config.fromCluster();
                } else {
                    log.info("Using default cluster since we are not running inside k8");
                    cli = Config.defaultClient();
                }
                Configuration.setDefaultApiClient((ApiClient)cli);
                this.appsClient = new AppsV1Api();
                this.coreClient = new CoreV1Api();
            } else {
                log.info("Setting up k8Client using uri " + this.k8Uri);
                ApiClient apiClient = new ApiClient().setBasePath(this.k8Uri);
                this.appsClient = new AppsV1Api(apiClient);
                this.coreClient = new CoreV1Api(apiClient);
            }
            if (!StringUtils.isEmpty((CharSequence)this.changeConfigMap)) {
                this.changeConfigMapTimer = new Timer();
                final KubernetesRuntimeFactory THIS = this;
                this.changeConfigMapTimer.scheduleAtFixedRate(new TimerTask(){

                    @Override
                    public void run() {
                        KubernetesRuntimeFactory.fetchConfigMap(KubernetesRuntimeFactory.this.coreClient, KubernetesRuntimeFactory.this.changeConfigMap, KubernetesRuntimeFactory.this.changeConfigMapNamespace, THIS);
                    }
                }, 300000L, 300000L);
            }
        }
    }

    static void fetchConfigMap(CoreV1Api coreClient, String changeConfigMap, String changeConfigMapNamespace, KubernetesRuntimeFactory kubernetesRuntimeFactory) {
        try {
            V1ConfigMap v1ConfigMap = coreClient.readNamespacedConfigMap(changeConfigMap, changeConfigMapNamespace, null, Boolean.valueOf(true), Boolean.valueOf(false));
            Map data = v1ConfigMap.getData();
            if (data != null) {
                KubernetesRuntimeFactory.overRideKubernetesConfig(data, kubernetesRuntimeFactory);
            }
        }
        catch (Exception e) {
            log.error("Error while trying to fetch configmap {} at namespace {}", new Object[]{changeConfigMap, changeConfigMapNamespace, e});
        }
    }

    static void overRideKubernetesConfig(Map<String, String> data, KubernetesRuntimeFactory kubernetesRuntimeFactory) throws Exception {
        for (Field field : KubernetesRuntimeFactory.class.getDeclaredFields()) {
            field.setAccessible(true);
            if (!data.containsKey(field.getName()) || data.get(field.getName()).equals(field.get(kubernetesRuntimeFactory))) continue;
            log.info("Kubernetes Config {} changed from {} to {}", new Object[]{field.getName(), field.get(kubernetesRuntimeFactory), data.get(field.getName())});
            field.set(kubernetesRuntimeFactory, data.get(field.getName()));
        }
    }

    void validateMinResourcesRequired(Function.FunctionDetails functionDetails) {
        if (this.functionInstanceMinResources != null) {
            Double minCpu = this.functionInstanceMinResources.getCpu();
            Long minRam = this.functionInstanceMinResources.getRam();
            if (minCpu != null) {
                if (functionDetails.getResources() == null) {
                    throw new IllegalArgumentException(String.format("Per instance CPU requested is not specified. Must specify CPU requested for function to be at least %s", minCpu));
                }
                if (functionDetails.getResources().getCpu() < minCpu) {
                    throw new IllegalArgumentException(String.format("Per instance CPU requested, %s, for function is less than the minimum required, %s", functionDetails.getResources().getCpu(), minCpu));
                }
            }
            if (minRam != null) {
                if (functionDetails.getResources() == null) {
                    throw new IllegalArgumentException(String.format("Per instance RAM requested is not specified. Must specify RAM requested for function to be at least %s", minRam));
                }
                if (functionDetails.getResources().getRam() < minRam) {
                    throw new IllegalArgumentException(String.format("Per instance RAM requested, %s, for function is less than the minimum required, %s", functionDetails.getResources().getRam(), minRam));
                }
            }
        }
    }

    public Optional<KubernetesFunctionAuthProvider> getAuthProvider() {
        return this.authProvider;
    }

    public Optional<KubernetesManifestCustomizer> getRuntimeCustomizer() {
        return this.manifestCustomizer;
    }

    private String getOverriddenNamespace(Function.FunctionDetails funcDetails) {
        Optional<KubernetesManifestCustomizer> manifestCustomizer = this.getRuntimeCustomizer();
        return manifestCustomizer.map(customizer -> customizer.customizeNamespace(funcDetails, this.jobNamespace)).orElse(this.jobNamespace);
    }

    public String getK8Uri() {
        return this.k8Uri;
    }

    public String getJobNamespace() {
        return this.jobNamespace;
    }

    public String getPulsarDockerImageName() {
        return this.pulsarDockerImageName;
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public String getPulsarRootDir() {
        return this.pulsarRootDir;
    }

    public String getPulsarAdminUrl() {
        return this.pulsarAdminUrl;
    }

    public String getPulsarServiceUrl() {
        return this.pulsarServiceUrl;
    }

    public String getPythonDependencyRepository() {
        return this.pythonDependencyRepository;
    }

    public String getPythonExtraDependencyRepository() {
        return this.pythonExtraDependencyRepository;
    }

    public String getExtraDependenciesDir() {
        return this.extraDependenciesDir;
    }

    public String getChangeConfigMap() {
        return this.changeConfigMap;
    }

    public String getChangeConfigMapNamespace() {
        return this.changeConfigMapNamespace;
    }

    public int getPercentMemoryPadding() {
        return this.percentMemoryPadding;
    }

    public double getCpuOverCommitRatio() {
        return this.cpuOverCommitRatio;
    }

    public double getMemoryOverCommitRatio() {
        return this.memoryOverCommitRatio;
    }

    public Boolean getSubmittingInsidePod() {
        return this.submittingInsidePod;
    }

    public Boolean getInstallUserCodeDependencies() {
        return this.installUserCodeDependencies;
    }

    public Map<String, String> getCustomLabels() {
        return this.customLabels;
    }

    public Integer getExpectedMetricsCollectionInterval() {
        return this.expectedMetricsCollectionInterval;
    }

    public String getStateStorageServiceUri() {
        return this.stateStorageServiceUri;
    }

    public AuthenticationConfig getAuthConfig() {
        return this.authConfig;
    }

    public String getJavaInstanceJarFile() {
        return this.javaInstanceJarFile;
    }

    public String getPythonInstanceFile() {
        return this.pythonInstanceFile;
    }

    public String getLogDirectory() {
        return this.logDirectory;
    }

    public Resources getFunctionInstanceMinResources() {
        return this.functionInstanceMinResources;
    }

    public boolean isAuthenticationEnabled() {
        return this.authenticationEnabled;
    }

    public Integer getGrpcPort() {
        return this.grpcPort;
    }

    public Integer getMetricsPort() {
        return this.metricsPort;
    }

    public Timer getChangeConfigMapTimer() {
        return this.changeConfigMapTimer;
    }

    public AppsV1Api getAppsClient() {
        return this.appsClient;
    }

    public CoreV1Api getCoreClient() {
        return this.coreClient;
    }

    public SecretsProviderConfigurator getSecretsProviderConfigurator() {
        return this.secretsProviderConfigurator;
    }

    public Optional<KubernetesManifestCustomizer> getManifestCustomizer() {
        return this.manifestCustomizer;
    }

    public byte[] getServerCaBytes() {
        return this.serverCaBytes;
    }

    public void setK8Uri(String k8Uri) {
        this.k8Uri = k8Uri;
    }

    public void setJobNamespace(String jobNamespace) {
        this.jobNamespace = jobNamespace;
    }

    public void setPulsarDockerImageName(String pulsarDockerImageName) {
        this.pulsarDockerImageName = pulsarDockerImageName;
    }

    public void setImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
    }

    public void setPulsarRootDir(String pulsarRootDir) {
        this.pulsarRootDir = pulsarRootDir;
    }

    public void setPulsarAdminUrl(String pulsarAdminUrl) {
        this.pulsarAdminUrl = pulsarAdminUrl;
    }

    public void setPulsarServiceUrl(String pulsarServiceUrl) {
        this.pulsarServiceUrl = pulsarServiceUrl;
    }

    public void setPythonDependencyRepository(String pythonDependencyRepository) {
        this.pythonDependencyRepository = pythonDependencyRepository;
    }

    public void setPythonExtraDependencyRepository(String pythonExtraDependencyRepository) {
        this.pythonExtraDependencyRepository = pythonExtraDependencyRepository;
    }

    public void setExtraDependenciesDir(String extraDependenciesDir) {
        this.extraDependenciesDir = extraDependenciesDir;
    }

    public void setChangeConfigMap(String changeConfigMap) {
        this.changeConfigMap = changeConfigMap;
    }

    public void setChangeConfigMapNamespace(String changeConfigMapNamespace) {
        this.changeConfigMapNamespace = changeConfigMapNamespace;
    }

    public void setPercentMemoryPadding(int percentMemoryPadding) {
        this.percentMemoryPadding = percentMemoryPadding;
    }

    public void setCpuOverCommitRatio(double cpuOverCommitRatio) {
        this.cpuOverCommitRatio = cpuOverCommitRatio;
    }

    public void setMemoryOverCommitRatio(double memoryOverCommitRatio) {
        this.memoryOverCommitRatio = memoryOverCommitRatio;
    }

    public void setSubmittingInsidePod(Boolean submittingInsidePod) {
        this.submittingInsidePod = submittingInsidePod;
    }

    public void setInstallUserCodeDependencies(Boolean installUserCodeDependencies) {
        this.installUserCodeDependencies = installUserCodeDependencies;
    }

    public void setCustomLabels(Map<String, String> customLabels) {
        this.customLabels = customLabels;
    }

    public void setExpectedMetricsCollectionInterval(Integer expectedMetricsCollectionInterval) {
        this.expectedMetricsCollectionInterval = expectedMetricsCollectionInterval;
    }

    public void setStateStorageServiceUri(String stateStorageServiceUri) {
        this.stateStorageServiceUri = stateStorageServiceUri;
    }

    public void setAuthConfig(AuthenticationConfig authConfig) {
        this.authConfig = authConfig;
    }

    public void setJavaInstanceJarFile(String javaInstanceJarFile) {
        this.javaInstanceJarFile = javaInstanceJarFile;
    }

    public void setPythonInstanceFile(String pythonInstanceFile) {
        this.pythonInstanceFile = pythonInstanceFile;
    }

    public void setFunctionInstanceMinResources(Resources functionInstanceMinResources) {
        this.functionInstanceMinResources = functionInstanceMinResources;
    }

    public void setAuthenticationEnabled(boolean authenticationEnabled) {
        this.authenticationEnabled = authenticationEnabled;
    }

    public void setGrpcPort(Integer grpcPort) {
        this.grpcPort = grpcPort;
    }

    public void setMetricsPort(Integer metricsPort) {
        this.metricsPort = metricsPort;
    }

    public void setChangeConfigMapTimer(Timer changeConfigMapTimer) {
        this.changeConfigMapTimer = changeConfigMapTimer;
    }

    public void setAppsClient(AppsV1Api appsClient) {
        this.appsClient = appsClient;
    }

    public void setCoreClient(CoreV1Api coreClient) {
        this.coreClient = coreClient;
    }

    public void setSecretsProviderConfigurator(SecretsProviderConfigurator secretsProviderConfigurator) {
        this.secretsProviderConfigurator = secretsProviderConfigurator;
    }

    public void setAuthProvider(Optional<KubernetesFunctionAuthProvider> authProvider) {
        this.authProvider = authProvider;
    }

    public void setManifestCustomizer(Optional<KubernetesManifestCustomizer> manifestCustomizer) {
        this.manifestCustomizer = manifestCustomizer;
    }

    public void setServerCaBytes(byte[] serverCaBytes) {
        this.serverCaBytes = serverCaBytes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesRuntimeFactory)) {
            return false;
        }
        KubernetesRuntimeFactory other = (KubernetesRuntimeFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$k8Uri = this.getK8Uri();
        String other$k8Uri = other.getK8Uri();
        if (this$k8Uri == null ? other$k8Uri != null : !this$k8Uri.equals(other$k8Uri)) {
            return false;
        }
        String this$jobNamespace = this.getJobNamespace();
        String other$jobNamespace = other.getJobNamespace();
        if (this$jobNamespace == null ? other$jobNamespace != null : !this$jobNamespace.equals(other$jobNamespace)) {
            return false;
        }
        String this$pulsarDockerImageName = this.getPulsarDockerImageName();
        String other$pulsarDockerImageName = other.getPulsarDockerImageName();
        if (this$pulsarDockerImageName == null ? other$pulsarDockerImageName != null : !this$pulsarDockerImageName.equals(other$pulsarDockerImageName)) {
            return false;
        }
        String this$imagePullPolicy = this.getImagePullPolicy();
        String other$imagePullPolicy = other.getImagePullPolicy();
        if (this$imagePullPolicy == null ? other$imagePullPolicy != null : !this$imagePullPolicy.equals(other$imagePullPolicy)) {
            return false;
        }
        String this$pulsarRootDir = this.getPulsarRootDir();
        String other$pulsarRootDir = other.getPulsarRootDir();
        if (this$pulsarRootDir == null ? other$pulsarRootDir != null : !this$pulsarRootDir.equals(other$pulsarRootDir)) {
            return false;
        }
        String this$pulsarAdminUrl = this.getPulsarAdminUrl();
        String other$pulsarAdminUrl = other.getPulsarAdminUrl();
        if (this$pulsarAdminUrl == null ? other$pulsarAdminUrl != null : !this$pulsarAdminUrl.equals(other$pulsarAdminUrl)) {
            return false;
        }
        String this$pulsarServiceUrl = this.getPulsarServiceUrl();
        String other$pulsarServiceUrl = other.getPulsarServiceUrl();
        if (this$pulsarServiceUrl == null ? other$pulsarServiceUrl != null : !this$pulsarServiceUrl.equals(other$pulsarServiceUrl)) {
            return false;
        }
        String this$pythonDependencyRepository = this.getPythonDependencyRepository();
        String other$pythonDependencyRepository = other.getPythonDependencyRepository();
        if (this$pythonDependencyRepository == null ? other$pythonDependencyRepository != null : !this$pythonDependencyRepository.equals(other$pythonDependencyRepository)) {
            return false;
        }
        String this$pythonExtraDependencyRepository = this.getPythonExtraDependencyRepository();
        String other$pythonExtraDependencyRepository = other.getPythonExtraDependencyRepository();
        if (this$pythonExtraDependencyRepository == null ? other$pythonExtraDependencyRepository != null : !this$pythonExtraDependencyRepository.equals(other$pythonExtraDependencyRepository)) {
            return false;
        }
        String this$extraDependenciesDir = this.getExtraDependenciesDir();
        String other$extraDependenciesDir = other.getExtraDependenciesDir();
        if (this$extraDependenciesDir == null ? other$extraDependenciesDir != null : !this$extraDependenciesDir.equals(other$extraDependenciesDir)) {
            return false;
        }
        String this$changeConfigMap = this.getChangeConfigMap();
        String other$changeConfigMap = other.getChangeConfigMap();
        if (this$changeConfigMap == null ? other$changeConfigMap != null : !this$changeConfigMap.equals(other$changeConfigMap)) {
            return false;
        }
        String this$changeConfigMapNamespace = this.getChangeConfigMapNamespace();
        String other$changeConfigMapNamespace = other.getChangeConfigMapNamespace();
        if (this$changeConfigMapNamespace == null ? other$changeConfigMapNamespace != null : !this$changeConfigMapNamespace.equals(other$changeConfigMapNamespace)) {
            return false;
        }
        if (this.getPercentMemoryPadding() != other.getPercentMemoryPadding()) {
            return false;
        }
        if (Double.compare(this.getCpuOverCommitRatio(), other.getCpuOverCommitRatio()) != 0) {
            return false;
        }
        if (Double.compare(this.getMemoryOverCommitRatio(), other.getMemoryOverCommitRatio()) != 0) {
            return false;
        }
        Boolean this$submittingInsidePod = this.getSubmittingInsidePod();
        Boolean other$submittingInsidePod = other.getSubmittingInsidePod();
        if (this$submittingInsidePod == null ? other$submittingInsidePod != null : !((Object)this$submittingInsidePod).equals(other$submittingInsidePod)) {
            return false;
        }
        Boolean this$installUserCodeDependencies = this.getInstallUserCodeDependencies();
        Boolean other$installUserCodeDependencies = other.getInstallUserCodeDependencies();
        if (this$installUserCodeDependencies == null ? other$installUserCodeDependencies != null : !((Object)this$installUserCodeDependencies).equals(other$installUserCodeDependencies)) {
            return false;
        }
        Map<String, String> this$customLabels = this.getCustomLabels();
        Map<String, String> other$customLabels = other.getCustomLabels();
        if (this$customLabels == null ? other$customLabels != null : !((Object)this$customLabels).equals(other$customLabels)) {
            return false;
        }
        Integer this$expectedMetricsCollectionInterval = this.getExpectedMetricsCollectionInterval();
        Integer other$expectedMetricsCollectionInterval = other.getExpectedMetricsCollectionInterval();
        if (this$expectedMetricsCollectionInterval == null ? other$expectedMetricsCollectionInterval != null : !((Object)this$expectedMetricsCollectionInterval).equals(other$expectedMetricsCollectionInterval)) {
            return false;
        }
        String this$stateStorageServiceUri = this.getStateStorageServiceUri();
        String other$stateStorageServiceUri = other.getStateStorageServiceUri();
        if (this$stateStorageServiceUri == null ? other$stateStorageServiceUri != null : !this$stateStorageServiceUri.equals(other$stateStorageServiceUri)) {
            return false;
        }
        AuthenticationConfig this$authConfig = this.getAuthConfig();
        AuthenticationConfig other$authConfig = other.getAuthConfig();
        if (this$authConfig == null ? other$authConfig != null : !this$authConfig.equals(other$authConfig)) {
            return false;
        }
        String this$javaInstanceJarFile = this.getJavaInstanceJarFile();
        String other$javaInstanceJarFile = other.getJavaInstanceJarFile();
        if (this$javaInstanceJarFile == null ? other$javaInstanceJarFile != null : !this$javaInstanceJarFile.equals(other$javaInstanceJarFile)) {
            return false;
        }
        String this$pythonInstanceFile = this.getPythonInstanceFile();
        String other$pythonInstanceFile = other.getPythonInstanceFile();
        if (this$pythonInstanceFile == null ? other$pythonInstanceFile != null : !this$pythonInstanceFile.equals(other$pythonInstanceFile)) {
            return false;
        }
        String this$logDirectory = this.getLogDirectory();
        String other$logDirectory = other.getLogDirectory();
        if (this$logDirectory == null ? other$logDirectory != null : !this$logDirectory.equals(other$logDirectory)) {
            return false;
        }
        Resources this$functionInstanceMinResources = this.getFunctionInstanceMinResources();
        Resources other$functionInstanceMinResources = other.getFunctionInstanceMinResources();
        if (this$functionInstanceMinResources == null ? other$functionInstanceMinResources != null : !this$functionInstanceMinResources.equals(other$functionInstanceMinResources)) {
            return false;
        }
        if (this.isAuthenticationEnabled() != other.isAuthenticationEnabled()) {
            return false;
        }
        Integer this$grpcPort = this.getGrpcPort();
        Integer other$grpcPort = other.getGrpcPort();
        if (this$grpcPort == null ? other$grpcPort != null : !((Object)this$grpcPort).equals(other$grpcPort)) {
            return false;
        }
        Integer this$metricsPort = this.getMetricsPort();
        Integer other$metricsPort = other.getMetricsPort();
        return !(this$metricsPort == null ? other$metricsPort != null : !((Object)this$metricsPort).equals(other$metricsPort));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KubernetesRuntimeFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $k8Uri = this.getK8Uri();
        result = result * 59 + ($k8Uri == null ? 43 : $k8Uri.hashCode());
        String $jobNamespace = this.getJobNamespace();
        result = result * 59 + ($jobNamespace == null ? 43 : $jobNamespace.hashCode());
        String $pulsarDockerImageName = this.getPulsarDockerImageName();
        result = result * 59 + ($pulsarDockerImageName == null ? 43 : $pulsarDockerImageName.hashCode());
        String $imagePullPolicy = this.getImagePullPolicy();
        result = result * 59 + ($imagePullPolicy == null ? 43 : $imagePullPolicy.hashCode());
        String $pulsarRootDir = this.getPulsarRootDir();
        result = result * 59 + ($pulsarRootDir == null ? 43 : $pulsarRootDir.hashCode());
        String $pulsarAdminUrl = this.getPulsarAdminUrl();
        result = result * 59 + ($pulsarAdminUrl == null ? 43 : $pulsarAdminUrl.hashCode());
        String $pulsarServiceUrl = this.getPulsarServiceUrl();
        result = result * 59 + ($pulsarServiceUrl == null ? 43 : $pulsarServiceUrl.hashCode());
        String $pythonDependencyRepository = this.getPythonDependencyRepository();
        result = result * 59 + ($pythonDependencyRepository == null ? 43 : $pythonDependencyRepository.hashCode());
        String $pythonExtraDependencyRepository = this.getPythonExtraDependencyRepository();
        result = result * 59 + ($pythonExtraDependencyRepository == null ? 43 : $pythonExtraDependencyRepository.hashCode());
        String $extraDependenciesDir = this.getExtraDependenciesDir();
        result = result * 59 + ($extraDependenciesDir == null ? 43 : $extraDependenciesDir.hashCode());
        String $changeConfigMap = this.getChangeConfigMap();
        result = result * 59 + ($changeConfigMap == null ? 43 : $changeConfigMap.hashCode());
        String $changeConfigMapNamespace = this.getChangeConfigMapNamespace();
        result = result * 59 + ($changeConfigMapNamespace == null ? 43 : $changeConfigMapNamespace.hashCode());
        result = result * 59 + this.getPercentMemoryPadding();
        long $cpuOverCommitRatio = Double.doubleToLongBits(this.getCpuOverCommitRatio());
        result = result * 59 + (int)($cpuOverCommitRatio >>> 32 ^ $cpuOverCommitRatio);
        long $memoryOverCommitRatio = Double.doubleToLongBits(this.getMemoryOverCommitRatio());
        result = result * 59 + (int)($memoryOverCommitRatio >>> 32 ^ $memoryOverCommitRatio);
        Boolean $submittingInsidePod = this.getSubmittingInsidePod();
        result = result * 59 + ($submittingInsidePod == null ? 43 : ((Object)$submittingInsidePod).hashCode());
        Boolean $installUserCodeDependencies = this.getInstallUserCodeDependencies();
        result = result * 59 + ($installUserCodeDependencies == null ? 43 : ((Object)$installUserCodeDependencies).hashCode());
        Map<String, String> $customLabels = this.getCustomLabels();
        result = result * 59 + ($customLabels == null ? 43 : ((Object)$customLabels).hashCode());
        Integer $expectedMetricsCollectionInterval = this.getExpectedMetricsCollectionInterval();
        result = result * 59 + ($expectedMetricsCollectionInterval == null ? 43 : ((Object)$expectedMetricsCollectionInterval).hashCode());
        String $stateStorageServiceUri = this.getStateStorageServiceUri();
        result = result * 59 + ($stateStorageServiceUri == null ? 43 : $stateStorageServiceUri.hashCode());
        AuthenticationConfig $authConfig = this.getAuthConfig();
        result = result * 59 + ($authConfig == null ? 43 : $authConfig.hashCode());
        String $javaInstanceJarFile = this.getJavaInstanceJarFile();
        result = result * 59 + ($javaInstanceJarFile == null ? 43 : $javaInstanceJarFile.hashCode());
        String $pythonInstanceFile = this.getPythonInstanceFile();
        result = result * 59 + ($pythonInstanceFile == null ? 43 : $pythonInstanceFile.hashCode());
        String $logDirectory = this.getLogDirectory();
        result = result * 59 + ($logDirectory == null ? 43 : $logDirectory.hashCode());
        Resources $functionInstanceMinResources = this.getFunctionInstanceMinResources();
        result = result * 59 + ($functionInstanceMinResources == null ? 43 : $functionInstanceMinResources.hashCode());
        result = result * 59 + (this.isAuthenticationEnabled() ? 79 : 97);
        Integer $grpcPort = this.getGrpcPort();
        result = result * 59 + ($grpcPort == null ? 43 : ((Object)$grpcPort).hashCode());
        Integer $metricsPort = this.getMetricsPort();
        result = result * 59 + ($metricsPort == null ? 43 : ((Object)$metricsPort).hashCode());
        return result;
    }

    public String toString() {
        return "KubernetesRuntimeFactory(k8Uri=" + this.getK8Uri() + ", jobNamespace=" + this.getJobNamespace() + ", pulsarDockerImageName=" + this.getPulsarDockerImageName() + ", imagePullPolicy=" + this.getImagePullPolicy() + ", pulsarRootDir=" + this.getPulsarRootDir() + ", pulsarAdminUrl=" + this.getPulsarAdminUrl() + ", pulsarServiceUrl=" + this.getPulsarServiceUrl() + ", pythonDependencyRepository=" + this.getPythonDependencyRepository() + ", pythonExtraDependencyRepository=" + this.getPythonExtraDependencyRepository() + ", extraDependenciesDir=" + this.getExtraDependenciesDir() + ", changeConfigMap=" + this.getChangeConfigMap() + ", changeConfigMapNamespace=" + this.getChangeConfigMapNamespace() + ", percentMemoryPadding=" + this.getPercentMemoryPadding() + ", cpuOverCommitRatio=" + this.getCpuOverCommitRatio() + ", memoryOverCommitRatio=" + this.getMemoryOverCommitRatio() + ", submittingInsidePod=" + this.getSubmittingInsidePod() + ", installUserCodeDependencies=" + this.getInstallUserCodeDependencies() + ", customLabels=" + this.getCustomLabels() + ", expectedMetricsCollectionInterval=" + this.getExpectedMetricsCollectionInterval() + ", stateStorageServiceUri=" + this.getStateStorageServiceUri() + ", authConfig=" + this.getAuthConfig() + ", javaInstanceJarFile=" + this.getJavaInstanceJarFile() + ", pythonInstanceFile=" + this.getPythonInstanceFile() + ", logDirectory=" + this.getLogDirectory() + ", functionInstanceMinResources=" + this.getFunctionInstanceMinResources() + ", authenticationEnabled=" + this.isAuthenticationEnabled() + ", grpcPort=" + this.getGrpcPort() + ", metricsPort=" + this.getMetricsPort() + ")";
    }
}

