/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.kubernetes;

import com.google.gson.Gson;
import io.kubernetes.client.models.V1ObjectMeta;
import io.kubernetes.client.models.V1PodSpec;
import io.kubernetes.client.models.V1PodTemplateSpec;
import io.kubernetes.client.models.V1Service;
import io.kubernetes.client.models.V1StatefulSet;
import io.kubernetes.client.models.V1Toleration;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.runtime.kubernetes.KubernetesManifestCustomizer;

public class BasicKubernetesManifestCustomizer
implements KubernetesManifestCustomizer {
    @Override
    public void initialize(Map<String, Object> config) {
    }

    @Override
    public String customizeNamespace(Function.FunctionDetails funcDetails, String currentNamespace) {
        RuntimeOpts opts = this.getOptsFromDetails(funcDetails);
        if (!StringUtils.isEmpty((CharSequence)opts.getJobNamespace())) {
            return opts.getJobNamespace();
        }
        return currentNamespace;
    }

    @Override
    public V1Service customizeService(Function.FunctionDetails funcDetails, V1Service service) {
        RuntimeOpts opts = this.getOptsFromDetails(funcDetails);
        service.setMetadata(this.updateMeta(opts, service.getMetadata()));
        return service;
    }

    @Override
    public V1StatefulSet customizeStatefulSet(Function.FunctionDetails funcDetails, V1StatefulSet statefulSet) {
        RuntimeOpts opts = this.getOptsFromDetails(funcDetails);
        statefulSet.setMetadata(this.updateMeta(opts, statefulSet.getMetadata()));
        V1PodTemplateSpec pt = statefulSet.getSpec().getTemplate();
        pt.setMetadata(this.updateMeta(opts, pt.getMetadata()));
        V1PodSpec ps = pt.getSpec();
        if (opts.getNodeSelectorLabels() != null && opts.getNodeSelectorLabels().size() > 0) {
            opts.getNodeSelectorLabels().forEach((arg_0, arg_1) -> ((V1PodSpec)ps).putNodeSelectorItem(arg_0, arg_1));
        }
        if (opts.getTolerations() != null && opts.getTolerations().size() > 0) {
            opts.getTolerations().forEach(arg_0 -> ((V1PodSpec)ps).addTolerationsItem(arg_0));
        }
        return statefulSet;
    }

    private RuntimeOpts getOptsFromDetails(Function.FunctionDetails funcDetails) {
        String customRuntimeOptions = funcDetails.getCustomRuntimeOptions();
        RuntimeOpts opts = (RuntimeOpts)new Gson().fromJson(customRuntimeOptions, RuntimeOpts.class);
        if (opts == null) {
            opts = new RuntimeOpts();
        }
        return opts;
    }

    private V1ObjectMeta updateMeta(RuntimeOpts opts, V1ObjectMeta meta) {
        if (opts.getExtraAnnotations() != null && opts.getExtraAnnotations().size() > 0) {
            opts.getExtraAnnotations().forEach((arg_0, arg_1) -> ((V1ObjectMeta)meta).putAnnotationsItem(arg_0, arg_1));
        }
        if (opts.getExtraLabels() != null && opts.getExtraLabels().size() > 0) {
            opts.getExtraLabels().forEach((arg_0, arg_1) -> ((V1ObjectMeta)meta).putLabelsItem(arg_0, arg_1));
        }
        return meta;
    }

    private static class RuntimeOpts {
        private String jobNamespace;
        private Map<String, String> extraLabels;
        private Map<String, String> extraAnnotations;
        private Map<String, String> nodeSelectorLabels;
        private List<V1Toleration> tolerations;

        public String getJobNamespace() {
            return this.jobNamespace;
        }

        public Map<String, String> getExtraLabels() {
            return this.extraLabels;
        }

        public Map<String, String> getExtraAnnotations() {
            return this.extraAnnotations;
        }

        public Map<String, String> getNodeSelectorLabels() {
            return this.nodeSelectorLabels;
        }

        public List<V1Toleration> getTolerations() {
            return this.tolerations;
        }

        public void setJobNamespace(String jobNamespace) {
            this.jobNamespace = jobNamespace;
        }

        public void setExtraLabels(Map<String, String> extraLabels) {
            this.extraLabels = extraLabels;
        }

        public void setExtraAnnotations(Map<String, String> extraAnnotations) {
            this.extraAnnotations = extraAnnotations;
        }

        public void setNodeSelectorLabels(Map<String, String> nodeSelectorLabels) {
            this.nodeSelectorLabels = nodeSelectorLabels;
        }

        public void setTolerations(List<V1Toleration> tolerations) {
            this.tolerations = tolerations;
        }
    }
}

