/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime;

import com.google.common.annotations.VisibleForTesting;
import io.prometheus.client.CollectorRegistry;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.functions.instance.AuthenticationConfig;
import org.apache.pulsar.functions.instance.InstanceCache;
import org.apache.pulsar.functions.instance.InstanceConfig;
import org.apache.pulsar.functions.runtime.RuntimeFactory;
import org.apache.pulsar.functions.runtime.ThreadRuntime;
import org.apache.pulsar.functions.secretsprovider.SecretsProvider;
import org.apache.pulsar.functions.utils.functioncache.FunctionCacheManager;
import org.apache.pulsar.functions.utils.functioncache.FunctionCacheManagerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadRuntimeFactory
implements RuntimeFactory {
    private static final Logger log = LoggerFactory.getLogger(ThreadRuntimeFactory.class);
    private final ThreadGroup threadGroup;
    private final FunctionCacheManager fnCache;
    private final PulsarClient pulsarClient;
    private final String storageServiceUrl;
    private final SecretsProvider secretsProvider;
    private final CollectorRegistry collectorRegistry;
    private volatile boolean closed;

    public ThreadRuntimeFactory(String threadGroupName, String pulsarServiceUrl, String storageServiceUrl, AuthenticationConfig authConfig, SecretsProvider secretsProvider, CollectorRegistry collectorRegistry, ClassLoader rootClassLoader) throws Exception {
        this(threadGroupName, ThreadRuntimeFactory.createPulsarClient(pulsarServiceUrl, authConfig), storageServiceUrl, secretsProvider, collectorRegistry, rootClassLoader);
    }

    @VisibleForTesting
    public ThreadRuntimeFactory(String threadGroupName, PulsarClient pulsarClient, String storageServiceUrl, SecretsProvider secretsProvider, CollectorRegistry collectorRegistry, ClassLoader rootClassLoader) {
        if (rootClassLoader == null) {
            rootClassLoader = Thread.currentThread().getContextClassLoader();
        }
        this.secretsProvider = secretsProvider;
        this.fnCache = new FunctionCacheManagerImpl(rootClassLoader);
        this.threadGroup = new ThreadGroup(threadGroupName);
        this.pulsarClient = pulsarClient;
        this.storageServiceUrl = storageServiceUrl;
        this.collectorRegistry = collectorRegistry;
    }

    public static ClassLoader loadJar(ClassLoader parent, File[] jars) throws MalformedURLException {
        URL[] urls = new URL[jars.length];
        for (int i = 0; i < jars.length; ++i) {
            urls[i] = jars[i].toURI().toURL();
        }
        return new URLClassLoader(urls, parent);
    }

    private static PulsarClient createPulsarClient(String pulsarServiceUrl, AuthenticationConfig authConfig) throws PulsarClientException {
        ClientBuilder clientBuilder = null;
        if (StringUtils.isNotBlank((CharSequence)pulsarServiceUrl)) {
            clientBuilder = PulsarClient.builder().serviceUrl(pulsarServiceUrl);
            if (authConfig != null) {
                if (StringUtils.isNotBlank((CharSequence)authConfig.getClientAuthenticationPlugin()) && StringUtils.isNotBlank((CharSequence)authConfig.getClientAuthenticationParameters())) {
                    clientBuilder.authentication(authConfig.getClientAuthenticationPlugin(), authConfig.getClientAuthenticationParameters());
                }
                clientBuilder.enableTls(authConfig.isUseTls());
                clientBuilder.allowTlsInsecureConnection(authConfig.isTlsAllowInsecureConnection());
                clientBuilder.enableTlsHostnameVerification(authConfig.isTlsHostnameVerificationEnable());
                clientBuilder.tlsTrustCertsFilePath(authConfig.getTlsTrustCertsFilePath());
            }
            return clientBuilder.build();
        }
        return null;
    }

    @Override
    public ThreadRuntime createContainer(InstanceConfig instanceConfig, String jarFile, String originalCodeFileName, Long expectedHealthCheckInterval) {
        return new ThreadRuntime(instanceConfig, this.fnCache, this.threadGroup, jarFile, this.pulsarClient, this.storageServiceUrl, this.secretsProvider, this.collectorRegistry);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.threadGroup.interrupt();
        this.fnCache.close();
        try {
            this.pulsarClient.close();
        }
        catch (PulsarClientException e) {
            log.warn("Failed to close pulsar client when closing function container factory", (Throwable)e);
        }
        InstanceCache.shutdown();
    }
}

