/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.auth;

import io.kubernetes.client.ApiException;
import io.kubernetes.client.apis.CoreV1Api;
import io.kubernetes.client.models.V1DeleteOptions;
import io.kubernetes.client.models.V1ObjectMeta;
import io.kubernetes.client.models.V1PodSpec;
import io.kubernetes.client.models.V1Secret;
import io.kubernetes.client.models.V1SecretVolumeSource;
import io.kubernetes.client.models.V1StatefulSet;
import io.kubernetes.client.models.V1Volume;
import io.kubernetes.client.models.V1VolumeMount;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.naming.AuthenticationException;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authentication.AuthenticationProviderToken;
import org.apache.pulsar.client.impl.auth.AuthenticationToken;
import org.apache.pulsar.functions.auth.FunctionAuthData;
import org.apache.pulsar.functions.auth.KubernetesFunctionAuthProvider;
import org.apache.pulsar.functions.instance.AuthenticationConfig;
import org.apache.pulsar.functions.utils.Actions;
import org.apache.pulsar.functions.utils.FunctionCommon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesSecretsTokenAuthProvider
implements KubernetesFunctionAuthProvider {
    private static final Logger log = LoggerFactory.getLogger(KubernetesSecretsTokenAuthProvider.class);
    private static final int NUM_RETRIES = 5;
    private static final long SLEEP_BETWEEN_RETRIES_MS = 500L;
    private static final String SECRET_NAME = "function-auth";
    private static final String DEFAULT_SECRET_MOUNT_DIR = "/etc/auth";
    private static final String FUNCTION_AUTH_TOKEN = "token";
    private final CoreV1Api coreClient;
    private final String kubeNamespace;

    public KubernetesSecretsTokenAuthProvider(CoreV1Api coreClient, String kubeNamespace) {
        this.coreClient = coreClient;
        this.kubeNamespace = kubeNamespace;
    }

    @Override
    public void configureAuthDataStatefulSet(V1StatefulSet statefulSet, Optional<FunctionAuthData> functionAuthData) {
        if (!functionAuthData.isPresent()) {
            return;
        }
        V1PodSpec podSpec = statefulSet.getSpec().getTemplate().getSpec();
        podSpec.setVolumes(Collections.singletonList(new V1Volume().name(SECRET_NAME).secret(new V1SecretVolumeSource().secretName(this.getSecretName(new String(functionAuthData.get().getData()))).defaultMode(Integer.valueOf(256)))));
        podSpec.getContainers().forEach(container -> container.setVolumeMounts(Collections.singletonList(new V1VolumeMount().name(SECRET_NAME).mountPath(DEFAULT_SECRET_MOUNT_DIR).readOnly(Boolean.valueOf(true)))));
    }

    @Override
    public void configureAuthenticationConfig(AuthenticationConfig authConfig, Optional<FunctionAuthData> functionAuthData) {
        if (!functionAuthData.isPresent()) {
            authConfig.setClientAuthenticationPlugin(null);
            authConfig.setClientAuthenticationParameters(null);
        } else {
            authConfig.setClientAuthenticationPlugin(AuthenticationToken.class.getName());
            authConfig.setClientAuthenticationParameters(String.format("file://%s/%s", DEFAULT_SECRET_MOUNT_DIR, FUNCTION_AUTH_TOKEN));
        }
    }

    @Override
    public Optional<FunctionAuthData> cacheAuthData(String tenant, String namespace, String name, AuthenticationDataSource authenticationDataSource) {
        String id = null;
        try {
            String token = AuthenticationProviderToken.getToken((AuthenticationDataSource)authenticationDataSource);
            if (token != null) {
                id = this.createSecret(token, tenant, namespace, name);
            }
        }
        catch (Exception e) {
            log.warn("Failed to get token for function {}", (Object)FunctionCommon.getFullyQualifiedName((String)tenant, (String)namespace, (String)name), (Object)e);
        }
        if (id != null) {
            return Optional.of(FunctionAuthData.builder().data(id.getBytes()).build());
        }
        return Optional.empty();
    }

    @Override
    public void cleanUpAuthData(String tenant, String namespace, String name, Optional<FunctionAuthData> functionAuthData) throws Exception {
        if (!functionAuthData.isPresent()) {
            return;
        }
        String fqfn = FunctionCommon.getFullyQualifiedName((String)tenant, (String)namespace, (String)name);
        String secretId = new String(functionAuthData.get().getData());
        if (StringUtils.isBlank((CharSequence)secretId)) {
            log.warn("Secret name for function {} is empty.", (Object)fqfn);
            return;
        }
        String secretName = this.getSecretName(secretId);
        Actions.Action deleteSecrets = Actions.Action.builder().actionName(String.format("Deleting secrets for function %s", fqfn)).numRetries(5).sleepBetweenInvocationsMs(500L).supplier(() -> {
            try {
                V1DeleteOptions v1DeleteOptions = new V1DeleteOptions();
                v1DeleteOptions.setGracePeriodSeconds(Long.valueOf(0L));
                v1DeleteOptions.setPropagationPolicy("Foreground");
                this.coreClient.deleteNamespacedSecret(secretName, this.kubeNamespace, v1DeleteOptions, "true", null, null, null);
            }
            catch (ApiException e) {
                if (e.getCode() == 404) {
                    log.warn("Secrets for function {} does not exist", (Object)fqfn);
                    return Actions.ActionResult.builder().success(true).build();
                }
                String errorMsg = e.getResponseBody() != null ? e.getResponseBody() : e.getMessage();
                return Actions.ActionResult.builder().success(false).errorMsg(errorMsg).build();
            }
            return Actions.ActionResult.builder().success(true).build();
        }).build();
        Actions.Action waitForSecretsDeletion = Actions.Action.builder().actionName(String.format("Waiting for secrets for function %s to complete deletion", fqfn)).numRetries(5).sleepBetweenInvocationsMs(500L).supplier(() -> {
            try {
                this.coreClient.readNamespacedSecret(secretName, this.kubeNamespace, null, null, null);
            }
            catch (ApiException e) {
                if (e.getCode() == 404) {
                    return Actions.ActionResult.builder().success(true).build();
                }
                String errorMsg = e.getResponseBody() != null ? e.getResponseBody() : e.getMessage();
                return Actions.ActionResult.builder().success(false).errorMsg(errorMsg).build();
            }
            return Actions.ActionResult.builder().success(false).build();
        }).build();
        AtomicBoolean success = new AtomicBoolean(false);
        Actions.newBuilder().addAction(deleteSecrets.toBuilder().continueOn(Boolean.valueOf(true)).build()).addAction(waitForSecretsDeletion.toBuilder().continueOn(Boolean.valueOf(false)).onSuccess(ignore -> success.set(true)).build()).addAction(deleteSecrets.toBuilder().continueOn(Boolean.valueOf(true)).build()).addAction(waitForSecretsDeletion.toBuilder().onSuccess(ignore -> success.set(true)).build()).run();
        if (!success.get()) {
            throw new RuntimeException(String.format("Failed to delete secrets for function %s", fqfn));
        }
    }

    @Override
    public Optional<FunctionAuthData> updateAuthData(String tenant, String namespace, String name, Optional<FunctionAuthData> existingFunctionAuthData, AuthenticationDataSource authenticationDataSource) throws Exception {
        String token;
        String secretId = existingFunctionAuthData.isPresent() ? new String(existingFunctionAuthData.get().getData()) : RandomStringUtils.random((int)5, (boolean)true, (boolean)true).toLowerCase();
        try {
            token = AuthenticationProviderToken.getToken((AuthenticationDataSource)authenticationDataSource);
        }
        catch (AuthenticationException e) {
            this.cleanUpAuthData(tenant, namespace, name, existingFunctionAuthData);
            return Optional.empty();
        }
        if (token != null) {
            this.upsertSecret(token, tenant, namespace, name, this.getSecretName(secretId));
            return Optional.of(FunctionAuthData.builder().data(secretId.getBytes()).build());
        }
        return existingFunctionAuthData;
    }

    private void upsertSecret(String token, String tenant, String namespace, String name, String secretName) throws InterruptedException {
        Actions.Action createAuthSecret = Actions.Action.builder().actionName(String.format("Upsert authentication secret for function %s/%s/%s", tenant, namespace, name)).numRetries(5).sleepBetweenInvocationsMs(500L).supplier(() -> {
            String id = RandomStringUtils.random((int)5, (boolean)true, (boolean)true).toLowerCase();
            V1Secret v1Secret = new V1Secret().metadata(new V1ObjectMeta().name(secretName)).data(Collections.singletonMap(FUNCTION_AUTH_TOKEN, token.getBytes()));
            try {
                this.coreClient.createNamespacedSecret(this.kubeNamespace, v1Secret, null);
            }
            catch (ApiException e) {
                if (e.getCode() == 409) {
                    try {
                        this.coreClient.replaceNamespacedSecret(secretName, this.kubeNamespace, v1Secret, null);
                        return Actions.ActionResult.builder().success(true).build();
                    }
                    catch (ApiException e1) {
                        String errorMsg = e.getResponseBody() != null ? e.getResponseBody() : e.getMessage();
                        return Actions.ActionResult.builder().success(false).errorMsg(errorMsg).build();
                    }
                }
                String errorMsg = e.getResponseBody() != null ? e.getResponseBody() : e.getMessage();
                return Actions.ActionResult.builder().success(false).errorMsg(errorMsg).build();
            }
            return Actions.ActionResult.builder().success(true).build();
        }).build();
        AtomicBoolean success = new AtomicBoolean(false);
        Actions.newBuilder().addAction(createAuthSecret.toBuilder().onSuccess(ignore -> success.set(true)).build()).run();
        if (!success.get()) {
            throw new RuntimeException(String.format("Failed to upsert authentication secret for function %s/%s/%s", tenant, namespace, name));
        }
    }

    private String createSecret(String token, String tenant, String namespace, String name) throws ApiException, InterruptedException {
        StringBuilder sb = new StringBuilder();
        Actions.Action createAuthSecret = Actions.Action.builder().actionName(String.format("Creating authentication secret for function %s/%s/%s", tenant, namespace, name)).numRetries(5).sleepBetweenInvocationsMs(500L).supplier(() -> {
            String id = RandomStringUtils.random((int)5, (boolean)true, (boolean)true).toLowerCase();
            V1Secret v1Secret = new V1Secret().metadata(new V1ObjectMeta().name(this.getSecretName(id))).data(Collections.singletonMap(FUNCTION_AUTH_TOKEN, token.getBytes()));
            try {
                this.coreClient.createNamespacedSecret(this.kubeNamespace, v1Secret, "true");
            }
            catch (ApiException e) {
                if (e.getCode() == 409) {
                    return Actions.ActionResult.builder().errorMsg(String.format("Secret %s already present", id)).success(false).build();
                }
                String errorMsg = e.getResponseBody() != null ? e.getResponseBody() : e.getMessage();
                return Actions.ActionResult.builder().success(false).errorMsg(errorMsg).build();
            }
            sb.append(id.toCharArray());
            return Actions.ActionResult.builder().success(true).build();
        }).build();
        AtomicBoolean success = new AtomicBoolean(false);
        Actions.newBuilder().addAction(createAuthSecret.toBuilder().onSuccess(ignore -> success.set(true)).build()).run();
        if (!success.get()) {
            throw new RuntimeException(String.format("Failed to create authentication secret for function %s/%s/%s", tenant, namespace, name));
        }
        return sb.toString();
    }

    private String getSecretName(String id) {
        return "pf-secret-" + id;
    }
}

