/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.functions.instance.AuthenticationConfig;
import org.apache.pulsar.functions.instance.InstanceConfig;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.runtime.JavaInstanceMain;
import org.apache.pulsar.functions.utils.FunctionDetailsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeUtils {
    private static final Logger log = LoggerFactory.getLogger(RuntimeUtils.class);
    private static final String FUNCTIONS_EXTRA_DEPS_PROPERTY = "pulsar.functions.extra.dependencies.dir";

    public static List<String> composeCmd(InstanceConfig instanceConfig, String instanceFile, String extraDependenciesDir, String logDirectory, String originalCodeFileName, String pulsarServiceUrl, String stateStorageServiceUrl, AuthenticationConfig authConfig, String shardId, Integer grpcPort, Long expectedHealthCheckInterval, String logConfigFile, String secretsProviderClassName, String secretsProviderConfig, Boolean installUserCodeDependencies, String pythonDependencyRepository, String pythonExtraDependencyRepository, int metricsPort) throws Exception {
        List<String> cmd = RuntimeUtils.getArgsBeforeCmd(instanceConfig, extraDependenciesDir);
        cmd.addAll(RuntimeUtils.getCmd(instanceConfig, instanceFile, extraDependenciesDir, logDirectory, originalCodeFileName, pulsarServiceUrl, stateStorageServiceUrl, authConfig, shardId, grpcPort, expectedHealthCheckInterval, logConfigFile, secretsProviderClassName, secretsProviderConfig, installUserCodeDependencies, pythonDependencyRepository, pythonExtraDependencyRepository, metricsPort));
        return cmd;
    }

    public static List<String> getArgsBeforeCmd(InstanceConfig instanceConfig, String extraDependenciesDir) {
        LinkedList<String> args = new LinkedList<String>();
        if (instanceConfig.getFunctionDetails().getRuntime() != Function.FunctionDetails.Runtime.JAVA && instanceConfig.getFunctionDetails().getRuntime() == Function.FunctionDetails.Runtime.PYTHON && StringUtils.isNotEmpty((CharSequence)extraDependenciesDir)) {
            args.add("PYTHONPATH=${PYTHONPATH}:" + extraDependenciesDir);
        }
        return args;
    }

    public static List<String> getCmd(InstanceConfig instanceConfig, String instanceFile, String extraDependenciesDir, String logDirectory, String originalCodeFileName, String pulsarServiceUrl, String stateStorageServiceUrl, AuthenticationConfig authConfig, String shardId, Integer grpcPort, Long expectedHealthCheckInterval, String logConfigFile, String secretsProviderClassName, String secretsProviderConfig, Boolean installUserCodeDependencies, String pythonDependencyRepository, String pythonExtraDependencyRepository, int metricsPort) throws Exception {
        LinkedList<String> args = new LinkedList<String>();
        if (instanceConfig.getFunctionDetails().getRuntime() == Function.FunctionDetails.Runtime.JAVA) {
            Function.Resources resources;
            args.add("java");
            args.add("-cp");
            String classpath = instanceFile;
            if (StringUtils.isNotEmpty((CharSequence)extraDependenciesDir)) {
                classpath = classpath + ":" + extraDependenciesDir + "/*";
            }
            args.add(classpath);
            args.add(String.format("-D%s=%s", "pulsar.functions.java.instance.jar", instanceFile));
            if (StringUtils.isNotEmpty((CharSequence)extraDependenciesDir)) {
                args.add(String.format("-D%s=%s", FUNCTIONS_EXTRA_DEPS_PROPERTY, extraDependenciesDir));
            }
            args.add("-Dlog4j.configurationFile=" + logConfigFile);
            args.add("-Dpulsar.function.log.dir=" + RuntimeUtils.genFunctionLogFolder(logDirectory, instanceConfig));
            args.add("-Dpulsar.function.log.file=" + String.format("%s-%s", instanceConfig.getFunctionDetails().getName(), shardId));
            if (!StringUtils.isEmpty((CharSequence)instanceConfig.getFunctionDetails().getRuntimeFlags())) {
                args.add(instanceConfig.getFunctionDetails().getRuntimeFlags());
            }
            if (instanceConfig.getFunctionDetails().getResources() != null && (resources = instanceConfig.getFunctionDetails().getResources()).getRam() != 0L) {
                args.add("-Xmx" + String.valueOf(resources.getRam()));
            }
            args.add(JavaInstanceMain.class.getName());
            args.add("--jar");
            args.add(originalCodeFileName);
        } else if (instanceConfig.getFunctionDetails().getRuntime() == Function.FunctionDetails.Runtime.PYTHON) {
            args.add("python");
            if (!StringUtils.isEmpty((CharSequence)instanceConfig.getFunctionDetails().getRuntimeFlags())) {
                args.add(instanceConfig.getFunctionDetails().getRuntimeFlags());
            }
            args.add(instanceFile);
            args.add("--py");
            args.add(originalCodeFileName);
            args.add("--logging_directory");
            args.add(logDirectory);
            args.add("--logging_file");
            args.add(instanceConfig.getFunctionDetails().getName());
            args.add("--logging_config_file");
            args.add(logConfigFile);
            if (installUserCodeDependencies != null && installUserCodeDependencies.booleanValue()) {
                args.add("--install_usercode_dependencies");
                args.add("True");
            }
            if (!StringUtils.isEmpty((CharSequence)pythonDependencyRepository)) {
                args.add("--dependency_repository");
                args.add(pythonDependencyRepository);
            }
            if (!StringUtils.isEmpty((CharSequence)pythonExtraDependencyRepository)) {
                args.add("--extra_dependency_repository");
                args.add(pythonExtraDependencyRepository);
            }
        }
        args.add("--instance_id");
        args.add(shardId);
        args.add("--function_id");
        args.add(instanceConfig.getFunctionId());
        args.add("--function_version");
        args.add(instanceConfig.getFunctionVersion());
        args.add("--function_details");
        args.add("'" + JsonFormat.printer().omittingInsignificantWhitespace().print((MessageOrBuilder)instanceConfig.getFunctionDetails()) + "'");
        args.add("--pulsar_serviceurl");
        args.add(pulsarServiceUrl);
        if (authConfig != null) {
            if (StringUtils.isNotBlank((CharSequence)authConfig.getClientAuthenticationPlugin()) && StringUtils.isNotBlank((CharSequence)authConfig.getClientAuthenticationParameters())) {
                args.add("--client_auth_plugin");
                args.add(authConfig.getClientAuthenticationPlugin());
                args.add("--client_auth_params");
                args.add(authConfig.getClientAuthenticationParameters());
            }
            args.add("--use_tls");
            args.add(Boolean.toString(authConfig.isUseTls()));
            args.add("--tls_allow_insecure");
            args.add(Boolean.toString(authConfig.isTlsAllowInsecureConnection()));
            args.add("--hostname_verification_enabled");
            args.add(Boolean.toString(authConfig.isTlsHostnameVerificationEnable()));
            if (StringUtils.isNotBlank((CharSequence)authConfig.getTlsTrustCertsFilePath())) {
                args.add("--tls_trust_cert_path");
                args.add(authConfig.getTlsTrustCertsFilePath());
            }
        }
        args.add("--max_buffered_tuples");
        args.add(String.valueOf(instanceConfig.getMaxBufferedTuples()));
        args.add("--port");
        args.add(String.valueOf(grpcPort));
        args.add("--metrics_port");
        args.add(String.valueOf(metricsPort));
        if (null != stateStorageServiceUrl) {
            args.add("--state_storage_serviceurl");
            args.add(stateStorageServiceUrl);
        }
        args.add("--expected_healthcheck_interval");
        args.add(String.valueOf(expectedHealthCheckInterval));
        if (!StringUtils.isEmpty((CharSequence)secretsProviderClassName)) {
            args.add("--secrets_provider");
            args.add(secretsProviderClassName);
            if (!StringUtils.isEmpty((CharSequence)secretsProviderConfig)) {
                args.add("--secrets_provider_config");
                args.add("'" + secretsProviderConfig + "'");
            }
        }
        args.add("--cluster_name");
        args.add(instanceConfig.getClusterName());
        return args;
    }

    public static String genFunctionLogFolder(String logDirectory, InstanceConfig instanceConfig) {
        return String.format("%s/%s", logDirectory, FunctionDetailsUtils.getFullyQualifiedName((Function.FunctionDetails)instanceConfig.getFunctionDetails()));
    }

    public static String getPrometheusMetrics(int metricsPort) throws IOException {
        String line;
        StringBuilder result = new StringBuilder();
        URL url = new URL(String.format("http://%s:%s", InetAddress.getLocalHost().getHostAddress(), metricsPort));
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((line = rd.readLine()) != null) {
            result.append(line + System.lineSeparator());
        }
        rd.close();
        return result.toString();
    }
}

