/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime;

import com.google.common.annotations.VisibleForTesting;
import java.nio.file.Paths;
import org.apache.pulsar.functions.instance.AuthenticationConfig;
import org.apache.pulsar.functions.instance.InstanceConfig;
import org.apache.pulsar.functions.runtime.ProcessRuntime;
import org.apache.pulsar.functions.runtime.RuntimeFactory;
import org.apache.pulsar.functions.secretsproviderconfigurator.SecretsProviderConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessRuntimeFactory
implements RuntimeFactory {
    private static final Logger log = LoggerFactory.getLogger(ProcessRuntimeFactory.class);
    private final String pulsarServiceUrl;
    private final String stateStorageServiceUrl;
    private AuthenticationConfig authConfig;
    private SecretsProviderConfigurator secretsProviderConfigurator;
    private String javaInstanceJarFile;
    private String pythonInstanceFile;
    private String logDirectory;
    private String extraDependenciesDir;

    @VisibleForTesting
    public ProcessRuntimeFactory(String pulsarServiceUrl, String stateStorageServiceUrl, AuthenticationConfig authConfig, String javaInstanceJarFile, String pythonInstanceFile, String logDirectory, String extraDependenciesDir, SecretsProviderConfigurator secretsProviderConfigurator) {
        this.pulsarServiceUrl = pulsarServiceUrl;
        this.stateStorageServiceUrl = stateStorageServiceUrl;
        this.authConfig = authConfig;
        this.secretsProviderConfigurator = secretsProviderConfigurator;
        this.javaInstanceJarFile = javaInstanceJarFile;
        this.pythonInstanceFile = pythonInstanceFile;
        this.extraDependenciesDir = extraDependenciesDir;
        this.logDirectory = logDirectory;
        if (this.javaInstanceJarFile == null) {
            String envJavaInstanceJarLocation = System.getProperty("pulsar.functions.java.instance.jar");
            if (null != envJavaInstanceJarLocation) {
                log.info("Java instance jar location is not defined, using the location defined in system environment : {}", (Object)envJavaInstanceJarLocation);
                this.javaInstanceJarFile = envJavaInstanceJarLocation;
            } else {
                throw new RuntimeException("No JavaInstanceJar specified");
            }
        }
        if (this.pythonInstanceFile == null) {
            String envPythonInstanceLocation = System.getProperty("pulsar.functions.python.instance.file");
            if (null != envPythonInstanceLocation) {
                log.info("Python instance file location is not defined using the location defined in system environment : {}", (Object)envPythonInstanceLocation);
                this.pythonInstanceFile = envPythonInstanceLocation;
            } else {
                throw new RuntimeException("No PythonInstanceFile specified");
            }
        }
        if (this.logDirectory == null) {
            String envProcessContainerLogDirectory = System.getProperty("pulsar.functions.process.container.log.dir");
            this.logDirectory = null != envProcessContainerLogDirectory ? envProcessContainerLogDirectory : Paths.get("logs", new String[0]).toFile().getAbsolutePath();
        }
        this.logDirectory = this.logDirectory + "/functions";
        if (this.extraDependenciesDir == null) {
            String envProcessContainerExtraDependenciesDir = System.getProperty("pulsar.functions.extra.dependencies.dir");
            if (null != envProcessContainerExtraDependenciesDir) {
                log.info("Extra dependencies location is not defined using the location defined in system environment : {}", (Object)envProcessContainerExtraDependenciesDir);
                this.extraDependenciesDir = envProcessContainerExtraDependenciesDir;
            } else {
                log.info("No extra dependencies location is defined in either function worker config or system environment");
            }
        }
    }

    @Override
    public ProcessRuntime createContainer(InstanceConfig instanceConfig, String codeFile, String originalcodeFileName, Long expectedHealthCheckInterval) throws Exception {
        String instanceFile;
        switch (instanceConfig.getFunctionDetails().getRuntime()) {
            case JAVA: {
                instanceFile = this.javaInstanceJarFile;
                break;
            }
            case PYTHON: {
                instanceFile = this.pythonInstanceFile;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported Runtime " + instanceConfig.getFunctionDetails().getRuntime());
            }
        }
        return new ProcessRuntime(instanceConfig, instanceFile, this.extraDependenciesDir, this.logDirectory, codeFile, this.pulsarServiceUrl, this.stateStorageServiceUrl, this.authConfig, this.secretsProviderConfigurator, expectedHealthCheckInterval);
    }

    @Override
    public void close() {
    }
}

