/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.checksum;

import org.apache.pulsar.functions.runtime.shaded.com.scurrilous.circe.checksum.Crc32cIntChecksum;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBuf;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBufAllocator;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.checksum.DigestManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CRC32CDigestManager
extends DigestManager {
    private static final Logger log = LoggerFactory.getLogger(CRC32CDigestManager.class);

    public CRC32CDigestManager(long ledgerId, boolean useV2Protocol, ByteBufAllocator allocator) {
        super(ledgerId, useV2Protocol, allocator);
    }

    @Override
    int getMacCodeLength() {
        return 4;
    }

    @Override
    boolean isInt32Digest() {
        return true;
    }

    @Override
    void populateValueAndReset(int digest, ByteBuf buf) {
        buf.writeInt(digest);
    }

    @Override
    int update(int digest, ByteBuf data, int offset, int len) {
        return Crc32cIntChecksum.resumeChecksum(digest, data, offset, len);
    }
}

