/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.AbstractHierarchicalLedgerManager;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.LedgerManager;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.util.StringUtils;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.util.ZkUtils;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.AsyncCallback;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.KeeperException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LongHierarchicalLedgerManager
extends AbstractHierarchicalLedgerManager {
    static final Logger LOG = LoggerFactory.getLogger(LongHierarchicalLedgerManager.class);
    static final String IDGEN_ZNODE = "idgen-long";

    public LongHierarchicalLedgerManager(AbstractConfiguration conf, ZooKeeper zk) {
        super(conf, zk);
    }

    @Override
    public long getLedgerId(String pathName) throws IOException {
        if (!pathName.startsWith(this.ledgerRootPath)) {
            throw new IOException("it is not a valid hashed path name : " + pathName);
        }
        String hierarchicalPath = pathName.substring(this.ledgerRootPath.length() + 1);
        return StringUtils.stringToLongHierarchicalLedgerId(hierarchicalPath);
    }

    @Override
    public String getLedgerPath(long ledgerId) {
        return this.ledgerRootPath + StringUtils.getLongHierarchicalLedgerPath(ledgerId);
    }

    @Override
    public void asyncProcessLedgers(BookkeeperInternalCallbacks.Processor<Long> processor, AsyncCallback.VoidCallback finalCb, Object context, int successRc, int failureRc) {
        this.asyncProcessLevelNodes(this.ledgerRootPath, new RecursiveProcessor(0, this.ledgerRootPath, processor, context, successRc, failureRc), finalCb, context, successRc, failureRc);
    }

    @Override
    public LedgerManager.LedgerRangeIterator getLedgerRanges(long zkOpTimeoutMs) {
        return new LongHierarchicalLedgerRangeIterator(zkOpTimeoutMs);
    }

    @Override
    protected String getLedgerParentNodeRegex() {
        return "\\d{3}";
    }

    private class LongHierarchicalLedgerRangeIterator
    implements LedgerManager.LedgerRangeIterator {
        LedgerManager.LedgerRangeIterator rootIterator;
        final long zkOpTimeoutMs;

        List<String> getChildrenAt(String path) throws IOException {
            try {
                List<String> children = ZkUtils.getChildrenInSingleNode(LongHierarchicalLedgerManager.this.zk, path, this.zkOpTimeoutMs);
                Collections.sort(children);
                return children;
            }
            catch (KeeperException.NoNodeException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("NoNodeException at path {}, assumed race with deletion", (Object)path);
                }
                return new ArrayList<String>();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted while reading ledgers at path " + path, ie);
            }
        }

        private LongHierarchicalLedgerRangeIterator(long zkOpTimeoutMs) {
            this.zkOpTimeoutMs = zkOpTimeoutMs;
        }

        private void bootstrap() throws IOException {
            if (this.rootIterator == null) {
                this.rootIterator = new InnerIterator(LongHierarchicalLedgerManager.this.ledgerRootPath, 0);
            }
        }

        @Override
        public synchronized boolean hasNext() throws IOException {
            this.bootstrap();
            return this.rootIterator.hasNext();
        }

        @Override
        public synchronized LedgerManager.LedgerRange next() throws IOException {
            this.bootstrap();
            return this.rootIterator.next();
        }

        private class InnerIterator
        implements LedgerManager.LedgerRangeIterator {
            final String path;
            final int level;
            final Iterator<String> thisLevelIterator;
            LedgerManager.LedgerRangeIterator nextLevelIterator;

            InnerIterator(String path, int level) throws IOException {
                this.path = path;
                this.level = level;
                this.thisLevelIterator = LongHierarchicalLedgerRangeIterator.this.getChildrenAt(path).iterator();
                this.advance();
            }

            void advance() throws IOException {
                while (this.thisLevelIterator.hasNext()) {
                    LedgerManager.LedgerRangeIterator nextIterator;
                    String node = this.thisLevelIterator.next();
                    if (this.level == 0 && !LongHierarchicalLedgerManager.this.isLedgerParentNode(node) || !(nextIterator = this.level < 3 ? new InnerIterator(this.path + "/" + node, this.level + 1) : new LeafIterator(this.path + "/" + node)).hasNext()) continue;
                    this.nextLevelIterator = nextIterator;
                    break;
                }
            }

            @Override
            public boolean hasNext() throws IOException {
                return this.nextLevelIterator != null;
            }

            @Override
            public LedgerManager.LedgerRange next() throws IOException {
                LedgerManager.LedgerRange ret = this.nextLevelIterator.next();
                if (!this.nextLevelIterator.hasNext()) {
                    this.nextLevelIterator = null;
                    this.advance();
                }
                return ret;
            }
        }

        class LeafIterator
        implements LedgerManager.LedgerRangeIterator {
            LedgerManager.LedgerRange range;

            LeafIterator(String path) throws IOException {
                List<String> ledgerLeafNodes = LongHierarchicalLedgerRangeIterator.this.getChildrenAt(path);
                NavigableSet<Long> ledgerIds = LongHierarchicalLedgerManager.this.ledgerListToSet(ledgerLeafNodes, path);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("All active ledgers from ZK for hash node {}: {}", (Object)path, ledgerIds);
                }
                if (!ledgerIds.isEmpty()) {
                    this.range = new LedgerManager.LedgerRange(ledgerIds);
                }
            }

            @Override
            public boolean hasNext() throws IOException {
                return this.range != null;
            }

            @Override
            public LedgerManager.LedgerRange next() throws IOException {
                if (this.range == null) {
                    throw new NoSuchElementException("next() must only be called if hasNext() is true");
                }
                LedgerManager.LedgerRange ret = this.range;
                this.range = null;
                return ret;
            }
        }
    }

    private class RecursiveProcessor
    implements BookkeeperInternalCallbacks.Processor<String> {
        private final int level;
        private final String path;
        private final BookkeeperInternalCallbacks.Processor<Long> processor;
        private final Object context;
        private final int successRc;
        private final int failureRc;

        private RecursiveProcessor(int level, String path, BookkeeperInternalCallbacks.Processor<Long> processor, Object context, int successRc, int failureRc) {
            this.level = level;
            this.path = path;
            this.processor = processor;
            this.context = context;
            this.successRc = successRc;
            this.failureRc = failureRc;
        }

        @Override
        public void process(String lNode, AsyncCallback.VoidCallback cb) {
            String nodePath = this.path + "/" + lNode;
            if (this.level == 0 && !LongHierarchicalLedgerManager.this.isLedgerParentNode(lNode)) {
                cb.processResult(this.successRc, null, this.context);
                return;
            }
            if (this.level < 3) {
                LongHierarchicalLedgerManager.this.asyncProcessLevelNodes(nodePath, new RecursiveProcessor(this.level + 1, nodePath, this.processor, this.context, this.successRc, this.failureRc), cb, this.context, this.successRc, this.failureRc);
            } else {
                LongHierarchicalLedgerManager.this.asyncProcessLedgersInSingleNode(nodePath, this.processor, cb, this.context, this.successRc, this.failureRc);
            }
        }
    }
}

