/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.api.proto;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pulsar.common.api.proto.CompressionType;
import org.apache.pulsar.common.api.proto.EncryptionKeys;
import org.apache.pulsar.common.api.proto.KeyValue;
import org.apache.pulsar.common.api.proto.LightProtoCodec;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBuf;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.Unpooled;

public final class MessageMetadata {
    private String producerName;
    private int _producerNameBufferIdx = -1;
    private int _producerNameBufferLen = -1;
    private static final int _PRODUCER_NAME_FIELD_NUMBER = 1;
    private static final int _PRODUCER_NAME_TAG = 10;
    private static final int _PRODUCER_NAME_TAG_SIZE = LightProtoCodec.computeVarIntSize(10);
    private static final int _PRODUCER_NAME_MASK = 1;
    private long sequenceId;
    private static final int _SEQUENCE_ID_FIELD_NUMBER = 2;
    private static final int _SEQUENCE_ID_TAG = 16;
    private static final int _SEQUENCE_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(16);
    private static final int _SEQUENCE_ID_MASK = 2;
    private long publishTime;
    private static final int _PUBLISH_TIME_FIELD_NUMBER = 3;
    private static final int _PUBLISH_TIME_TAG = 24;
    private static final int _PUBLISH_TIME_TAG_SIZE = LightProtoCodec.computeVarIntSize(24);
    private static final int _PUBLISH_TIME_MASK = 4;
    private List<KeyValue> properties = null;
    private int _propertiesCount = 0;
    private static final int _PROPERTIES_FIELD_NUMBER = 4;
    private static final int _PROPERTIES_TAG = 34;
    private static final int _PROPERTIES_TAG_SIZE = LightProtoCodec.computeVarIntSize(34);
    private String replicatedFrom;
    private int _replicatedFromBufferIdx = -1;
    private int _replicatedFromBufferLen = -1;
    private static final int _REPLICATED_FROM_FIELD_NUMBER = 5;
    private static final int _REPLICATED_FROM_TAG = 42;
    private static final int _REPLICATED_FROM_TAG_SIZE = LightProtoCodec.computeVarIntSize(42);
    private static final int _REPLICATED_FROM_MASK = 16;
    private String partitionKey;
    private int _partitionKeyBufferIdx = -1;
    private int _partitionKeyBufferLen = -1;
    private static final int _PARTITION_KEY_FIELD_NUMBER = 6;
    private static final int _PARTITION_KEY_TAG = 50;
    private static final int _PARTITION_KEY_TAG_SIZE = LightProtoCodec.computeVarIntSize(50);
    private static final int _PARTITION_KEY_MASK = 32;
    private List<LightProtoCodec.StringHolder> replicateTos = null;
    private int _replicateTosCount = 0;
    private static final int _REPLICATE_TO_FIELD_NUMBER = 7;
    private static final int _REPLICATE_TO_TAG = 58;
    private static final int _REPLICATE_TO_TAG_SIZE = LightProtoCodec.computeVarIntSize(58);
    private CompressionType compression = CompressionType.NONE;
    private static final int _COMPRESSION_FIELD_NUMBER = 8;
    private static final int _COMPRESSION_TAG = 64;
    private static final int _COMPRESSION_TAG_SIZE = LightProtoCodec.computeVarIntSize(64);
    private static final int _COMPRESSION_MASK = 128;
    private int uncompressedSize = 0;
    private static final int _UNCOMPRESSED_SIZE_FIELD_NUMBER = 9;
    private static final int _UNCOMPRESSED_SIZE_TAG = 72;
    private static final int _UNCOMPRESSED_SIZE_TAG_SIZE = LightProtoCodec.computeVarIntSize(72);
    private static final int _UNCOMPRESSED_SIZE_MASK = 256;
    private int numMessagesInBatch = 1;
    private static final int _NUM_MESSAGES_IN_BATCH_FIELD_NUMBER = 11;
    private static final int _NUM_MESSAGES_IN_BATCH_TAG = 88;
    private static final int _NUM_MESSAGES_IN_BATCH_TAG_SIZE = LightProtoCodec.computeVarIntSize(88);
    private static final int _NUM_MESSAGES_IN_BATCH_MASK = 512;
    private long eventTime = 0L;
    private static final int _EVENT_TIME_FIELD_NUMBER = 12;
    private static final int _EVENT_TIME_TAG = 96;
    private static final int _EVENT_TIME_TAG_SIZE = LightProtoCodec.computeVarIntSize(96);
    private static final int _EVENT_TIME_MASK = 1024;
    private List<EncryptionKeys> encryptionKeys = null;
    private int _encryptionKeysCount = 0;
    private static final int _ENCRYPTION_KEYS_FIELD_NUMBER = 13;
    private static final int _ENCRYPTION_KEYS_TAG = 106;
    private static final int _ENCRYPTION_KEYS_TAG_SIZE = LightProtoCodec.computeVarIntSize(106);
    private String encryptionAlgo;
    private int _encryptionAlgoBufferIdx = -1;
    private int _encryptionAlgoBufferLen = -1;
    private static final int _ENCRYPTION_ALGO_FIELD_NUMBER = 14;
    private static final int _ENCRYPTION_ALGO_TAG = 114;
    private static final int _ENCRYPTION_ALGO_TAG_SIZE = LightProtoCodec.computeVarIntSize(114);
    private static final int _ENCRYPTION_ALGO_MASK = 4096;
    private ByteBuf encryptionParam = null;
    private int _encryptionParamIdx = -1;
    private int _encryptionParamLen = -1;
    private static final int _ENCRYPTION_PARAM_FIELD_NUMBER = 15;
    private static final int _ENCRYPTION_PARAM_TAG = 122;
    private static final int _ENCRYPTION_PARAM_TAG_SIZE = LightProtoCodec.computeVarIntSize(122);
    private static final int _ENCRYPTION_PARAM_MASK = 8192;
    private ByteBuf schemaVersion = null;
    private int _schemaVersionIdx = -1;
    private int _schemaVersionLen = -1;
    private static final int _SCHEMA_VERSION_FIELD_NUMBER = 16;
    private static final int _SCHEMA_VERSION_TAG = 130;
    private static final int _SCHEMA_VERSION_TAG_SIZE = LightProtoCodec.computeVarIntSize(130);
    private static final int _SCHEMA_VERSION_MASK = 16384;
    private boolean partitionKeyB64Encoded = false;
    private static final int _PARTITION_KEY_B64_ENCODED_FIELD_NUMBER = 17;
    private static final int _PARTITION_KEY_B64_ENCODED_TAG = 136;
    private static final int _PARTITION_KEY_B64_ENCODED_TAG_SIZE = LightProtoCodec.computeVarIntSize(136);
    private static final int _PARTITION_KEY_B64_ENCODED_MASK = 32768;
    private ByteBuf orderingKey = null;
    private int _orderingKeyIdx = -1;
    private int _orderingKeyLen = -1;
    private static final int _ORDERING_KEY_FIELD_NUMBER = 18;
    private static final int _ORDERING_KEY_TAG = 146;
    private static final int _ORDERING_KEY_TAG_SIZE = LightProtoCodec.computeVarIntSize(146);
    private static final int _ORDERING_KEY_MASK = 65536;
    private long deliverAtTime;
    private static final int _DELIVER_AT_TIME_FIELD_NUMBER = 19;
    private static final int _DELIVER_AT_TIME_TAG = 152;
    private static final int _DELIVER_AT_TIME_TAG_SIZE = LightProtoCodec.computeVarIntSize(152);
    private static final int _DELIVER_AT_TIME_MASK = 131072;
    private int markerType;
    private static final int _MARKER_TYPE_FIELD_NUMBER = 20;
    private static final int _MARKER_TYPE_TAG = 160;
    private static final int _MARKER_TYPE_TAG_SIZE = LightProtoCodec.computeVarIntSize(160);
    private static final int _MARKER_TYPE_MASK = 262144;
    private long txnidLeastBits;
    private static final int _TXNID_LEAST_BITS_FIELD_NUMBER = 22;
    private static final int _TXNID_LEAST_BITS_TAG = 176;
    private static final int _TXNID_LEAST_BITS_TAG_SIZE = LightProtoCodec.computeVarIntSize(176);
    private static final int _TXNID_LEAST_BITS_MASK = 524288;
    private long txnidMostBits;
    private static final int _TXNID_MOST_BITS_FIELD_NUMBER = 23;
    private static final int _TXNID_MOST_BITS_TAG = 184;
    private static final int _TXNID_MOST_BITS_TAG_SIZE = LightProtoCodec.computeVarIntSize(184);
    private static final int _TXNID_MOST_BITS_MASK = 0x100000;
    private long highestSequenceId = 0L;
    private static final int _HIGHEST_SEQUENCE_ID_FIELD_NUMBER = 24;
    private static final int _HIGHEST_SEQUENCE_ID_TAG = 192;
    private static final int _HIGHEST_SEQUENCE_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(192);
    private static final int _HIGHEST_SEQUENCE_ID_MASK = 0x200000;
    private boolean nullValue = false;
    private static final int _NULL_VALUE_FIELD_NUMBER = 25;
    private static final int _NULL_VALUE_TAG = 200;
    private static final int _NULL_VALUE_TAG_SIZE = LightProtoCodec.computeVarIntSize(200);
    private static final int _NULL_VALUE_MASK = 0x400000;
    private String uuid;
    private int _uuidBufferIdx = -1;
    private int _uuidBufferLen = -1;
    private static final int _UUID_FIELD_NUMBER = 26;
    private static final int _UUID_TAG = 210;
    private static final int _UUID_TAG_SIZE = LightProtoCodec.computeVarIntSize(210);
    private static final int _UUID_MASK = 0x800000;
    private int numChunksFromMsg;
    private static final int _NUM_CHUNKS_FROM_MSG_FIELD_NUMBER = 27;
    private static final int _NUM_CHUNKS_FROM_MSG_TAG = 216;
    private static final int _NUM_CHUNKS_FROM_MSG_TAG_SIZE = LightProtoCodec.computeVarIntSize(216);
    private static final int _NUM_CHUNKS_FROM_MSG_MASK = 0x1000000;
    private int totalChunkMsgSize;
    private static final int _TOTAL_CHUNK_MSG_SIZE_FIELD_NUMBER = 28;
    private static final int _TOTAL_CHUNK_MSG_SIZE_TAG = 224;
    private static final int _TOTAL_CHUNK_MSG_SIZE_TAG_SIZE = LightProtoCodec.computeVarIntSize(224);
    private static final int _TOTAL_CHUNK_MSG_SIZE_MASK = 0x2000000;
    private int chunkId;
    private static final int _CHUNK_ID_FIELD_NUMBER = 29;
    private static final int _CHUNK_ID_TAG = 232;
    private static final int _CHUNK_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(232);
    private static final int _CHUNK_ID_MASK = 0x4000000;
    private boolean nullPartitionKey = false;
    private static final int _NULL_PARTITION_KEY_FIELD_NUMBER = 30;
    private static final int _NULL_PARTITION_KEY_TAG = 240;
    private static final int _NULL_PARTITION_KEY_TAG_SIZE = LightProtoCodec.computeVarIntSize(240);
    private static final int _NULL_PARTITION_KEY_MASK = 0x8000000;
    private int _bitField0;
    private static final int _REQUIRED_FIELDS_MASK0 = 7;
    private int _cachedSize;
    private ByteBuf _parsedBuffer;

    public boolean hasProducerName() {
        return (this._bitField0 & 1) != 0;
    }

    public String getProducerName() {
        if (!this.hasProducerName()) {
            throw new IllegalStateException("Field 'producer_name' is not set");
        }
        if (this.producerName == null) {
            this.producerName = LightProtoCodec.readString(this._parsedBuffer, this._producerNameBufferIdx, this._producerNameBufferLen);
        }
        return this.producerName;
    }

    public MessageMetadata setProducerName(String producerName) {
        this.producerName = producerName;
        this._bitField0 |= 1;
        this._producerNameBufferIdx = -1;
        this._producerNameBufferLen = LightProtoCodec.computeStringUTF8Size(producerName);
        this._cachedSize = -1;
        return this;
    }

    public MessageMetadata clearProducerName() {
        this._bitField0 &= 0xFFFFFFFE;
        this.producerName = null;
        this._producerNameBufferIdx = -1;
        this._producerNameBufferLen = -1;
        return this;
    }

    public boolean hasSequenceId() {
        return (this._bitField0 & 2) != 0;
    }

    public long getSequenceId() {
        if (!this.hasSequenceId()) {
            throw new IllegalStateException("Field 'sequence_id' is not set");
        }
        return this.sequenceId;
    }

    public MessageMetadata setSequenceId(long sequenceId) {
        this.sequenceId = sequenceId;
        this._bitField0 |= 2;
        this._cachedSize = -1;
        return this;
    }

    public MessageMetadata clearSequenceId() {
        this._bitField0 &= 0xFFFFFFFD;
        return this;
    }

    public boolean hasPublishTime() {
        return (this._bitField0 & 4) != 0;
    }

    public long getPublishTime() {
        if (!this.hasPublishTime()) {
            throw new IllegalStateException("Field 'publish_time' is not set");
        }
        return this.publishTime;
    }

    public MessageMetadata setPublishTime(long publishTime) {
        this.publishTime = publishTime;
        this._bitField0 |= 4;
        this._cachedSize = -1;
        return this;
    }

    public MessageMetadata clearPublishTime() {
        this._bitField0 &= 0xFFFFFFFB;
        return this;
    }

    public int getPropertiesCount() {
        return this._propertiesCount;
    }

    public KeyValue getPropertyAt(int idx) {
        if (idx < 0 || idx >= this._propertiesCount) {
            throw new IndexOutOfBoundsException("Index " + idx + " is out of the list size (" + this._propertiesCount + ") for field 'properties'");
        }
        return this.properties.get(idx);
    }

    public List<KeyValue> getPropertiesList() {
        if (this._propertiesCount == 0) {
            return Collections.emptyList();
        }
        return this.properties.subList(0, this._propertiesCount);
    }

    public KeyValue addProperty() {
        if (this.properties == null) {
            this.properties = new ArrayList<KeyValue>();
        }
        if (this.properties.size() == this._propertiesCount) {
            this.properties.add(new KeyValue());
        }
        this._cachedSize = -1;
        return this.properties.get(this._propertiesCount++);
    }

    public MessageMetadata addAllProperties(Iterable<KeyValue> properties) {
        for (KeyValue _o : properties) {
            this.addProperty().copyFrom(_o);
        }
        return this;
    }

    public MessageMetadata clearProperties() {
        for (int i = 0; i < this._propertiesCount; ++i) {
            this.properties.get(i).clear();
        }
        this._propertiesCount = 0;
        return this;
    }

    public boolean hasReplicatedFrom() {
        return (this._bitField0 & 0x10) != 0;
    }

    public String getReplicatedFrom() {
        if (!this.hasReplicatedFrom()) {
            throw new IllegalStateException("Field 'replicated_from' is not set");
        }
        if (this.replicatedFrom == null) {
            this.replicatedFrom = LightProtoCodec.readString(this._parsedBuffer, this._replicatedFromBufferIdx, this._replicatedFromBufferLen);
        }
        return this.replicatedFrom;
    }

    public MessageMetadata setReplicatedFrom(String replicatedFrom) {
        this.replicatedFrom = replicatedFrom;
        this._bitField0 |= 0x10;
        this._replicatedFromBufferIdx = -1;
        this._replicatedFromBufferLen = LightProtoCodec.computeStringUTF8Size(replicatedFrom);
        this._cachedSize = -1;
        return this;
    }

    public MessageMetadata clearReplicatedFrom() {
        this._bitField0 &= 0xFFFFFFEF;
        this.replicatedFrom = null;
        this._replicatedFromBufferIdx = -1;
        this._replicatedFromBufferLen = -1;
        return this;
    }

    public boolean hasPartitionKey() {
        return (this._bitField0 & 0x20) != 0;
    }

    public String getPartitionKey() {
        if (!this.hasPartitionKey()) {
            throw new IllegalStateException("Field 'partition_key' is not set");
        }
        if (this.partitionKey == null) {
            this.partitionKey = LightProtoCodec.readString(this._parsedBuffer, this._partitionKeyBufferIdx, this._partitionKeyBufferLen);
        }
        return this.partitionKey;
    }

    public MessageMetadata setPartitionKey(String partitionKey) {
        this.partitionKey = partitionKey;
        this._bitField0 |= 0x20;
        this._partitionKeyBufferIdx = -1;
        this._partitionKeyBufferLen = LightProtoCodec.computeStringUTF8Size(partitionKey);
        this._cachedSize = -1;
        return this;
    }

    public MessageMetadata clearPartitionKey() {
        this._bitField0 &= 0xFFFFFFDF;
        this.partitionKey = null;
        this._partitionKeyBufferIdx = -1;
        this._partitionKeyBufferLen = -1;
        return this;
    }

    public int getReplicateTosCount() {
        return this._replicateTosCount;
    }

    public String getReplicateToAt(int idx) {
        if (idx < 0 || idx >= this._replicateTosCount) {
            throw new IndexOutOfBoundsException("Index " + idx + " is out of the list size (" + this._replicateTosCount + ") for field 'replicate_to'");
        }
        LightProtoCodec.StringHolder _sh = this.replicateTos.get(idx);
        if (_sh.s == null) {
            _sh.s = LightProtoCodec.readString(this._parsedBuffer, _sh.idx, _sh.len);
        }
        return _sh.s;
    }

    public List<String> getReplicateTosList() {
        if (this._replicateTosCount == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> _l = new ArrayList<String>();
        for (int i = 0; i < this._replicateTosCount; ++i) {
            _l.add(this.getReplicateToAt(i));
        }
        return _l;
    }

    public void addReplicateTo(String replicateTo) {
        if (this.replicateTos == null) {
            this.replicateTos = new ArrayList<LightProtoCodec.StringHolder>();
        }
        LightProtoCodec.StringHolder _sh = this._newReplicateToStringHolder();
        this._cachedSize = -1;
        _sh.s = replicateTo;
        _sh.idx = -1;
        _sh.len = LightProtoCodec.computeStringUTF8Size(_sh.s);
    }

    public MessageMetadata addAllReplicateTos(Iterable<String> replicateTos) {
        for (String _s : replicateTos) {
            this.addReplicateTo(_s);
        }
        return this;
    }

    private LightProtoCodec.StringHolder _newReplicateToStringHolder() {
        LightProtoCodec.StringHolder _sh;
        if (this.replicateTos == null) {
            this.replicateTos = new ArrayList<LightProtoCodec.StringHolder>();
        }
        if (this.replicateTos.size() == this._replicateTosCount) {
            _sh = new LightProtoCodec.StringHolder();
            this.replicateTos.add(_sh);
        } else {
            _sh = this.replicateTos.get(this._replicateTosCount);
        }
        ++this._replicateTosCount;
        return _sh;
    }

    public MessageMetadata clearReplicateTo() {
        for (int i = 0; i < this._replicateTosCount; ++i) {
            LightProtoCodec.StringHolder _sh = this.replicateTos.get(i);
            _sh.s = null;
            _sh.idx = -1;
            _sh.len = -1;
        }
        this._replicateTosCount = 0;
        return this;
    }

    public boolean hasCompression() {
        return (this._bitField0 & 0x80) != 0;
    }

    public CompressionType getCompression() {
        return this.compression;
    }

    public MessageMetadata setCompression(CompressionType compression) {
        this.compression = compression;
        this._bitField0 |= 0x80;
        this._cachedSize = -1;
        return this;
    }

    public MessageMetadata clearCompression() {
        this._bitField0 &= 0xFFFFFF7F;
        this.compression = CompressionType.NONE;
        return this;
    }

    public boolean hasUncompressedSize() {
        return (this._bitField0 & 0x100) != 0;
    }

    public int getUncompressedSize() {
        return this.uncompressedSize;
    }

    public MessageMetadata setUncompressedSize(int uncompressedSize) {
        this.uncompressedSize = uncompressedSize;
        this._bitField0 |= 0x100;
        this._cachedSize = -1;
        return this;
    }

    public MessageMetadata clearUncompressedSize() {
        this._bitField0 &= 0xFFFFFEFF;
        this.uncompressedSize = 0;
        return this;
    }

    public boolean hasNumMessagesInBatch() {
        return (this._bitField0 & 0x200) != 0;
    }

    public int getNumMessagesInBatch() {
        return this.numMessagesInBatch;
    }

    public MessageMetadata setNumMessagesInBatch(int numMessagesInBatch) {
        this.numMessagesInBatch = numMessagesInBatch;
        this._bitField0 |= 0x200;
        this._cachedSize = -1;
        return this;
    }

    public MessageMetadata clearNumMessagesInBatch() {
        this._bitField0 &= 0xFFFFFDFF;
        this.numMessagesInBatch = 1;
        return this;
    }

    public boolean hasEventTime() {
        return (this._bitField0 & 0x400) != 0;
    }

    public long getEventTime() {
        return this.eventTime;
    }

    public MessageMetadata setEventTime(long eventTime) {
        this.eventTime = eventTime;
        this._bitField0 |= 0x400;
        this._cachedSize = -1;
        return this;
    }

    public MessageMetadata clearEventTime() {
        this._bitField0 &= 0xFFFFFBFF;
        this.eventTime = 0L;
        return this;
    }

    public int getEncryptionKeysCount() {
        return this._encryptionKeysCount;
    }

    public EncryptionKeys getEncryptionKeyAt(int idx) {
        if (idx < 0 || idx >= this._encryptionKeysCount) {
            throw new IndexOutOfBoundsException("Index " + idx + " is out of the list size (" + this._encryptionKeysCount + ") for field 'encryption_keys'");
        }
        return this.encryptionKeys.get(idx);
    }

    public List<EncryptionKeys> getEncryptionKeysList() {
        if (this._encryptionKeysCount == 0) {
            return Collections.emptyList();
        }
        return this.encryptionKeys.subList(0, this._encryptionKeysCount);
    }

    public EncryptionKeys addEncryptionKey() {
        if (this.encryptionKeys == null) {
            this.encryptionKeys = new ArrayList<EncryptionKeys>();
        }
        if (this.encryptionKeys.size() == this._encryptionKeysCount) {
            this.encryptionKeys.add(new EncryptionKeys());
        }
        this._cachedSize = -1;
        return this.encryptionKeys.get(this._encryptionKeysCount++);
    }

    public MessageMetadata addAllEncryptionKeys(Iterable<EncryptionKeys> encryptionKeys) {
        for (EncryptionKeys _o : encryptionKeys) {
            this.addEncryptionKey().copyFrom(_o);
        }
        return this;
    }

    public MessageMetadata clearEncryptionKeys() {
        for (int i = 0; i < this._encryptionKeysCount; ++i) {
            this.encryptionKeys.get(i).clear();
        }
        this._encryptionKeysCount = 0;
        return this;
    }

    public boolean hasEncryptionAlgo() {
        return (this._bitField0 & 0x1000) != 0;
    }

    public String getEncryptionAlgo() {
        if (!this.hasEncryptionAlgo()) {
            throw new IllegalStateException("Field 'encryption_algo' is not set");
        }
        if (this.encryptionAlgo == null) {
            this.encryptionAlgo = LightProtoCodec.readString(this._parsedBuffer, this._encryptionAlgoBufferIdx, this._encryptionAlgoBufferLen);
        }
        return this.encryptionAlgo;
    }

    public MessageMetadata setEncryptionAlgo(String encryptionAlgo) {
        this.encryptionAlgo = encryptionAlgo;
        this._bitField0 |= 0x1000;
        this._encryptionAlgoBufferIdx = -1;
        this._encryptionAlgoBufferLen = LightProtoCodec.computeStringUTF8Size(encryptionAlgo);
        this._cachedSize = -1;
        return this;
    }

    public MessageMetadata clearEncryptionAlgo() {
        this._bitField0 &= 0xFFFFEFFF;
        this.encryptionAlgo = null;
        this._encryptionAlgoBufferIdx = -1;
        this._encryptionAlgoBufferLen = -1;
        return this;
    }

    public boolean hasEncryptionParam() {
        return (this._bitField0 & 0x2000) != 0;
    }

    public int getEncryptionParamSize() {
        if (!this.hasEncryptionParam()) {
            throw new IllegalStateException("Field 'encryption_param' is not set");
        }
        return this._encryptionParamLen;
    }

    public byte[] getEncryptionParam() {
        ByteBuf _b = this.getEncryptionParamSlice();
        byte[] res = new byte[_b.readableBytes()];
        _b.getBytes(0, res);
        return res;
    }

    public ByteBuf getEncryptionParamSlice() {
        if (!this.hasEncryptionParam()) {
            throw new IllegalStateException("Field 'encryption_param' is not set");
        }
        if (this.encryptionParam == null) {
            return this._parsedBuffer.slice(this._encryptionParamIdx, this._encryptionParamLen);
        }
        return this.encryptionParam.slice(0, this._encryptionParamLen);
    }

    public MessageMetadata setEncryptionParam(byte[] encryptionParam) {
        this.setEncryptionParam(Unpooled.wrappedBuffer(encryptionParam));
        return this;
    }

    public MessageMetadata setEncryptionParam(ByteBuf encryptionParam) {
        this.encryptionParam = encryptionParam;
        this._bitField0 |= 0x2000;
        this._encryptionParamIdx = -1;
        this._encryptionParamLen = encryptionParam.readableBytes();
        this._cachedSize = -1;
        return this;
    }

    public MessageMetadata clearEncryptionParam() {
        this._bitField0 &= 0xFFFFDFFF;
        this.encryptionParam = null;
        this._encryptionParamIdx = -1;
        this._encryptionParamLen = -1;
        return this;
    }

    public boolean hasSchemaVersion() {
        return (this._bitField0 & 0x4000) != 0;
    }

    public int getSchemaVersionSize() {
        if (!this.hasSchemaVersion()) {
            throw new IllegalStateException("Field 'schema_version' is not set");
        }
        return this._schemaVersionLen;
    }

    public byte[] getSchemaVersion() {
        ByteBuf _b = this.getSchemaVersionSlice();
        byte[] res = new byte[_b.readableBytes()];
        _b.getBytes(0, res);
        return res;
    }

    public ByteBuf getSchemaVersionSlice() {
        if (!this.hasSchemaVersion()) {
            throw new IllegalStateException("Field 'schema_version' is not set");
        }
        if (this.schemaVersion == null) {
            return this._parsedBuffer.slice(this._schemaVersionIdx, this._schemaVersionLen);
        }
        return this.schemaVersion.slice(0, this._schemaVersionLen);
    }

    public MessageMetadata setSchemaVersion(byte[] schemaVersion) {
        this.setSchemaVersion(Unpooled.wrappedBuffer(schemaVersion));
        return this;
    }

    public MessageMetadata setSchemaVersion(ByteBuf schemaVersion) {
        this.schemaVersion = schemaVersion;
        this._bitField0 |= 0x4000;
        this._schemaVersionIdx = -1;
        this._schemaVersionLen = schemaVersion.readableBytes();
        this._cachedSize = -1;
        return this;
    }

    public MessageMetadata clearSchemaVersion() {
        this._bitField0 &= 0xFFFFBFFF;
        this.schemaVersion = null;
        this._schemaVersionIdx = -1;
        this._schemaVersionLen = -1;
        return this;
    }

    public boolean hasPartitionKeyB64Encoded() {
        return (this._bitField0 & 0x8000) != 0;
    }

    public boolean isPartitionKeyB64Encoded() {
        return this.partitionKeyB64Encoded;
    }

    public MessageMetadata setPartitionKeyB64Encoded(boolean partitionKeyB64Encoded) {
        this.partitionKeyB64Encoded = partitionKeyB64Encoded;
        this._bitField0 |= 0x8000;
        this._cachedSize = -1;
        return this;
    }

    public MessageMetadata clearPartitionKeyB64Encoded() {
        this._bitField0 &= 0xFFFF7FFF;
        this.partitionKeyB64Encoded = false;
        return this;
    }

    public boolean hasOrderingKey() {
        return (this._bitField0 & 0x10000) != 0;
    }

    public int getOrderingKeySize() {
        if (!this.hasOrderingKey()) {
            throw new IllegalStateException("Field 'ordering_key' is not set");
        }
        return this._orderingKeyLen;
    }

    public byte[] getOrderingKey() {
        ByteBuf _b = this.getOrderingKeySlice();
        byte[] res = new byte[_b.readableBytes()];
        _b.getBytes(0, res);
        return res;
    }

    public ByteBuf getOrderingKeySlice() {
        if (!this.hasOrderingKey()) {
            throw new IllegalStateException("Field 'ordering_key' is not set");
        }
        if (this.orderingKey == null) {
            return this._parsedBuffer.slice(this._orderingKeyIdx, this._orderingKeyLen);
        }
        return this.orderingKey.slice(0, this._orderingKeyLen);
    }

    public MessageMetadata setOrderingKey(byte[] orderingKey) {
        this.setOrderingKey(Unpooled.wrappedBuffer(orderingKey));
        return this;
    }

    public MessageMetadata setOrderingKey(ByteBuf orderingKey) {
        this.orderingKey = orderingKey;
        this._bitField0 |= 0x10000;
        this._orderingKeyIdx = -1;
        this._orderingKeyLen = orderingKey.readableBytes();
        this._cachedSize = -1;
        return this;
    }

    public MessageMetadata clearOrderingKey() {
        this._bitField0 &= 0xFFFEFFFF;
        this.orderingKey = null;
        this._orderingKeyIdx = -1;
        this._orderingKeyLen = -1;
        return this;
    }

    public boolean hasDeliverAtTime() {
        return (this._bitField0 & 0x20000) != 0;
    }

    public long getDeliverAtTime() {
        if (!this.hasDeliverAtTime()) {
            throw new IllegalStateException("Field 'deliver_at_time' is not set");
        }
        return this.deliverAtTime;
    }

    public MessageMetadata setDeliverAtTime(long deliverAtTime) {
        this.deliverAtTime = deliverAtTime;
        this._bitField0 |= 0x20000;
        this._cachedSize = -1;
        return this;
    }

    public MessageMetadata clearDeliverAtTime() {
        this._bitField0 &= 0xFFFDFFFF;
        return this;
    }

    public boolean hasMarkerType() {
        return (this._bitField0 & 0x40000) != 0;
    }

    public int getMarkerType() {
        if (!this.hasMarkerType()) {
            throw new IllegalStateException("Field 'marker_type' is not set");
        }
        return this.markerType;
    }

    public MessageMetadata setMarkerType(int markerType) {
        this.markerType = markerType;
        this._bitField0 |= 0x40000;
        this._cachedSize = -1;
        return this;
    }

    public MessageMetadata clearMarkerType() {
        this._bitField0 &= 0xFFFBFFFF;
        return this;
    }

    public boolean hasTxnidLeastBits() {
        return (this._bitField0 & 0x80000) != 0;
    }

    public long getTxnidLeastBits() {
        if (!this.hasTxnidLeastBits()) {
            throw new IllegalStateException("Field 'txnid_least_bits' is not set");
        }
        return this.txnidLeastBits;
    }

    public MessageMetadata setTxnidLeastBits(long txnidLeastBits) {
        this.txnidLeastBits = txnidLeastBits;
        this._bitField0 |= 0x80000;
        this._cachedSize = -1;
        return this;
    }

    public MessageMetadata clearTxnidLeastBits() {
        this._bitField0 &= 0xFFF7FFFF;
        return this;
    }

    public boolean hasTxnidMostBits() {
        return (this._bitField0 & 0x100000) != 0;
    }

    public long getTxnidMostBits() {
        if (!this.hasTxnidMostBits()) {
            throw new IllegalStateException("Field 'txnid_most_bits' is not set");
        }
        return this.txnidMostBits;
    }

    public MessageMetadata setTxnidMostBits(long txnidMostBits) {
        this.txnidMostBits = txnidMostBits;
        this._bitField0 |= 0x100000;
        this._cachedSize = -1;
        return this;
    }

    public MessageMetadata clearTxnidMostBits() {
        this._bitField0 &= 0xFFEFFFFF;
        return this;
    }

    public boolean hasHighestSequenceId() {
        return (this._bitField0 & 0x200000) != 0;
    }

    public long getHighestSequenceId() {
        return this.highestSequenceId;
    }

    public MessageMetadata setHighestSequenceId(long highestSequenceId) {
        this.highestSequenceId = highestSequenceId;
        this._bitField0 |= 0x200000;
        this._cachedSize = -1;
        return this;
    }

    public MessageMetadata clearHighestSequenceId() {
        this._bitField0 &= 0xFFDFFFFF;
        this.highestSequenceId = 0L;
        return this;
    }

    public boolean hasNullValue() {
        return (this._bitField0 & 0x400000) != 0;
    }

    public boolean isNullValue() {
        return this.nullValue;
    }

    public MessageMetadata setNullValue(boolean nullValue) {
        this.nullValue = nullValue;
        this._bitField0 |= 0x400000;
        this._cachedSize = -1;
        return this;
    }

    public MessageMetadata clearNullValue() {
        this._bitField0 &= 0xFFBFFFFF;
        this.nullValue = false;
        return this;
    }

    public boolean hasUuid() {
        return (this._bitField0 & 0x800000) != 0;
    }

    public String getUuid() {
        if (!this.hasUuid()) {
            throw new IllegalStateException("Field 'uuid' is not set");
        }
        if (this.uuid == null) {
            this.uuid = LightProtoCodec.readString(this._parsedBuffer, this._uuidBufferIdx, this._uuidBufferLen);
        }
        return this.uuid;
    }

    public MessageMetadata setUuid(String uuid) {
        this.uuid = uuid;
        this._bitField0 |= 0x800000;
        this._uuidBufferIdx = -1;
        this._uuidBufferLen = LightProtoCodec.computeStringUTF8Size(uuid);
        this._cachedSize = -1;
        return this;
    }

    public MessageMetadata clearUuid() {
        this._bitField0 &= 0xFF7FFFFF;
        this.uuid = null;
        this._uuidBufferIdx = -1;
        this._uuidBufferLen = -1;
        return this;
    }

    public boolean hasNumChunksFromMsg() {
        return (this._bitField0 & 0x1000000) != 0;
    }

    public int getNumChunksFromMsg() {
        if (!this.hasNumChunksFromMsg()) {
            throw new IllegalStateException("Field 'num_chunks_from_msg' is not set");
        }
        return this.numChunksFromMsg;
    }

    public MessageMetadata setNumChunksFromMsg(int numChunksFromMsg) {
        this.numChunksFromMsg = numChunksFromMsg;
        this._bitField0 |= 0x1000000;
        this._cachedSize = -1;
        return this;
    }

    public MessageMetadata clearNumChunksFromMsg() {
        this._bitField0 &= 0xFEFFFFFF;
        return this;
    }

    public boolean hasTotalChunkMsgSize() {
        return (this._bitField0 & 0x2000000) != 0;
    }

    public int getTotalChunkMsgSize() {
        if (!this.hasTotalChunkMsgSize()) {
            throw new IllegalStateException("Field 'total_chunk_msg_size' is not set");
        }
        return this.totalChunkMsgSize;
    }

    public MessageMetadata setTotalChunkMsgSize(int totalChunkMsgSize) {
        this.totalChunkMsgSize = totalChunkMsgSize;
        this._bitField0 |= 0x2000000;
        this._cachedSize = -1;
        return this;
    }

    public MessageMetadata clearTotalChunkMsgSize() {
        this._bitField0 &= 0xFDFFFFFF;
        return this;
    }

    public boolean hasChunkId() {
        return (this._bitField0 & 0x4000000) != 0;
    }

    public int getChunkId() {
        if (!this.hasChunkId()) {
            throw new IllegalStateException("Field 'chunk_id' is not set");
        }
        return this.chunkId;
    }

    public MessageMetadata setChunkId(int chunkId) {
        this.chunkId = chunkId;
        this._bitField0 |= 0x4000000;
        this._cachedSize = -1;
        return this;
    }

    public MessageMetadata clearChunkId() {
        this._bitField0 &= 0xFBFFFFFF;
        return this;
    }

    public boolean hasNullPartitionKey() {
        return (this._bitField0 & 0x8000000) != 0;
    }

    public boolean isNullPartitionKey() {
        return this.nullPartitionKey;
    }

    public MessageMetadata setNullPartitionKey(boolean nullPartitionKey) {
        this.nullPartitionKey = nullPartitionKey;
        this._bitField0 |= 0x8000000;
        this._cachedSize = -1;
        return this;
    }

    public MessageMetadata clearNullPartitionKey() {
        this._bitField0 &= 0xF7FFFFFF;
        this.nullPartitionKey = false;
        return this;
    }

    public int writeTo(ByteBuf _b) {
        Object _item;
        int i;
        this.checkRequiredFields();
        int _writeIdx = _b.writerIndex();
        LightProtoCodec.writeVarInt(_b, 10);
        LightProtoCodec.writeVarInt(_b, this._producerNameBufferLen);
        if (this._producerNameBufferIdx == -1) {
            LightProtoCodec.writeString(_b, this.producerName, this._producerNameBufferLen);
        } else {
            this._parsedBuffer.getBytes(this._producerNameBufferIdx, _b, this._producerNameBufferLen);
        }
        LightProtoCodec.writeVarInt(_b, 16);
        LightProtoCodec.writeVarInt64(_b, this.sequenceId);
        LightProtoCodec.writeVarInt(_b, 24);
        LightProtoCodec.writeVarInt64(_b, this.publishTime);
        for (i = 0; i < this._propertiesCount; ++i) {
            _item = this.properties.get(i);
            LightProtoCodec.writeVarInt(_b, 34);
            LightProtoCodec.writeVarInt(_b, ((KeyValue)_item).getSerializedSize());
            ((KeyValue)_item).writeTo(_b);
        }
        if (this.hasReplicatedFrom()) {
            LightProtoCodec.writeVarInt(_b, 42);
            LightProtoCodec.writeVarInt(_b, this._replicatedFromBufferLen);
            if (this._replicatedFromBufferIdx == -1) {
                LightProtoCodec.writeString(_b, this.replicatedFrom, this._replicatedFromBufferLen);
            } else {
                this._parsedBuffer.getBytes(this._replicatedFromBufferIdx, _b, this._replicatedFromBufferLen);
            }
        }
        if (this.hasPartitionKey()) {
            LightProtoCodec.writeVarInt(_b, 50);
            LightProtoCodec.writeVarInt(_b, this._partitionKeyBufferLen);
            if (this._partitionKeyBufferIdx == -1) {
                LightProtoCodec.writeString(_b, this.partitionKey, this._partitionKeyBufferLen);
            } else {
                this._parsedBuffer.getBytes(this._partitionKeyBufferIdx, _b, this._partitionKeyBufferLen);
            }
        }
        for (i = 0; i < this._replicateTosCount; ++i) {
            LightProtoCodec.StringHolder _sh = this.replicateTos.get(i);
            LightProtoCodec.writeVarInt(_b, 58);
            LightProtoCodec.writeVarInt(_b, _sh.len);
            if (_sh.idx == -1) {
                LightProtoCodec.writeString(_b, _sh.s, _sh.len);
                continue;
            }
            this._parsedBuffer.getBytes(_sh.idx, _b, _sh.len);
        }
        if (this.hasCompression()) {
            LightProtoCodec.writeVarInt(_b, 64);
            LightProtoCodec.writeVarInt(_b, this.compression.getValue());
        }
        if (this.hasUncompressedSize()) {
            LightProtoCodec.writeVarInt(_b, 72);
            LightProtoCodec.writeVarInt(_b, this.uncompressedSize);
        }
        if (this.hasNumMessagesInBatch()) {
            LightProtoCodec.writeVarInt(_b, 88);
            LightProtoCodec.writeVarInt(_b, this.numMessagesInBatch);
        }
        if (this.hasEventTime()) {
            LightProtoCodec.writeVarInt(_b, 96);
            LightProtoCodec.writeVarInt64(_b, this.eventTime);
        }
        for (i = 0; i < this._encryptionKeysCount; ++i) {
            _item = this.encryptionKeys.get(i);
            LightProtoCodec.writeVarInt(_b, 106);
            LightProtoCodec.writeVarInt(_b, ((EncryptionKeys)_item).getSerializedSize());
            ((EncryptionKeys)_item).writeTo(_b);
        }
        if (this.hasEncryptionAlgo()) {
            LightProtoCodec.writeVarInt(_b, 114);
            LightProtoCodec.writeVarInt(_b, this._encryptionAlgoBufferLen);
            if (this._encryptionAlgoBufferIdx == -1) {
                LightProtoCodec.writeString(_b, this.encryptionAlgo, this._encryptionAlgoBufferLen);
            } else {
                this._parsedBuffer.getBytes(this._encryptionAlgoBufferIdx, _b, this._encryptionAlgoBufferLen);
            }
        }
        if (this.hasEncryptionParam()) {
            LightProtoCodec.writeVarInt(_b, 122);
            LightProtoCodec.writeVarInt(_b, this._encryptionParamLen);
            if (this._encryptionParamIdx == -1) {
                _b.writeBytes(this.encryptionParam);
            } else {
                this._parsedBuffer.getBytes(this._encryptionParamIdx, _b, this._encryptionParamLen);
            }
        }
        if (this.hasSchemaVersion()) {
            LightProtoCodec.writeVarInt(_b, 130);
            LightProtoCodec.writeVarInt(_b, this._schemaVersionLen);
            if (this._schemaVersionIdx == -1) {
                _b.writeBytes(this.schemaVersion);
            } else {
                this._parsedBuffer.getBytes(this._schemaVersionIdx, _b, this._schemaVersionLen);
            }
        }
        if (this.hasPartitionKeyB64Encoded()) {
            LightProtoCodec.writeVarInt(_b, 136);
            _b.writeBoolean(this.partitionKeyB64Encoded);
        }
        if (this.hasOrderingKey()) {
            LightProtoCodec.writeVarInt(_b, 146);
            LightProtoCodec.writeVarInt(_b, this._orderingKeyLen);
            if (this._orderingKeyIdx == -1) {
                _b.writeBytes(this.orderingKey);
            } else {
                this._parsedBuffer.getBytes(this._orderingKeyIdx, _b, this._orderingKeyLen);
            }
        }
        if (this.hasDeliverAtTime()) {
            LightProtoCodec.writeVarInt(_b, 152);
            LightProtoCodec.writeVarInt64(_b, this.deliverAtTime);
        }
        if (this.hasMarkerType()) {
            LightProtoCodec.writeVarInt(_b, 160);
            LightProtoCodec.writeVarInt(_b, this.markerType);
        }
        if (this.hasTxnidLeastBits()) {
            LightProtoCodec.writeVarInt(_b, 176);
            LightProtoCodec.writeVarInt64(_b, this.txnidLeastBits);
        }
        if (this.hasTxnidMostBits()) {
            LightProtoCodec.writeVarInt(_b, 184);
            LightProtoCodec.writeVarInt64(_b, this.txnidMostBits);
        }
        if (this.hasHighestSequenceId()) {
            LightProtoCodec.writeVarInt(_b, 192);
            LightProtoCodec.writeVarInt64(_b, this.highestSequenceId);
        }
        if (this.hasNullValue()) {
            LightProtoCodec.writeVarInt(_b, 200);
            _b.writeBoolean(this.nullValue);
        }
        if (this.hasUuid()) {
            LightProtoCodec.writeVarInt(_b, 210);
            LightProtoCodec.writeVarInt(_b, this._uuidBufferLen);
            if (this._uuidBufferIdx == -1) {
                LightProtoCodec.writeString(_b, this.uuid, this._uuidBufferLen);
            } else {
                this._parsedBuffer.getBytes(this._uuidBufferIdx, _b, this._uuidBufferLen);
            }
        }
        if (this.hasNumChunksFromMsg()) {
            LightProtoCodec.writeVarInt(_b, 216);
            LightProtoCodec.writeVarInt(_b, this.numChunksFromMsg);
        }
        if (this.hasTotalChunkMsgSize()) {
            LightProtoCodec.writeVarInt(_b, 224);
            LightProtoCodec.writeVarInt(_b, this.totalChunkMsgSize);
        }
        if (this.hasChunkId()) {
            LightProtoCodec.writeVarInt(_b, 232);
            LightProtoCodec.writeVarInt(_b, this.chunkId);
        }
        if (this.hasNullPartitionKey()) {
            LightProtoCodec.writeVarInt(_b, 240);
            _b.writeBoolean(this.nullPartitionKey);
        }
        return _b.writerIndex() - _writeIdx;
    }

    public int getSerializedSize() {
        Object _item;
        int i;
        if (this._cachedSize > -1) {
            return this._cachedSize;
        }
        int _size = 0;
        _size += _PRODUCER_NAME_TAG_SIZE;
        _size += LightProtoCodec.computeVarIntSize(this._producerNameBufferLen);
        _size += this._producerNameBufferLen;
        _size += _SEQUENCE_ID_TAG_SIZE;
        _size += LightProtoCodec.computeVarInt64Size(this.sequenceId);
        _size += _PUBLISH_TIME_TAG_SIZE;
        _size += LightProtoCodec.computeVarInt64Size(this.publishTime);
        for (i = 0; i < this._propertiesCount; ++i) {
            _item = this.properties.get(i);
            _size += _PROPERTIES_TAG_SIZE;
            int MsgsizeProperties = ((KeyValue)_item).getSerializedSize();
            _size += LightProtoCodec.computeVarIntSize(MsgsizeProperties) + MsgsizeProperties;
        }
        if (this.hasReplicatedFrom()) {
            _size += _REPLICATED_FROM_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this._replicatedFromBufferLen);
            _size += this._replicatedFromBufferLen;
        }
        if (this.hasPartitionKey()) {
            _size += _PARTITION_KEY_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this._partitionKeyBufferLen);
            _size += this._partitionKeyBufferLen;
        }
        for (i = 0; i < this._replicateTosCount; ++i) {
            LightProtoCodec.StringHolder _sh = this.replicateTos.get(i);
            _size += _REPLICATE_TO_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(_sh.len) + _sh.len;
        }
        if (this.hasCompression()) {
            _size += _COMPRESSION_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this.compression.getValue());
        }
        if (this.hasUncompressedSize()) {
            _size += _UNCOMPRESSED_SIZE_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this.uncompressedSize);
        }
        if (this.hasNumMessagesInBatch()) {
            _size += _NUM_MESSAGES_IN_BATCH_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this.numMessagesInBatch);
        }
        if (this.hasEventTime()) {
            _size += _EVENT_TIME_TAG_SIZE;
            _size += LightProtoCodec.computeVarInt64Size(this.eventTime);
        }
        for (i = 0; i < this._encryptionKeysCount; ++i) {
            _item = this.encryptionKeys.get(i);
            _size += _ENCRYPTION_KEYS_TAG_SIZE;
            int MsgsizeEncryptionKeys = ((EncryptionKeys)_item).getSerializedSize();
            _size += LightProtoCodec.computeVarIntSize(MsgsizeEncryptionKeys) + MsgsizeEncryptionKeys;
        }
        if (this.hasEncryptionAlgo()) {
            _size += _ENCRYPTION_ALGO_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this._encryptionAlgoBufferLen);
            _size += this._encryptionAlgoBufferLen;
        }
        if (this.hasEncryptionParam()) {
            _size += _ENCRYPTION_PARAM_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this._encryptionParamLen) + this._encryptionParamLen;
        }
        if (this.hasSchemaVersion()) {
            _size += _SCHEMA_VERSION_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this._schemaVersionLen) + this._schemaVersionLen;
        }
        if (this.hasPartitionKeyB64Encoded()) {
            _size += _PARTITION_KEY_B64_ENCODED_TAG_SIZE;
            ++_size;
        }
        if (this.hasOrderingKey()) {
            _size += _ORDERING_KEY_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this._orderingKeyLen) + this._orderingKeyLen;
        }
        if (this.hasDeliverAtTime()) {
            _size += _DELIVER_AT_TIME_TAG_SIZE;
            _size += LightProtoCodec.computeVarInt64Size(this.deliverAtTime);
        }
        if (this.hasMarkerType()) {
            _size += _MARKER_TYPE_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this.markerType);
        }
        if (this.hasTxnidLeastBits()) {
            _size += _TXNID_LEAST_BITS_TAG_SIZE;
            _size += LightProtoCodec.computeVarInt64Size(this.txnidLeastBits);
        }
        if (this.hasTxnidMostBits()) {
            _size += _TXNID_MOST_BITS_TAG_SIZE;
            _size += LightProtoCodec.computeVarInt64Size(this.txnidMostBits);
        }
        if (this.hasHighestSequenceId()) {
            _size += _HIGHEST_SEQUENCE_ID_TAG_SIZE;
            _size += LightProtoCodec.computeVarInt64Size(this.highestSequenceId);
        }
        if (this.hasNullValue()) {
            _size += _NULL_VALUE_TAG_SIZE;
            ++_size;
        }
        if (this.hasUuid()) {
            _size += _UUID_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this._uuidBufferLen);
            _size += this._uuidBufferLen;
        }
        if (this.hasNumChunksFromMsg()) {
            _size += _NUM_CHUNKS_FROM_MSG_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this.numChunksFromMsg);
        }
        if (this.hasTotalChunkMsgSize()) {
            _size += _TOTAL_CHUNK_MSG_SIZE_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this.totalChunkMsgSize);
        }
        if (this.hasChunkId()) {
            _size += _CHUNK_ID_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this.chunkId);
        }
        if (this.hasNullPartitionKey()) {
            _size += _NULL_PARTITION_KEY_TAG_SIZE;
            ++_size;
        }
        this._cachedSize = _size;
        return _size;
    }

    public void parseFrom(ByteBuf _buffer, int _size) {
        this.clear();
        int _endIdx = _buffer.readerIndex() + _size;
        block30: while (_buffer.readerIndex() < _endIdx) {
            int _tag = LightProtoCodec.readVarInt(_buffer);
            switch (_tag) {
                case 10: {
                    this._bitField0 |= 1;
                    this._producerNameBufferLen = LightProtoCodec.readVarInt(_buffer);
                    this._producerNameBufferIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._producerNameBufferLen);
                    continue block30;
                }
                case 16: {
                    this._bitField0 |= 2;
                    this.sequenceId = LightProtoCodec.readVarInt64(_buffer);
                    continue block30;
                }
                case 24: {
                    this._bitField0 |= 4;
                    this.publishTime = LightProtoCodec.readVarInt64(_buffer);
                    continue block30;
                }
                case 34: {
                    int _propertiesSize = LightProtoCodec.readVarInt(_buffer);
                    this.addProperty().parseFrom(_buffer, _propertiesSize);
                    continue block30;
                }
                case 42: {
                    this._bitField0 |= 0x10;
                    this._replicatedFromBufferLen = LightProtoCodec.readVarInt(_buffer);
                    this._replicatedFromBufferIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._replicatedFromBufferLen);
                    continue block30;
                }
                case 50: {
                    this._bitField0 |= 0x20;
                    this._partitionKeyBufferLen = LightProtoCodec.readVarInt(_buffer);
                    this._partitionKeyBufferIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._partitionKeyBufferLen);
                    continue block30;
                }
                case 58: {
                    LightProtoCodec.StringHolder _replicateToSh = this._newReplicateToStringHolder();
                    _replicateToSh.len = LightProtoCodec.readVarInt(_buffer);
                    _replicateToSh.idx = _buffer.readerIndex();
                    _buffer.skipBytes(_replicateToSh.len);
                    continue block30;
                }
                case 64: {
                    CompressionType _compression = CompressionType.valueOf(LightProtoCodec.readVarInt(_buffer));
                    if (_compression == null) continue block30;
                    this._bitField0 |= 0x80;
                    this.compression = _compression;
                    continue block30;
                }
                case 72: {
                    this._bitField0 |= 0x100;
                    this.uncompressedSize = LightProtoCodec.readVarInt(_buffer);
                    continue block30;
                }
                case 88: {
                    this._bitField0 |= 0x200;
                    this.numMessagesInBatch = LightProtoCodec.readVarInt(_buffer);
                    continue block30;
                }
                case 96: {
                    this._bitField0 |= 0x400;
                    this.eventTime = LightProtoCodec.readVarInt64(_buffer);
                    continue block30;
                }
                case 106: {
                    int _encryptionKeysSize = LightProtoCodec.readVarInt(_buffer);
                    this.addEncryptionKey().parseFrom(_buffer, _encryptionKeysSize);
                    continue block30;
                }
                case 114: {
                    this._bitField0 |= 0x1000;
                    this._encryptionAlgoBufferLen = LightProtoCodec.readVarInt(_buffer);
                    this._encryptionAlgoBufferIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._encryptionAlgoBufferLen);
                    continue block30;
                }
                case 122: {
                    this._bitField0 |= 0x2000;
                    this._encryptionParamLen = LightProtoCodec.readVarInt(_buffer);
                    this._encryptionParamIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._encryptionParamLen);
                    continue block30;
                }
                case 130: {
                    this._bitField0 |= 0x4000;
                    this._schemaVersionLen = LightProtoCodec.readVarInt(_buffer);
                    this._schemaVersionIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._schemaVersionLen);
                    continue block30;
                }
                case 136: {
                    this._bitField0 |= 0x8000;
                    this.partitionKeyB64Encoded = LightProtoCodec.readVarInt(_buffer) == 1;
                    continue block30;
                }
                case 146: {
                    this._bitField0 |= 0x10000;
                    this._orderingKeyLen = LightProtoCodec.readVarInt(_buffer);
                    this._orderingKeyIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._orderingKeyLen);
                    continue block30;
                }
                case 152: {
                    this._bitField0 |= 0x20000;
                    this.deliverAtTime = LightProtoCodec.readVarInt64(_buffer);
                    continue block30;
                }
                case 160: {
                    this._bitField0 |= 0x40000;
                    this.markerType = LightProtoCodec.readVarInt(_buffer);
                    continue block30;
                }
                case 176: {
                    this._bitField0 |= 0x80000;
                    this.txnidLeastBits = LightProtoCodec.readVarInt64(_buffer);
                    continue block30;
                }
                case 184: {
                    this._bitField0 |= 0x100000;
                    this.txnidMostBits = LightProtoCodec.readVarInt64(_buffer);
                    continue block30;
                }
                case 192: {
                    this._bitField0 |= 0x200000;
                    this.highestSequenceId = LightProtoCodec.readVarInt64(_buffer);
                    continue block30;
                }
                case 200: {
                    this._bitField0 |= 0x400000;
                    this.nullValue = LightProtoCodec.readVarInt(_buffer) == 1;
                    continue block30;
                }
                case 210: {
                    this._bitField0 |= 0x800000;
                    this._uuidBufferLen = LightProtoCodec.readVarInt(_buffer);
                    this._uuidBufferIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._uuidBufferLen);
                    continue block30;
                }
                case 216: {
                    this._bitField0 |= 0x1000000;
                    this.numChunksFromMsg = LightProtoCodec.readVarInt(_buffer);
                    continue block30;
                }
                case 224: {
                    this._bitField0 |= 0x2000000;
                    this.totalChunkMsgSize = LightProtoCodec.readVarInt(_buffer);
                    continue block30;
                }
                case 232: {
                    this._bitField0 |= 0x4000000;
                    this.chunkId = LightProtoCodec.readVarInt(_buffer);
                    continue block30;
                }
                case 240: {
                    this._bitField0 |= 0x8000000;
                    this.nullPartitionKey = LightProtoCodec.readVarInt(_buffer) == 1;
                    continue block30;
                }
            }
            LightProtoCodec.skipUnknownField(_tag, _buffer);
        }
        this.checkRequiredFields();
        this._parsedBuffer = _buffer;
    }

    private void checkRequiredFields() {
        if ((this._bitField0 & 7) != 7) {
            throw new IllegalStateException("Some required fields are missing");
        }
    }

    public MessageMetadata clear() {
        int i;
        this.producerName = null;
        this._producerNameBufferIdx = -1;
        this._producerNameBufferLen = -1;
        for (i = 0; i < this._propertiesCount; ++i) {
            this.properties.get(i).clear();
        }
        this._propertiesCount = 0;
        this.replicatedFrom = null;
        this._replicatedFromBufferIdx = -1;
        this._replicatedFromBufferLen = -1;
        this.partitionKey = null;
        this._partitionKeyBufferIdx = -1;
        this._partitionKeyBufferLen = -1;
        for (i = 0; i < this._replicateTosCount; ++i) {
            LightProtoCodec.StringHolder _sh = this.replicateTos.get(i);
            _sh.s = null;
            _sh.idx = -1;
            _sh.len = -1;
        }
        this._replicateTosCount = 0;
        this.compression = CompressionType.NONE;
        this.uncompressedSize = 0;
        this.numMessagesInBatch = 1;
        this.eventTime = 0L;
        for (i = 0; i < this._encryptionKeysCount; ++i) {
            this.encryptionKeys.get(i).clear();
        }
        this._encryptionKeysCount = 0;
        this.encryptionAlgo = null;
        this._encryptionAlgoBufferIdx = -1;
        this._encryptionAlgoBufferLen = -1;
        this.encryptionParam = null;
        this._encryptionParamIdx = -1;
        this._encryptionParamLen = -1;
        this.schemaVersion = null;
        this._schemaVersionIdx = -1;
        this._schemaVersionLen = -1;
        this.partitionKeyB64Encoded = false;
        this.orderingKey = null;
        this._orderingKeyIdx = -1;
        this._orderingKeyLen = -1;
        this.highestSequenceId = 0L;
        this.nullValue = false;
        this.uuid = null;
        this._uuidBufferIdx = -1;
        this._uuidBufferLen = -1;
        this.nullPartitionKey = false;
        this._parsedBuffer = null;
        this._cachedSize = -1;
        this._bitField0 = 0;
        return this;
    }

    public MessageMetadata copyFrom(MessageMetadata _other) {
        int i;
        this._cachedSize = -1;
        if (_other.hasProducerName()) {
            this.setProducerName(_other.getProducerName());
        }
        if (_other.hasSequenceId()) {
            this.setSequenceId(_other.sequenceId);
        }
        if (_other.hasPublishTime()) {
            this.setPublishTime(_other.publishTime);
        }
        for (i = 0; i < _other.getPropertiesCount(); ++i) {
            this.addProperty().copyFrom(_other.getPropertyAt(i));
        }
        if (_other.hasReplicatedFrom()) {
            this.setReplicatedFrom(_other.getReplicatedFrom());
        }
        if (_other.hasPartitionKey()) {
            this.setPartitionKey(_other.getPartitionKey());
        }
        for (i = 0; i < _other.getReplicateTosCount(); ++i) {
            this.addReplicateTo(_other.getReplicateToAt(i));
        }
        if (_other.hasCompression()) {
            this.setCompression(_other.compression);
        }
        if (_other.hasUncompressedSize()) {
            this.setUncompressedSize(_other.uncompressedSize);
        }
        if (_other.hasNumMessagesInBatch()) {
            this.setNumMessagesInBatch(_other.numMessagesInBatch);
        }
        if (_other.hasEventTime()) {
            this.setEventTime(_other.eventTime);
        }
        for (i = 0; i < _other.getEncryptionKeysCount(); ++i) {
            this.addEncryptionKey().copyFrom(_other.getEncryptionKeyAt(i));
        }
        if (_other.hasEncryptionAlgo()) {
            this.setEncryptionAlgo(_other.getEncryptionAlgo());
        }
        if (_other.hasEncryptionParam()) {
            this.setEncryptionParam(_other.getEncryptionParam());
        }
        if (_other.hasSchemaVersion()) {
            this.setSchemaVersion(_other.getSchemaVersion());
        }
        if (_other.hasPartitionKeyB64Encoded()) {
            this.setPartitionKeyB64Encoded(_other.partitionKeyB64Encoded);
        }
        if (_other.hasOrderingKey()) {
            this.setOrderingKey(_other.getOrderingKey());
        }
        if (_other.hasDeliverAtTime()) {
            this.setDeliverAtTime(_other.deliverAtTime);
        }
        if (_other.hasMarkerType()) {
            this.setMarkerType(_other.markerType);
        }
        if (_other.hasTxnidLeastBits()) {
            this.setTxnidLeastBits(_other.txnidLeastBits);
        }
        if (_other.hasTxnidMostBits()) {
            this.setTxnidMostBits(_other.txnidMostBits);
        }
        if (_other.hasHighestSequenceId()) {
            this.setHighestSequenceId(_other.highestSequenceId);
        }
        if (_other.hasNullValue()) {
            this.setNullValue(_other.nullValue);
        }
        if (_other.hasUuid()) {
            this.setUuid(_other.getUuid());
        }
        if (_other.hasNumChunksFromMsg()) {
            this.setNumChunksFromMsg(_other.numChunksFromMsg);
        }
        if (_other.hasTotalChunkMsgSize()) {
            this.setTotalChunkMsgSize(_other.totalChunkMsgSize);
        }
        if (_other.hasChunkId()) {
            this.setChunkId(_other.chunkId);
        }
        if (_other.hasNullPartitionKey()) {
            this.setNullPartitionKey(_other.nullPartitionKey);
        }
        return this;
    }

    public byte[] toByteArray() {
        byte[] a = new byte[this.getSerializedSize()];
        ByteBuf b = Unpooled.wrappedBuffer(a).writerIndex(0);
        this.writeTo(b);
        return a;
    }

    public void parseFrom(byte[] a) {
        ByteBuf b = Unpooled.wrappedBuffer(a);
        this.parseFrom(b, b.readableBytes());
    }
}

