/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.net.InetSocketAddress;
import java.time.Clock;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.ProxyProtocol;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.ServiceUrlProvider;
import org.apache.pulsar.client.api.SizeUnit;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.client.impl.conf.ConfigurationDataUtils;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Preconditions;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils;

public class ClientBuilderImpl
implements ClientBuilder {
    ClientConfigurationData conf;

    public ClientBuilderImpl() {
        this(new ClientConfigurationData());
    }

    public ClientBuilderImpl(ClientConfigurationData conf) {
        this.conf = conf;
    }

    @Override
    public PulsarClient build() throws PulsarClientException {
        Preconditions.checkArgument(StringUtils.isNotBlank(this.conf.getServiceUrl()) || this.conf.getServiceUrlProvider() != null, "service URL or service URL provider needs to be specified on the ClientBuilder object.");
        Preconditions.checkArgument(StringUtils.isBlank(this.conf.getServiceUrl()) || this.conf.getServiceUrlProvider() == null, "Can only chose one way service URL or service URL provider.");
        if (this.conf.getServiceUrlProvider() != null) {
            Preconditions.checkArgument(StringUtils.isNotBlank(this.conf.getServiceUrlProvider().getServiceUrl()), "Cannot get service url from service url provider.");
            this.conf.setServiceUrl(this.conf.getServiceUrlProvider().getServiceUrl());
        }
        PulsarClientImpl client = new PulsarClientImpl(this.conf);
        if (this.conf.getServiceUrlProvider() != null) {
            this.conf.getServiceUrlProvider().initialize(client);
        }
        return client;
    }

    @Override
    public ClientBuilder clone() {
        return new ClientBuilderImpl(this.conf.clone());
    }

    @Override
    public ClientBuilder loadConf(Map<String, Object> config) {
        this.conf = ConfigurationDataUtils.loadData(config, this.conf, ClientConfigurationData.class);
        this.setAuthenticationFromPropsIfAvailable(this.conf);
        return this;
    }

    @Override
    public ClientBuilder serviceUrl(String serviceUrl) {
        Preconditions.checkArgument(StringUtils.isNotBlank(serviceUrl), "Param serviceUrl must not be blank.");
        this.conf.setServiceUrl(serviceUrl);
        if (!this.conf.isUseTls()) {
            this.enableTls(serviceUrl.startsWith("pulsar+ssl") || serviceUrl.startsWith("https"));
        }
        return this;
    }

    @Override
    public ClientBuilder serviceUrlProvider(ServiceUrlProvider serviceUrlProvider) {
        Preconditions.checkArgument(serviceUrlProvider != null, "Param serviceUrlProvider must not be null.");
        this.conf.setServiceUrlProvider(serviceUrlProvider);
        return this;
    }

    @Override
    public ClientBuilder listenerName(String listenerName) {
        Preconditions.checkArgument(StringUtils.isNotBlank(listenerName), "Param listenerName must not be blank.");
        this.conf.setListenerName(StringUtils.trim(listenerName));
        return this;
    }

    @Override
    public ClientBuilder connectionMaxIdleSeconds(int connectionMaxIdleSeconds) {
        Preconditions.checkArgument(connectionMaxIdleSeconds < 0 || connectionMaxIdleSeconds >= 60, "Connection idle detect interval seconds at least 60.");
        this.conf.setConnectionMaxIdleSeconds(connectionMaxIdleSeconds);
        return this;
    }

    @Override
    public ClientBuilder authentication(Authentication authentication) {
        this.conf.setAuthentication(authentication);
        return this;
    }

    @Override
    public ClientBuilder authentication(String authPluginClassName, String authParamsString) throws PulsarClientException.UnsupportedAuthenticationException {
        this.conf.setAuthPluginClassName(authPluginClassName);
        this.conf.setAuthParams(authParamsString);
        this.conf.setAuthParamMap(null);
        this.conf.setAuthentication(AuthenticationFactory.create(authPluginClassName, authParamsString));
        return this;
    }

    @Override
    public ClientBuilder authentication(String authPluginClassName, Map<String, String> authParams) throws PulsarClientException.UnsupportedAuthenticationException {
        this.conf.setAuthPluginClassName(authPluginClassName);
        this.conf.setAuthParamMap(authParams);
        this.conf.setAuthParams(null);
        this.conf.setAuthentication(AuthenticationFactory.create(authPluginClassName, authParams));
        return this;
    }

    private void setAuthenticationFromPropsIfAvailable(ClientConfigurationData clientConfig) {
        String authPluginClass = clientConfig.getAuthPluginClassName();
        String authParams = clientConfig.getAuthParams();
        Map<String, String> authParamMap = clientConfig.getAuthParamMap();
        if (StringUtils.isBlank(authPluginClass) || StringUtils.isBlank(authParams) && authParamMap == null) {
            return;
        }
        try {
            if (StringUtils.isNotBlank(authParams)) {
                this.authentication(authPluginClass, authParams);
            } else if (authParamMap != null) {
                this.authentication(authPluginClass, authParamMap);
            }
        }
        catch (PulsarClientException.UnsupportedAuthenticationException ex) {
            throw new RuntimeException("Failed to create authentication: " + ex.getMessage(), ex);
        }
    }

    @Override
    public ClientBuilder operationTimeout(int operationTimeout, TimeUnit unit) {
        Preconditions.checkArgument(operationTimeout >= 0, "operationTimeout needs to be >= 0");
        this.conf.setOperationTimeoutMs(unit.toMillis(operationTimeout));
        return this;
    }

    @Override
    public ClientBuilder lookupTimeout(int lookupTimeout, TimeUnit unit) {
        Preconditions.checkArgument(lookupTimeout >= 0, "lookupTimeout must not be negative");
        this.conf.setLookupTimeoutMs(unit.toMillis(lookupTimeout));
        return this;
    }

    @Override
    public ClientBuilder ioThreads(int numIoThreads) {
        Preconditions.checkArgument(numIoThreads > 0, "ioThreads needs to be > 0");
        this.conf.setNumIoThreads(numIoThreads);
        return this;
    }

    @Override
    public ClientBuilder listenerThreads(int numListenerThreads) {
        Preconditions.checkArgument(numListenerThreads > 0, "listenerThreads needs to be > 0");
        this.conf.setNumListenerThreads(numListenerThreads);
        return this;
    }

    @Override
    public ClientBuilder connectionsPerBroker(int connectionsPerBroker) {
        Preconditions.checkArgument(connectionsPerBroker >= 0, "connectionsPerBroker needs to be >= 0");
        this.conf.setConnectionsPerBroker(connectionsPerBroker);
        return this;
    }

    @Override
    public ClientBuilder enableTcpNoDelay(boolean useTcpNoDelay) {
        this.conf.setUseTcpNoDelay(useTcpNoDelay);
        return this;
    }

    @Override
    public ClientBuilder enableTls(boolean useTls) {
        this.conf.setUseTls(useTls);
        return this;
    }

    @Override
    public ClientBuilder tlsKeyFilePath(String tlsKeyFilePath) {
        this.conf.setTlsKeyFilePath(tlsKeyFilePath);
        return this;
    }

    @Override
    public ClientBuilder tlsCertificateFilePath(String tlsCertificateFilePath) {
        this.conf.setTlsCertificateFilePath(tlsCertificateFilePath);
        return this;
    }

    @Override
    public ClientBuilder enableTlsHostnameVerification(boolean enableTlsHostnameVerification) {
        this.conf.setTlsHostnameVerificationEnable(enableTlsHostnameVerification);
        return this;
    }

    @Override
    public ClientBuilder tlsTrustCertsFilePath(String tlsTrustCertsFilePath) {
        this.conf.setTlsTrustCertsFilePath(tlsTrustCertsFilePath);
        return this;
    }

    @Override
    public ClientBuilder allowTlsInsecureConnection(boolean tlsAllowInsecureConnection) {
        this.conf.setTlsAllowInsecureConnection(tlsAllowInsecureConnection);
        return this;
    }

    @Override
    public ClientBuilder useKeyStoreTls(boolean useKeyStoreTls) {
        this.conf.setUseKeyStoreTls(useKeyStoreTls);
        return this;
    }

    @Override
    public ClientBuilder sslProvider(String sslProvider) {
        this.conf.setSslProvider(sslProvider);
        return this;
    }

    @Override
    public ClientBuilder tlsKeyStoreType(String tlsKeyStoreType) {
        this.conf.setTlsKeyStoreType(tlsKeyStoreType);
        return this;
    }

    @Override
    public ClientBuilder tlsKeyStorePath(String tlsTrustStorePath) {
        this.conf.setTlsKeyStorePath(tlsTrustStorePath);
        return this;
    }

    @Override
    public ClientBuilder tlsKeyStorePassword(String tlsKeyStorePassword) {
        this.conf.setTlsKeyStorePassword(tlsKeyStorePassword);
        return this;
    }

    @Override
    public ClientBuilder tlsTrustStoreType(String tlsTrustStoreType) {
        this.conf.setTlsTrustStoreType(tlsTrustStoreType);
        return this;
    }

    @Override
    public ClientBuilder tlsTrustStorePath(String tlsTrustStorePath) {
        this.conf.setTlsTrustStorePath(tlsTrustStorePath);
        return this;
    }

    @Override
    public ClientBuilder tlsTrustStorePassword(String tlsTrustStorePassword) {
        this.conf.setTlsTrustStorePassword(tlsTrustStorePassword);
        return this;
    }

    @Override
    public ClientBuilder tlsCiphers(Set<String> tlsCiphers) {
        this.conf.setTlsCiphers(tlsCiphers);
        return this;
    }

    @Override
    public ClientBuilder tlsProtocols(Set<String> tlsProtocols) {
        this.conf.setTlsProtocols(tlsProtocols);
        return this;
    }

    @Override
    public ClientBuilder statsInterval(long statsInterval, TimeUnit unit) {
        this.conf.setStatsIntervalSeconds(unit.toSeconds(statsInterval));
        return this;
    }

    @Override
    public ClientBuilder maxConcurrentLookupRequests(int concurrentLookupRequests) {
        this.conf.setConcurrentLookupRequest(concurrentLookupRequests);
        return this;
    }

    @Override
    public ClientBuilder maxLookupRequests(int maxLookupRequests) {
        this.conf.setMaxLookupRequest(maxLookupRequests);
        return this;
    }

    @Override
    public ClientBuilder maxLookupRedirects(int maxLookupRedirects) {
        this.conf.setMaxLookupRedirects(maxLookupRedirects);
        return this;
    }

    @Override
    public ClientBuilder maxNumberOfRejectedRequestPerConnection(int maxNumberOfRejectedRequestPerConnection) {
        this.conf.setMaxNumberOfRejectedRequestPerConnection(maxNumberOfRejectedRequestPerConnection);
        return this;
    }

    @Override
    public ClientBuilder keepAliveInterval(int keepAliveInterval, TimeUnit unit) {
        this.conf.setKeepAliveIntervalSeconds((int)unit.toSeconds(keepAliveInterval));
        return this;
    }

    @Override
    public ClientBuilder connectionTimeout(int duration, TimeUnit unit) {
        Preconditions.checkArgument(duration >= 0, "connectionTimeout needs to be >= 0");
        this.conf.setConnectionTimeoutMs((int)unit.toMillis(duration));
        return this;
    }

    @Override
    public ClientBuilder startingBackoffInterval(long duration, TimeUnit unit) {
        this.conf.setInitialBackoffIntervalNanos(unit.toNanos(duration));
        return this;
    }

    @Override
    public ClientBuilder maxBackoffInterval(long duration, TimeUnit unit) {
        this.conf.setMaxBackoffIntervalNanos(unit.toNanos(duration));
        return this;
    }

    @Override
    public ClientBuilder enableBusyWait(boolean enableBusyWait) {
        this.conf.setEnableBusyWait(enableBusyWait);
        return this;
    }

    public ClientConfigurationData getClientConfigurationData() {
        return this.conf;
    }

    @Override
    public ClientBuilder memoryLimit(long memoryLimit, SizeUnit unit) {
        this.conf.setMemoryLimitBytes(unit.toBytes(memoryLimit));
        return this;
    }

    @Override
    public ClientBuilder clock(Clock clock) {
        this.conf.setClock(clock);
        return this;
    }

    @Override
    public ClientBuilder proxyServiceUrl(String proxyServiceUrl, ProxyProtocol proxyProtocol) {
        if (StringUtils.isNotBlank(proxyServiceUrl)) {
            Preconditions.checkArgument(proxyProtocol != null, "proxyProtocol must be present with proxyServiceUrl");
        }
        this.conf.setProxyServiceUrl(proxyServiceUrl);
        this.conf.setProxyProtocol(proxyProtocol);
        return this;
    }

    @Override
    public ClientBuilder enableTransaction(boolean enableTransaction) {
        this.conf.setEnableTransaction(enableTransaction);
        return this;
    }

    @Override
    public ClientBuilder dnsLookupBind(String address, int port) {
        Preconditions.checkArgument(port >= 0 && port <= 65535, "DnsLookBindPort need to be within the range of 0 and 65535");
        this.conf.setDnsLookupBindAddress(address);
        this.conf.setDnsLookupBindPort(port);
        return this;
    }

    @Override
    public ClientBuilder socks5ProxyAddress(InetSocketAddress socks5ProxyAddress) {
        this.conf.setSocks5ProxyAddress(socks5ProxyAddress);
        return this;
    }

    @Override
    public ClientBuilder socks5ProxyUsername(String socks5ProxyUsername) {
        this.conf.setSocks5ProxyUsername(socks5ProxyUsername);
        return this;
    }

    @Override
    public ClientBuilder socks5ProxyPassword(String socks5ProxyPassword) {
        this.conf.setSocks5ProxyPassword(socks5ProxyPassword);
        return this;
    }

    public ClientBuilder description(String description) {
        if (description != null && description.length() > 64) {
            throw new IllegalArgumentException("description should be at most 64 characters");
        }
        this.conf.setDescription(description);
        return this;
    }
}

