/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.resources;

import java.util.Optional;
import org.apache.pulsar.broker.resources.BookieResources;
import org.apache.pulsar.broker.resources.ClusterResources;
import org.apache.pulsar.broker.resources.DynamicConfigurationResources;
import org.apache.pulsar.broker.resources.LoadManagerReportResources;
import org.apache.pulsar.broker.resources.LocalPoliciesResources;
import org.apache.pulsar.broker.resources.NamespaceResources;
import org.apache.pulsar.broker.resources.ResourceGroupResources;
import org.apache.pulsar.broker.resources.TenantResources;
import org.apache.pulsar.broker.resources.TopicResources;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;

public class PulsarResources {
    public static final int DEFAULT_OPERATION_TIMEOUT_SEC = 30;
    private final TenantResources tenantResources;
    private final ClusterResources clusterResources;
    private final ResourceGroupResources resourcegroupResources;
    private final NamespaceResources namespaceResources;
    private final DynamicConfigurationResources dynamicConfigResources;
    private final LocalPoliciesResources localPolicies;
    private final LoadManagerReportResources loadReportResources;
    private final BookieResources bookieResources;
    private final TopicResources topicResources;
    private final Optional<MetadataStore> localMetadataStore;
    private final Optional<MetadataStore> configurationMetadataStore;

    public PulsarResources(MetadataStore localMetadataStore, MetadataStore configurationMetadataStore) {
        this(localMetadataStore, configurationMetadataStore, 30);
    }

    public PulsarResources(MetadataStore localMetadataStore, MetadataStore configurationMetadataStore, int operationTimeoutSec) {
        if (configurationMetadataStore != null) {
            this.tenantResources = new TenantResources(configurationMetadataStore, operationTimeoutSec);
            this.clusterResources = new ClusterResources(configurationMetadataStore, operationTimeoutSec);
            this.namespaceResources = new NamespaceResources(localMetadataStore, configurationMetadataStore, operationTimeoutSec);
            this.resourcegroupResources = new ResourceGroupResources(configurationMetadataStore, operationTimeoutSec);
        } else {
            this.tenantResources = null;
            this.clusterResources = null;
            this.namespaceResources = null;
            this.resourcegroupResources = null;
        }
        if (localMetadataStore != null) {
            this.dynamicConfigResources = new DynamicConfigurationResources(localMetadataStore, operationTimeoutSec);
            this.localPolicies = new LocalPoliciesResources(localMetadataStore, operationTimeoutSec);
            this.loadReportResources = new LoadManagerReportResources(localMetadataStore, operationTimeoutSec);
            this.bookieResources = new BookieResources(localMetadataStore, operationTimeoutSec);
            this.topicResources = new TopicResources(localMetadataStore);
        } else {
            this.dynamicConfigResources = null;
            this.localPolicies = null;
            this.loadReportResources = null;
            this.bookieResources = null;
            this.topicResources = null;
        }
        this.localMetadataStore = Optional.ofNullable(localMetadataStore);
        this.configurationMetadataStore = Optional.ofNullable(configurationMetadataStore);
    }

    public static MetadataStoreExtended createLocalMetadataStore(String serverUrls, int sessionTimeoutMs, boolean allowReadOnlyOperations) throws MetadataStoreException {
        return MetadataStoreExtended.create(serverUrls, MetadataStoreConfig.builder().sessionTimeoutMillis(sessionTimeoutMs).allowReadOnlyOperations(allowReadOnlyOperations).metadataStoreName("metadata-store").build());
    }

    public static MetadataStoreExtended createConfigMetadataStore(String serverUrls, int sessionTimeoutMs, boolean allowReadOnlyOperations) throws MetadataStoreException {
        return MetadataStoreExtended.create(serverUrls, MetadataStoreConfig.builder().sessionTimeoutMillis(sessionTimeoutMs).allowReadOnlyOperations(allowReadOnlyOperations).metadataStoreName("configuration-metadata-store").build());
    }

    public TenantResources getTenantResources() {
        return this.tenantResources;
    }

    public ClusterResources getClusterResources() {
        return this.clusterResources;
    }

    public ResourceGroupResources getResourcegroupResources() {
        return this.resourcegroupResources;
    }

    public NamespaceResources getNamespaceResources() {
        return this.namespaceResources;
    }

    public DynamicConfigurationResources getDynamicConfigResources() {
        return this.dynamicConfigResources;
    }

    public LocalPoliciesResources getLocalPolicies() {
        return this.localPolicies;
    }

    public LoadManagerReportResources getLoadReportResources() {
        return this.loadReportResources;
    }

    public BookieResources getBookieResources() {
        return this.bookieResources;
    }

    public TopicResources getTopicResources() {
        return this.topicResources;
    }

    public Optional<MetadataStore> getLocalMetadataStore() {
        return this.localMetadataStore;
    }

    public Optional<MetadataStore> getConfigurationMetadataStore() {
        return this.configurationMetadataStore;
    }
}

