/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shaded.com.yahoo.sketches.quantiles;

import com.yahoo.memory.NativeMemory;
import java.util.Arrays;
import org.apache.pulsar.shaded.com.yahoo.sketches.Family;
import org.apache.pulsar.shaded.com.yahoo.sketches.quantiles.DoublesSketch;
import org.apache.pulsar.shaded.com.yahoo.sketches.quantiles.PreambleUtil;
import org.apache.pulsar.shaded.com.yahoo.sketches.quantiles.Util;

class DoublesToByteArrayImpl {
    DoublesToByteArrayImpl() {
    }

    static byte[] toByteArray(DoublesSketch sketch, boolean ordered, boolean compact) {
        boolean empty = sketch.isEmpty();
        int flags = (empty ? 4 : 0) | (ordered ? 16 : 0) | (compact ? 8 : 0);
        if (empty) {
            byte[] outByteArr = new byte[8];
            NativeMemory memOut = new NativeMemory(outByteArr);
            long cumOffset = memOut.getCumulativeOffset(0L);
            boolean preLongs = true;
            DoublesToByteArrayImpl.insertPre0(outByteArr, cumOffset, 1, flags, sketch.getK());
            return outByteArr;
        }
        return DoublesToByteArrayImpl.combinedBufferToByteArray(sketch, ordered, compact);
    }

    static byte[] combinedBufferToByteArray(DoublesSketch sketch, boolean ordered, boolean compact) {
        int preLongs = 2;
        int extra = 2;
        int preBytes = 32;
        int flags = (ordered ? 16 : 0) | (compact ? 8 : 0);
        int k = sketch.getK();
        long n = sketch.getN();
        double[] combinedBuffer = sketch.getCombinedBuffer();
        double[] bbItemsArr = null;
        int bbCnt = Util.computeBaseBufferItems(k, n);
        if (bbCnt > 0) {
            bbItemsArr = new double[bbCnt];
            System.arraycopy(combinedBuffer, 0, bbItemsArr, 0, bbCnt);
            if (ordered) {
                Arrays.sort(bbItemsArr);
            }
        }
        byte[] outByteArr = null;
        if (compact) {
            long bits;
            int retainedItems = sketch.getRetainedItems();
            int outBytes = (retainedItems << 3) + 32;
            outByteArr = new byte[outBytes];
            NativeMemory memOut = new NativeMemory(outByteArr);
            long cumOffset = memOut.getCumulativeOffset(0L);
            DoublesToByteArrayImpl.insertPre0(outByteArr, cumOffset, 2, flags, k);
            PreambleUtil.insertN(outByteArr, cumOffset, n);
            PreambleUtil.insertMinDouble(outByteArr, cumOffset, sketch.getMinValue());
            PreambleUtil.insertMaxDouble(outByteArr, cumOffset, sketch.getMaxValue());
            if (bbCnt > 0) {
                memOut.putDoubleArray(32L, bbItemsArr, 0, bbCnt);
            }
            if ((bits = sketch.getBitPattern()) != 0L) {
                long memOffset = 32 + (bbCnt << 3);
                int combBufOffset = 2 * k;
                while (bits != 0L) {
                    if ((bits & 1L) > 0L) {
                        memOut.putDoubleArray(memOffset, combinedBuffer, combBufOffset, k);
                        memOffset += (long)(k << 3);
                    }
                    combBufOffset += k;
                    bits >>>= 1;
                }
            }
        } else {
            int totLevels = Util.computeNumLevelsNeeded(k, n);
            int outBytes = totLevels == 0 ? (bbCnt << 3) + 32 : ((2 + totLevels) * k << 3) + 32;
            outByteArr = new byte[outBytes];
            NativeMemory memOut = new NativeMemory(outByteArr);
            long cumOffset = memOut.getCumulativeOffset(0L);
            DoublesToByteArrayImpl.insertPre0(outByteArr, cumOffset, 2, flags, k);
            PreambleUtil.insertN(outByteArr, cumOffset, n);
            PreambleUtil.insertMinDouble(outByteArr, cumOffset, sketch.getMinValue());
            PreambleUtil.insertMaxDouble(outByteArr, cumOffset, sketch.getMaxValue());
            if (bbCnt > 0) {
                memOut.putDoubleArray(32L, bbItemsArr, 0, bbCnt);
            }
            if (totLevels > 0) {
                long memOffset = 32L + (2L * (long)k << 3);
                int combBufOffset = 2 * k;
                memOut.putDoubleArray(memOffset, combinedBuffer, combBufOffset, totLevels * k);
            }
        }
        return outByteArr;
    }

    static void insertPre0(byte[] outArr, long cumOffset, int preLongs, int flags, int k) {
        PreambleUtil.insertPreLongs(outArr, cumOffset, preLongs);
        PreambleUtil.insertSerVer(outArr, cumOffset, 3);
        PreambleUtil.insertFamilyID(outArr, cumOffset, Family.QUANTILES.getID());
        PreambleUtil.insertFlags(outArr, cumOffset, flags);
        PreambleUtil.insertK(outArr, cumOffset, k);
    }
}

