/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.pulsar.common.functions.FunctionDefinition;
import org.apache.pulsar.functions.utils.functions.FunctionArchive;
import org.apache.pulsar.functions.utils.functions.FunctionUtils;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionsManager {
    private static final Logger log = LoggerFactory.getLogger(FunctionsManager.class);
    private TreeMap<String, FunctionArchive> functions;

    public FunctionsManager(WorkerConfig workerConfig) throws IOException {
        this.functions = FunctionUtils.searchForFunctions(workerConfig.getFunctionsDirectory());
    }

    public FunctionArchive getFunction(String functionType) {
        return this.functions.get(functionType);
    }

    public Path getFunctionArchive(String functionType) {
        return this.functions.get(functionType).getArchivePath();
    }

    public List<FunctionDefinition> getFunctionDefinitions() {
        return this.functions.values().stream().map(FunctionArchive::getFunctionDefinition).collect(Collectors.toList());
    }

    public void reloadFunctions(WorkerConfig workerConfig) throws IOException {
        this.functions = FunctionUtils.searchForFunctions(workerConfig.getFunctionsDirectory());
    }
}

