/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.utils.io;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.pulsar.common.io.ConfigFieldDefinition;
import org.apache.pulsar.common.io.ConnectorDefinition;
import org.apache.pulsar.common.nar.NarClassLoader;
import org.apache.pulsar.common.nar.NarClassLoaderBuilder;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.common.util.Reflections;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.functions.utils.Exceptions;
import org.apache.pulsar.functions.utils.io.Connector;
import org.apache.pulsar.io.core.BatchSource;
import org.apache.pulsar.io.core.Sink;
import org.apache.pulsar.io.core.Source;
import org.apache.pulsar.io.core.annotations.FieldDoc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectorUtils {
    private static final Logger log = LoggerFactory.getLogger(ConnectorUtils.class);
    private static final String PULSAR_IO_SERVICE_NAME = "pulsar-io.yaml";

    public static String getIOSourceClass(NarClassLoader narClassLoader) throws IOException {
        ConnectorDefinition conf = ConnectorUtils.getConnectorDefinition(narClassLoader);
        if (StringUtils.isEmpty(conf.getSourceClass())) {
            throw new IOException(String.format("The '%s' connector does not provide a source implementation", conf.getName()));
        }
        try {
            Class<?> sourceClass = narClassLoader.loadClass(conf.getSourceClass());
            if (!Source.class.isAssignableFrom(sourceClass) && !BatchSource.class.isAssignableFrom(sourceClass)) {
                throw new IOException(String.format("Class %s does not implement interface %s or %s", conf.getSourceClass(), Source.class.getName(), BatchSource.class.getName()));
            }
        }
        catch (Throwable t) {
            Exceptions.rethrowIOException(t);
        }
        return conf.getSourceClass();
    }

    public static String getIOSinkClass(NarClassLoader narClassLoader) throws IOException {
        ConnectorDefinition conf = ConnectorUtils.getConnectorDefinition(narClassLoader);
        if (StringUtils.isEmpty(conf.getSinkClass())) {
            throw new IOException(String.format("The '%s' connector does not provide a sink implementation", conf.getName()));
        }
        try {
            Class<?> sinkClass = narClassLoader.loadClass(conf.getSinkClass());
            if (!Sink.class.isAssignableFrom(sinkClass)) {
                throw new IOException("Class " + conf.getSinkClass() + " does not implement interface " + Sink.class.getName());
            }
        }
        catch (Throwable t) {
            Exceptions.rethrowIOException(t);
        }
        return conf.getSinkClass();
    }

    public static ConnectorDefinition getConnectorDefinition(NarClassLoader narClassLoader) throws IOException {
        String configStr = narClassLoader.getServiceDefinition(PULSAR_IO_SERVICE_NAME);
        return ObjectMapperFactory.getYamlMapper().reader().readValue(configStr, ConnectorDefinition.class);
    }

    public static List<ConfigFieldDefinition> getConnectorConfigDefinition(ClassLoader classLoader, String configClassName) throws Exception {
        LinkedList<ConfigFieldDefinition> retval = new LinkedList<ConfigFieldDefinition>();
        Class<?> configClass = classLoader.loadClass(configClassName);
        for (Field field : Reflections.getAllFields(configClass)) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            ConfigFieldDefinition configFieldDefinition = new ConfigFieldDefinition();
            configFieldDefinition.setFieldName(field.getName());
            configFieldDefinition.setTypeName(field.getType().getName());
            HashMap<String, String> attributes = new HashMap<String, String>();
            for (Annotation annotation : field.getAnnotations()) {
                if (!annotation.annotationType().equals(FieldDoc.class)) continue;
                FieldDoc fieldDoc = (FieldDoc)annotation;
                for (Method method : FieldDoc.class.getDeclaredMethods()) {
                    Object value = method.invoke((Object)fieldDoc, new Object[0]);
                    attributes.put(method.getName(), value == null ? "" : value.toString());
                }
            }
            configFieldDefinition.setAttributes(attributes);
            retval.add(configFieldDefinition);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TreeMap<String, Connector> searchForConnectors(String connectorsDirectory, String narExtractionDirectory) throws IOException {
        Path path = Paths.get(connectorsDirectory, new String[0]).toAbsolutePath();
        log.info("Searching for connectors in {}", (Object)path);
        if (!path.toFile().exists()) {
            log.warn("Connectors archive directory not found");
            return new TreeMap<String, Connector>();
        }
        ArrayList<Path> archives = new ArrayList<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path, "*.nar");){
            for (Path archive : stream) {
                archives.add(archive);
            }
        }
        if (archives.isEmpty()) {
            return new TreeMap<String, Connector>();
        }
        ExecutorService oneTimeExecutor = null;
        try {
            int nThreads = Math.min(Runtime.getRuntime().availableProcessors(), archives.size());
            log.info("Loading {} connector definitions with a thread pool of size {}", (Object)archives.size(), (Object)nThreads);
            oneTimeExecutor = Executors.newFixedThreadPool(nThreads, new ThreadFactoryBuilder().setNameFormat("connector-extraction-executor-%d").build());
            ArrayList<CompletableFuture<Map.Entry>> futures = new ArrayList<CompletableFuture<Map.Entry>>();
            for (Path archive : archives) {
                CompletableFuture<Map.Entry> future = CompletableFuture.supplyAsync(() -> ConnectorUtils.getConnectorDefinitionEntry(archive, narExtractionDirectory), oneTimeExecutor);
                futures.add(future);
            }
            FutureUtil.waitForAll(futures).join();
            TreeMap treeMap = futures.stream().map(CompletableFuture::join).filter(entry -> entry != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, TreeMap::new));
            return treeMap;
        }
        finally {
            if (oneTimeExecutor != null) {
                oneTimeExecutor.shutdown();
            }
        }
    }

    private static Map.Entry<String, Connector> getConnectorDefinitionEntry(Path archive, String narExtractionDirectory) {
        try {
            NarClassLoader ncl = NarClassLoaderBuilder.builder().narFile(new File(archive.toString())).extractionDirectory(narExtractionDirectory).build();
            Connector.ConnectorBuilder connectorBuilder = Connector.builder();
            ConnectorDefinition cntDef = ConnectorUtils.getConnectorDefinition(ncl);
            log.info("Found connector {} from {}", (Object)cntDef, (Object)archive);
            connectorBuilder.archivePath(archive);
            if (!StringUtils.isEmpty(cntDef.getSourceClass()) && !StringUtils.isEmpty(cntDef.getSourceConfigClass())) {
                connectorBuilder.sourceConfigFieldDefinitions(ConnectorUtils.getConnectorConfigDefinition(ncl, cntDef.getSourceConfigClass()));
            }
            if (!StringUtils.isEmpty(cntDef.getSinkClass()) && !StringUtils.isEmpty(cntDef.getSinkConfigClass())) {
                connectorBuilder.sinkConfigFieldDefinitions(ConnectorUtils.getConnectorConfigDefinition(ncl, cntDef.getSinkConfigClass()));
            }
            connectorBuilder.classLoader(ncl);
            connectorBuilder.connectorDefinition(cntDef);
            return new AbstractMap.SimpleEntry<String, Connector>(cntDef.getName(), connectorBuilder.build());
        }
        catch (Throwable t) {
            log.warn("Failed to load connector from {}", (Object)archive, (Object)t);
            return null;
        }
    }

    private ConnectorUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

