/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.source;

import java.util.Map;
import java.util.Optional;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.functions.proto.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarFunctionRecord<T>
implements Record<T> {
    private static final Logger log = LoggerFactory.getLogger(PulsarFunctionRecord.class);
    private final Record<T> record;
    private final Function.FunctionDetails functionConfig;

    public PulsarFunctionRecord(Record<T> record, Function.FunctionDetails functionConfig) {
        this.record = record;
        this.functionConfig = functionConfig;
    }

    @Override
    public Optional<String> getTopicName() {
        return this.record.getTopicName();
    }

    @Override
    public Optional<String> getKey() {
        return this.record.getKey();
    }

    @Override
    public Schema getSchema() {
        return this.record.getSchema();
    }

    @Override
    public T getValue() {
        return this.record.getValue();
    }

    @Override
    public Optional<Long> getEventTime() {
        return this.record.getEventTime();
    }

    @Override
    public Optional<String> getPartitionId() {
        return this.record.getPartitionId();
    }

    @Override
    public Optional<Integer> getPartitionIndex() {
        return this.record.getPartitionIndex();
    }

    @Override
    public Optional<Long> getRecordSequence() {
        return this.record.getRecordSequence();
    }

    @Override
    public Map<String, String> getProperties() {
        return this.record.getProperties();
    }

    @Override
    public void ack() {
        Function.ProcessingGuarantees processingGuarantees = this.functionConfig.getProcessingGuarantees();
        if (processingGuarantees == Function.ProcessingGuarantees.MANUAL) {
            this.record.ack();
        } else {
            log.warn("Ignore this ack option, under this configuration Guarantees:[{}] autoAck:[{}], the framework will automatically ack", (Object)processingGuarantees, (Object)this.functionConfig.getAutoAck());
        }
    }

    @Override
    public void fail() {
        this.record.fail();
    }

    @Override
    public Optional<String> getDestinationTopic() {
        return this.record.getDestinationTopic();
    }

    @Override
    public Optional<Message<T>> getMessage() {
        return this.record.getMessage();
    }
}

