/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.quorum;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.CreateMode;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.KeeperException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.MultiOperationRecord;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.Op;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.metrics.MetricsContext;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.proto.CreateRequest;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.ByteBufferInputStream;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.Request;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.ServerMetrics;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.ZKDatabase;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.quorum.UpgradeableSessionTracker;

public abstract class QuorumZooKeeperServer
extends ZooKeeperServer {
    public final QuorumPeer self;
    protected UpgradeableSessionTracker upgradeableSessionTracker;

    protected QuorumZooKeeperServer(FileTxnSnapLog logFactory, int tickTime, int minSessionTimeout, int maxSessionTimeout, int listenBacklog, ZKDatabase zkDb, QuorumPeer self) {
        super(logFactory, tickTime, minSessionTimeout, maxSessionTimeout, listenBacklog, zkDb, self.getInitialConfig(), self.isReconfigEnabled());
        this.self = self;
    }

    @Override
    protected void startSessionTracker() {
        this.upgradeableSessionTracker = (UpgradeableSessionTracker)this.sessionTracker;
        this.upgradeableSessionTracker.start();
    }

    public Request checkUpgradeSession(Request request) throws IOException, KeeperException {
        if (request.isThrottled()) {
            return null;
        }
        if (request.type != 1 && request.type != 15 && request.type != 14 || !this.upgradeableSessionTracker.isLocalSession(request.sessionId)) {
            return null;
        }
        if (14 == request.type) {
            MultiOperationRecord multiTransactionRecord = new MultiOperationRecord();
            request.request.rewind();
            ByteBufferInputStream.byteBuffer2Record(request.request, multiTransactionRecord);
            request.request.rewind();
            boolean containsEphemeralCreate = false;
            for (Op op : multiTransactionRecord) {
                CreateRequest createRequest;
                CreateMode createMode;
                if (op.getType() != 1 && op.getType() != 15 || !(createMode = CreateMode.fromFlag((createRequest = (CreateRequest)op.toRequestRecord()).getFlags())).isEphemeral()) continue;
                containsEphemeralCreate = true;
                break;
            }
            if (!containsEphemeralCreate) {
                return null;
            }
        } else {
            CreateRequest createRequest = new CreateRequest();
            request.request.rewind();
            ByteBufferInputStream.byteBuffer2Record(request.request, createRequest);
            request.request.rewind();
            CreateMode createMode = CreateMode.fromFlag(createRequest.getFlags());
            if (!createMode.isEphemeral()) {
                return null;
            }
        }
        if (!this.self.isLocalSessionsUpgradingEnabled()) {
            throw new KeeperException.EphemeralOnLocalSessionException();
        }
        return this.makeUpgradeRequest(request.sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Request makeUpgradeRequest(long sessionId) {
        UpgradeableSessionTracker upgradeableSessionTracker = this.upgradeableSessionTracker;
        synchronized (upgradeableSessionTracker) {
            if (this.upgradeableSessionTracker.isLocalSession(sessionId)) {
                int timeout = this.upgradeableSessionTracker.upgradeSession(sessionId);
                ByteBuffer to = ByteBuffer.allocate(4);
                to.putInt(timeout);
                return new Request(null, sessionId, 0, -10, to, null);
            }
        }
        return null;
    }

    public void upgrade(long sessionId) {
        Request request = this.makeUpgradeRequest(sessionId);
        if (request != null) {
            LOG.info("Upgrading session 0x{}", (Object)Long.toHexString(sessionId));
            this.submitRequest(request);
        }
    }

    @Override
    protected void setLocalSessionFlag(Request si) {
        switch (si.type) {
            case -10: {
                if (!this.self.areLocalSessionsEnabled()) break;
                si.setLocalSession(true);
                break;
            }
            case -11: {
                String reqType = "global";
                if (this.upgradeableSessionTracker.isLocalSession(si.sessionId)) {
                    si.setLocalSession(true);
                    reqType = "local";
                }
                LOG.info("Submitting {} closeSession request for session 0x{}", (Object)reqType, (Object)Long.toHexString(si.sessionId));
                break;
            }
        }
    }

    @Override
    public void dumpConf(PrintWriter pwriter) {
        super.dumpConf(pwriter);
        pwriter.print("initLimit=");
        pwriter.println(this.self.getInitLimit());
        pwriter.print("syncLimit=");
        pwriter.println(this.self.getSyncLimit());
        pwriter.print("electionAlg=");
        pwriter.println(this.self.getElectionType());
        pwriter.print("electionPort=");
        pwriter.println(this.self.getElectionAddress().getAllPorts().stream().map(Objects::toString).collect(Collectors.joining("|")));
        pwriter.print("quorumPort=");
        pwriter.println(this.self.getQuorumAddress().getAllPorts().stream().map(Objects::toString).collect(Collectors.joining("|")));
        pwriter.print("peerType=");
        pwriter.println(this.self.getLearnerType().ordinal());
        pwriter.println("membership: ");
        pwriter.print(this.self.getQuorumVerifier().toString());
    }

    @Override
    protected void setState(ZooKeeperServer.State state) {
        this.state = state;
    }

    @Override
    protected void registerMetrics() {
        super.registerMetrics();
        MetricsContext rootContext = ServerMetrics.getMetrics().getMetricsProvider().getRootContext();
        rootContext.registerGauge("quorum_size", () -> this.self.getQuorumSize());
    }

    @Override
    protected void unregisterMetrics() {
        super.unregisterMetrics();
        MetricsContext rootContext = ServerMetrics.getMetrics().getMetricsProvider().getRootContext();
        rootContext.unregisterGauge("quorum_size");
    }

    @Override
    public void dumpMonitorValues(BiConsumer<String, Object> response) {
        super.dumpMonitorValues(response);
        response.accept("peer_state", this.self.getDetailedPeerState());
    }
}

