/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.zookeeper;

import java.util.Arrays;
import java.util.Random;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.zookeeper.RetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExponentialBackOffWithDeadlinePolicy
implements RetryPolicy {
    private static final Logger log = LoggerFactory.getLogger(ExponentialBackOffWithDeadlinePolicy.class);
    static final int[] RETRY_BACKOFF = new int[]{0, 1, 2, 3, 5, 5, 5, 10, 10, 10, 20, 40, 100};
    public static final int JITTER_PERCENT = 10;
    private final Random random;
    private final long baseBackoffTime;
    private final long deadline;
    private final int maxRetries;

    public ExponentialBackOffWithDeadlinePolicy(long baseBackoffTime, long deadline, int maxRetries) {
        this.baseBackoffTime = baseBackoffTime;
        this.deadline = deadline;
        this.maxRetries = maxRetries;
        this.random = new Random(System.currentTimeMillis());
    }

    @Override
    public boolean allowRetry(int retryCount, long elapsedRetryTime) {
        return retryCount <= this.maxRetries && elapsedRetryTime < this.deadline;
    }

    @Override
    public long nextRetryWaitTime(int retryCount, long elapsedRetryTime) {
        long jitter;
        long waitTime;
        int idx = retryCount;
        if (idx >= RETRY_BACKOFF.length) {
            idx = RETRY_BACKOFF.length - 1;
        }
        if (elapsedRetryTime + (waitTime = this.baseBackoffTime * (long)RETRY_BACKOFF[idx]) + (jitter = (long)this.random.nextInt(10) * waitTime / 100L) > this.deadline) {
            log.warn("Final retry attempt: {}, timeleft: {}, stacktrace: {}", new Object[]{retryCount, this.deadline - elapsedRetryTime, Arrays.toString(Thread.currentThread().getStackTrace())});
            return this.deadline - elapsedRetryTime;
        }
        return waitTime + jitter;
    }
}

