/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.replication;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.Counter;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.Gauge;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.StatsLogger;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.annotations.StatsDoc;

@StatsDoc(name="auditor", help="Auditor related stats")
public class AuditorStats {
    private final AtomicInteger ledgersNotAdheringToPlacementPolicyGuageValue;
    private final AtomicInteger ledgersSoftlyAdheringToPlacementPolicyGuageValue;
    private final AtomicInteger numOfURLedgersElapsedRecoveryGracePeriodGuageValue;
    private final AtomicInteger numLedgersHavingNoReplicaOfAnEntryGuageValue;
    private final AtomicInteger numLedgersHavingLessThanAQReplicasOfAnEntryGuageValue;
    private final AtomicInteger numLedgersHavingLessThanWQReplicasOfAnEntryGuageValue;
    private final AtomicInteger underReplicatedLedgersGuageValue;
    private final StatsLogger statsLogger;
    @StatsDoc(name="NUM_UNDER_REPLICATED_LEDGERS", help="the distribution of num under_replicated ledgers on each auditor run")
    private final OpStatsLogger numUnderReplicatedLedger;
    @StatsDoc(name="UNDER_REPLICATED_LEDGERS_TOTAL_SIZE", help="the distribution of under_replicated ledgers total size on each auditor run")
    private final OpStatsLogger underReplicatedLedgerTotalSize;
    @StatsDoc(name="URL_PUBLISH_TIME_FOR_LOST_BOOKIE", help="the latency distribution of publishing under replicated ledgers for lost bookies")
    private final OpStatsLogger uRLPublishTimeForLostBookies;
    @StatsDoc(name="BOOKIE_TO_LEDGERS_MAP_CREATION_TIME", help="the latency distribution of creating bookies-to-ledgers map")
    private final OpStatsLogger bookieToLedgersMapCreationTime;
    @StatsDoc(name="CHECK_ALL_LEDGERS_TIME", help="the latency distribution of checking all ledgers")
    private final OpStatsLogger checkAllLedgersTime;
    @StatsDoc(name="PLACEMENT_POLICY_CHECK_TIME", help="the latency distribution of placementPolicy check")
    private final OpStatsLogger placementPolicyCheckTime;
    @StatsDoc(name="REPLICAS_CHECK_TIME", help="the latency distribution of replicas check")
    private final OpStatsLogger replicasCheckTime;
    @StatsDoc(name="AUDIT_BOOKIES_TIME", help="the latency distribution of auditing all the bookies")
    private final OpStatsLogger auditBookiesTime;
    @StatsDoc(name="NUM_LEDGERS_CHECKED", help="the number of ledgers checked by the auditor")
    private final Counter numLedgersChecked;
    @StatsDoc(name="NUM_FRAGMENTS_PER_LEDGER", help="the distribution of number of fragments per ledger")
    private final OpStatsLogger numFragmentsPerLedger;
    @StatsDoc(name="NUM_BOOKIES_PER_LEDGER", help="the distribution of number of bookies per ledger")
    private final OpStatsLogger numBookiesPerLedger;
    @StatsDoc(name="NUM_BOOKIE_AUDITS_DELAYED", help="the number of bookie-audits delayed")
    private final Counter numBookieAuditsDelayed;
    @StatsDoc(name="NUM_DELAYED_BOOKIE_AUDITS_CANCELLED", help="the number of delayed-bookie-audits cancelled")
    private final Counter numDelayedBookieAuditsCancelled;
    @StatsDoc(name="NUM_REPLICATED_LEDGERS", help="the number of replicated ledgers")
    private final Counter numReplicatedLedgers;
    @StatsDoc(name="NUM_LEDGERS_NOT_ADHERING_TO_PLACEMENT_POLICY", help="Gauge for number of ledgers not adhering to placement policy found in placement policy check")
    private final Gauge<Integer> numLedgersNotAdheringToPlacementPolicy;
    @StatsDoc(name="NUM_LEDGERS_SOFTLY_ADHERING_TO_PLACEMENT_POLICY", help="Gauge for number of ledgers softly adhering to placement policy found in placement policy check")
    private final Gauge<Integer> numLedgersSoftlyAdheringToPlacementPolicy;
    @StatsDoc(name="NUM_UNDERREPLICATED_LEDGERS_ELAPSED_RECOVERY_GRACE_PERIOD", help="Gauge for number of underreplicated ledgers elapsed recovery grace period")
    private final Gauge<Integer> numUnderreplicatedLedgersElapsedRecoveryGracePeriod;
    @StatsDoc(name="NUM_LEDGERS_HAVING_NO_REPLICA_OF_AN_ENTRY", help="Gauge for number of ledgers having an entry with all the replicas missing")
    private final Gauge<Integer> numLedgersHavingNoReplicaOfAnEntry;
    @StatsDoc(name="NUM_LEDGERS_HAVING_LESS_THAN_AQ_REPLICAS_OF_AN_ENTRY", help="Gauge for number of ledgers having an entry with less than AQ number of replicas, this doesn't include ledgers counted towards numLedgersHavingNoReplicaOfAnEntry")
    private final Gauge<Integer> numLedgersHavingLessThanAQReplicasOfAnEntry;
    @StatsDoc(name="NUM_LEDGERS_HAVING_LESS_THAN_WQ_REPLICAS_OF_AN_ENTRY", help="Gauge for number of ledgers having an entry with less than WQ number of replicas, this doesn't include ledgers counted towards numLedgersHavingLessThanAQReplicasOfAnEntry")
    private final Gauge<Integer> numLedgersHavingLessThanWQReplicasOfAnEntry;
    @StatsDoc(name="NUM_UNDER_REPLICATED_LEDGERS_GUAGE", help="Gauge for num of underreplicated ledgers")
    private final Gauge<Integer> numUnderReplicatedLedgers;

    public AuditorStats(StatsLogger statsLogger) {
        this.statsLogger = statsLogger;
        this.ledgersNotAdheringToPlacementPolicyGuageValue = new AtomicInteger(0);
        this.ledgersSoftlyAdheringToPlacementPolicyGuageValue = new AtomicInteger(0);
        this.numOfURLedgersElapsedRecoveryGracePeriodGuageValue = new AtomicInteger(0);
        this.numLedgersHavingNoReplicaOfAnEntryGuageValue = new AtomicInteger(0);
        this.numLedgersHavingLessThanAQReplicasOfAnEntryGuageValue = new AtomicInteger(0);
        this.numLedgersHavingLessThanWQReplicasOfAnEntryGuageValue = new AtomicInteger(0);
        this.underReplicatedLedgersGuageValue = new AtomicInteger(0);
        this.numUnderReplicatedLedger = this.statsLogger.getOpStatsLogger("NUM_UNDER_REPLICATED_LEDGERS");
        this.underReplicatedLedgerTotalSize = this.statsLogger.getOpStatsLogger("UNDER_REPLICATED_LEDGERS_TOTAL_SIZE");
        this.uRLPublishTimeForLostBookies = this.statsLogger.getOpStatsLogger("URL_PUBLISH_TIME_FOR_LOST_BOOKIE");
        this.bookieToLedgersMapCreationTime = this.statsLogger.getOpStatsLogger("BOOKIE_TO_LEDGERS_MAP_CREATION_TIME");
        this.checkAllLedgersTime = this.statsLogger.getOpStatsLogger("CHECK_ALL_LEDGERS_TIME");
        this.placementPolicyCheckTime = this.statsLogger.getOpStatsLogger("PLACEMENT_POLICY_CHECK_TIME");
        this.replicasCheckTime = this.statsLogger.getOpStatsLogger("REPLICAS_CHECK_TIME");
        this.auditBookiesTime = this.statsLogger.getOpStatsLogger("AUDIT_BOOKIES_TIME");
        this.numLedgersChecked = this.statsLogger.getCounter("NUM_LEDGERS_CHECKED");
        this.numFragmentsPerLedger = this.statsLogger.getOpStatsLogger("NUM_FRAGMENTS_PER_LEDGER");
        this.numBookiesPerLedger = this.statsLogger.getOpStatsLogger("NUM_BOOKIES_PER_LEDGER");
        this.numBookieAuditsDelayed = this.statsLogger.getCounter("NUM_BOOKIE_AUDITS_DELAYED");
        this.numDelayedBookieAuditsCancelled = this.statsLogger.getCounter("NUM_DELAYED_BOOKIE_AUDITS_CANCELLED");
        this.numReplicatedLedgers = this.statsLogger.getCounter("NUM_REPLICATED_LEDGERS");
        this.numLedgersNotAdheringToPlacementPolicy = new Gauge<Integer>(){

            public Integer getDefaultValue() {
                return 0;
            }

            public Integer getSample() {
                return AuditorStats.this.ledgersNotAdheringToPlacementPolicyGuageValue.get();
            }
        };
        this.statsLogger.registerGauge("NUM_LEDGERS_NOT_ADHERING_TO_PLACEMENT_POLICY", this.numLedgersNotAdheringToPlacementPolicy);
        this.numLedgersSoftlyAdheringToPlacementPolicy = new Gauge<Integer>(){

            public Integer getDefaultValue() {
                return 0;
            }

            public Integer getSample() {
                return AuditorStats.this.ledgersSoftlyAdheringToPlacementPolicyGuageValue.get();
            }
        };
        this.statsLogger.registerGauge("NUM_LEDGERS_SOFTLY_ADHERING_TO_PLACEMENT_POLICY", this.numLedgersSoftlyAdheringToPlacementPolicy);
        this.numUnderreplicatedLedgersElapsedRecoveryGracePeriod = new Gauge<Integer>(){

            public Integer getDefaultValue() {
                return 0;
            }

            public Integer getSample() {
                return AuditorStats.this.numOfURLedgersElapsedRecoveryGracePeriodGuageValue.get();
            }
        };
        this.statsLogger.registerGauge("NUM_UNDERREPLICATED_LEDGERS_ELAPSED_RECOVERY_GRACE_PERIOD", this.numUnderreplicatedLedgersElapsedRecoveryGracePeriod);
        this.numLedgersHavingNoReplicaOfAnEntry = new Gauge<Integer>(){

            public Integer getDefaultValue() {
                return 0;
            }

            public Integer getSample() {
                return AuditorStats.this.numLedgersHavingNoReplicaOfAnEntryGuageValue.get();
            }
        };
        this.statsLogger.registerGauge("NUM_LEDGERS_HAVING_NO_REPLICA_OF_AN_ENTRY", this.numLedgersHavingNoReplicaOfAnEntry);
        this.numLedgersHavingLessThanAQReplicasOfAnEntry = new Gauge<Integer>(){

            public Integer getDefaultValue() {
                return 0;
            }

            public Integer getSample() {
                return AuditorStats.this.numLedgersHavingLessThanAQReplicasOfAnEntryGuageValue.get();
            }
        };
        this.statsLogger.registerGauge("NUM_LEDGERS_HAVING_LESS_THAN_AQ_REPLICAS_OF_AN_ENTRY", this.numLedgersHavingLessThanAQReplicasOfAnEntry);
        this.numLedgersHavingLessThanWQReplicasOfAnEntry = new Gauge<Integer>(){

            public Integer getDefaultValue() {
                return 0;
            }

            public Integer getSample() {
                return AuditorStats.this.numLedgersHavingLessThanWQReplicasOfAnEntryGuageValue.get();
            }
        };
        this.statsLogger.registerGauge("NUM_LEDGERS_HAVING_LESS_THAN_WQ_REPLICAS_OF_AN_ENTRY", this.numLedgersHavingLessThanWQReplicasOfAnEntry);
        this.numUnderReplicatedLedgers = new Gauge<Integer>(){

            public Integer getDefaultValue() {
                return 0;
            }

            public Integer getSample() {
                return AuditorStats.this.underReplicatedLedgersGuageValue.get();
            }
        };
        this.statsLogger.registerGauge("NUM_UNDER_REPLICATED_LEDGERS_GUAGE", this.numUnderReplicatedLedgers);
    }

    public AtomicInteger getLedgersNotAdheringToPlacementPolicyGuageValue() {
        return this.ledgersNotAdheringToPlacementPolicyGuageValue;
    }

    public AtomicInteger getLedgersSoftlyAdheringToPlacementPolicyGuageValue() {
        return this.ledgersSoftlyAdheringToPlacementPolicyGuageValue;
    }

    public AtomicInteger getNumOfURLedgersElapsedRecoveryGracePeriodGuageValue() {
        return this.numOfURLedgersElapsedRecoveryGracePeriodGuageValue;
    }

    public AtomicInteger getNumLedgersHavingNoReplicaOfAnEntryGuageValue() {
        return this.numLedgersHavingNoReplicaOfAnEntryGuageValue;
    }

    public AtomicInteger getNumLedgersHavingLessThanAQReplicasOfAnEntryGuageValue() {
        return this.numLedgersHavingLessThanAQReplicasOfAnEntryGuageValue;
    }

    public AtomicInteger getNumLedgersHavingLessThanWQReplicasOfAnEntryGuageValue() {
        return this.numLedgersHavingLessThanWQReplicasOfAnEntryGuageValue;
    }

    public AtomicInteger getUnderReplicatedLedgersGuageValue() {
        return this.underReplicatedLedgersGuageValue;
    }

    public StatsLogger getStatsLogger() {
        return this.statsLogger;
    }

    public OpStatsLogger getNumUnderReplicatedLedger() {
        return this.numUnderReplicatedLedger;
    }

    public OpStatsLogger getUnderReplicatedLedgerTotalSize() {
        return this.underReplicatedLedgerTotalSize;
    }

    public OpStatsLogger getURLPublishTimeForLostBookies() {
        return this.uRLPublishTimeForLostBookies;
    }

    public OpStatsLogger getBookieToLedgersMapCreationTime() {
        return this.bookieToLedgersMapCreationTime;
    }

    public OpStatsLogger getCheckAllLedgersTime() {
        return this.checkAllLedgersTime;
    }

    public OpStatsLogger getPlacementPolicyCheckTime() {
        return this.placementPolicyCheckTime;
    }

    public OpStatsLogger getReplicasCheckTime() {
        return this.replicasCheckTime;
    }

    public OpStatsLogger getAuditBookiesTime() {
        return this.auditBookiesTime;
    }

    public Counter getNumLedgersChecked() {
        return this.numLedgersChecked;
    }

    public OpStatsLogger getNumFragmentsPerLedger() {
        return this.numFragmentsPerLedger;
    }

    public OpStatsLogger getNumBookiesPerLedger() {
        return this.numBookiesPerLedger;
    }

    public Counter getNumBookieAuditsDelayed() {
        return this.numBookieAuditsDelayed;
    }

    public Counter getNumDelayedBookieAuditsCancelled() {
        return this.numDelayedBookieAuditsCancelled;
    }

    public Counter getNumReplicatedLedgers() {
        return this.numReplicatedLedgers;
    }

    public Gauge<Integer> getNumLedgersNotAdheringToPlacementPolicy() {
        return this.numLedgersNotAdheringToPlacementPolicy;
    }

    public Gauge<Integer> getNumLedgersSoftlyAdheringToPlacementPolicy() {
        return this.numLedgersSoftlyAdheringToPlacementPolicy;
    }

    public Gauge<Integer> getNumUnderreplicatedLedgersElapsedRecoveryGracePeriod() {
        return this.numUnderreplicatedLedgersElapsedRecoveryGracePeriod;
    }

    public Gauge<Integer> getNumLedgersHavingNoReplicaOfAnEntry() {
        return this.numLedgersHavingNoReplicaOfAnEntry;
    }

    public Gauge<Integer> getNumLedgersHavingLessThanAQReplicasOfAnEntry() {
        return this.numLedgersHavingLessThanAQReplicasOfAnEntry;
    }

    public Gauge<Integer> getNumLedgersHavingLessThanWQReplicasOfAnEntry() {
        return this.numLedgersHavingLessThanWQReplicasOfAnEntry;
    }

    public Gauge<Integer> getNumUnderReplicatedLedgers() {
        return this.numUnderReplicatedLedgers;
    }
}

