/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.checksum;

import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBuf;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBufAllocator;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.checksum.DigestManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacDigestManager
extends DigestManager {
    private static final Logger LOG = LoggerFactory.getLogger(MacDigestManager.class);
    public static final String DIGEST_ALGORITHM = "SHA-1";
    public static final String KEY_ALGORITHM = "HmacSHA1";
    public static final int MAC_CODE_LENGTH = 20;
    final byte[] passwd;
    static final byte[] EMPTY_LEDGER_KEY;
    private final ThreadLocal<Mac> mac = new ThreadLocal<Mac>(){

        @Override
        protected Mac initialValue() {
            try {
                byte[] macKey = MacDigestManager.genDigest("mac", MacDigestManager.this.passwd);
                SecretKeySpec keySpec = new SecretKeySpec(macKey, MacDigestManager.KEY_ALGORITHM);
                Mac mac = Mac.getInstance(MacDigestManager.KEY_ALGORITHM);
                mac.init(keySpec);
                return mac;
            }
            catch (GeneralSecurityException gse) {
                LOG.error("Couldn't not get mac instance", (Throwable)gse);
                return null;
            }
        }
    };

    public MacDigestManager(long ledgerId, byte[] passwd, boolean useV2Protocol, ByteBufAllocator allocator) throws GeneralSecurityException {
        super(ledgerId, useV2Protocol, allocator);
        this.passwd = Arrays.copyOf(passwd, passwd.length);
    }

    public static byte[] genDigest(String pad, byte[] passwd) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(DIGEST_ALGORITHM);
        digest.update(pad.getBytes(StandardCharsets.UTF_8));
        digest.update(passwd);
        return digest.digest();
    }

    @Override
    int getMacCodeLength() {
        return 20;
    }

    @Override
    void populateValueAndReset(int digest, ByteBuf buffer) {
        buffer.writeBytes(this.mac.get().doFinal());
    }

    @Override
    int update(int digest, ByteBuf data, int offset, int len) {
        this.mac.get().update(data.slice(offset, len).nioBuffer());
        return 0;
    }

    @Override
    boolean isInt32Digest() {
        return false;
    }

    static {
        try {
            EMPTY_LEDGER_KEY = MacDigestManager.genDigest("ledger", new byte[0]);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

