/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.math.Quantiles;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.WeightedRandomSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DynamicWeightedRandomSelectionImpl<T>
implements WeightedRandomSelection<T> {
    static final Logger LOG = LoggerFactory.getLogger(DynamicWeightedRandomSelectionImpl.class);
    int maxProbabilityMultiplier;
    final Map<T, WeightedRandomSelection.WeightedObject> weightMap;
    final ReadWriteLock rwLock = new ReentrantReadWriteLock(true);
    Random rand;

    DynamicWeightedRandomSelectionImpl() {
        this(-1);
    }

    DynamicWeightedRandomSelectionImpl(int maxMultiplier) {
        this.maxProbabilityMultiplier = maxMultiplier;
        this.weightMap = new HashMap<T, WeightedRandomSelection.WeightedObject>();
        this.rand = new Random(System.currentTimeMillis());
    }

    @Override
    public void updateMap(Map<T, WeightedRandomSelection.WeightedObject> updatedMap) {
        this.rwLock.writeLock().lock();
        try {
            this.weightMap.clear();
            this.weightMap.putAll(updatedMap);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public T getNextRandom() {
        this.rwLock.readLock().lock();
        try {
            T t = this.getNextRandom(this.weightMap.keySet());
            return t;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getNextRandom(Collection<T> selectedNodes) {
        this.rwLock.readLock().lock();
        try {
            long medianWeight;
            long minWeight = Long.MAX_VALUE;
            long actTotalWeight = 0L;
            for (T node2 : selectedNodes) {
                long weight = 0L;
                if (this.weightMap.containsKey(node2)) {
                    weight = this.weightMap.get(node2).getWeight();
                }
                actTotalWeight += weight;
                if (weight <= 0L || minWeight <= weight) continue;
                minWeight = weight;
            }
            if (actTotalWeight == 0L) {
                minWeight = 1L;
                medianWeight = 1L;
            } else {
                Function<Object, Long> weightFunc = node -> {
                    long weight = 0L;
                    if (this.weightMap.containsKey(node)) {
                        weight = this.weightMap.get(node).getWeight();
                    }
                    return weight;
                };
                ArrayList weightList = selectedNodes.stream().map(weightFunc).collect(Collectors.toCollection(ArrayList::new));
                Quantiles.ScaleAndIndex median = Quantiles.median();
                medianWeight = (long)median.compute(weightList);
            }
            long maxWeight = (long)this.maxProbabilityMultiplier * medianWeight;
            long cumTotalWeight = 0L;
            Object nextRandomNode = null;
            for (T node3 : selectedNodes) {
                long randValue;
                long weight = 0L;
                if (this.weightMap.containsKey(node3)) {
                    weight = this.weightMap.get(node3).getWeight();
                }
                if (weight <= 0L) {
                    weight = minWeight;
                } else if (maxWeight > 0L && weight > maxWeight) {
                    weight = maxWeight;
                }
                long tmpRandLong = this.rand.nextLong();
                if (tmpRandLong == Long.MIN_VALUE) {
                    ++tmpRandLong;
                }
                if ((randValue = Math.abs(tmpRandLong) % (cumTotalWeight + weight)) >= cumTotalWeight) {
                    nextRandomNode = node3;
                }
                cumTotalWeight += weight;
            }
            Iterator<T> iterator = nextRandomNode;
            return (T)iterator;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Override
    public void setMaxProbabilityMultiplier(int max) {
        this.maxProbabilityMultiplier = max;
    }
}

