/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.net.jodah.failsafe;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.pulsar.functions.runtime.shaded.net.jodah.failsafe.ExecutionContext;
import org.apache.pulsar.functions.runtime.shaded.net.jodah.failsafe.ExecutionResult;
import org.apache.pulsar.functions.runtime.shaded.net.jodah.failsafe.FailsafeExecutor;
import org.apache.pulsar.functions.runtime.shaded.net.jodah.failsafe.Policy;
import org.apache.pulsar.functions.runtime.shaded.net.jodah.failsafe.PolicyExecutor;
import org.apache.pulsar.functions.runtime.shaded.net.jodah.failsafe.internal.util.Assert;
import org.apache.pulsar.functions.runtime.shaded.net.jodah.failsafe.util.concurrent.Scheduler;

public abstract class AbstractExecution<R>
extends ExecutionContext<R> {
    final Scheduler scheduler;
    final FailsafeExecutor<R> executor;
    final List<PolicyExecutor<R, Policy<R>>> policyExecutors;
    volatile boolean inProgress;
    volatile boolean attemptRecorded;
    volatile boolean resultHandled;
    volatile boolean canInterrupt;
    volatile boolean interrupted;
    volatile long waitNanos;
    volatile boolean completed;

    AbstractExecution(Scheduler scheduler, FailsafeExecutor<R> executor) {
        this.scheduler = scheduler;
        this.executor = executor;
        this.policyExecutors = new ArrayList<PolicyExecutor<R, Policy<R>>>(executor.policies.size());
        ListIterator policyIterator = executor.policies.listIterator(executor.policies.size());
        int i = 1;
        while (policyIterator.hasPrevious()) {
            PolicyExecutor policyExecutor = policyIterator.previous().toExecutor(this);
            policyExecutor.policyIndex = i++;
            this.policyExecutors.add(policyExecutor);
        }
    }

    void record(ExecutionResult result) {
        this.record(result, false);
    }

    void record(ExecutionResult result, boolean timeout) {
        Assert.state(!this.completed, "Execution has already been completed", new Object[0]);
        if (!this.interrupted) {
            this.recordAttempt();
            if (this.inProgress) {
                this.lastResult = result.getResult();
                this.lastFailure = result.getFailure();
                this.executions.incrementAndGet();
                if (!timeout) {
                    this.inProgress = false;
                }
            }
        }
    }

    void recordAttempt() {
        if (!this.attemptRecorded) {
            this.attempts.incrementAndGet();
            this.attemptRecorded = true;
        }
    }

    synchronized void preExecute() {
        this.attemptStartTime = Duration.ofNanos(System.nanoTime());
        if (this.startTime == Duration.ZERO) {
            this.startTime = this.attemptStartTime;
        }
        this.inProgress = true;
        this.attemptRecorded = false;
        this.resultHandled = false;
        this.cancelledIndex = 0;
        this.canInterrupt = true;
        this.interrupted = false;
    }

    boolean isAsyncExecution() {
        return false;
    }

    synchronized ExecutionResult postExecute(ExecutionResult result) {
        this.record(result);
        boolean allComplete = true;
        for (PolicyExecutor<R, Policy<R>> policyExecutor : this.policyExecutors) {
            result = policyExecutor.postExecute(result);
            allComplete = allComplete && result.isComplete();
        }
        this.waitNanos = result.getWaitNanos();
        this.completed = allComplete;
        return result;
    }

    public Duration getWaitTime() {
        return Duration.ofNanos(this.waitNanos);
    }

    public boolean isComplete() {
        return this.completed;
    }
}

