/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.com.google.re2j;

import java.util.Arrays;
import java.util.Map;
import org.apache.pulsar.functions.runtime.shaded.com.google.re2j.Utils;

class Regexp {
    static final Regexp[] EMPTY_SUBS = new Regexp[0];
    Op op;
    int flags;
    Regexp[] subs;
    int[] runes;
    int min;
    int max;
    int cap;
    String name;
    Map<String, Integer> namedGroups;

    Regexp(Op op) {
        this.op = op;
    }

    Regexp(Regexp that) {
        this.op = that.op;
        this.flags = that.flags;
        this.subs = that.subs;
        this.runes = that.runes;
        this.min = that.min;
        this.max = that.max;
        this.cap = that.cap;
        this.name = that.name;
        this.namedGroups = that.namedGroups;
    }

    void reinit() {
        this.flags = 0;
        this.subs = EMPTY_SUBS;
        this.runes = null;
        this.max = 0;
        this.min = 0;
        this.cap = 0;
        this.name = null;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        this.appendTo(out);
        return out.toString();
    }

    private static void quoteIfHyphen(StringBuilder out, int rune) {
        if (rune == 45) {
            out.append('\\');
        }
    }

    private void appendTo(StringBuilder out) {
        switch (this.op) {
            case NO_MATCH: {
                out.append("[^\\x00-\\x{10FFFF}]");
                break;
            }
            case EMPTY_MATCH: {
                out.append("(?:)");
                break;
            }
            case STAR: 
            case PLUS: 
            case QUEST: 
            case REPEAT: {
                Regexp sub = this.subs[0];
                if (sub.op.ordinal() > Op.CAPTURE.ordinal() || sub.op == Op.LITERAL && sub.runes.length > 1) {
                    out.append("(?:");
                    sub.appendTo(out);
                    out.append(')');
                } else {
                    sub.appendTo(out);
                }
                switch (this.op) {
                    case STAR: {
                        out.append('*');
                        break;
                    }
                    case PLUS: {
                        out.append('+');
                        break;
                    }
                    case QUEST: {
                        out.append('?');
                        break;
                    }
                    case REPEAT: {
                        out.append('{').append(this.min);
                        if (this.min != this.max) {
                            out.append(',');
                            if (this.max >= 0) {
                                out.append(this.max);
                            }
                        }
                        out.append('}');
                    }
                }
                if ((this.flags & 0x20) == 0) break;
                out.append('?');
                break;
            }
            case CONCAT: {
                for (Regexp sub : this.subs) {
                    if (sub.op == Op.ALTERNATE) {
                        out.append("(?:");
                        sub.appendTo(out);
                        out.append(')');
                        continue;
                    }
                    sub.appendTo(out);
                }
                break;
            }
            case ALTERNATE: {
                String sep = "";
                for (Regexp sub : this.subs) {
                    out.append(sep);
                    sep = "|";
                    sub.appendTo(out);
                }
                break;
            }
            case LITERAL: {
                if ((this.flags & 1) != 0) {
                    out.append("(?i:");
                }
                for (int rune : this.runes) {
                    Utils.escapeRune(out, rune);
                }
                if ((this.flags & 1) == 0) break;
                out.append(')');
                break;
            }
            case ANY_CHAR_NOT_NL: {
                out.append("(?-s:.)");
                break;
            }
            case ANY_CHAR: {
                out.append("(?s:.)");
                break;
            }
            case CAPTURE: {
                if (this.name == null || this.name.isEmpty()) {
                    out.append('(');
                } else {
                    out.append("(?P<");
                    out.append(this.name);
                    out.append(">");
                }
                if (this.subs[0].op != Op.EMPTY_MATCH) {
                    this.subs[0].appendTo(out);
                }
                out.append(')');
                break;
            }
            case BEGIN_TEXT: {
                out.append("\\A");
                break;
            }
            case END_TEXT: {
                if ((this.flags & 0x100) != 0) {
                    out.append("(?-m:$)");
                    break;
                }
                out.append("\\z");
                break;
            }
            case BEGIN_LINE: {
                out.append('^');
                break;
            }
            case END_LINE: {
                out.append('$');
                break;
            }
            case WORD_BOUNDARY: {
                out.append("\\b");
                break;
            }
            case NO_WORD_BOUNDARY: {
                out.append("\\B");
                break;
            }
            case CHAR_CLASS: {
                if (this.runes.length % 2 != 0) {
                    out.append("[invalid char class]");
                    break;
                }
                out.append('[');
                if (this.runes.length == 0) {
                    out.append("^\\x00-\\x{10FFFF}");
                } else if (this.runes[0] == 0 && this.runes[this.runes.length - 1] == 0x10FFFF) {
                    out.append('^');
                    for (int i = 1; i < this.runes.length - 1; i += 2) {
                        int lo = this.runes[i] + 1;
                        int hi = this.runes[i + 1] - 1;
                        Regexp.quoteIfHyphen(out, lo);
                        Utils.escapeRune(out, lo);
                        if (lo == hi) continue;
                        out.append('-');
                        Regexp.quoteIfHyphen(out, hi);
                        Utils.escapeRune(out, hi);
                    }
                } else {
                    for (int i = 0; i < this.runes.length; i += 2) {
                        int lo = this.runes[i];
                        int hi = this.runes[i + 1];
                        Regexp.quoteIfHyphen(out, lo);
                        Utils.escapeRune(out, lo);
                        if (lo == hi) continue;
                        out.append('-');
                        Regexp.quoteIfHyphen(out, hi);
                        Utils.escapeRune(out, hi);
                    }
                }
                out.append(']');
                break;
            }
            default: {
                out.append((Object)this.op);
            }
        }
    }

    int maxCap() {
        int m = 0;
        if (this.op == Op.CAPTURE) {
            m = this.cap;
        }
        if (this.subs != null) {
            for (Regexp sub : this.subs) {
                int n = sub.maxCap();
                if (m >= n) continue;
                m = n;
            }
        }
        return m;
    }

    public int hashCode() {
        int hashcode = this.op.hashCode();
        switch (this.op) {
            case END_TEXT: {
                hashcode += 31 * (this.flags & 0x100);
                break;
            }
            case LITERAL: 
            case CHAR_CLASS: {
                hashcode += 31 * Arrays.hashCode(this.runes);
                break;
            }
            case CONCAT: 
            case ALTERNATE: {
                hashcode += 31 * Arrays.deepHashCode(this.subs);
                break;
            }
            case STAR: 
            case PLUS: 
            case QUEST: {
                hashcode += 31 * (this.flags & 0x20) + 31 * this.subs[0].hashCode();
                break;
            }
            case REPEAT: {
                hashcode += 31 * this.min + 31 * this.max + 31 * this.subs[0].hashCode();
                break;
            }
            case CAPTURE: {
                hashcode += 31 * this.cap + 31 * (this.name != null ? this.name.hashCode() : 0) + 31 * this.subs[0].hashCode();
            }
        }
        return hashcode;
    }

    public boolean equals(Object that) {
        if (!(that instanceof Regexp)) {
            return false;
        }
        Regexp x = this;
        Regexp y = (Regexp)that;
        if (x.op != y.op) {
            return false;
        }
        switch (x.op) {
            case END_TEXT: {
                if ((x.flags & 0x100) == (y.flags & 0x100)) break;
                return false;
            }
            case LITERAL: 
            case CHAR_CLASS: {
                if (Arrays.equals(x.runes, y.runes)) break;
                return false;
            }
            case CONCAT: 
            case ALTERNATE: {
                if (x.subs.length != y.subs.length) {
                    return false;
                }
                for (int i = 0; i < x.subs.length; ++i) {
                    if (x.subs[i].equals(y.subs[i])) continue;
                    return false;
                }
                break;
            }
            case STAR: 
            case PLUS: 
            case QUEST: {
                if ((x.flags & 0x20) == (y.flags & 0x20) && x.subs[0].equals(y.subs[0])) break;
                return false;
            }
            case REPEAT: {
                if ((x.flags & 0x20) == (y.flags & 0x20) && x.min == y.min && x.max == y.max && x.subs[0].equals(y.subs[0])) break;
                return false;
            }
            case CAPTURE: {
                if (x.cap == y.cap && !(x.name != null ? !x.name.equals(y.name) : y.name != null) && x.subs[0].equals(y.subs[0])) break;
                return false;
            }
        }
        return true;
    }

    static enum Op {
        NO_MATCH,
        EMPTY_MATCH,
        LITERAL,
        CHAR_CLASS,
        ANY_CHAR_NOT_NL,
        ANY_CHAR,
        BEGIN_LINE,
        END_LINE,
        BEGIN_TEXT,
        END_TEXT,
        WORD_BOUNDARY,
        NO_WORD_BOUNDARY,
        CAPTURE,
        STAR,
        PLUS,
        QUEST,
        REPEAT,
        CONCAT,
        ALTERNATE,
        LEFT_PAREN,
        VERTICAL_BAR;


        boolean isPseudo() {
            return this.ordinal() >= LEFT_PAREN.ordinal();
        }
    }
}

