/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.impl.schema.AbstractSchema;
import org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBuf;

public class ShortSchema
extends AbstractSchema<Short> {
    private static final ShortSchema INSTANCE;
    private static final SchemaInfo SCHEMA_INFO;

    public static ShortSchema of() {
        return INSTANCE;
    }

    @Override
    public void validate(byte[] message) {
        if (message.length != 2) {
            throw new SchemaSerializationException("Size of data received by ShortSchema is not 2");
        }
    }

    @Override
    public void validate(ByteBuf message) {
        if (message.readableBytes() != 2) {
            throw new SchemaSerializationException("Size of data received by ShortSchema is not 2");
        }
    }

    @Override
    public byte[] encode(Short message) {
        if (null == message) {
            return null;
        }
        return new byte[]{(byte)(message >>> 8), message.byteValue()};
    }

    @Override
    public Short decode(byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        this.validate(bytes);
        short value = 0;
        for (byte b : bytes) {
            value = (short)(value << 8);
            value = (short)(value | b & 0xFF);
        }
        return value;
    }

    @Override
    public Short decode(ByteBuf byteBuf) {
        if (null == byteBuf) {
            return null;
        }
        this.validate(byteBuf);
        short value = 0;
        for (int i = 0; i < 2; ++i) {
            value = (short)(value << 8);
            value = (short)(value | byteBuf.getByte(i) & 0xFF);
        }
        return value;
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        return SCHEMA_INFO;
    }

    static {
        SCHEMA_INFO = SchemaInfoImpl.builder().name("INT16").type(SchemaType.INT16).schema(new byte[0]).build();
        INSTANCE = new ShortSchema();
    }
}

