/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.net.ConnectException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.common.policies.data.ErrorData;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.functions.runtime.shaded.javax.ws.rs.ClientErrorException;
import org.apache.pulsar.functions.runtime.shaded.javax.ws.rs.ServerErrorException;
import org.apache.pulsar.functions.runtime.shaded.javax.ws.rs.ServiceUnavailableException;
import org.apache.pulsar.functions.runtime.shaded.javax.ws.rs.WebApplicationException;
import org.apache.pulsar.functions.runtime.shaded.javax.ws.rs.client.Entity;
import org.apache.pulsar.functions.runtime.shaded.javax.ws.rs.client.Invocation;
import org.apache.pulsar.functions.runtime.shaded.javax.ws.rs.client.InvocationCallback;
import org.apache.pulsar.functions.runtime.shaded.javax.ws.rs.client.WebTarget;
import org.apache.pulsar.functions.runtime.shaded.javax.ws.rs.core.GenericType;
import org.apache.pulsar.functions.runtime.shaded.javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseResource {
    private static final Logger log = LoggerFactory.getLogger(BaseResource.class);
    protected final Authentication auth;
    protected final long readTimeoutMs;

    protected BaseResource(Authentication auth, long readTimeoutMs) {
        this.auth = auth;
        this.readTimeoutMs = readTimeoutMs;
    }

    public Invocation.Builder request(WebTarget target) throws PulsarAdminException {
        try {
            return this.requestAsync(target).get();
        }
        catch (Exception e) {
            throw new PulsarAdminException.GettingAuthenticationDataException(e);
        }
    }

    public CompletableFuture<Invocation.Builder> requestAsync(WebTarget target) {
        CompletableFuture<Invocation.Builder> builderFuture = new CompletableFuture<Invocation.Builder>();
        CompletableFuture<Map<String, String>> authFuture = new CompletableFuture<Map<String, String>>();
        try {
            AuthenticationDataProvider authData = this.auth.getAuthData(target.getUri().getHost());
            if (authData.hasDataForHttp()) {
                this.auth.authenticationStage(target.getUri().toString(), authData, null, authFuture);
            } else {
                authFuture.complete(null);
            }
            authFuture.whenComplete((respHeaders, ex) -> {
                if (ex != null) {
                    log.warn("[{}] Failed to perform http request at auth stage: {}", (Object)target.getUri(), (Object)ex.getMessage());
                    builderFuture.completeExceptionally(new PulsarClientException((Throwable)ex));
                    return;
                }
                try {
                    Set<Map.Entry<String, String>> headers;
                    Invocation.Builder builder = target.request("application/json");
                    if (authData.hasDataForHttp() && (headers = this.auth.newRequestHeader(target.getUri().toString(), authData, (Map<String, String>)respHeaders)) != null) {
                        headers.forEach(entry -> builder.header((String)entry.getKey(), entry.getValue()));
                    }
                    builderFuture.complete(builder);
                }
                catch (Throwable t) {
                    builderFuture.completeExceptionally(new PulsarAdminException.GettingAuthenticationDataException(t));
                }
            });
        }
        catch (Throwable t) {
            builderFuture.completeExceptionally(new PulsarAdminException.GettingAuthenticationDataException(t));
        }
        return builderFuture;
    }

    public <T> CompletableFuture<Void> asyncPutRequest(final WebTarget target, Entity<T> entity) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            this.request(target).async().put(entity, new InvocationCallback<ErrorData>(){

                @Override
                public void completed(ErrorData response) {
                    future.complete(null);
                }

                @Override
                public void failed(Throwable throwable) {
                    log.warn("[{}] Failed to perform http put request: {}", (Object)target.getUri(), (Object)throwable.getMessage());
                    future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
                }
            });
        }
        catch (PulsarAdminException cae) {
            future.completeExceptionally(cae);
        }
        return future;
    }

    public <T, R> void asyncPostRequestWithResponse(WebTarget target, Entity<T> entity, InvocationCallback<R> callback) {
        try {
            this.request(target).async().post(entity, callback);
        }
        catch (PulsarAdminException cae) {
            callback.failed(cae);
        }
    }

    public <T> CompletableFuture<Void> asyncPostRequest(final WebTarget target, Entity<T> entity) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            this.request(target).async().post(entity, new InvocationCallback<ErrorData>(){

                @Override
                public void completed(ErrorData response) {
                    future.complete(null);
                }

                @Override
                public void failed(Throwable throwable) {
                    log.warn("[{}] Failed to perform http post request: {}", (Object)target.getUri(), (Object)throwable.getMessage());
                    future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
                }
            });
        }
        catch (PulsarAdminException cae) {
            future.completeExceptionally(cae);
        }
        return future;
    }

    public <T> void asyncGetRequest(WebTarget target, InvocationCallback<T> callback) {
        try {
            this.request(target).async().get(callback);
        }
        catch (PulsarAdminException cae) {
            callback.failed(cae);
        }
    }

    public <T> CompletableFuture<T> asyncGetRequest(WebTarget target, FutureCallback<T> callback) {
        this.asyncGetRequest(target, (InvocationCallback<T>)callback);
        return callback.future();
    }

    protected <T> CompletableFuture<T> asyncGetRequest(WebTarget target, Class<? extends T> type) {
        return this.asyncGetRequest(target, (Response response) -> response.readEntity(type));
    }

    protected <T> CompletableFuture<T> asyncGetRequest(WebTarget target, GenericType<T> type) {
        return this.asyncGetRequest(target, (Response response) -> response.readEntity(type));
    }

    private <T> CompletableFuture<T> asyncGetRequest(WebTarget target, final Function<Response, T> readResponse) {
        final CompletableFuture future = new CompletableFuture();
        this.asyncGetRequest(target, new InvocationCallback<Response>(){

            @Override
            public void completed(Response response) {
                if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                    future.completeExceptionally(BaseResource.this.getApiException(response));
                } else {
                    try {
                        future.complete(readResponse.apply(response));
                    }
                    catch (Exception e) {
                        future.completeExceptionally(BaseResource.getApiException(e));
                    }
                }
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public CompletableFuture<Void> asyncDeleteRequest(final WebTarget target) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            this.request(target).async().delete(new InvocationCallback<ErrorData>(){

                @Override
                public void completed(ErrorData response) {
                    future.complete(null);
                }

                @Override
                public void failed(Throwable throwable) {
                    log.warn("[{}] Failed to perform http delete request: {}", (Object)target.getUri(), (Object)throwable.getMessage());
                    future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
                }
            });
        }
        catch (PulsarAdminException cae) {
            future.completeExceptionally(cae);
        }
        return future;
    }

    public <T> void asyncDeleteRequest(WebTarget target, InvocationCallback<T> callback) {
        try {
            this.request(target).async().delete(callback);
        }
        catch (PulsarAdminException cae) {
            callback.failed(cae);
        }
    }

    public static PulsarAdminException getApiException(Throwable e) {
        if (e instanceof PulsarAdminException) {
            return (PulsarAdminException)e;
        }
        if (e instanceof ServiceUnavailableException) {
            if (e.getCause() instanceof ConnectException) {
                return new PulsarAdminException.ConnectException(e.getCause());
            }
            ServerErrorException see = (ServerErrorException)e;
            int statusCode = see.getResponse().getStatus();
            String httpError = BaseResource.getReasonFromServer(see);
            return new PulsarAdminException(e, httpError, statusCode);
        }
        if (e instanceof WebApplicationException) {
            if (e instanceof ServerErrorException) {
                ServerErrorException see = (ServerErrorException)e;
                int statusCode = see.getResponse().getStatus();
                String httpError = BaseResource.getReasonFromServer(see);
                return new PulsarAdminException.ServerSideErrorException(see, httpError, httpError, statusCode);
            }
            if (e instanceof ClientErrorException) {
                ClientErrorException cee = (ClientErrorException)e;
                int statusCode = cee.getResponse().getStatus();
                String httpError = BaseResource.getReasonFromServer(cee);
                switch (statusCode) {
                    case 401: 
                    case 403: {
                        return new PulsarAdminException.NotAuthorizedException(cee, httpError, statusCode);
                    }
                    case 404: {
                        return new PulsarAdminException.NotFoundException(cee, httpError, statusCode);
                    }
                    case 405: {
                        return new PulsarAdminException.NotAllowedException(cee, httpError, statusCode);
                    }
                    case 409: {
                        return new PulsarAdminException.ConflictException(cee, httpError, statusCode);
                    }
                    case 412: {
                        return new PulsarAdminException.PreconditionFailedException(cee, httpError, statusCode);
                    }
                }
                return new PulsarAdminException(httpError, (Throwable)cee, httpError, statusCode);
            }
            WebApplicationException wae = (WebApplicationException)e;
            int statusCode = wae.getResponse().getStatus();
            String httpError = BaseResource.getReasonFromServer(wae);
            return new PulsarAdminException(httpError, (Throwable)wae, httpError, statusCode);
        }
        return new PulsarAdminException(e);
    }

    public PulsarAdminException getApiException(Response response) {
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return null;
        }
        try {
            if (response.getStatus() >= 500) {
                throw new ServerErrorException(response);
            }
            if (response.getStatus() >= 400) {
                throw new ClientErrorException(response);
            }
            throw new WebApplicationException(response);
        }
        catch (Exception e) {
            return BaseResource.getApiException(e);
        }
    }

    public static String getReasonFromServer(WebApplicationException e) {
        try {
            return e.getResponse().readEntity(ErrorData.class).reason.toString();
        }
        catch (Exception ex) {
            try {
                return ObjectMapperFactory.getMapper().reader().readValue((String)e.getResponse().getEntity().toString(), ErrorData.class).reason;
            }
            catch (Exception ex1) {
                try {
                    return ObjectMapperFactory.getMapper().reader().readValue((String)e.getMessage(), ErrorData.class).reason;
                }
                catch (Exception ex2) {
                    return e.getMessage();
                }
            }
        }
    }

    protected <T> T sync(Supplier<CompletableFuture<T>> executor) throws PulsarAdminException {
        try {
            return executor.get().get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
        catch (ExecutionException e) {
            throw PulsarAdminException.wrap(BaseResource.getApiException(e.getCause()));
        }
        catch (Exception e) {
            throw PulsarAdminException.wrap(BaseResource.getApiException(e));
        }
    }

    static abstract class FutureCallback<T>
    implements InvocationCallback<T> {
        private final CompletableFuture<T> future = new CompletableFuture();

        FutureCallback() {
        }

        @Override
        public void completed(T value) {
            this.future.complete(value);
        }

        @Override
        public void failed(Throwable throwable) {
            this.future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
        }

        public CompletableFuture<T> future() {
            return this.future;
        }
    }
}

