/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.cli.commands.client;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.functions.runtime.shaded.com.beust.jcommander.Parameter;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.api.BookKeeper;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.api.DigestType;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.api.WriteHandle;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.cli.helpers.ClientCommand;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.framework.CliSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTestCommand
extends ClientCommand<Flags> {
    private static final String NAME = "simpletest";
    private static final String DESC = "Simple test to create a ledger and write entries to it.";
    private static final Logger LOG = LoggerFactory.getLogger(SimpleTestCommand.class);

    public SimpleTestCommand() {
        this(new Flags());
    }

    public SimpleTestCommand(Flags flags) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags(flags).build());
    }

    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    protected void run(BookKeeper bk, Flags flags) throws Exception {
        byte[] data = new byte[100];
        try (WriteHandle wh = (WriteHandle)FutureUtils.result(bk.newCreateLedgerOp().withEnsembleSize(flags.ensembleSize).withWriteQuorumSize(flags.writeQuorumSize).withAckQuorumSize(flags.ackQuorumSize).withDigestType(DigestType.CRC32C).withPassword(new byte[0]).execute());){
            LOG.info("Ledger ID: {}", (Object)wh.getId());
            long lastReport = System.nanoTime();
            for (int i = 0; i < flags.numEntries; ++i) {
                wh.append(data);
                if (TimeUnit.SECONDS.convert(System.nanoTime() - lastReport, TimeUnit.NANOSECONDS) <= 1L) continue;
                LOG.info("{} entries written", (Object)i);
                lastReport = System.nanoTime();
            }
            LOG.info("{} entries written to ledger {}", (Object)flags.numEntries, (Object)wh.getId());
        }
    }

    public static class Flags
    extends CliFlags {
        @Parameter(names={"-e", "--ensemble-size"}, description="Ensemble size (default 3)")
        private int ensembleSize = 3;
        @Parameter(names={"-w", "--write-quorum-size"}, description="Write quorum size (default 2)")
        private int writeQuorumSize = 2;
        @Parameter(names={"-a", "--ack-quorum-size"}, description="Ack quorum size (default 2)")
        private int ackQuorumSize = 2;
        @Parameter(names={"-n", "--num-entries"}, description="Entries to write (default 100)")
        private int numEntries = 100;

        public Flags ensembleSize(int ensembleSize) {
            this.ensembleSize = ensembleSize;
            return this;
        }

        public Flags writeQuorumSize(int writeQuorumSize) {
            this.writeQuorumSize = writeQuorumSize;
            return this;
        }

        public Flags ackQuorumSize(int ackQuorumSize) {
            this.ackQuorumSize = ackQuorumSize;
            return this;
        }

        public Flags numEntries(int numEntries) {
            this.numEntries = numEntries;
            return this;
        }
    }
}

