/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.server.service;

import java.io.IOException;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Preconditions;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.component.ComponentInfoPublisher;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.http.HttpServer;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.http.HttpServerConfiguration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.http.HttpServerLoader;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.http.HttpServiceProvider;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.server.component.ServerLifecycleComponent;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.server.conf.BookieConfiguration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.server.http.BKHttpServiceProvider;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.StatsLogger;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.configuration.Configuration;

public class HttpService
extends ServerLifecycleComponent {
    public static final String NAME = "http-service";
    private HttpServer server;

    public HttpService(BKHttpServiceProvider provider, BookieConfiguration conf, StatsLogger statsLogger) {
        super(NAME, conf, statsLogger);
        HttpServerLoader.loadHttpServer((Configuration)conf.getServerConf());
        this.server = HttpServerLoader.get();
        Preconditions.checkNotNull(this.server, "httpServerClass is not configured or it could not be started, please check your configuration and logs");
        this.server.initialize((HttpServiceProvider)provider);
    }

    @Override
    protected void doStart() {
        ServerConfiguration serverConf = ((BookieConfiguration)this.conf).getServerConf();
        HttpServerConfiguration tlsOption = new HttpServerConfiguration(serverConf.isHttpServerTlsEnable(), serverConf.getHttpServerKeystorePath(), serverConf.getHttpServerKeystorePassword(), serverConf.getHttpServerTrustStorePath(), serverConf.getHttpServerTrustStorePassword());
        this.server.startServer(serverConf.getHttpServerPort(), serverConf.getHttpServerHost(), tlsOption);
    }

    @Override
    protected void doStop() {
    }

    @Override
    protected void doClose() throws IOException {
        this.server.stopServer();
    }

    @Override
    public void publishInfo(ComponentInfoPublisher componentInfoPublisher) {
        if (((BookieConfiguration)this.conf).getServerConf().isHttpServerEnabled()) {
            ComponentInfoPublisher.EndpointInfo endpoint = new ComponentInfoPublisher.EndpointInfo("httpserver", ((BookieConfiguration)this.conf).getServerConf().getHttpServerPort(), "0.0.0.0", "http", null, null);
            componentInfoPublisher.publishEndpoint(endpoint);
        }
    }
}

