/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.server;

import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Preconditions;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Ticker;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.BookieResources;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.LegacyCookieValidation;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.ReadOnlyBookie;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.UncleanShutdownDetectionImpl;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.datainteg.DataIntegrityCheckImpl;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.datainteg.DataIntegrityCookieValidation;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.datainteg.DataIntegrityService;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.datainteg.EntryCopierImpl;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.BookKeeper;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.allocator.ByteBufAllocatorWithOomHandler;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.component.AutoCloseableLifecycleComponent;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.component.ComponentInfoPublisher;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.component.ComponentStarter;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.component.LifecycleComponentStack;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.component.RxSchedulerLifecycleComponent;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.conf.UncheckedConfigurationException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.discover.BookieServiceInfo;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.LedgerManager;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.MetadataBookieDriver;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.net.BookieId;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.server.component.ServerLifecycleComponent;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.server.conf.BookieConfiguration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.server.http.BKHttpServiceProvider;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.server.service.AutoRecoveryService;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.server.service.BookieService;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.server.service.HttpService;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.server.service.ScrubberService;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.server.service.StatsProviderService;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.StatsLogger;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.util.DiskChecker;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.cli.BasicParser;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.cli.CommandLine;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.cli.HelpFormatter;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.cli.Option;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.cli.Options;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.cli.ParseException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.configuration.ConfigurationException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    static final Options BK_OPTS = new Options();

    private static void printUsage() {
        HelpFormatter hf = new HelpFormatter();
        String header = "\nBookieServer provide an interface to start a bookie with configuration file and/or arguments.The settings in configuration file will be overwrite by provided arguments.\nOptions including:\n";
        String footer = "Here is an example:\n\tBookieServer -c bookie.conf -z localhost:2181 -m /bookkeeper/ledgers -p 3181 -j /mnt/journal -i \"/mnt/index1 /mnt/index2\" -l \"/mnt/ledger1 /mnt/ledger2 /mnt/ledger3\"\n";
        hf.printHelp("BookieServer [options]\n", header, BK_OPTS, footer, true);
    }

    private static void loadConfFile(ServerConfiguration conf, String confFile) throws IllegalArgumentException {
        try {
            conf.loadConf(new File(confFile).toURI().toURL());
            conf.validate();
        }
        catch (MalformedURLException e) {
            log.error("Could not open configuration file: {}", (Object)confFile, (Object)e);
            throw new IllegalArgumentException();
        }
        catch (ConfigurationException e) {
            log.error("Malformed configuration file: {}", (Object)confFile, (Object)e);
            throw new IllegalArgumentException();
        }
        log.info("Using configuration file {}", (Object)confFile);
    }

    private static ServerConfiguration parseArgs(String[] args) throws IllegalArgumentException {
        try {
            String sPort;
            BasicParser parser = new BasicParser();
            CommandLine cmdLine = parser.parse(BK_OPTS, args);
            if (cmdLine.hasOption('h')) {
                throw new IllegalArgumentException();
            }
            ServerConfiguration conf = new ServerConfiguration();
            if (cmdLine.hasOption('c')) {
                String confFile = cmdLine.getOptionValue("c");
                Main.loadConfFile(conf, confFile);
            }
            if (cmdLine.hasOption("withAutoRecovery")) {
                conf.setAutoRecoveryDaemonEnabled(true);
            }
            if (cmdLine.hasOption("r")) {
                conf.setForceReadOnlyBookie(true);
            }
            boolean overwriteMetadataServiceUri = false;
            String sZkLedgersRootPath = "/ledgers";
            if (cmdLine.hasOption('m')) {
                sZkLedgersRootPath = cmdLine.getOptionValue('m');
                log.info("Get cmdline zookeeper ledger path: {}", (Object)sZkLedgersRootPath);
                overwriteMetadataServiceUri = true;
            }
            String sZK = conf.getZkServers();
            if (cmdLine.hasOption('z')) {
                sZK = cmdLine.getOptionValue('z');
                log.info("Get cmdline zookeeper instance: {}", (Object)sZK);
                overwriteMetadataServiceUri = true;
            }
            if (overwriteMetadataServiceUri) {
                String metadataServiceUri = "zk://" + sZK + sZkLedgersRootPath;
                conf.setMetadataServiceUri(metadataServiceUri);
                log.info("Overwritten service uri to {}", (Object)metadataServiceUri);
            }
            if (cmdLine.hasOption('p')) {
                sPort = cmdLine.getOptionValue('p');
                log.info("Get cmdline bookie port: {}", (Object)sPort);
                conf.setBookiePort(Integer.parseInt(sPort));
            }
            if (cmdLine.hasOption("httpport")) {
                sPort = cmdLine.getOptionValue("httpport");
                log.info("Get cmdline http port: {}", (Object)sPort);
                Integer iPort = Integer.parseInt(sPort);
                conf.setHttpServerPort(iPort);
            }
            if (cmdLine.hasOption('j')) {
                String sJournalDir = cmdLine.getOptionValue('j');
                log.info("Get cmdline journal dir: {}", (Object)sJournalDir);
                conf.setJournalDirName(sJournalDir);
            }
            if (cmdLine.hasOption('i')) {
                String[] sIndexDirs = cmdLine.getOptionValues('i');
                log.info("Get cmdline index dirs: ");
                for (String index : sIndexDirs) {
                    log.info("indexDir : {}", (Object)index);
                }
                conf.setIndexDirName(sIndexDirs);
            }
            if (cmdLine.hasOption('l')) {
                String[] sLedgerDirs = cmdLine.getOptionValues('l');
                log.info("Get cmdline ledger dirs: ");
                for (String ledger : sLedgerDirs) {
                    log.info("ledgerdir : {}", (Object)ledger);
                }
                conf.setLedgerDirNames(sLedgerDirs);
            }
            return conf;
        }
        catch (ParseException e) {
            log.error("Error parsing command line arguments : ", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public static void main(String[] args) {
        int retCode = Main.doMain(args);
        Runtime.getRuntime().exit(retCode);
    }

    static int doMain(String[] args) {
        LifecycleComponentStack server;
        ServerConfiguration conf;
        try {
            conf = Main.parseCommandLine(args);
        }
        catch (IllegalArgumentException iae) {
            return 1;
        }
        try {
            server = Main.buildBookieServer(new BookieConfiguration(conf));
        }
        catch (Exception e) {
            log.error("Failed to build bookie server", (Throwable)e);
            return 2;
        }
        try {
            ComponentStarter.startComponent(server).get();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            log.info("Bookie server is interrupted. Exiting ...");
        }
        catch (ExecutionException ee) {
            log.error("Error in bookie shutdown", ee.getCause());
            return 2;
        }
        return 0;
    }

    private static ServerConfiguration parseCommandLine(String[] args) throws IllegalArgumentException, UncheckedConfigurationException {
        ServerConfiguration conf;
        try {
            conf = Main.parseArgs(args);
        }
        catch (IllegalArgumentException iae) {
            log.error("Error parsing command line arguments : ", (Throwable)iae);
            System.err.println(iae.getMessage());
            Main.printUsage();
            throw iae;
        }
        String hello = String.format("Hello, I'm your bookie, bookieId is %1$s, listening on port %2$s. Metadata service uri is %3$s. Journals are in %4$s. Ledgers are stored in %5$s.", conf.getBookieId() != null ? conf.getBookieId() : "<not-set>", conf.getBookiePort(), conf.getMetadataServiceUriUnchecked(), Arrays.asList(conf.getJournalDirNames()), Arrays.asList(conf.getLedgerDirNames()));
        log.info(hello);
        return conf;
    }

    public static LifecycleComponentStack buildBookieServer(BookieConfiguration conf) throws Exception {
        String[] extraComponents;
        ComponentInfoPublisher componentInfoPublisher = new ComponentInfoPublisher();
        Supplier<BookieServiceInfo> bookieServiceInfoProvider = () -> Main.buildBookieServiceInfo(componentInfoPublisher);
        LifecycleComponentStack.Builder serverBuilder = LifecycleComponentStack.newBuilder().withComponentInfoPublisher(componentInfoPublisher).withName("bookie-server");
        StatsProviderService statsProviderService = new StatsProviderService(conf);
        StatsLogger rootStatsLogger = statsProviderService.getStatsProvider().getStatsLogger("");
        serverBuilder.addComponent(statsProviderService);
        log.info("Load lifecycle component : {}", (Object)StatsProviderService.class.getName());
        MetadataBookieDriver metadataDriver = BookieResources.createMetadataDriver(conf.getServerConf(), rootStatsLogger);
        serverBuilder.addComponent(new AutoCloseableLifecycleComponent("metadataDriver", metadataDriver));
        RegistrationManager rm = metadataDriver.createRegistrationManager();
        serverBuilder.addComponent(new AutoCloseableLifecycleComponent("registrationManager", rm));
        LedgerManagerFactory lmFactory = metadataDriver.getLedgerManagerFactory();
        serverBuilder.addComponent(new AutoCloseableLifecycleComponent("lmFactory", lmFactory));
        LedgerManager ledgerManager = lmFactory.newLedgerManager();
        serverBuilder.addComponent(new AutoCloseableLifecycleComponent("ledgerManager", ledgerManager));
        StatsLogger bookieStats = rootStatsLogger.scope("bookie");
        DiskChecker diskChecker = BookieResources.createDiskChecker(conf.getServerConf());
        LedgerDirsManager ledgerDirsManager = BookieResources.createLedgerDirsManager(conf.getServerConf(), diskChecker, bookieStats.scope("ledger"));
        LedgerDirsManager indexDirsManager = BookieResources.createIndexDirsManager(conf.getServerConf(), diskChecker, bookieStats.scope("index"), ledgerDirsManager);
        ByteBufAllocatorWithOomHandler allocator = BookieResources.createAllocator(conf.getServerConf());
        UncleanShutdownDetectionImpl uncleanShutdownDetection = new UncleanShutdownDetectionImpl(ledgerDirsManager);
        if (uncleanShutdownDetection.lastShutdownWasUnclean()) {
            log.info("Unclean shutdown detected. The bookie did not register a graceful shutdown prior to this boot.");
        }
        LedgerStorage storage = null;
        DataIntegrityCheckImpl integCheck = null;
        if (conf.getServerConf().isDataIntegrityCheckingEnabled()) {
            StatsLogger clientStats = bookieStats.scope("bookkeeper_client");
            ClientConfiguration clientConfiguration = new ClientConfiguration(conf.getServerConf());
            clientConfiguration.setClientRole("system");
            BookKeeper bkc = BookKeeper.forConfig(clientConfiguration).statsLogger(clientStats).build();
            serverBuilder.addComponent(new AutoCloseableLifecycleComponent("bkc", bkc));
            BookieId bookieId = BookieImpl.getBookieId(conf.getServerConf());
            ExecutorService rxExecutor = Executors.newFixedThreadPool(2, new ThreadFactoryBuilder().setNameFormat("rx-schedule-%d").setUncaughtExceptionHandler((t, ex) -> log.error("Uncaught exception on thread {}", (Object)t.getName(), (Object)ex)).build());
            Scheduler rxScheduler = Schedulers.from((Executor)rxExecutor);
            serverBuilder.addComponent(new RxSchedulerLifecycleComponent("rx-scheduler", conf, bookieStats, rxScheduler, rxExecutor));
            storage = BookieResources.createLedgerStorage(conf.getServerConf(), ledgerManager, ledgerDirsManager, indexDirsManager, bookieStats, allocator);
            EntryCopierImpl copier = new EntryCopierImpl(bookieId, bkc.getClientCtx().getBookieClient(), storage, Ticker.systemTicker());
            integCheck = new DataIntegrityCheckImpl(bookieId, ledgerManager, storage, copier, new BookKeeperAdmin(bkc, clientStats, clientConfiguration), rxScheduler);
            if (!conf.getServerConf().getJournalWriteData() && uncleanShutdownDetection.lastShutdownWasUnclean()) {
                integCheck.runPreBootCheck("UNCLEAN_SHUTDOWN");
            }
            DataIntegrityCookieValidation cookieValidation = new DataIntegrityCookieValidation(conf.getServerConf(), rm, integCheck);
            cookieValidation.checkCookies(Main.storageDirectoriesFromConf(conf.getServerConf()));
        } else {
            LegacyCookieValidation cookieValidation = new LegacyCookieValidation(conf.getServerConf(), rm);
            cookieValidation.checkCookies(Main.storageDirectoriesFromConf(conf.getServerConf()));
            storage = BookieResources.createLedgerStorage(conf.getServerConf(), ledgerManager, ledgerDirsManager, indexDirsManager, bookieStats, allocator);
        }
        BookieImpl bookie = conf.getServerConf().isForceReadOnlyBookie() ? new ReadOnlyBookie(conf.getServerConf(), rm, storage, diskChecker, ledgerDirsManager, indexDirsManager, bookieStats, allocator, bookieServiceInfoProvider) : new BookieImpl(conf.getServerConf(), rm, storage, diskChecker, ledgerDirsManager, indexDirsManager, bookieStats, allocator, bookieServiceInfoProvider);
        BookieService bookieService = new BookieService(conf, bookie, rootStatsLogger, allocator, uncleanShutdownDetection);
        serverBuilder.addComponent(bookieService);
        log.info("Load lifecycle component : {}", (Object)BookieService.class.getName());
        if (conf.getServerConf().isLocalScrubEnabled()) {
            serverBuilder.addComponent(new ScrubberService(rootStatsLogger.scope("scrubber"), conf, bookieService.getServer().getBookie().getLedgerStorage()));
        }
        if (conf.getServerConf().isAutoRecoveryDaemonEnabled()) {
            AutoRecoveryService autoRecoveryService = new AutoRecoveryService(conf, rootStatsLogger.scope("replication"));
            serverBuilder.addComponent(autoRecoveryService);
            log.info("Load lifecycle component : {}", (Object)AutoRecoveryService.class.getName());
        }
        if (conf.getServerConf().isDataIntegrityCheckingEnabled()) {
            Preconditions.checkNotNull(integCheck, "integCheck should have been initialized with the cookie validation");
            DataIntegrityService dataIntegrityService = new DataIntegrityService(conf, rootStatsLogger.scope("replication"), integCheck);
            serverBuilder.addComponent(dataIntegrityService);
            log.info("Load lifecycle component : {}", (Object)DataIntegrityService.class.getName());
        }
        if (conf.getServerConf().isHttpServerEnabled()) {
            BKHttpServiceProvider provider = new BKHttpServiceProvider.Builder().setBookieServer(bookieService.getServer()).setServerConfiguration(conf.getServerConf()).setStatsProvider(statsProviderService.getStatsProvider()).setLedgerManagerFactory(metadataDriver.getLedgerManagerFactory()).build();
            HttpService httpService = new HttpService(provider, conf, rootStatsLogger);
            serverBuilder.addComponent(httpService);
            log.info("Load lifecycle component : {}", (Object)HttpService.class.getName());
        }
        if (null != (extraComponents = conf.getServerConf().getExtraServerComponents())) {
            try {
                List<ServerLifecycleComponent> components = ServerLifecycleComponent.loadServerComponents(extraComponents, conf, rootStatsLogger);
                for (ServerLifecycleComponent component : components) {
                    serverBuilder.addComponent(component);
                    log.info("Load lifecycle component : {}", (Object)component.getClass().getName());
                }
            }
            catch (Exception e) {
                if (conf.getServerConf().getIgnoreExtraServerComponentsStartupFailures()) {
                    log.info("Failed to load extra components '{}' - {}. Continuing without those components.", (Object)StringUtils.join(extraComponents), (Object)e.getMessage());
                }
                throw e;
            }
        }
        return serverBuilder.build();
    }

    private static BookieServiceInfo buildBookieServiceInfo(ComponentInfoPublisher componentInfoPublisher) {
        List<BookieServiceInfo.Endpoint> endpoints = componentInfoPublisher.getEndpoints().values().stream().map(e -> new BookieServiceInfo.Endpoint(e.getId(), e.getPort(), e.getHost(), e.getProtocol(), e.getAuth(), e.getExtensions())).collect(Collectors.toList());
        return new BookieServiceInfo(componentInfoPublisher.getProperties(), endpoints);
    }

    public static List<File> storageDirectoriesFromConf(ServerConfiguration conf) throws IOException {
        File[] indexDirs;
        File[] ledgerDirs;
        ArrayList<File> dirs = new ArrayList<File>();
        File[] journalDirs = conf.getJournalDirs();
        if (journalDirs != null) {
            for (File j : journalDirs) {
                File cur = BookieImpl.getCurrentDirectory(j);
                if (dirs.stream().anyMatch(f -> f.equals(cur))) continue;
                BookieImpl.checkDirectoryStructure(cur);
                dirs.add(cur);
            }
        }
        if ((ledgerDirs = conf.getLedgerDirs()) != null) {
            for (File l : ledgerDirs) {
                File cur = BookieImpl.getCurrentDirectory(l);
                if (dirs.stream().anyMatch(f -> f.equals(cur))) continue;
                BookieImpl.checkDirectoryStructure(cur);
                dirs.add(cur);
            }
        }
        if ((indexDirs = conf.getIndexDirs()) != null) {
            for (File i : indexDirs) {
                File cur = BookieImpl.getCurrentDirectory(i);
                if (dirs.stream().anyMatch(f -> f.equals(cur))) continue;
                BookieImpl.checkDirectoryStructure(cur);
                dirs.add(cur);
            }
        }
        return dirs;
    }

    static {
        BK_OPTS.addOption("c", "conf", true, "Configuration for Bookie Server");
        BK_OPTS.addOption("withAutoRecovery", false, "Start Autorecovery service Bookie server");
        BK_OPTS.addOption("r", "readOnly", false, "Force Start a ReadOnly Bookie server");
        BK_OPTS.addOption("z", "zkserver", true, "Zookeeper Server");
        BK_OPTS.addOption("m", "zkledgerpath", true, "Zookeeper ledgers root path");
        BK_OPTS.addOption("p", "bookieport", true, "bookie port exported");
        BK_OPTS.addOption("hp", "httpport", true, "bookie http port exported");
        BK_OPTS.addOption("j", "journal", true, "bookie journal directory");
        Option indexDirs = new Option("i", "indexdirs", true, "bookie index directories");
        indexDirs.setArgs(10);
        BK_OPTS.addOption(indexDirs);
        Option ledgerDirs = new Option("l", "ledgerdirs", true, "bookie ledgers directories");
        ledgerDirs.setArgs(10);
        BK_OPTS.addOption(ledgerDirs);
        BK_OPTS.addOption("h", "help", false, "Print help message");
    }
}

