/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.storage.ldb;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.collect.Sets;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBuf;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.EntryLogger;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.storage.ldb.KeyValueStorage;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.storage.ldb.KeyValueStorageFactory;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.storage.ldb.KeyValueStorageRocksDB;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.storage.ldb.LedgerMetadataIndex;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.storage.ldb.LongPairWrapper;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.storage.ldb.LongWrapper;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.StatsLogger;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.util.DiskChecker;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang.time.DurationFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationsIndexRebuildOp {
    private final ServerConfiguration conf;
    private static final Logger LOG = LoggerFactory.getLogger(LocationsIndexRebuildOp.class);

    public LocationsIndexRebuildOp(ServerConfiguration conf) {
        this.conf = conf;
    }

    public void initiate() throws IOException {
        LOG.info("Starting locations index rebuilding");
        String basePath = BookieImpl.getCurrentDirectory(this.conf.getLedgerDirs()[0]).toString();
        Path currentPath = FileSystems.getDefault().getPath(basePath, "locations");
        String timestamp = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(new Date());
        Path backupPath = FileSystems.getDefault().getPath(basePath, "locations.BACKUP-" + timestamp);
        Files.move(currentPath, backupPath, new CopyOption[0]);
        LOG.info("Created locations index backup at {}", (Object)backupPath);
        long startTime = System.nanoTime();
        EntryLogger entryLogger = new EntryLogger(this.conf, new LedgerDirsManager(this.conf, this.conf.getLedgerDirs(), new DiskChecker(this.conf.getDiskUsageThreshold(), this.conf.getDiskUsageWarnThreshold())));
        Set<Long> entryLogs = entryLogger.getEntryLogsSet();
        final Set<Long> activeLedgers = this.getActiveLedgers(this.conf, KeyValueStorageRocksDB.factory, basePath);
        LOG.info("Found {} active ledgers in ledger manager", (Object)activeLedgers.size());
        final KeyValueStorage newIndex = KeyValueStorageRocksDB.factory.newKeyValueStorage(basePath, "locations", KeyValueStorageFactory.DbConfigType.Default, this.conf);
        int totalEntryLogs = entryLogs.size();
        int completedEntryLogs = 0;
        LOG.info("Scanning {} entry logs", (Object)totalEntryLogs);
        for (final long entryLogId : entryLogs) {
            entryLogger.scanEntryLog(entryLogId, new EntryLogger.EntryLogScanner(){

                @Override
                public void process(long ledgerId, long offset, ByteBuf entry) throws IOException {
                    long entryId = entry.getLong(8);
                    long location = entryLogId << 32 | offset + 4L;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Rebuilding {}:{} at location {} / {}", new Object[]{ledgerId, entryId, location >> 32, location & 0x7FFFFFFEL});
                    }
                    LongPairWrapper key = LongPairWrapper.get(ledgerId, entryId);
                    LongWrapper value = LongWrapper.get(location);
                    newIndex.put(key.array, value.array);
                }

                @Override
                public boolean accept(long ledgerId) {
                    return activeLedgers.contains(ledgerId);
                }
            });
            LOG.info("Completed scanning of log {}.log -- {} / {}", new Object[]{Long.toHexString(entryLogId), ++completedEntryLogs, totalEntryLogs});
        }
        newIndex.sync();
        newIndex.close();
        LOG.info("Rebuilding index is done. Total time: {}", (Object)DurationFormatUtils.formatDurationHMS(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime)));
    }

    private Set<Long> getActiveLedgers(ServerConfiguration conf, KeyValueStorageFactory storageFactory, String basePath) throws IOException {
        LedgerMetadataIndex ledgers = new LedgerMetadataIndex(conf, storageFactory, basePath, (StatsLogger)NullStatsLogger.INSTANCE);
        HashSet<Long> activeLedgers = Sets.newHashSet();
        for (Long ledger : ledgers.getActiveLedgersInRange(0L, Long.MAX_VALUE)) {
            activeLedgers.add(ledger);
        }
        ledgers.close();
        return activeLedgers;
    }
}

