/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.stats;

import java.util.function.Supplier;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.Counter;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.Gauge;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.StatsLogger;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.annotations.StatsDoc;

@StatsDoc(name="bookie", category="server", help="Garbage Collector related stats")
public class GarbageCollectorStats {
    final StatsLogger statsLogger;
    @StatsDoc(name="MINOR_COMPACTION_COUNT", help="Number of minor compactions")
    private final Counter minorCompactionCounter;
    @StatsDoc(name="MAJOR_COMPACTION_COUNT", help="Number of major compactions")
    private final Counter majorCompactionCounter;
    @StatsDoc(name="RECLAIMED_DELETION_SPACE_BYTES", help="Number of disk space bytes reclaimed via deleting entry log files")
    private final Counter reclaimedSpaceViaDeletes;
    @StatsDoc(name="RECLAIMED_COMPACTION_SPACE_BYTES", help="Number of disk space bytes reclaimed via compacting entry log files")
    private final Counter reclaimedSpaceViaCompaction;
    @StatsDoc(name="DELETED_LEDGER_COUNT", help="Number of ledgers deleted by garbage collection")
    private final Counter deletedLedgerCounter;
    @StatsDoc(name="THREAD_RUNTIME", help="Operation stats of garbage collections")
    private final OpStatsLogger gcThreadRuntime;
    @StatsDoc(name="ACTIVE_ENTRY_LOG_COUNT", help="Current number of active entry log files")
    private final Gauge<Integer> activeEntryLogCountGauge;
    @StatsDoc(name="ACTIVE_ENTRY_LOG_SPACE_BYTES", help="Current number of active entry log space bytes")
    private final Gauge<Long> activeEntryLogSpaceBytesGauge;
    @StatsDoc(name="ACTIVE_LEDGER_COUNT", help="Current number of active ledgers")
    private final Gauge<Integer> activeLedgerCountGauge;

    public GarbageCollectorStats(StatsLogger statsLogger, final Supplier<Integer> activeEntryLogCountSupplier, final Supplier<Long> activeEntryLogSpaceBytesSupplier, final Supplier<Integer> activeLedgerCountSupplier) {
        this.statsLogger = statsLogger;
        this.minorCompactionCounter = statsLogger.getCounter("MINOR_COMPACTION_COUNT");
        this.majorCompactionCounter = statsLogger.getCounter("MAJOR_COMPACTION_COUNT");
        this.reclaimedSpaceViaCompaction = statsLogger.getCounter("RECLAIMED_COMPACTION_SPACE_BYTES");
        this.reclaimedSpaceViaDeletes = statsLogger.getCounter("RECLAIMED_DELETION_SPACE_BYTES");
        this.gcThreadRuntime = statsLogger.getOpStatsLogger("THREAD_RUNTIME");
        this.deletedLedgerCounter = statsLogger.getCounter("DELETED_LEDGER_COUNT");
        this.activeEntryLogCountGauge = new Gauge<Integer>(){

            public Integer getDefaultValue() {
                return 0;
            }

            public Integer getSample() {
                return (Integer)activeEntryLogCountSupplier.get();
            }
        };
        statsLogger.registerGauge("ACTIVE_ENTRY_LOG_COUNT", this.activeEntryLogCountGauge);
        this.activeEntryLogSpaceBytesGauge = new Gauge<Long>(){

            public Long getDefaultValue() {
                return 0L;
            }

            public Long getSample() {
                return (Long)activeEntryLogSpaceBytesSupplier.get();
            }
        };
        statsLogger.registerGauge("ACTIVE_ENTRY_LOG_SPACE_BYTES", this.activeEntryLogSpaceBytesGauge);
        this.activeLedgerCountGauge = new Gauge<Integer>(){

            public Integer getDefaultValue() {
                return 0;
            }

            public Integer getSample() {
                return (Integer)activeLedgerCountSupplier.get();
            }
        };
        statsLogger.registerGauge("ACTIVE_LEDGER_COUNT", this.activeLedgerCountGauge);
    }

    public StatsLogger getStatsLogger() {
        return this.statsLogger;
    }

    public Counter getMinorCompactionCounter() {
        return this.minorCompactionCounter;
    }

    public Counter getMajorCompactionCounter() {
        return this.majorCompactionCounter;
    }

    public Counter getReclaimedSpaceViaDeletes() {
        return this.reclaimedSpaceViaDeletes;
    }

    public Counter getReclaimedSpaceViaCompaction() {
        return this.reclaimedSpaceViaCompaction;
    }

    public Counter getDeletedLedgerCounter() {
        return this.deletedLedgerCounter;
    }

    public OpStatsLogger getGcThreadRuntime() {
        return this.gcThreadRuntime;
    }

    public Gauge<Integer> getActiveEntryLogCountGauge() {
        return this.activeEntryLogCountGauge;
    }

    public Gauge<Long> getActiveEntryLogSpaceBytesGauge() {
        return this.activeEntryLogSpaceBytesGauge;
    }

    public Gauge<Integer> getActiveLedgerCountGauge() {
        return this.activeLedgerCountGauge;
    }
}

