/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.util;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortManager {
    private static final Logger LOG = LoggerFactory.getLogger(PortManager.class);
    private static int nextPort = 15000;

    public static void initPort(int initPort) {
        nextPort = initPort;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized int nextFreePort() {
        int exceptionCount = 0;
        while (true) {
            ++nextPort;
            try {
                int port;
                try (ServerSocket ignored = new ServerSocket(port);){
                    TimeUnit.MILLISECONDS.sleep(100L);
                    int n = port;
                    return n;
                }
            }
            catch (IOException ioe) {
                if (++exceptionCount <= 100) continue;
                throw new RuntimeException("Unable to allocate socket port", ioe);
            }
            catch (InterruptedException ie) {
                LOG.error("Failed to allocate socket port", (Throwable)ie);
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }
}

