/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.server.service;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Preconditions;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.util.concurrent.RateLimiter;
import org.apache.pulsar.functions.runtime.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.server.component.ServerLifecycleComponent;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.server.conf.BookieConfiguration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.Counter;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.StatsLogger;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.util.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScrubberService
extends ServerLifecycleComponent {
    private static final Logger LOG = LoggerFactory.getLogger(ScrubberService.class);
    private static final String NAME = "scrubber";
    private final ScheduledExecutorService executor;
    private final Random rng = new Random();
    private final long scrubPeriod;
    private final Optional<RateLimiter> scrubRateLimiter;
    private final AtomicBoolean stop = new AtomicBoolean(false);
    private final LedgerStorage ledgerStorage;
    private final OpStatsLogger scrubCounter;
    private final Counter errorCounter;
    private final Counter fatalErrorCounter;

    public ScrubberService(StatsLogger logger, BookieConfiguration conf, LedgerStorage ledgerStorage) {
        super(NAME, conf, logger);
        this.executor = Executors.newSingleThreadScheduledExecutor(new DefaultThreadFactory("ScrubThread"));
        this.scrubPeriod = conf.getServerConf().getLocalScrubPeriod();
        Preconditions.checkArgument(this.scrubPeriod > 0L, "localScrubInterval must be > 0 for ScrubberService to be used");
        double rateLimit = conf.getServerConf().getLocalScrubRateLimit();
        this.scrubRateLimiter = rateLimit == 0.0 ? Optional.empty() : Optional.of(RateLimiter.create(rateLimit));
        this.ledgerStorage = ledgerStorage;
        this.scrubCounter = logger.getOpStatsLogger("runTime");
        this.errorCounter = logger.getCounter("detectedScrubErrors");
        this.fatalErrorCounter = logger.getCounter("detectedFatalScrubErrors");
    }

    private long getNextPeriodMS() {
        return (long)((double)this.scrubPeriod * (1.5 - this.rng.nextDouble()) * 1000.0);
    }

    private void doSchedule() {
        this.executor.schedule(this::run, this.getNextPeriodMS(), TimeUnit.MILLISECONDS);
    }

    private void run() {
        boolean success = false;
        long start = MathUtils.nowInNano();
        try {
            List<LedgerStorage.DetectedInconsistency> errors = this.ledgerStorage.localConsistencyCheck(this.scrubRateLimiter);
            if (errors.size() > 0) {
                this.errorCounter.add((long)errors.size());
                LOG.error("Found inconsistency during localConsistencyCheck:");
                for (LedgerStorage.DetectedInconsistency error : errors) {
                    LOG.error("Ledger {}, entry {}: ", new Object[]{error.getLedgerId(), error.getEntryId(), error.getException()});
                }
            }
            success = true;
        }
        catch (IOException e) {
            this.fatalErrorCounter.inc();
            LOG.error("Got fatal exception {} running localConsistencyCheck", (Object)e.toString());
        }
        if (success) {
            this.scrubCounter.registerSuccessfulEvent(MathUtils.elapsedNanos(start), TimeUnit.NANOSECONDS);
        } else {
            this.scrubCounter.registerFailedEvent(MathUtils.elapsedNanos(start), TimeUnit.NANOSECONDS);
            Runtime.getRuntime().exit(5);
        }
        if (!this.stop.get()) {
            this.doSchedule();
        }
    }

    @Override
    protected void doStart() {
        this.doSchedule();
    }

    @Override
    protected void doStop() {
        this.stop.set(true);
        this.executor.shutdown();
    }

    @Override
    protected void doClose() throws IOException {
    }
}

