/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.sasl;

import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.auth.KerberosName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslClientState {
    private static final Logger LOG = LoggerFactory.getLogger(SaslClientState.class);
    private final SaslClient saslClient;
    private final Subject clientSubject;
    private String username;
    private String password;

    public SaslClientState(String serverHostname, Subject subject) throws SaslException {
        String saslServiceName = System.getProperty("bookkeeper.sasl.servicename", "bookkeeper");
        String serverPrincipal = saslServiceName + "/" + serverHostname;
        this.clientSubject = subject;
        if (this.clientSubject == null) {
            throw new SaslException("Cannot create JAAS Sujbect for SASL");
        }
        if (this.clientSubject.getPrincipals().isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using JAAS/SASL/DIGEST-MD5 auth to connect to {}", (Object)serverPrincipal);
            }
            String[] mechs = new String[]{"DIGEST-MD5"};
            this.username = (String)this.clientSubject.getPublicCredentials().toArray()[0];
            this.password = (String)this.clientSubject.getPrivateCredentials().toArray()[0];
            this.saslClient = Sasl.createSaslClient(mechs, this.username, "bookkeeper", "bookkeeper", null, new ClientCallbackHandler(this.password));
        } else {
            Object[] principals = this.clientSubject.getPrincipals().toArray();
            Principal clientPrincipal = (Principal)principals[0];
            KerberosName clientKerberosName = new KerberosName(clientPrincipal.getName());
            KerberosName serviceKerberosName = new KerberosName(serverPrincipal + "@" + clientKerberosName.getRealm());
            final String serviceName = serviceKerberosName.getServiceName();
            final String serviceHostname = serviceKerberosName.getHostName();
            final String clientPrincipalName = clientKerberosName.toString();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using JAAS/SASL/GSSAPI auth to connect to server Principal {}", (Object)serverPrincipal);
            }
            try {
                this.saslClient = Subject.doAs(this.clientSubject, new PrivilegedExceptionAction<SaslClient>(){

                    @Override
                    public SaslClient run() throws SaslException {
                        String[] mechs = new String[]{"GSSAPI"};
                        return Sasl.createSaslClient(mechs, clientPrincipalName, serviceName, serviceHostname, null, new ClientCallbackHandler(null));
                    }
                });
            }
            catch (PrivilegedActionException err) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("GSSAPI client error", err.getCause());
                }
                throw new SaslException("error while booting GSSAPI client", err.getCause());
            }
        }
        if (this.saslClient == null) {
            throw new SaslException("Cannot create JVM SASL Client");
        }
    }

    public byte[] evaluateChallenge(final byte[] saslToken) throws SaslException {
        if (saslToken == null) {
            throw new SaslException("saslToken is null");
        }
        if (this.clientSubject != null) {
            try {
                byte[] retval = Subject.doAs(this.clientSubject, new PrivilegedExceptionAction<byte[]>(){

                    @Override
                    public byte[] run() throws SaslException {
                        return SaslClientState.this.saslClient.evaluateChallenge(saslToken);
                    }
                });
                return retval;
            }
            catch (PrivilegedActionException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("SASL error", e.getCause());
                }
                throw new SaslException("SASL/JAAS error", e.getCause());
            }
        }
        return this.saslClient.evaluateChallenge(saslToken);
    }

    public boolean hasInitialResponse() {
        return this.saslClient.hasInitialResponse();
    }

    public boolean isComplete() {
        return this.saslClient.isComplete();
    }

    public byte[] saslResponse(byte[] saslTokenMessage) {
        try {
            byte[] retval = this.saslClient.evaluateChallenge(saslTokenMessage);
            return retval;
        }
        catch (SaslException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("saslResponse: Failed to respond to SASL server's token:", (Throwable)e);
            }
            return null;
        }
    }

    static class ClientCallbackHandler
    implements CallbackHandler {
        private String password = null;

        public ClientCallbackHandler(String password) {
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callback;
                    nc.setName(nc.getDefaultName());
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callback;
                    if (this.password == null) continue;
                    pc.setPassword(this.password.toCharArray());
                    continue;
                }
                if (callback instanceof RealmCallback) {
                    RealmCallback rc = (RealmCallback)callback;
                    rc.setText(rc.getDefaultText());
                    continue;
                }
                if (callback instanceof AuthorizeCallback) {
                    String authzid;
                    AuthorizeCallback ac = (AuthorizeCallback)callback;
                    String authid = ac.getAuthenticationID();
                    if (authid.equals(authzid = ac.getAuthorizationID())) {
                        ac.setAuthorized(true);
                    } else {
                        ac.setAuthorized(false);
                    }
                    if (!ac.isAuthorized()) continue;
                    ac.setAuthorizedID(authzid);
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unrecognized SASL ClientCallback");
            }
        }
    }
}

