/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.metastore;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.metastore.MSException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.metastore.MetastoreCallback;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.metastore.MetastoreCursor;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.metastore.MetastoreTable;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.metastore.MetastoreTableItem;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.versioning.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetastoreUtils {
    private static final Logger logger = LoggerFactory.getLogger(MetastoreUtils.class);

    public static void cleanTable(MetastoreTable table, int numEntriesPerScan) throws MSException, InterruptedException {
        SyncMetastoreCallback<MetastoreCursor> openCb = new SyncMetastoreCallback<MetastoreCursor>();
        table.openCursor(MetastoreTable.NON_FIELDS, openCb, null);
        MetastoreCursor cursor = openCb.getResult();
        logger.info("Open cursor for table {} to clean entries.", (Object)table.getName());
        ArrayList<String> keysToClean = new ArrayList<String>(numEntriesPerScan);
        int numEntriesRemoved = 0;
        while (cursor.hasMoreEntries()) {
            logger.info("Fetching next {} entries from table {} to clean.", (Object)numEntriesPerScan, (Object)table.getName());
            Iterator<MetastoreTableItem> iter = cursor.readEntries(numEntriesPerScan);
            keysToClean.clear();
            while (iter.hasNext()) {
                MetastoreTableItem item = iter.next();
                String key = item.getKey();
                keysToClean.add(key);
            }
            if (keysToClean.isEmpty()) continue;
            logger.info("Issuing deletes to delete keys {}", keysToClean);
            MultiMetastoreCallback<Void> mcb = new MultiMetastoreCallback<Void>(keysToClean.size());
            for (String key : keysToClean) {
                table.remove(key, Version.ANY, mcb, null);
            }
            mcb.waitUntilAllFinished();
            logger.info("Removed {} entries from table {}.", (Object)(numEntriesRemoved += keysToClean.size()), (Object)table.getName());
        }
        logger.info("Finished cleaning up table {}.", (Object)table.getName());
    }

    static class SyncMetastoreCallback<T>
    implements MetastoreCallback<T> {
        int rc;
        T result;
        final CountDownLatch doneLatch = new CountDownLatch(1);

        SyncMetastoreCallback() {
        }

        @Override
        public void complete(int rc, T value, Object ctx) {
            this.rc = rc;
            this.result = value;
            this.doneLatch.countDown();
        }

        public T getResult() throws MSException, InterruptedException {
            this.doneLatch.await();
            if (MSException.Code.OK.getCode() != this.rc) {
                throw MSException.create(MSException.Code.get(this.rc));
            }
            return this.result;
        }
    }

    static class MultiMetastoreCallback<T>
    implements MetastoreCallback<T> {
        int rc = MSException.Code.OK.getCode();
        final int numOps;
        final AtomicInteger numFinished = new AtomicInteger(0);
        final CountDownLatch doneLatch = new CountDownLatch(1);

        MultiMetastoreCallback(int numOps) {
            this.numOps = numOps;
        }

        @Override
        public void complete(int rc, T value, Object ctx) {
            if (MSException.Code.OK.getCode() != rc) {
                this.rc = rc;
                this.doneLatch.countDown();
                return;
            }
            if (this.numFinished.incrementAndGet() == this.numOps) {
                this.doneLatch.countDown();
            }
        }

        public void waitUntilAllFinished() throws MSException, InterruptedException {
            this.doneLatch.await();
            if (MSException.Code.OK.getCode() != this.rc) {
                throw MSException.create(MSException.Code.get(this.rc));
            }
        }
    }
}

