/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.conf;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.PooledByteBufAllocator;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.allocator.LeakDetectionPolicy;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.allocator.OutOfMemoryPolicy;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.allocator.PoolingPolicy;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.util.JsonUtil;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.util.ReflectionUtils;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.conf.UncheckedConfigurationException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.feature.Feature;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.AbstractZkLedgerManagerFactory;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.FlatLedgerManagerFactory;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.HierarchicalLedgerManagerFactory;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.LongHierarchicalLedgerManagerFactory;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.MSLedgerManagerFactory;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.util.EntryFormatter;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.util.LedgerIdFormatter;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.util.StringEntryFormatter;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.configuration.CompositeConfiguration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.configuration.ConfigurationException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.configuration.SystemConfiguration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfiguration<T extends AbstractConfiguration>
extends CompositeConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AbstractConfiguration.class);
    public static final String READ_SYSTEM_PROPERTIES_PROPERTY = "org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.conf.readsystemproperties";
    private static final boolean READ_SYSTEM_PROPERTIES = Boolean.getBoolean("org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.conf.readsystemproperties");
    protected static final ClassLoader DEFAULT_LOADER;
    protected static final String ZK_TIMEOUT = "zkTimeout";
    protected static final String ZK_SERVERS = "zkServers";
    protected static final String ZK_RETRY_BACKOFF_MAX_RETRIES = "zkRetryBackoffMaxRetries";
    protected static final String LEDGER_MANAGER_TYPE = "ledgerManagerType";
    protected static final String LEDGER_MANAGER_FACTORY_CLASS = "ledgerManagerFactoryClass";
    protected static final String ALLOW_SHADED_LEDGER_MANAGER_FACTORY_CLASS = "allowShadedLedgerManagerFactoryClass";
    protected static final String SHADED_LEDGER_MANAGER_FACTORY_CLASS_PREFIX = "shadedLedgerManagerFactoryClassPrefix";
    protected static final String METADATA_SERVICE_URI = "metadataServiceUri";
    protected static final String ZK_LEDGERS_ROOT_PATH = "zkLedgersRootPath";
    protected static final String ZK_REQUEST_RATE_LIMIT = "zkRequestRateLimit";
    protected static final String AVAILABLE_NODE = "available";
    protected static final String REREPLICATION_ENTRY_BATCH_SIZE = "rereplicationEntryBatchSize";
    protected static final String STORE_SYSTEMTIME_AS_LEDGER_UNDERREPLICATED_MARK_TIME = "storeSystemTimeAsLedgerUnderreplicatedMarkTime";
    protected static final String STORE_SYSTEMTIME_AS_LEDGER_CREATION_TIME = "storeSystemTimeAsLedgerCreationTime";
    protected static final String ENABLE_BUSY_WAIT = "enableBusyWait";
    protected static final String METASTORE_IMPL_CLASS = "metastoreImplClass";
    protected static final String METASTORE_MAX_ENTRIES_PER_SCAN = "metastoreMaxEntriesPerScan";
    protected static final String TLS_PROVIDER = "tlsProvider";
    protected static final String TLS_PROVIDER_FACTORY_CLASS = "tlsProviderFactoryClass";
    protected static final String LEDGERID_FORMATTER_CLASS = "ledgerIdFormatterClass";
    protected static final String ENTRY_FORMATTER_CLASS = "entryFormatterClass";
    protected static final String TLS_CLIENT_AUTHENTICATION = "tlsClientAuthentication";
    protected static final String PRESERVE_MDC_FOR_TASK_EXECUTION = "preserveMdcForTaskExecution";
    protected static final Class<? extends EntryFormatter> DEFAULT_ENTRY_FORMATTER;
    protected static final Class<? extends LedgerIdFormatter> DEFAULT_LEDGERID_FORMATTER;
    protected static final String TLS_CERT_FILES_REFRESH_DURATION_SECONDS = "tlsCertFilesRefreshDurationSeconds";
    protected static final String TLS_ENABLED_CIPHER_SUITES = "tlsEnabledCipherSuites";
    protected static final String TLS_ENABLED_PROTOCOLS = "tlsEnabledProtocols";
    protected static final String TLS_KEYSTORE_TYPE = "tlsKeyStoreType";
    protected static final String TLS_KEYSTORE = "tlsKeyStore";
    protected static final String TLS_KEYSTORE_PASSWORD_PATH = "tlsKeyStorePasswordPath";
    protected static final String TLS_TRUSTSTORE_TYPE = "tlsTrustStoreType";
    protected static final String TLS_TRUSTSTORE = "tlsTrustStore";
    protected static final String TLS_TRUSTSTORE_PASSWORD_PATH = "tlsTrustStorePasswordPath";
    protected static final String TLS_CERTIFICATE_PATH = "tlsCertificatePath";
    protected static final String NETTY_MAX_FRAME_SIZE = "nettyMaxFrameSizeBytes";
    protected static final int DEFAULT_NETTY_MAX_FRAME_SIZE = 0x500000;
    protected static final String ZK_ENABLE_SECURITY = "zkEnableSecurity";
    public static final String LEDGER_MANAGER_FACTORY_DISABLE_CLASS_CHECK = "ledgerManagerFactoryDisableClassCheck";
    public static final String PERMITTED_STARTUP_USERS = "permittedStartupUsers";
    public static final String MIN_NUM_RACKS_PER_WRITE_QUORUM = "minNumRacksPerWriteQuorum";
    public static final String ENFORCE_MIN_NUM_RACKS_PER_WRITE_QUORUM = "enforceMinNumRacksPerWriteQuorum";
    public static final String ENFORCE_MIN_NUM_FAULT_DOMAINS_FOR_WRITE = "enforceMinNumFaultDomainsForWrite";
    public static final String IGNORE_LOCAL_NODE_IN_PLACEMENT_POLICY = "ignoreLocalNodeInPlacementPolicy";
    public static final String MIN_NUM_ZONES_PER_WRITE_QUORUM = "minNumZonesPerWriteQuorum";
    public static final String DESIRED_NUM_ZONES_PER_WRITE_QUORUM = "desiredNumZonesPerWriteQuorum";
    public static final String ENFORCE_STRICT_ZONEAWARE_PLACEMENT = "enforceStrictZoneawarePlacement";
    protected static final String ALLOCATOR_POOLING_POLICY = "allocatorPoolingPolicy";
    protected static final String ALLOCATOR_POOLING_CONCURRENCY = "allocatorPoolingConcurrency";
    protected static final String ALLOCATOR_OOM_POLICY = "allocatorOutOfMemoryPolicy";
    protected static final String ALLOCATOR_LEAK_DETECTION_POLICY = "allocatorLeakDetectionPolicy";
    public static final String LIMIT_STATS_LOGGING = "limitStatsLogging";
    protected static final String REPLICATION_RATE_BY_BYTES = "replicationRateByBytes";

    protected AbstractConfiguration() {
        if (READ_SYSTEM_PROPERTIES) {
            this.addConfiguration(new SystemConfiguration());
        }
    }

    public void setPermittedStartupUsers(String s) {
        this.setProperty(PERMITTED_STARTUP_USERS, s);
    }

    public String[] getPermittedStartupUsers() {
        return this.getStringArray(PERMITTED_STARTUP_USERS);
    }

    public void loadConf(URL confURL) throws ConfigurationException {
        PropertiesConfiguration loadedConf = new PropertiesConfiguration(confURL);
        Iterator<String> iter = loadedConf.getKeys();
        while (iter.hasNext()) {
            String key = iter.next();
            this.setProperty(key, loadedConf.getProperty(key));
        }
    }

    public void loadConf(CompositeConfiguration baseConf) {
        Iterator<String> iter = baseConf.getKeys();
        while (iter.hasNext()) {
            String key = iter.next();
            this.setProperty(key, baseConf.getProperty(key));
        }
    }

    public String getMetadataServiceUriUnchecked() throws UncheckedConfigurationException {
        try {
            return this.getMetadataServiceUri();
        }
        catch (ConfigurationException e) {
            throw new UncheckedConfigurationException(e);
        }
    }

    public String getMetadataServiceUri() throws ConfigurationException {
        String serviceUri = this.getString(METADATA_SERVICE_URI);
        if (StringUtils.isBlank(serviceUri)) {
            String ledgerManagerType = this.getLedgerManagerLayoutStringFromFactoryClass();
            String zkServers = this.getZkServers();
            if (null != zkServers) {
                serviceUri = String.format("zk+%s://%s%s", ledgerManagerType, zkServers.replace(",", ";"), this.getZkLedgersRootPath());
            }
        }
        return serviceUri;
    }

    public T setMetadataServiceUri(String serviceUri) {
        this.setProperty(METADATA_SERVICE_URI, serviceUri);
        return this.getThis();
    }

    @Deprecated
    public String getZkServers() {
        List<Object> servers = this.getList(ZK_SERVERS, null);
        if (null == servers || 0 == servers.size()) {
            return null;
        }
        return StringUtils.join(servers, ",");
    }

    @Deprecated
    public T setZkServers(String zkServers) {
        this.setProperty(ZK_SERVERS, zkServers);
        return this.getThis();
    }

    public int getZkTimeout() {
        return this.getInt(ZK_TIMEOUT, 10000);
    }

    public T setZkTimeout(int zkTimeout) {
        this.setProperty(ZK_TIMEOUT, Integer.toString(zkTimeout));
        return this.getThis();
    }

    public int getZkRetryBackoffMaxRetries() {
        return this.getInt(ZK_RETRY_BACKOFF_MAX_RETRIES, Integer.MAX_VALUE);
    }

    public T setZkRetryBackoffMaxRetries(int maxRetries) {
        this.setProperty(ZK_RETRY_BACKOFF_MAX_RETRIES, Integer.toString(maxRetries));
        return this.getThis();
    }

    @Deprecated
    public void setLedgerManagerType(String lmType) {
        this.setProperty(LEDGER_MANAGER_TYPE, lmType);
    }

    @Deprecated
    public String getLedgerManagerType() {
        return this.getString(LEDGER_MANAGER_TYPE);
    }

    public T setAllowShadedLedgerManagerFactoryClass(boolean allowed) {
        this.setProperty(ALLOW_SHADED_LEDGER_MANAGER_FACTORY_CLASS, allowed);
        return this.getThis();
    }

    public boolean isShadedLedgerManagerFactoryClassAllowed() {
        return this.getBoolean(ALLOW_SHADED_LEDGER_MANAGER_FACTORY_CLASS, false);
    }

    public T setShadedLedgerManagerFactoryClassPrefix(String classPrefix) {
        this.setProperty(SHADED_LEDGER_MANAGER_FACTORY_CLASS_PREFIX, classPrefix);
        return this.getThis();
    }

    public String getShadedLedgerManagerFactoryClassPrefix() {
        return this.getString(SHADED_LEDGER_MANAGER_FACTORY_CLASS_PREFIX, "org.apache.pulsar.functions.runtime.shaded.dlshade.");
    }

    public void setLedgerManagerFactoryClassName(String factoryClassName) {
        this.setProperty(LEDGER_MANAGER_FACTORY_CLASS, factoryClassName);
    }

    public String getLedgerManagerFactoryClassName() {
        return this.getString(LEDGER_MANAGER_FACTORY_CLASS);
    }

    public String getLedgerManagerLayoutStringFromFactoryClass() throws ConfigurationException {
        String ledgerManagerType;
        Class<LedgerManagerFactory> factoryClass = this.getLedgerManagerFactoryClass();
        if (factoryClass == null) {
            ledgerManagerType = "null";
        } else {
            if (!AbstractZkLedgerManagerFactory.class.isAssignableFrom(factoryClass)) {
                throw new ConfigurationException("metadata service uri is not supported for " + factoryClass);
            }
            if (factoryClass == HierarchicalLedgerManagerFactory.class) {
                ledgerManagerType = "hierarchical";
            } else if (factoryClass == FlatLedgerManagerFactory.class) {
                ledgerManagerType = "flat";
            } else if (factoryClass == LongHierarchicalLedgerManagerFactory.class) {
                ledgerManagerType = "longhierarchical";
            } else if (factoryClass == MSLedgerManagerFactory.class) {
                ledgerManagerType = "ms";
            } else {
                throw new IllegalArgumentException("Unknown zookeeper based ledger manager factory : " + factoryClass);
            }
        }
        return ledgerManagerType;
    }

    public void setLedgerManagerFactoryClass(Class<? extends LedgerManagerFactory> factoryClass) {
        this.setProperty(LEDGER_MANAGER_FACTORY_CLASS, factoryClass.getName());
    }

    public Class<? extends LedgerManagerFactory> getLedgerManagerFactoryClass() throws ConfigurationException {
        return ReflectionUtils.getClass(this, LEDGER_MANAGER_FACTORY_CLASS, null, LedgerManagerFactory.class, DEFAULT_LOADER);
    }

    @Deprecated
    public void setZkLedgersRootPath(String zkLedgersPath) {
        this.setProperty(ZK_LEDGERS_ROOT_PATH, zkLedgersPath);
    }

    @Deprecated
    public String getZkLedgersRootPath() {
        return this.getString(ZK_LEDGERS_ROOT_PATH, "/ledgers");
    }

    public double getZkRequestRateLimit() {
        return this.getDouble(ZK_REQUEST_RATE_LIMIT, 0.0);
    }

    public void setZkRequestRateLimit(double rateLimit) {
        this.setProperty(ZK_REQUEST_RATE_LIMIT, rateLimit);
    }

    public boolean isZkEnableSecurity() {
        return this.getBoolean(ZK_ENABLE_SECURITY, false);
    }

    public void setZkEnableSecurity(boolean zkEnableSecurity) {
        this.setProperty(ZK_ENABLE_SECURITY, zkEnableSecurity);
    }

    @Deprecated
    public String getZkAvailableBookiesPath() {
        return this.getZkLedgersRootPath() + "/" + AVAILABLE_NODE;
    }

    public void setRereplicationEntryBatchSize(long rereplicationEntryBatchSize) {
        this.setProperty(REREPLICATION_ENTRY_BATCH_SIZE, rereplicationEntryBatchSize);
    }

    public long getRereplicationEntryBatchSize() {
        return this.getLong(REREPLICATION_ENTRY_BATCH_SIZE, 10L);
    }

    public String getMetastoreImplClass() {
        return this.getString(METASTORE_IMPL_CLASS);
    }

    public void setMetastoreImplClass(String metastoreImplClass) {
        this.setProperty(METASTORE_IMPL_CLASS, metastoreImplClass);
    }

    public int getMetastoreMaxEntriesPerScan() {
        return this.getInt(METASTORE_MAX_ENTRIES_PER_SCAN, 50);
    }

    public void setMetastoreMaxEntriesPerScan(int maxEntries) {
        this.setProperty(METASTORE_MAX_ENTRIES_PER_SCAN, maxEntries);
    }

    public void setFeature(String configProperty, Feature feature) {
        this.setProperty(configProperty, feature);
    }

    public Feature getFeature(String configProperty, Feature defaultValue) {
        if (null == this.getProperty(configProperty)) {
            return defaultValue;
        }
        return (Feature)this.getProperty(configProperty);
    }

    public void setLedgerIdFormatterClass(Class<? extends LedgerIdFormatter> formatterClass) {
        this.setProperty(LEDGERID_FORMATTER_CLASS, formatterClass.getName());
    }

    public Class<? extends LedgerIdFormatter> getLedgerIdFormatterClass() throws ConfigurationException {
        return ReflectionUtils.getClass(this, LEDGERID_FORMATTER_CLASS, DEFAULT_LEDGERID_FORMATTER, LedgerIdFormatter.class, DEFAULT_LOADER);
    }

    public void setEntryFormatterClass(Class<? extends EntryFormatter> formatterClass) {
        this.setProperty(ENTRY_FORMATTER_CLASS, formatterClass.getName());
    }

    public Class<? extends EntryFormatter> getEntryFormatterClass() throws ConfigurationException {
        return ReflectionUtils.getClass(this, ENTRY_FORMATTER_CLASS, DEFAULT_ENTRY_FORMATTER, EntryFormatter.class, DEFAULT_LOADER);
    }

    public T setClientAuthProviderFactoryClass(String factoryClass) {
        this.setProperty("clientAuthProviderFactoryClass", factoryClass);
        return this.getThis();
    }

    public String getClientAuthProviderFactoryClass() {
        return this.getString("clientAuthProviderFactoryClass", null);
    }

    public int getNettyMaxFrameSizeBytes() {
        return this.getInt(NETTY_MAX_FRAME_SIZE, 0x500000);
    }

    public T setNettyMaxFrameSizeBytes(int maxSize) {
        this.setProperty(NETTY_MAX_FRAME_SIZE, String.valueOf(maxSize));
        return this.getThis();
    }

    public String getTLSProviderFactoryClass() {
        return this.getString(TLS_PROVIDER_FACTORY_CLASS, null);
    }

    public T setTLSProviderFactoryClass(String factoryClass) {
        this.setProperty(TLS_PROVIDER_FACTORY_CLASS, factoryClass);
        return this.getThis();
    }

    public String getTLSProvider() {
        return this.getString(TLS_PROVIDER, "OpenSSL");
    }

    public T setTLSProvider(String provider) {
        this.setProperty(TLS_PROVIDER, provider);
        return this.getThis();
    }

    public boolean getTLSClientAuthentication() {
        return this.getBoolean(TLS_CLIENT_AUTHENTICATION, false);
    }

    public T setTLSClientAuthentication(boolean enabled) {
        this.setProperty(TLS_CLIENT_AUTHENTICATION, enabled);
        return this.getThis();
    }

    public T setTLSCertFilesRefreshDurationSeconds(long certFilesRefreshSec) {
        this.setProperty(TLS_CERT_FILES_REFRESH_DURATION_SECONDS, certFilesRefreshSec);
        return this.getThis();
    }

    public long getTLSCertFilesRefreshDurationSeconds() {
        return this.getLong(TLS_CERT_FILES_REFRESH_DURATION_SECONDS, 0L);
    }

    public T setTLSEnabledCipherSuites(String list) {
        this.setProperty(TLS_ENABLED_CIPHER_SUITES, list);
        return this.getThis();
    }

    public String getTLSEnabledCipherSuites() {
        return this.getString(TLS_ENABLED_CIPHER_SUITES, null);
    }

    public T setTLSEnabledProtocols(String list) {
        this.setProperty(TLS_ENABLED_PROTOCOLS, list);
        return this.getThis();
    }

    public String getTLSEnabledProtocols() {
        return this.getString(TLS_ENABLED_PROTOCOLS, null);
    }

    public void setMinNumRacksPerWriteQuorum(int minNumRacksPerWriteQuorum) {
        this.setProperty(MIN_NUM_RACKS_PER_WRITE_QUORUM, minNumRacksPerWriteQuorum);
    }

    public int getMinNumRacksPerWriteQuorum() {
        return this.getInteger(MIN_NUM_RACKS_PER_WRITE_QUORUM, 2);
    }

    public void setMinNumZonesPerWriteQuorum(int minNumZonesPerWriteQuorum) {
        this.setProperty(MIN_NUM_ZONES_PER_WRITE_QUORUM, minNumZonesPerWriteQuorum);
    }

    public int getMinNumZonesPerWriteQuorum() {
        return this.getInteger(MIN_NUM_ZONES_PER_WRITE_QUORUM, 2);
    }

    public void setDesiredNumZonesPerWriteQuorum(int desiredNumZonesPerWriteQuorum) {
        this.setProperty(DESIRED_NUM_ZONES_PER_WRITE_QUORUM, desiredNumZonesPerWriteQuorum);
    }

    public int getDesiredNumZonesPerWriteQuorum() {
        return this.getInteger(DESIRED_NUM_ZONES_PER_WRITE_QUORUM, 3);
    }

    public void setEnforceStrictZoneawarePlacement(boolean enforceStrictZoneawarePlacement) {
        this.setProperty(ENFORCE_STRICT_ZONEAWARE_PLACEMENT, enforceStrictZoneawarePlacement);
    }

    public boolean getEnforceStrictZoneawarePlacement() {
        return this.getBoolean(ENFORCE_STRICT_ZONEAWARE_PLACEMENT, true);
    }

    public void setEnforceMinNumRacksPerWriteQuorum(boolean enforceMinNumRacksPerWriteQuorum) {
        this.setProperty(ENFORCE_MIN_NUM_RACKS_PER_WRITE_QUORUM, enforceMinNumRacksPerWriteQuorum);
    }

    public boolean getEnforceMinNumRacksPerWriteQuorum() {
        return this.getBoolean(ENFORCE_MIN_NUM_RACKS_PER_WRITE_QUORUM, false);
    }

    public void setEnforceMinNumFaultDomainsForWrite(boolean enforceMinNumFaultDomainsForWrite) {
        this.setProperty(ENFORCE_MIN_NUM_FAULT_DOMAINS_FOR_WRITE, enforceMinNumFaultDomainsForWrite);
    }

    public boolean getEnforceMinNumFaultDomainsForWrite() {
        return this.getBoolean(ENFORCE_MIN_NUM_FAULT_DOMAINS_FOR_WRITE, false);
    }

    public void setIgnoreLocalNodeInPlacementPolicy(boolean ignoreLocalNodeInPlacementPolicy) {
        this.setProperty(IGNORE_LOCAL_NODE_IN_PLACEMENT_POLICY, ignoreLocalNodeInPlacementPolicy);
    }

    public boolean getIgnoreLocalNodeInPlacementPolicy() {
        return this.getBoolean(IGNORE_LOCAL_NODE_IN_PLACEMENT_POLICY, false);
    }

    public T setStoreSystemTimeAsLedgerUnderreplicatedMarkTime(boolean enabled) {
        this.setProperty(STORE_SYSTEMTIME_AS_LEDGER_UNDERREPLICATED_MARK_TIME, enabled);
        return this.getThis();
    }

    public boolean getStoreSystemTimeAsLedgerUnderreplicatedMarkTime() {
        return this.getBoolean(STORE_SYSTEMTIME_AS_LEDGER_UNDERREPLICATED_MARK_TIME, true);
    }

    public boolean getPreserveMdcForTaskExecution() {
        return this.getBoolean(PRESERVE_MDC_FOR_TASK_EXECUTION, false);
    }

    public T setPreserveMdcForTaskExecution(boolean enabled) {
        this.setProperty(PRESERVE_MDC_FOR_TASK_EXECUTION, enabled);
        return this.getThis();
    }

    public PoolingPolicy getAllocatorPoolingPolicy() {
        return PoolingPolicy.valueOf(this.getString(ALLOCATOR_POOLING_POLICY, PoolingPolicy.PooledDirect.toString()));
    }

    public T setAllocatorPoolingPolicy(PoolingPolicy poolingPolicy) {
        this.setProperty(ALLOCATOR_POOLING_POLICY, poolingPolicy.toString());
        return this.getThis();
    }

    public int getAllocatorPoolingConcurrency() {
        return this.getInteger(ALLOCATOR_POOLING_CONCURRENCY, PooledByteBufAllocator.defaultNumDirectArena());
    }

    public T setAllocatorPoolingConcurrenncy(int concurrency) {
        this.setProperty(ALLOCATOR_POOLING_POLICY, concurrency);
        return this.getThis();
    }

    public OutOfMemoryPolicy getAllocatorOutOfMemoryPolicy() {
        return OutOfMemoryPolicy.valueOf(this.getString(ALLOCATOR_OOM_POLICY, OutOfMemoryPolicy.FallbackToHeap.toString()));
    }

    public T setAllocatorOutOfMemoryPolicy(OutOfMemoryPolicy oomPolicy) {
        this.setProperty(ALLOCATOR_OOM_POLICY, oomPolicy.toString());
        return this.getThis();
    }

    public LeakDetectionPolicy getAllocatorLeakDetectionPolicy() {
        return LeakDetectionPolicy.valueOf(this.getString(ALLOCATOR_LEAK_DETECTION_POLICY, LeakDetectionPolicy.Disabled.toString()));
    }

    public T setAllocatorLeakDetectionPolicy(LeakDetectionPolicy leakDetectionPolicy) {
        this.setProperty(ALLOCATOR_LEAK_DETECTION_POLICY, leakDetectionPolicy.toString());
        return this.getThis();
    }

    public boolean isBusyWaitEnabled() {
        return this.getBoolean(ENABLE_BUSY_WAIT, false);
    }

    public T setBusyWaitEnabled(boolean busyWaitEanbled) {
        this.setProperty(ENABLE_BUSY_WAIT, busyWaitEanbled);
        return this.getThis();
    }

    public boolean getLimitStatsLogging() {
        return this.getBoolean(LIMIT_STATS_LOGGING, false);
    }

    public T setLimitStatsLogging(boolean limitStatsLogging) {
        this.setProperty(LIMIT_STATS_LOGGING, limitStatsLogging);
        return this.getThis();
    }

    public int getReplicationRateByBytes() {
        return this.getInt(REPLICATION_RATE_BY_BYTES, -1);
    }

    public T setReplicationRateByBytes(int rate) {
        this.setProperty(REPLICATION_RATE_BY_BYTES, rate);
        return this.getThis();
    }

    protected abstract T getThis();

    public String asJson() throws JsonUtil.ParseJsonException {
        return JsonUtil.toJson(this.toMap());
    }

    private Map<String, Object> toMap() {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        Iterator<String> iterator = this.getKeys();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            Object property = this.getProperty(key);
            if (property == null) continue;
            configMap.put(key, property.toString());
        }
        return configMap;
    }

    static {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (null == loader) {
            loader = AbstractConfiguration.class.getClassLoader();
        }
        DEFAULT_LOADER = loader;
        DEFAULT_ENTRY_FORMATTER = StringEntryFormatter.class;
        DEFAULT_LEDGERID_FORMATTER = LedgerIdFormatter.LongLedgerIdFormatter.class;
    }
}

