/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.allocator.impl;

import java.util.function.Consumer;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBufAllocator;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.allocator.ByteBufAllocatorBuilder;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.allocator.LeakDetectionPolicy;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.allocator.OutOfMemoryPolicy;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.allocator.PoolingPolicy;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.allocator.impl.ByteBufAllocatorImpl;

public class ByteBufAllocatorBuilderImpl
implements ByteBufAllocatorBuilder {
    ByteBufAllocator pooledAllocator = null;
    ByteBufAllocator unpooledAllocator = null;
    PoolingPolicy poolingPolicy = PoolingPolicy.PooledDirect;
    int poolingConcurrency = 2 * Runtime.getRuntime().availableProcessors();
    OutOfMemoryPolicy outOfMemoryPolicy = OutOfMemoryPolicy.FallbackToHeap;
    Consumer<OutOfMemoryError> outOfMemoryListener = null;
    LeakDetectionPolicy leakDetectionPolicy = LeakDetectionPolicy.Disabled;

    @Override
    public ByteBufAllocator build() {
        return new ByteBufAllocatorImpl(this.pooledAllocator, this.unpooledAllocator, this.poolingPolicy, this.poolingConcurrency, this.outOfMemoryPolicy, this.outOfMemoryListener, this.leakDetectionPolicy);
    }

    @Override
    public ByteBufAllocatorBuilder pooledAllocator(ByteBufAllocator pooledAllocator) {
        this.pooledAllocator = pooledAllocator;
        return this;
    }

    @Override
    public ByteBufAllocatorBuilder unpooledAllocator(ByteBufAllocator unpooledAllocator) {
        this.unpooledAllocator = unpooledAllocator;
        return this;
    }

    @Override
    public ByteBufAllocatorBuilder poolingPolicy(PoolingPolicy policy) {
        this.poolingPolicy = policy;
        return this;
    }

    @Override
    public ByteBufAllocatorBuilder poolingConcurrency(int poolingConcurrency) {
        this.poolingConcurrency = poolingConcurrency;
        return this;
    }

    @Override
    public ByteBufAllocatorBuilder outOfMemoryPolicy(OutOfMemoryPolicy policy) {
        this.outOfMemoryPolicy = policy;
        return this;
    }

    @Override
    public ByteBufAllocatorBuilder outOfMemoryListener(Consumer<OutOfMemoryError> listener) {
        this.outOfMemoryListener = listener;
        return this;
    }

    @Override
    public ByteBufAllocatorBuilder leakDetectionPolicy(LeakDetectionPolicy leakDetectionPolicy) {
        this.leakDetectionPolicy = leakDetectionPolicy;
        return this;
    }
}

