/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.clients.utils;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.CallCredentials;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.Metadata;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.stub.AbstractStub;

public final class GrpcUtils {
    private GrpcUtils() {
    }

    public static <T extends AbstractStub<T>> T configureGrpcStub(T stub, Optional<String> token) {
        return (T)token.map(t -> {
            final Metadata metadata = new Metadata();
            Metadata.Key tokenKey = Metadata.Key.of((String)"token", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
            metadata.put(tokenKey, t);
            CallCredentials callCredentials = new CallCredentials(){

                public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials.MetadataApplier applier) {
                    applier.apply(metadata);
                }

                public void thisUsesUnstableApi() {
                }
            };
            return stub.withCallCredentials(callCredentials);
        }).orElse(stub);
    }

    public static <T> void processRpcException(Throwable rpcCause, CompletableFuture<T> future) {
        future.completeExceptionally(rpcCause);
    }
}

